/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateLocalVarFromInstanceofAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateCastExpressionFromInstanceofAction
extends CreateLocalVarFromInstanceofAction {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        boolean available;
        if (project == null) {
            CreateCastExpressionFromInstanceofAction.$$$reportNull$$$0(0);
        }
        if (!(available = super.isAvailable(project, editor, file))) {
            return false;
        }
        PsiInstanceOfExpression instanceOfExpression = CreateCastExpressionFromInstanceofAction.getInstanceOfExpressionAtCaret(editor, file);
        if (instanceOfExpression == null) {
            return false;
        }
        PsiTypeElement checkType = instanceOfExpression.getCheckType();
        if (checkType == null) {
            return false;
        }
        PsiType type2 = checkType.getType();
        String castTo = type2.getPresentableText();
        this.setText(CodeInsightBundle.message((String)"cast.to.0", (Object[])new Object[]{castTo}));
        return true;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateCastExpressionFromInstanceofAction.$$$reportNull$$$0(1);
        }
        PsiInstanceOfExpression instanceOfExpression = CreateCastExpressionFromInstanceofAction.getInstanceOfExpressionAtCaret(editor, file);
        assert (instanceOfExpression.getContainingFile() == file) : instanceOfExpression.getContainingFile() + "; file=" + file;
        PsiElement decl = CreateCastExpressionFromInstanceofAction.createAndInsertCast(instanceOfExpression, editor, file);
        if (decl == null) {
            return;
        }
        if ((decl = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)decl)) == null) {
            return;
        }
        decl = CodeStyleManager.getInstance((Project)project).reformat(decl);
        editor.getCaretModel().moveToOffset(decl.getTextRange().getEndOffset());
    }

    @Nullable
    private static PsiElement createAndInsertCast(PsiInstanceOfExpression instanceOfExpression, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiStatement statementInside;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)instanceOfExpression.getProject()).getElementFactory();
        PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText("((a)b)", (PsiElement)instanceOfExpression);
        PsiParenthesizedExpression paren = (PsiParenthesizedExpression)statement.getExpression();
        PsiTypeCastExpression cast = (PsiTypeCastExpression)paren.getExpression();
        PsiType castType = instanceOfExpression.getCheckType().getType();
        cast.getCastType().replace((PsiElement)factory.createTypeElement(castType));
        cast.getOperand().replace((PsiElement)instanceOfExpression.getOperand());
        PsiStatement psiStatement = statementInside = CreateCastExpressionFromInstanceofAction.isNegated(instanceOfExpression) ? null : CreateCastExpressionFromInstanceofAction.getExpressionStatementInside(file, editor, instanceOfExpression.getOperand());
        if (statementInside != null) {
            return statementInside.replace((PsiElement)statement);
        }
        return CreateCastExpressionFromInstanceofAction.insertAtAnchor(instanceOfExpression, (PsiElement)statement);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"cast.expression", (Object[])new Object[0]);
        if (string == null) {
            CreateCastExpressionFromInstanceofAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateCastExpressionFromInstanceofAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateCastExpressionFromInstanceofAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

