/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SwitchStatementBranch;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConvertSwitchToIfIntention
implements IntentionAction {
    private final PsiSwitchStatement mySwitchExpression;

    public ConvertSwitchToIfIntention(@NotNull PsiSwitchStatement switchStatement) {
        if (switchStatement == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(0);
        }
        this.mySwitchExpression = switchStatement;
    }

    @NotNull
    public String getText() {
        if ("Replace 'switch' with 'if'" == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(1);
        }
        return "Replace 'switch' with 'if'";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiCodeBlock body2;
        if (project == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(3);
        }
        return (body2 = this.mySwitchExpression.getBody()) != null && !body2.isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(4);
        }
        ConvertSwitchToIfIntention.doProcessIntention(this.mySwitchExpression);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(5);
        }
        PsiSwitchStatement psiSwitchStatement = this.mySwitchExpression;
        if (psiSwitchStatement == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(6);
        }
        return psiSwitchStatement;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void doProcessIntention(@NotNull PsiSwitchStatement switchStatement) {
        String declarationString;
        String expressionText;
        boolean hadSideEffects;
        boolean isSwitchOnString;
        PsiExpression switchExpression;
        if (switchStatement == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(7);
        }
        if ((switchExpression = switchStatement.getExpression()) == null) {
            return;
        }
        PsiType switchExpressionType = RefactoringUtil.getTypeByExpressionWithExpectedType(switchExpression);
        if (switchExpressionType == null) {
            return;
        }
        CommentTracker commentTracker = new CommentTracker();
        commentTracker.markUnchanged(switchExpression);
        boolean useEquals = isSwitchOnString = switchExpressionType.equalsToText("java.lang.String");
        if (!useEquals) {
            PsiClass aClass = PsiUtil.resolveClassInType((PsiType)switchExpressionType);
            useEquals = aClass != null && !aClass.isEnum();
        }
        Project project = switchStatement.getProject();
        if (RemoveUnusedVariableUtil.checkSideEffects(switchExpression, null, new ArrayList())) {
            hadSideEffects = true;
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            String variableName = isSwitchOnString ? javaCodeStyleManager.suggestUniqueVariableName("s", (PsiElement)switchExpression, true) : javaCodeStyleManager.suggestUniqueVariableName("i", (PsiElement)switchExpression, true);
            expressionText = variableName;
            declarationString = switchExpressionType.getCanonicalText() + ' ' + variableName + " = " + switchExpression.getText() + ';';
        } else {
            hadSideEffects = false;
            declarationString = null;
            expressionText = ParenthesesUtils.getPrecedence(switchExpression) > 9 ? '(' + switchExpression.getText() + ')' : switchExpression.getText();
        }
        PsiCodeBlock body2 = switchStatement.getBody();
        if (body2 == null) {
            return;
        }
        ArrayList<SwitchStatementBranch> openBranches = new ArrayList<SwitchStatementBranch>();
        HashSet<PsiLocalVariable> declaredVariables = new HashSet<PsiLocalVariable>();
        ArrayList<SwitchStatementBranch> allBranches = new ArrayList<SwitchStatementBranch>();
        SwitchStatementBranch currentBranch = null;
        PsiElement[] children = body2.getChildren();
        for (int i = 1; i < children.length - 1; ++i) {
            PsiElement statement = children[i];
            if (statement instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement label = (PsiSwitchLabelStatement)statement;
                if (currentBranch == null) {
                    openBranches.clear();
                    currentBranch = new SwitchStatementBranch();
                    currentBranch.addPendingVariableDeclarations(declaredVariables);
                    allBranches.add(currentBranch);
                    openBranches.add(currentBranch);
                } else if (currentBranch.hasStatements()) {
                    currentBranch = new SwitchStatementBranch();
                    allBranches.add(currentBranch);
                    openBranches.add(currentBranch);
                }
                if (label.isDefaultCase()) {
                    currentBranch.setDefault();
                    continue;
                }
                PsiExpression psiExpression = label.getCaseValue();
                String string = ConvertSwitchToIfIntention.getCaseValueText(psiExpression, commentTracker);
                currentBranch.addCaseValue(string);
                continue;
            }
            if (statement instanceof PsiStatement) {
                if (statement instanceof PsiDeclarationStatement) {
                    PsiElement[] psiElementArray;
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                    for (PsiElement varElement : psiElementArray = declarationStatement.getDeclaredElements()) {
                        PsiLocalVariable variable = (PsiLocalVariable)varElement;
                        declaredVariables.add(variable);
                    }
                }
                for (SwitchStatementBranch switchStatementBranch : openBranches) {
                    switchStatementBranch.addStatement(statement);
                }
                try {
                    ControlFlow controlFlow = ControlFlowFactory.getInstance(project).getControlFlow(statement, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                    int n = controlFlow.getStartOffset(statement);
                    int n2 = controlFlow.getEndOffset(statement);
                    if (n == -1 || n2 == -1 || ControlFlowUtil.canCompleteNormally(controlFlow, n, n2)) continue;
                    currentBranch = null;
                }
                catch (AnalysisCanceledException e) {
                    currentBranch = null;
                }
                continue;
            }
            for (SwitchStatementBranch switchStatementBranch : openBranches) {
                if (statement instanceof PsiWhiteSpace) {
                    switchStatementBranch.addWhiteSpace(statement);
                    continue;
                }
                switchStatementBranch.addComment(statement);
            }
        }
        StringBuilder ifStatementText = new StringBuilder();
        boolean firstBranch = true;
        SwitchStatementBranch defaultBranch = null;
        for (SwitchStatementBranch switchStatementBranch : allBranches) {
            if (switchStatementBranch.isDefault()) {
                defaultBranch = switchStatementBranch;
                continue;
            }
            ConvertSwitchToIfIntention.dumpBranch(switchStatementBranch, expressionText, firstBranch, useEquals, ifStatementText, commentTracker);
            firstBranch = false;
        }
        if (defaultBranch != null) {
            ConvertSwitchToIfIntention.dumpDefaultBranch(defaultBranch, firstBranch, ifStatementText, commentTracker);
        }
        if (ifStatementText.length() == 0) {
            return;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)project);
        if (hadSideEffects) {
            PsiStatement psiStatement = psiElementFactory.createStatementFromText(declarationString, (PsiElement)switchStatement);
            switchStatement.getParent().addBefore((PsiElement)psiStatement, (PsiElement)switchStatement);
        }
        PsiStatement psiStatement = psiElementFactory.createStatementFromText(ifStatementText.toString(), (PsiElement)switchStatement);
        commentTracker.replaceAndRestoreComments((PsiElement)switchStatement, (PsiElement)psiStatement);
    }

    private static String getCaseValueText(PsiExpression value2, CommentTracker commentTracker) {
        if ((value2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)value2)) == null) {
            return "";
        }
        if (!(value2 instanceof PsiReferenceExpression)) {
            return commentTracker.text((PsiElement)value2);
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)value2;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiEnumConstant)) {
            return commentTracker.text((PsiElement)value2);
        }
        PsiEnumConstant enumConstant = (PsiEnumConstant)target;
        PsiClass aClass = enumConstant.getContainingClass();
        if (aClass == null) {
            return commentTracker.text((PsiElement)value2);
        }
        return aClass.getQualifiedName() + '.' + commentTracker.text((PsiElement)referenceExpression);
    }

    private static void dumpBranch(SwitchStatementBranch branch, String expressionText, boolean firstBranch, boolean useEquals, @NonNls StringBuilder out, CommentTracker commentTracker) {
        if (!firstBranch) {
            out.append("else ");
        }
        ConvertSwitchToIfIntention.dumpCaseValues(expressionText, branch.getCaseValues(), useEquals, out);
        ConvertSwitchToIfIntention.dumpBody(branch, out, commentTracker);
    }

    private static void dumpDefaultBranch(SwitchStatementBranch defaultBranch, boolean firstBranch, @NonNls StringBuilder out, CommentTracker commentTracker) {
        if (!firstBranch) {
            out.append("else ");
        }
        ConvertSwitchToIfIntention.dumpBody(defaultBranch, out, commentTracker);
    }

    private static void dumpCaseValues(String expressionText, List<String> caseValues2, boolean useEquals, @NonNls StringBuilder out) {
        out.append("if(");
        boolean firstCaseValue = true;
        for (String caseValue : caseValues2) {
            if (!firstCaseValue) {
                out.append("||");
            }
            firstCaseValue = false;
            if (useEquals) {
                out.append(caseValue).append(".equals(").append(expressionText).append(')');
                continue;
            }
            out.append(expressionText).append("==").append(caseValue);
        }
        out.append(')');
    }

    private static void dumpBody(SwitchStatementBranch branch, @NonNls StringBuilder out, CommentTracker commentTracker) {
        List<PsiElement> bodyStatements = branch.getBodyElements();
        out.append('{');
        for (PsiLocalVariable variable : branch.getPendingVariableDeclarations()) {
            if (ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(bodyStatements.toArray(PsiElement.EMPTY_ARRAY))).findFirst() == null) continue;
            out.append(variable.getType().getCanonicalText()).append(' ').append(variable.getName()).append(';');
        }
        for (PsiElement bodyStatement : bodyStatements) {
            if (bodyStatement instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)bodyStatement;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                for (PsiStatement statement : codeBlock.getStatements()) {
                    ConvertSwitchToIfIntention.appendElement((PsiElement)statement, out, commentTracker);
                }
                continue;
            }
            ConvertSwitchToIfIntention.appendElement(bodyStatement, out, commentTracker);
        }
        out.append("\n}");
    }

    private static void appendElement(PsiElement element, @NonNls StringBuilder out, CommentTracker commentTracker) {
        PsiBreakStatement breakStatement;
        PsiIdentifier identifier;
        if (element instanceof PsiBreakStatement && (identifier = (breakStatement = (PsiBreakStatement)element).getLabelIdentifier()) == null) {
            return;
        }
        out.append(commentTracker.text(element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ConvertSwitchToIfIntention";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ConvertSwitchToIfIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToMakeWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doProcessIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

