/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListFix;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeParameterClassFix
extends ExtendsListFix {
    public ChangeParameterClassFix(@NotNull PsiClass aClassToExtend, @NotNull PsiClassType parameterClass) {
        if (aClassToExtend == null) {
            ChangeParameterClassFix.$$$reportNull$$$0(0);
        }
        if (parameterClass == null) {
            ChangeParameterClassFix.$$$reportNull$$$0(1);
        }
        super(aClassToExtend, parameterClass, true);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.parameter.class.family", new Object[0]);
        if (string == null) {
            ChangeParameterClassFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            ChangeParameterClassFix.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ChangeParameterClassFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            ChangeParameterClassFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            ChangeParameterClassFix.$$$reportNull$$$0(6);
        }
        return super.isAvailable(project, file, startElement, endElement) && this.myClassToExtendFrom != null && this.myClassToExtendFrom.isValid() && this.myClassToExtendFrom.getQualifiedName() != null;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            ChangeParameterClassFix.$$$reportNull$$$0(7);
        }
        if (file == null) {
            ChangeParameterClassFix.$$$reportNull$$$0(8);
        }
        if (startElement == null) {
            ChangeParameterClassFix.$$$reportNull$$$0(9);
        }
        if (endElement == null) {
            ChangeParameterClassFix.$$$reportNull$$$0(10);
        }
        PsiClass myClass = (PsiClass)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.invokeImpl(myClass));
        Editor editor1 = CodeInsightUtil.positionCursorAtLBrace(project, myClass.getContainingFile(), myClass);
        if (editor1 == null) {
            return;
        }
        Collection<CandidateInfo> toImplement = OverrideImplementExploreUtil.getMethodsToOverrideImplement(myClass, true);
        if (!toImplement.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    List members = ContainerUtil.map2List((Collection)toImplement, s -> new PsiMethodMember((CandidateInfo)s));
                    OverrideImplementUtil.overrideOrImplementMethodsInRightPlace(editor1, myClass, members, false);
                });
            } else {
                editor1.getCaretModel().moveToOffset(myClass.getTextRange().getStartOffset());
                OverrideImplementUtil.chooseAndImplementMethods(project, editor1, myClass);
            }
        }
        UndoUtil.markPsiFileForUndo((PsiFile)file);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClassToExtend";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

