/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.application.options.colors.ScopeAttributesUtil;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyValidationManagerImpl;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightNamesUtil {
    private static final Logger LOG = Logger.getInstance(HighlightNamesUtil.class);

    @Nullable
    static HighlightInfo highlightMethodName(@NotNull PsiMethod method, @NotNull PsiElement elementToHighlight, boolean isDeclaration, @NotNull TextAttributesScheme colorsScheme) {
        if (method == null) {
            HighlightNamesUtil.$$$reportNull$$$0(0);
        }
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(1);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(2);
        }
        return HighlightNamesUtil.highlightMethodName((PsiMember)method, elementToHighlight, elementToHighlight.getTextRange(), colorsScheme, isDeclaration);
    }

    @Nullable
    static HighlightInfo highlightMethodName(@NotNull PsiMember methodOrClass, @NotNull PsiElement elementToHighlight, @NotNull TextRange range, @NotNull TextAttributesScheme colorsScheme, boolean isDeclaration) {
        HighlightInfoType type2;
        if (methodOrClass == null) {
            HighlightNamesUtil.$$$reportNull$$$0(3);
        }
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(4);
        }
        if (range == null) {
            HighlightNamesUtil.$$$reportNull$$$0(5);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(6);
        }
        boolean isInherited = false;
        boolean isStaticallyImported = false;
        if (!isDeclaration) {
            isStaticallyImported = HighlightNamesUtil.isStaticallyImported(elementToHighlight);
            if (HighlightNamesUtil.isCalledOnThis(elementToHighlight)) {
                PsiClass enclosingClass;
                PsiClass containingClass = methodOrClass instanceof PsiMethod ? methodOrClass.getContainingClass() : null;
                PsiClass psiClass = enclosingClass = containingClass == null ? null : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, PsiClass.class);
                while (enclosingClass != null && !(isInherited = enclosingClass.isInheritor(containingClass, true))) {
                    enclosingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)enclosingClass, PsiClass.class, (boolean)true);
                }
            }
        }
        LOG.assertTrue(methodOrClass instanceof PsiMethod || !isDeclaration);
        HighlightInfoType highlightInfoType = type2 = methodOrClass instanceof PsiMethod ? HighlightNamesUtil.getMethodNameHighlightType((PsiMethod)methodOrClass, isDeclaration, isInherited, isStaticallyImported) : JavaHighlightInfoTypes.CONSTRUCTOR_CALL;
        if (type2 != null) {
            TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes((PsiElement)methodOrClass, type2, colorsScheme);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)type2).range(range);
            if (attributes != null) {
                builder.textAttributes(attributes);
            }
            return builder.createUnconditionally();
        }
        return null;
    }

    private static boolean isCalledOnThis(@NotNull PsiElement elementToHighlight) {
        PsiElement qualifier;
        PsiMethodCallExpression methodCallExpression;
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(7);
        }
        return (methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, PsiMethodCallExpression.class)) != null && ((qualifier = methodCallExpression.getMethodExpression().getQualifier()) == null || qualifier instanceof PsiThisExpression);
    }

    private static boolean isStaticallyImported(@NotNull PsiElement elementToHighlight) {
        PsiReferenceExpression referenceExpression;
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(8);
        }
        if ((referenceExpression = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, PsiReferenceExpression.class)) != null) {
            JavaResolveResult result = referenceExpression.advancedResolve(false);
            return result.getCurrentFileResolveScope() instanceof PsiImportStaticStatement;
        }
        return false;
    }

    private static TextAttributes mergeWithScopeAttributes(@Nullable PsiElement element, @NotNull HighlightInfoType type2, @NotNull TextAttributesScheme colorsScheme) {
        if (type2 == null) {
            HighlightNamesUtil.$$$reportNull$$$0(9);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(10);
        }
        TextAttributes regularAttributes = HighlightInfo.getAttributesByType((PsiElement)element, (HighlightInfoType)type2, (TextAttributesScheme)colorsScheme);
        if (element == null) {
            return regularAttributes;
        }
        TextAttributes scopeAttributes = HighlightNamesUtil.getScopeAttributes(element, colorsScheme);
        return TextAttributes.merge((TextAttributes)scopeAttributes, (TextAttributes)regularAttributes);
    }

    @NotNull
    static HighlightInfo highlightClassName(@Nullable PsiClass aClass, @NotNull PsiElement elementToHighlight, @NotNull TextAttributesScheme colorsScheme) {
        PsiElement parent;
        PsiJavaCodeReferenceElement referenceElement;
        PsiElement identifier;
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(11);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(12);
        }
        TextRange range = elementToHighlight.getTextRange();
        if (elementToHighlight instanceof PsiJavaCodeReferenceElement && (identifier = (referenceElement = (PsiJavaCodeReferenceElement)elementToHighlight).getReferenceNameElement()) != null) {
            range = identifier.getTextRange();
        }
        if ((parent = elementToHighlight.getParent()) instanceof PsiAnnotation) {
            PsiAnnotation psiAnnotation = (PsiAnnotation)parent;
            range = new TextRange(psiAnnotation.getTextRange().getStartOffset(), range.getEndOffset());
        }
        HighlightInfoType type2 = HighlightNamesUtil.getClassNameHighlightType(aClass, elementToHighlight);
        TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes((PsiElement)aClass, type2, colorsScheme);
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)type2).range(range);
        if (attributes != null) {
            builder.textAttributes(attributes);
        }
        HighlightInfo highlightInfo = builder.createUnconditionally();
        if (highlightInfo == null) {
            HighlightNamesUtil.$$$reportNull$$$0(13);
        }
        return highlightInfo;
    }

    @Nullable
    static HighlightInfo highlightVariableName(@NotNull PsiVariable variable, @NotNull PsiElement elementToHighlight, @NotNull TextAttributesScheme colorsScheme) {
        HighlightInfoType varType;
        if (variable == null) {
            HighlightNamesUtil.$$$reportNull$$$0(14);
        }
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(15);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(16);
        }
        if ((varType = HighlightNamesUtil.getVariableNameHighlightType(variable, elementToHighlight)) == null) {
            return null;
        }
        if (variable instanceof PsiField) {
            TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes((PsiElement)variable, varType, colorsScheme);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)varType).range(elementToHighlight.getTextRange());
            if (attributes != null) {
                builder.textAttributes(attributes);
            }
            return builder.createUnconditionally();
        }
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)varType).range(elementToHighlight);
        return RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)colorsScheme, (Language)JavaLanguage.INSTANCE) ? builder.createUnconditionally() : builder.create();
    }

    @Nullable
    static HighlightInfo highlightClassNameInQualifier(@NotNull PsiJavaCodeReferenceElement element, @NotNull TextAttributesScheme colorsScheme) {
        PsiElement resolved;
        PsiElement qualifierExpression2;
        if (element == null) {
            HighlightNamesUtil.$$$reportNull$$$0(17);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(18);
        }
        if ((qualifierExpression2 = element.getQualifier()) instanceof PsiJavaCodeReferenceElement && (resolved = ((PsiJavaCodeReferenceElement)qualifierExpression2).resolve()) instanceof PsiClass) {
            return HighlightNamesUtil.highlightClassName((PsiClass)resolved, qualifierExpression2, colorsScheme);
        }
        return null;
    }

    private static HighlightInfoType getMethodNameHighlightType(@NotNull PsiMethod method, boolean isDeclaration, boolean isInheritedMethod, boolean isStaticallyImported) {
        if (method == null) {
            HighlightNamesUtil.$$$reportNull$$$0(19);
        }
        if (method.isConstructor()) {
            return isDeclaration ? JavaHighlightInfoTypes.CONSTRUCTOR_DECLARATION : JavaHighlightInfoTypes.CONSTRUCTOR_CALL;
        }
        if (isDeclaration) {
            return JavaHighlightInfoTypes.METHOD_DECLARATION;
        }
        if (method.hasModifierProperty("static")) {
            return isStaticallyImported ? JavaHighlightInfoTypes.STATIC_METHOD_CALL_IMPORTED : JavaHighlightInfoTypes.STATIC_METHOD;
        }
        if (isInheritedMethod) {
            return JavaHighlightInfoTypes.INHERITED_METHOD;
        }
        if (method.hasModifierProperty("abstract")) {
            return JavaHighlightInfoTypes.ABSTRACT_METHOD;
        }
        return JavaHighlightInfoTypes.METHOD_CALL;
    }

    @Nullable
    private static HighlightInfoType getVariableNameHighlightType(@NotNull PsiVariable var, @NotNull PsiElement elementToHighlight) {
        if (var == null) {
            HighlightNamesUtil.$$$reportNull$$$0(20);
        }
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(21);
        }
        if (var instanceof PsiLocalVariable || var instanceof PsiParameter && ((PsiParameter)var).getDeclarationScope() instanceof PsiForeachStatement) {
            return JavaHighlightInfoTypes.LOCAL_VARIABLE;
        }
        if (var instanceof PsiField) {
            if (var.hasModifierProperty("static")) {
                boolean staticallyImported = HighlightNamesUtil.isStaticallyImported(elementToHighlight);
                if (var.hasModifierProperty("final")) {
                    return staticallyImported ? JavaHighlightInfoTypes.STATIC_FINAL_FIELD_IMPORTED : JavaHighlightInfoTypes.STATIC_FINAL_FIELD;
                }
                return staticallyImported ? JavaHighlightInfoTypes.STATIC_FIELD_IMPORTED : JavaHighlightInfoTypes.STATIC_FIELD;
            }
            return var.hasModifierProperty("final") ? JavaHighlightInfoTypes.INSTANCE_FINAL_FIELD : JavaHighlightInfoTypes.INSTANCE_FIELD;
        }
        if (var instanceof PsiParameter) {
            return ((PsiParameter)var).getDeclarationScope() instanceof PsiLambdaExpression ? JavaHighlightInfoTypes.LAMBDA_PARAMETER : JavaHighlightInfoTypes.PARAMETER;
        }
        return null;
    }

    @NotNull
    private static HighlightInfoType getClassNameHighlightType(@Nullable PsiClass aClass, @NotNull PsiElement element) {
        if (element == null) {
            HighlightNamesUtil.$$$reportNull$$$0(22);
        }
        if (element instanceof PsiJavaCodeReferenceElement && element.getParent() instanceof PsiAnonymousClass) {
            HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ANONYMOUS_CLASS_NAME;
            if (highlightInfoType == null) {
                HighlightNamesUtil.$$$reportNull$$$0(23);
            }
            return highlightInfoType;
        }
        if (aClass != null) {
            if (aClass.isAnnotationType()) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ANNOTATION_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(24);
                }
                return highlightInfoType;
            }
            if (aClass.isInterface()) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.INTERFACE_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(25);
                }
                return highlightInfoType;
            }
            if (aClass.isEnum()) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ENUM_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(26);
                }
                return highlightInfoType;
            }
            if (aClass instanceof PsiTypeParameter) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.TYPE_PARAMETER_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(27);
                }
                return highlightInfoType;
            }
            PsiModifierList modList = aClass.getModifierList();
            if (modList != null && modList.hasModifierProperty("abstract")) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ABSTRACT_CLASS_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(28);
                }
                return highlightInfoType;
            }
        }
        HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.CLASS_NAME;
        if (highlightInfoType == null) {
            HighlightNamesUtil.$$$reportNull$$$0(29);
        }
        return highlightInfoType;
    }

    @Nullable
    static HighlightInfo highlightReassignedVariable(@NotNull PsiVariable variable, @NotNull PsiElement elementToHighlight) {
        if (variable == null) {
            HighlightNamesUtil.$$$reportNull$$$0(30);
        }
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(31);
        }
        if (variable instanceof PsiLocalVariable) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)JavaHighlightInfoTypes.REASSIGNED_LOCAL_VARIABLE).range(elementToHighlight).create();
        }
        if (variable instanceof PsiParameter) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)JavaHighlightInfoTypes.REASSIGNED_PARAMETER).range(elementToHighlight).create();
        }
        return null;
    }

    private static TextAttributes getScopeAttributes(@NotNull PsiElement element, @NotNull TextAttributesScheme colorsScheme) {
        PsiFile file;
        if (element == null) {
            HighlightNamesUtil.$$$reportNull$$$0(32);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(33);
        }
        if ((file = element.getContainingFile()) == null) {
            return null;
        }
        TextAttributes result = null;
        DependencyValidationManagerImpl validationManager = (DependencyValidationManagerImpl)DependencyValidationManager.getInstance((Project)file.getProject());
        List scopes = validationManager.getScopeBasedHighlightingCachedScopes();
        for (Pair scope : scopes) {
            PackageSet packageSet;
            NamedScope namedScope = (NamedScope)scope.getFirst();
            TextAttributesKey scopeKey = ScopeAttributesUtil.getScopeTextAttributeKey((String)namedScope.getName());
            TextAttributes attributes = colorsScheme.getAttributes(scopeKey);
            if (attributes == null || attributes.isEmpty() || (packageSet = namedScope.getValue()) == null || !packageSet.contains(file, (NamedScopesHolder)scope.getSecond())) continue;
            result = TextAttributes.merge((TextAttributes)attributes, result);
        }
        return result;
    }

    @NotNull
    public static TextRange getMethodDeclarationTextRange(@NotNull PsiMethod method) {
        if (method == null) {
            HighlightNamesUtil.$$$reportNull$$$0(34);
        }
        if (method instanceof SyntheticElement) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                HighlightNamesUtil.$$$reportNull$$$0(35);
            }
            return textRange;
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList((PsiElement)method.getModifierList());
        TextRange throwsRange = method.getThrowsList().getTextRange();
        LOG.assertTrue(throwsRange != null, (Object)method);
        int end = throwsRange.getEndOffset();
        TextRange textRange = new TextRange(start, end);
        if (textRange == null) {
            HighlightNamesUtil.$$$reportNull$$$0(36);
        }
        return textRange;
    }

    @NotNull
    public static TextRange getFieldDeclarationTextRange(@NotNull PsiField field) {
        if (field == null) {
            HighlightNamesUtil.$$$reportNull$$$0(37);
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList((PsiElement)field.getModifierList());
        int end = field.getNameIdentifier().getTextRange().getEndOffset();
        TextRange textRange = new TextRange(start, end);
        if (textRange == null) {
            HighlightNamesUtil.$$$reportNull$$$0(38);
        }
        return textRange;
    }

    @NotNull
    public static TextRange getClassDeclarationTextRange(@NotNull PsiClass aClass) {
        PsiReferenceList endElement;
        PsiJavaCodeReferenceElement psiElement;
        if (aClass == null) {
            HighlightNamesUtil.$$$reportNull$$$0(39);
        }
        if (aClass instanceof PsiEnumConstantInitializer) {
            TextRange textRange = ((PsiEnumConstantInitializer)aClass).getEnumConstant().getNameIdentifier().getTextRange();
            if (textRange == null) {
                HighlightNamesUtil.$$$reportNull$$$0(40);
            }
            return textRange;
        }
        Object object = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassReference() : (psiElement = aClass.getModifierList() == null ? aClass.getNameIdentifier() : aClass.getModifierList());
        if (psiElement == null) {
            TextRange textRange = new TextRange(aClass.getTextRange().getStartOffset(), aClass.getTextRange().getStartOffset());
            if (textRange == null) {
                HighlightNamesUtil.$$$reportNull$$$0(41);
            }
            return textRange;
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList((PsiElement)psiElement);
        Object object2 = endElement = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassReference() : aClass.getImplementsList();
        if (endElement == null) {
            endElement = aClass.getNameIdentifier();
        }
        TextRange endTextRange = endElement == null ? null : endElement.getTextRange();
        int end = endTextRange == null ? start : endTextRange.getEndOffset();
        TextRange textRange = new TextRange(start, end);
        if (textRange == null) {
            HighlightNamesUtil.$$$reportNull$$$0(42);
        }
        return textRange;
    }

    private static int stripAnnotationsFromModifierList(@NotNull PsiElement element) {
        TextRange textRange;
        if (element == null) {
            HighlightNamesUtil.$$$reportNull$$$0(43);
        }
        if ((textRange = element.getTextRange()) == null) {
            return 0;
        }
        PsiAnnotation lastAnnotation = null;
        for (PsiElement child : element.getChildren()) {
            if (!(child instanceof PsiAnnotation)) continue;
            lastAnnotation = (PsiAnnotation)child;
        }
        if (lastAnnotation == null) {
            return textRange.getStartOffset();
        }
        ASTNode node = lastAnnotation.getNode();
        if (node != null) {
            while ((node = TreeUtil.nextLeaf((ASTNode)node)) != null && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(node.getElementType())) {
            }
        }
        if (node != null) {
            return node.getTextRange().getStartOffset();
        }
        return textRange.getStartOffset();
    }

    static HighlightInfo highlightPackage(@NotNull PsiElement resolved, @NotNull PsiJavaCodeReferenceElement elementToHighlight, @NotNull TextAttributesScheme scheme) {
        TextRange range;
        PsiElement referenceNameElement;
        if (resolved == null) {
            HighlightNamesUtil.$$$reportNull$$$0(44);
        }
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(45);
        }
        if (scheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(46);
        }
        if ((referenceNameElement = elementToHighlight.getReferenceNameElement()) == null) {
            range = elementToHighlight.getTextRange();
        } else {
            PsiElement nextSibling = PsiTreeUtil.nextLeaf((PsiElement)referenceNameElement);
            if (nextSibling != null && nextSibling.getTextRange().isEmpty()) {
                nextSibling = PsiTreeUtil.nextLeaf((PsiElement)nextSibling);
            }
            range = PsiUtil.isJavaToken((PsiElement)nextSibling, (IElementType)JavaTokenType.DOT) ? new TextRange(referenceNameElement.getTextRange().getStartOffset(), nextSibling.getTextRange().getEndOffset()) : referenceNameElement.getTextRange();
        }
        HighlightInfoType type2 = JavaHighlightInfoTypes.CLASS_NAME;
        TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes(resolved, type2, scheme);
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)type2).range(range);
        if (attributes != null) {
            builder.textAttributes(attributes);
        }
        return builder.createUnconditionally();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 21: 
            case 31: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 12: 
            case 16: 
            case 18: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodOrClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil";
                break;
            }
            case 14: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 17: 
            case 22: 
            case 32: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightClassName";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNameHighlightType";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodDeclarationTextRange";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldDeclarationTextRange";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDeclarationTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "highlightMethodName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCalledOnThis";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isStaticallyImported";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mergeWithScopeAttributes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "highlightClassName";
                break;
            }
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "highlightVariableName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "highlightClassNameInQualifier";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMethodNameHighlightType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getVariableNameHighlightType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getClassNameHighlightType";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "highlightReassignedVariable";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getScopeAttributes";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDeclarationTextRange";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFieldDeclarationTextRange";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclarationTextRange";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "stripAnnotationsFromModifierList";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "highlightPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

