/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.ConstructorInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaConstructorCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.getters.ExpectedTypesGetter;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaInheritorsGetter
extends CompletionProvider<CompletionParameters> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.JavaInheritorsGetter");
    private final ConstructorInsertHandler myConstructorInsertHandler;

    public JavaInheritorsGetter(ConstructorInsertHandler constructorInsertHandler) {
        this.myConstructorInsertHandler = constructorInsertHandler;
    }

    private static boolean shouldAddArrayInitializer(PsiElement position) {
        if (!JavaCompletionContributor.isInJavaContext(position) || !JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiNewExpression.class);
        return newExpression != null && newExpression.getParent() instanceof PsiExpressionList;
    }

    public void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext matchingContext, @NotNull CompletionResultSet result) {
        if (parameters2 == null) {
            JavaInheritorsGetter.$$$reportNull$$$0(0);
        }
        if (result == null) {
            JavaInheritorsGetter.$$$reportNull$$$0(1);
        }
        ExpectedTypeInfo[] infos = JavaSmartCompletionContributor.getExpectedTypes(parameters2);
        List<ExpectedTypeInfo> infoCollection = Arrays.asList(infos);
        this.generateVariants(parameters2, result.getPrefixMatcher(), infos, (Consumer<LookupElement>)((Consumer)lookupElement -> {
            if (result == null) {
                JavaInheritorsGetter.$$$reportNull$$$0(3);
            }
            result.addElement((LookupElement)JavaSmartCompletionContributor.decorate(lookupElement, infoCollection));
        }));
    }

    public void generateVariants(CompletionParameters parameters2, PrefixMatcher prefixMatcher, Consumer<LookupElement> consumer) {
        this.generateVariants(parameters2, prefixMatcher, JavaSmartCompletionContributor.getExpectedTypes(parameters2), consumer);
    }

    private void generateVariants(CompletionParameters parameters2, PrefixMatcher prefixMatcher, ExpectedTypeInfo[] infos, Consumer<LookupElement> consumer) {
        JavaInheritorsGetter.addArrayTypes(parameters2.getPosition(), infos, consumer);
        List<PsiClassType> classTypes = JavaInheritorsGetter.extractClassTypes(infos);
        boolean arraysWelcome = ContainerUtil.exists((Object[])ExpectedTypesGetter.extractTypes(infos, true), t -> t.getDeepComponentType().equalsToText("java.lang.Object"));
        JavaInheritorsGetter.processInheritors(parameters2, classTypes, prefixMatcher, (Consumer<PsiType>)((Consumer)type2 -> {
            LookupElement element = this.addExpectedType((PsiType)type2, parameters2);
            if (element != null) {
                Supplier<PsiClassType> itemType = () -> (PsiClassType)((TypedLookupItem)ObjectUtils.assertNotNull((Object)element.as(TypedLookupItem.CLASS_CONDITION_KEY))).getType();
                JavaConstructorCallElement.wrap(element, (PsiClass)element.getObject(), parameters2.getPosition(), itemType).forEach(arg_0 -> ((Consumer)consumer).consume(arg_0));
            }
            if (arraysWelcome) {
                consumer.consume((Object)JavaInheritorsGetter.createNewArrayItem(parameters2.getPosition(), (PsiType)type2.createArrayType()));
            }
        }));
    }

    private static void addArrayTypes(PsiElement identifierCopy, ExpectedTypeInfo[] infos, Consumer<LookupElement> consumer) {
        for (PsiType type2 : ExpectedTypesGetter.extractTypes(infos, true)) {
            if (!(type2 instanceof PsiArrayType)) continue;
            consumer.consume((Object)JavaInheritorsGetter.createNewArrayItem(identifierCopy, type2));
            if (!JavaInheritorsGetter.shouldAddArrayInitializer(identifierCopy)) continue;
            PsiTypeLookupItem item = JavaInheritorsGetter.createNewArrayItem(identifierCopy, type2);
            item.setAddArrayInitializer();
            consumer.consume((Object)item);
        }
    }

    private static PsiTypeLookupItem createNewArrayItem(PsiElement context, PsiType type2) {
        return PsiTypeLookupItem.createLookupItem(TypeConversionUtil.erasure((PsiType)GenericsUtil.getVariableTypeByExpressionType((PsiType)type2)), context).setShowPackage();
    }

    private static List<PsiClassType> extractClassTypes(ExpectedTypeInfo[] infos) {
        SmartList expectedClassTypes = new SmartList();
        for (PsiType type2 : ExpectedTypesGetter.extractTypes(infos, true)) {
            PsiClassType classType;
            if (!(type2 instanceof PsiClassType) || (classType = (PsiClassType)type2).resolve() == null) continue;
            expectedClassTypes.add(classType);
        }
        return expectedClassTypes;
    }

    @Nullable
    private LookupElement addExpectedType(PsiType type2, CompletionParameters parameters2) {
        if (!JavaCompletionUtil.hasAccessibleConstructor(type2)) {
            return null;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        if (psiClass == null || psiClass.getName() == null) {
            return null;
        }
        PsiElement position = parameters2.getPosition();
        if ((parameters2.getInvocationCount() < 2 || psiClass instanceof PsiCompiledElement) && HighlightClassUtil.checkCreateInnerClassFromStaticContext(position, null, psiClass) != null && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("new")).afterLeaf(new String[]{"."}))).accepts((Object)position)) {
            return null;
        }
        PsiType psiType = GenericsUtil.eliminateWildcards((PsiType)type2);
        if (JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)parameters2.getOriginalPosition()) && PsiUtil.getLanguageLevel((PsiElement)parameters2.getOriginalFile()).isAtLeast(LanguageLevel.JDK_1_7)) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
            if (psiClass.hasTypeParameters() && !((PsiClassType)type2).isRaw()) {
                String erasedText = TypeConversionUtil.erasure((PsiType)psiType).getCanonicalText();
                String canonicalText = psiType.getCanonicalText();
                if (canonicalText.contains("?extends") || canonicalText.contains("?super")) {
                    LOG.error("Malformed canonical text: " + canonicalText + "; presentable text: " + psiType + " of " + psiType.getClass() + "; " + (psiType instanceof PsiClassReferenceType ? ((PsiClassReferenceType)psiType).getReference().getClass() : ""));
                    return null;
                }
                try {
                    boolean hasDefaultConstructor = PsiDiamondTypeImpl.hasDefaultConstructor(psiClass);
                    boolean hasConstructorWithGenericsParameters = PsiDiamondTypeImpl.haveConstructorsGenericsParameters(psiClass);
                    if (hasDefaultConstructor || !hasConstructorWithGenericsParameters) {
                        String args;
                        if (hasDefaultConstructor) {
                            args = "";
                        } else {
                            Object[] constructorParams = psiClass.getConstructors()[0].getParameterList().getParameters();
                            args = StringUtil.join((Object[])constructorParams, p -> PsiTypesUtil.getDefaultValueOfType((PsiType)p.getType()), (String)",");
                        }
                        PsiStatement statement = elementFactory.createStatementFromText(canonicalText + " v = new " + erasedText + "<>(" + args + ")", parameters2.getPosition());
                        PsiVariable declaredVar = (PsiVariable)((PsiDeclarationStatement)statement).getDeclaredElements()[0];
                        PsiNewExpression initializer = (PsiNewExpression)declaredVar.getInitializer();
                        PsiDiamondType.DiamondInferenceResult inferenceResult = PsiDiamondTypeImpl.resolveInferredTypes(initializer);
                        if (inferenceResult.getErrorMessage() == null && !psiClass.hasModifierProperty("abstract") && JavaInheritorsGetter.areInferredTypesApplicable(inferenceResult.getTypes(), parameters2.getPosition())) {
                            psiType = initializer.getType();
                        }
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }
        }
        PsiTypeLookupItem item = PsiTypeLookupItem.createLookupItem(psiType, position).setShowPackage();
        if (psiClass.isInterface() || psiClass.hasModifierProperty("abstract")) {
            item.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
            item.setIndicateAnonymous(true);
        }
        return LookupElementDecorator.withInsertHandler((LookupElement)item, (InsertHandler)this.myConstructorInsertHandler);
    }

    private static boolean areInferredTypesApplicable(@NotNull PsiType[] types, PsiElement position) {
        if (types == null) {
            JavaInheritorsGetter.$$$reportNull$$$0(2);
        }
        PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiNewExpression.class, (boolean)false);
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)position)) {
            return newExpression != null && PsiTypesUtil.getExpectedTypeByParent((PsiElement)newExpression) != null;
        }
        PsiCallExpression methodCallExpression = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)newExpression, PsiCallExpression.class, (boolean)false, (Class[])new Class[]{PsiStatement.class});
        if (methodCallExpression != null && PsiUtil.isLanguageLevel8OrHigher((PsiElement)methodCallExpression)) {
            PsiType expectedType;
            PsiClass aClass;
            PsiParameter[] parameters2;
            JavaResolveResult resolveResult;
            PsiMethod method;
            int idx;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)newExpression.getParent());
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            int n = idx = argumentList != null ? ArrayUtil.find((Object[])argumentList.getExpressions(), (Object)parent) : -1;
            if (idx > -1 && (method = (PsiMethod)(resolveResult = methodCallExpression.resolveMethodGenerics()).getElement()) != null && idx < (parameters2 = method.getParameterList().getParameters()).length && (aClass = PsiUtil.resolveClassInType((PsiType)(expectedType = resolveResult.getSubstitutor().substitute(parameters2[idx].getType())))) != null) {
                PsiClassType inferredArg = JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(aClass, types);
                return TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)inferredArg);
            }
        }
        return true;
    }

    public static void processInheritors(CompletionParameters parameters2, Collection<PsiClassType> expectedClassTypes, PrefixMatcher matcher, Consumer<PsiType> consumer) {
        PsiElement context = parameters2.getPosition();
        GlobalSearchScope scope = context.getResolveScope();
        expectedClassTypes = ContainerUtil.mapNotNull(expectedClassTypes, type2 -> type2.resolve() instanceof PsiTypeParameter ? null : PsiClassImplUtil.correctType(type2, scope));
        if (!JavaInheritorsGetter.processMostProbableInheritors(parameters2.getOriginalFile(), context, expectedClassTypes, consumer)) {
            return;
        }
        for (PsiClassType type3 : expectedClassTypes) {
            CodeInsightUtil.processSubTypes((PsiType)type3, context, false, matcher, consumer);
        }
    }

    private static boolean processMostProbableInheritors(PsiFile contextFile, PsiElement context, Collection<PsiClassType> expectedClassTypes, Consumer<PsiType> consumer) {
        block0: for (PsiClassType type2 : expectedClassTypes) {
            StatisticsInfo[] stats;
            consumer.consume((Object)type2);
            PsiClassType.ClassResolveResult baseResult = JavaCompletionUtil.originalize(type2).resolveGenerics();
            PsiClass baseClass = baseResult.getElement();
            if (baseClass == null) {
                return false;
            }
            PsiSubstitutor baseSubstitutor = baseResult.getSubstitutor();
            Processor<PsiClass> processor = CodeInsightUtil.createInheritorsProcessor(context, type2, 0, false, consumer, baseClass, baseSubstitutor);
            for (StatisticsInfo statisticsInfo : stats = StatisticsManager.getInstance().getAllValues(JavaStatisticsManager.getAfterNewKey((PsiType)type2))) {
                String value2 = statisticsInfo.getValue();
                if (!value2.startsWith("class#")) continue;
                String qname = value2.substring("class#".length());
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)contextFile.getProject()).findClass(qname, contextFile.getResolveScope());
                if (psiClass != null && !PsiTreeUtil.isAncestor((PsiElement)contextFile, (PsiElement)psiClass, (boolean)true) && !processor.process((Object)psiClass)) continue block0;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/JavaInheritorsGetter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "areInferredTypesApplicable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addCompletions$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

