/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CheckInitialized;
import com.intellij.codeInsight.completion.CollectConversion;
import com.intellij.codeInsight.completion.CompletionBundle;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.ConstructorInsertHandler;
import com.intellij.codeInsight.completion.ExcludeFilter;
import com.intellij.codeInsight.completion.FunctionalExpressionCompletionProvider;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaClassNameInsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionSession;
import com.intellij.codeInsight.completion.JavaCompletionSorting;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaGenerateMemberCompletionContributor;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaMemberNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaStaticMemberProcessor;
import com.intellij.codeInsight.completion.LabelReferenceCompletion;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.MethodReturnTypeProvider;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.SameSignatureCallParametersProvider;
import com.intellij.codeInsight.completion.SmartCastProvider;
import com.intellij.codeInsight.completion.TypeArgumentCompletionProvider;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiNameValuePairPattern;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementExtractorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.classes.AnnotationTypeFilter;
import com.intellij.psi.filters.classes.AssignableFromContextFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.filters.getters.ExpectedTypesGetter;
import com.intellij.psi.filters.getters.JavaMembersGetter;
import com.intellij.psi.impl.java.stubs.index.JavaAutoModuleNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.PsiLabelReference;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.JavaCompletionContributor");
    static final ElementPattern<PsiElement> ANNOTATION_NAME = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiAnnotation.class})).afterLeaf(new String[]{"@"});
    private static final PsiJavaElementPattern.Capture<PsiElement> UNEXPECTED_REFERENCE_AFTER_DOT = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."})).insideStarting((ElementPattern)PsiJavaPatterns.psiExpressionStatement());
    private static final PsiNameValuePairPattern NAME_VALUE_PAIR = (PsiNameValuePairPattern)PsiJavaPatterns.psiNameValuePair().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiAnnotation.class));
    private static final ElementPattern<PsiElement> ANNOTATION_ATTRIBUTE_NAME = PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiIdentifier.class).withParent((ElementPattern)NAME_VALUE_PAIR), ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"("})).withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().withParent((ElementPattern)NAME_VALUE_PAIR))});
    private static final ElementPattern SWITCH_LABEL = PsiJavaPatterns.psiElement().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiSwitchLabelStatement.class).withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiSwitchStatement.class).with((PatternCondition)new PatternCondition<PsiSwitchStatement>("enumExpressionType"){

        public boolean accepts(@NotNull PsiSwitchStatement psiSwitchStatement, ProcessingContext context) {
            PsiExpression expression2;
            if (psiSwitchStatement == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((expression2 = psiSwitchStatement.getExpression()) == null) {
                return false;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
            return aClass != null && aClass.isEnum();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiSwitchStatement", "com/intellij/codeInsight/completion/JavaCompletionContributor$1", "accepts"));
        }
    })));
    private static final ElementPattern<PsiElement> AFTER_NUMBER_LITERAL = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement().withElementType((ElementPattern)PsiJavaPatterns.elementType().oneOf((Object[])new IElementType[]{JavaTokenType.DOUBLE_LITERAL, JavaTokenType.LONG_LITERAL, JavaTokenType.FLOAT_LITERAL, JavaTokenType.INTEGER_LITERAL})));
    private static final ElementPattern<PsiElement> IMPORT_REFERENCE = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).withParent(PsiImportStatementBase.class));
    private static final ElementPattern<PsiElement> CATCH_OR_FINALLY = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("}")).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiCodeBlock.class).afterLeaf(new String[]{"try"})));
    private static final ElementPattern<PsiElement> INSIDE_CONSTRUCTOR = PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiMethod().constructor(true));

    @Nullable
    public static ElementFilter getReferenceFilter(PsiElement position) {
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)position, PsiClass.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiMethod.class, PsiExpressionList.class, PsiVariable.class, PsiAnnotation.class});
        if (containingClass != null && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"extends", "implements", ",", "&"})).accepts((Object)position)) {
            return new AndFilter((ElementFilter)ElementClassFilter.CLASS, (ElementFilter)new NotFilter((ElementFilter)new AssignableFromContextFilter()));
        }
        if (ANNOTATION_NAME.accepts((Object)position)) {
            return new AnnotationTypeFilter();
        }
        if (JavaKeywordCompletion.isDeclarationStart(position) || JavaKeywordCompletion.isInsideParameterList(position) || JavaCompletionContributor.isInsideAnnotationName(position) || ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiReferenceParameterList.class)).accepts((Object)position)) {
            return new OrFilter(new ElementFilter[]{ElementClassFilter.CLASS, ElementClassFilter.PACKAGE});
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"instanceof"})).accepts((Object)position)) {
            return new ElementExtractorFilter(ElementClassFilter.CLASS);
        }
        if (JavaKeywordCompletion.VARIABLE_AFTER_FINAL.accepts((Object)position)) {
            return ElementClassFilter.CLASS;
        }
        if (CATCH_OR_FINALLY.accepts((Object)position) || JavaKeywordCompletion.START_SWITCH.accepts((Object)position) || JavaKeywordCompletion.isInstanceofPlace(position) || JavaKeywordCompletion.isAfterPrimitiveOrArrayType(position)) {
            return null;
        }
        if (((PsiElementPattern)JavaKeywordCompletion.START_FOR.withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiExpressionStatement.class, PsiForStatement.class})).accepts((Object)position)) {
            return new OrFilter(new ElementFilter[]{ElementClassFilter.CLASS, ElementClassFilter.VARIABLE});
        }
        if (JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
            return ElementClassFilter.CLASS;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiAnnotationParameterList.class)).accepts((Object)position)) {
            return JavaCompletionContributor.createAnnotationFilter(position);
        }
        PsiVariable var = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)position, PsiVariable.class, (boolean)false, (Class[])new Class[]{PsiClass.class});
        if (var != null && PsiTreeUtil.isAncestor((PsiElement)var.getInitializer(), (PsiElement)position, (boolean)false)) {
            return new ExcludeFilter(var);
        }
        if (SWITCH_LABEL.accepts((Object)position)) {
            return new ClassFilter(PsiField.class){

                public boolean isAcceptable(Object element, PsiElement context) {
                    return element instanceof PsiEnumConstant;
                }
            };
        }
        PsiForeachStatement loop = (PsiForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiForeachStatement.class);
        if (loop != null && PsiTreeUtil.isAncestor((PsiElement)loop.getIteratedValue(), (PsiElement)position, (boolean)false)) {
            return new ExcludeFilter((PsiVariable)loop.getIterationParameter());
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiPackageAccessibilityStatement.class) != null) {
            return JavaCompletionContributor.applyScopeFilter(ElementClassFilter.PACKAGE, position);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{PsiUsesStatement.class, PsiProvidesStatement.class}) != null) {
            OrFilter filter = new OrFilter(new ElementFilter[]{ElementClassFilter.CLASS, ElementClassFilter.PACKAGE});
            if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiReferenceList.class) != null) {
                filter = JavaCompletionContributor.applyScopeFilter((ElementFilter)filter, position);
            }
            return filter;
        }
        return TrueFilter.INSTANCE;
    }

    private static boolean isInsideAnnotationName(PsiElement position) {
        PsiAnnotation anno = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        return anno != null && PsiTreeUtil.isAncestor((PsiElement)anno.getNameReferenceElement(), (PsiElement)position, (boolean)true);
    }

    private static ElementFilter createAnnotationFilter(PsiElement position) {
        ArrayList filters = ContainerUtil.newArrayList((Object[])new ElementFilter[]{ElementClassFilter.CLASS, ElementClassFilter.PACKAGE, new AndFilter((ElementFilter)new ClassFilter(PsiField.class), (ElementFilter)new ModifierFilter("static", "final"))});
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiNameValuePair())).accepts((Object)position)) {
            filters.add(new ClassFilter(PsiAnnotationMethod.class){

                public boolean isAcceptable(Object element, PsiElement context) {
                    return element instanceof PsiAnnotationMethod && PsiUtil.isAnnotationMethod((PsiElement)((PsiElement)element));
                }
            });
        }
        return new OrFilter(filters.toArray(ElementFilter.EMPTY_ARRAY));
    }

    public static ElementFilter applyScopeFilter(ElementFilter filter, PsiElement position) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)position);
        return module != null ? new AndFilter(filter, (ElementFilter)new SearchScopeFilter(module.getModuleScope())) : filter;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet _result) {
        PsiReference reference;
        if (parameters2 == null) {
            JavaCompletionContributor.$$$reportNull$$$0(0);
        }
        if (_result == null) {
            JavaCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters2.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        PsiElement position = parameters2.getPosition();
        if (!JavaCompletionContributor.isInJavaContext(position)) {
            return;
        }
        if (AFTER_NUMBER_LITERAL.accepts((Object)position) || UNEXPECTED_REFERENCE_AFTER_DOT.accepts((Object)position)) {
            _result.stopHere();
            return;
        }
        CompletionResultSet result = JavaCompletionSorting.addJavaSorting(parameters2, _result);
        JavaCompletionSession session = new JavaCompletionSession(result);
        if (ANNOTATION_ATTRIBUTE_NAME.accepts((Object)position) && !JavaKeywordCompletion.isAfterPrimitiveOrArrayType(position)) {
            JavaCompletionContributor.addExpectedTypeMembers(parameters2, (Consumer<LookupElement>)result);
            JavaKeywordCompletion.addPrimitiveTypes((Consumer<LookupElement>)result, position, session);
            JavaCompletionContributor.completeAnnotationAttributeName(result, position, parameters2);
            result.stopHere();
            return;
        }
        PrefixMatcher matcher = result.getPrefixMatcher();
        PsiElement parent = position.getParent();
        if (new JavaKeywordCompletion(parameters2, session).addWildcardExtendsSuper(result, position)) {
            return;
        }
        if (position instanceof PsiIdentifier) {
            JavaCompletionContributor.addIdentifierVariants(parameters2, position, result, session, matcher);
        }
        MultiMap<CompletionResultSet, LookupElement> referenceVariants = JavaCompletionContributor.addReferenceVariants(parameters2, result, session);
        Set usedWords = ContainerUtil.map2Set((Collection)referenceVariants.values(), LookupElement::getLookupString);
        for (Map.Entry entry : referenceVariants.entrySet()) {
            session.registerBatchItems((CompletionResultSet)entry.getKey(), (Collection)entry.getValue());
        }
        session.flushBatchItems();
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiLiteralExpression.class)).accepts((Object)position) && ((reference = position.getContainingFile().findReferenceAt(parameters2.getOffset())) == null || reference.isSoft())) {
            WordCompletionContributor.addWordCompletionVariants((CompletionResultSet)result, (CompletionParameters)parameters2, (Set)usedWords);
        }
        if (position instanceof PsiIdentifier) {
            JavaGenerateMemberCompletionContributor.fillCompletionVariants(parameters2, result);
        }
        JavaCompletionContributor.addAllClasses(parameters2, result, session);
        if (position instanceof PsiIdentifier) {
            FunctionalExpressionCompletionProvider.addFunctionalVariants(parameters2, false, true, result.getPrefixMatcher(), (Consumer<LookupElement>)result);
        }
        if (position instanceof PsiIdentifier && parent instanceof PsiReferenceExpression && !((PsiReferenceExpression)parent).isQualified() && parameters2.isExtendedCompletion() && StringUtil.isNotEmpty((String)matcher.getPrefix())) {
            new JavaStaticMemberProcessor(parameters2).processStaticMethodsGlobally(matcher, (Consumer<LookupElement>)result);
        }
        if (parent instanceof PsiJavaModuleReferenceElement) {
            JavaCompletionContributor.addModuleReferences(parent, parameters2.getOriginalFile(), result);
        }
        result.stopHere();
    }

    private static void addIdentifierVariants(@NotNull CompletionParameters parameters2, PsiElement position, CompletionResultSet result, JavaCompletionSession session, PrefixMatcher matcher) {
        if (parameters2 == null) {
            JavaCompletionContributor.$$$reportNull$$$0(2);
        }
        session.registerBatchItems(result, JavaCompletionContributor.getFastIdentifierVariants(parameters2, position, matcher, position.getParent(), session));
        if (JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
            session.flushBatchItems();
            new JavaInheritorsGetter(ConstructorInsertHandler.BASIC_INSTANCE).generateVariants(parameters2, matcher, (Consumer<LookupElement>)((Consumer)lookupElement -> {
                if (!JavaCompletionContributor.isSuggestedByKeywordCompletion(lookupElement)) {
                    session.addClassItem((LookupElement)lookupElement);
                }
            }));
        }
        JavaCompletionContributor.suggestSmartCast(parameters2, session, false, (Consumer<LookupElement>)result);
    }

    private static boolean isSuggestedByKeywordCompletion(LookupElement lookupElement) {
        if (lookupElement instanceof PsiTypeLookupItem) {
            PsiType type2 = ((PsiTypeLookupItem)lookupElement).getType();
            return type2 instanceof PsiArrayType && ((PsiArrayType)type2).getComponentType() instanceof PsiPrimitiveType;
        }
        return false;
    }

    private static void suggestSmartCast(CompletionParameters parameters2, JavaCompletionSession session, boolean quick, Consumer<LookupElement> result) {
        if (SmartCastProvider.shouldSuggestCast(parameters2)) {
            session.flushBatchItems();
            SmartCastProvider.addCastVariants(parameters2, session.getMatcher(), (Consumer<LookupElement>)((Consumer)element -> {
                JavaCompletionContributor.registerClassFromTypeElement(element, session);
                result.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)element, (double)1.0));
            }), quick);
        }
    }

    private static List<LookupElement> getFastIdentifierVariants(@NotNull CompletionParameters parameters2, PsiElement position, PrefixMatcher matcher, PsiElement parent, @NotNull JavaCompletionSession session) {
        if (parameters2 == null) {
            JavaCompletionContributor.$$$reportNull$$$0(3);
        }
        if (session == null) {
            JavaCompletionContributor.$$$reportNull$$$0(4);
        }
        ArrayList<LookupElement> items = new ArrayList<LookupElement>();
        if (TypeArgumentCompletionProvider.IN_TYPE_ARGS.accepts((Object)position)) {
            new TypeArgumentCompletionProvider(false, session).addTypeArgumentVariants(parameters2, (Consumer<LookupElement>)((Consumer)items::add), matcher);
        }
        FunctionalExpressionCompletionProvider.addFunctionalVariants(parameters2, false, false, matcher, (Consumer<LookupElement>)((Consumer)items::add));
        if (MethodReturnTypeProvider.IN_METHOD_RETURN_TYPE.accepts((Object)position)) {
            MethodReturnTypeProvider.addProbableReturnTypes(parameters2, (Consumer<LookupElement>)((Consumer)element -> {
                if (session == null) {
                    JavaCompletionContributor.$$$reportNull$$$0(14);
                }
                JavaCompletionContributor.registerClassFromTypeElement(element, session);
                items.add((LookupElement)element);
            }));
        }
        JavaCompletionContributor.suggestSmartCast(parameters2, session, true, (Consumer<LookupElement>)((Consumer)items::add));
        if (parent instanceof PsiReferenceExpression) {
            List<ExpectedTypeInfo> expected = Arrays.asList(ExpectedTypesProvider.getExpectedTypes((PsiExpression)parent, true));
            CollectConversion.addCollectConversion((PsiReferenceExpression)parent, expected, (Consumer<LookupElement>)((Consumer)lookupElement -> items.add((LookupElement)JavaSmartCompletionContributor.decorate(lookupElement, expected))));
        }
        if (IMPORT_REFERENCE.accepts((Object)position)) {
            items.add((LookupElement)LookupElementBuilder.create((String)"*"));
        }
        items.addAll(new JavaKeywordCompletion(parameters2, session).getResults());
        JavaCompletionContributor.addExpressionVariants(parameters2, position, (Consumer<LookupElement>)((Consumer)items::add));
        return items;
    }

    private static void registerClassFromTypeElement(LookupElement element, JavaCompletionSession session) {
        PsiClass aClass;
        PsiType type2 = ((PsiTypeLookupItem)ObjectUtils.assertNotNull((Object)element.as(PsiTypeLookupItem.CLASS_CONDITION_KEY))).getType();
        if (type2 instanceof PsiPrimitiveType) {
            session.registerKeyword(type2.getCanonicalText(false));
        } else if (type2 instanceof PsiClassType && ((PsiClassType)type2).getParameterCount() == 0 && (aClass = ((PsiClassType)type2).resolve()) != null) {
            session.registerClass(aClass);
        }
    }

    private static void addExpressionVariants(@NotNull CompletionParameters parameters2, PsiElement position, Consumer<LookupElement> result) {
        if (parameters2 == null) {
            JavaCompletionContributor.$$$reportNull$$$0(5);
        }
        if (JavaSmartCompletionContributor.INSIDE_EXPRESSION.accepts((Object)position) && !JavaKeywordCompletion.AFTER_DOT.accepts((Object)position) && !SmartCastProvider.shouldSuggestCast(parameters2)) {
            JavaCompletionContributor.addExpectedTypeMembers(parameters2, result);
            if (SameSignatureCallParametersProvider.IN_CALL_ARGUMENT.accepts((Object)position)) {
                new SameSignatureCallParametersProvider().addSignatureItems(parameters2, result);
            }
        }
    }

    public static boolean isInJavaContext(PsiElement position) {
        return PsiUtilCore.findLanguageFromElement((PsiElement)position).isKindOf((Language)JavaLanguage.INSTANCE);
    }

    public static void addAllClasses(CompletionParameters parameters2, CompletionResultSet result, JavaCompletionSession session) {
        if (!JavaCompletionContributor.isClassNamePossible(parameters2) || !JavaCompletionContributor.mayStartClassName(result)) {
            return;
        }
        if (parameters2.getInvocationCount() >= 2) {
            JavaClassNameCompletionContributor.addAllClasses(parameters2, parameters2.getInvocationCount() <= 2, result.getPrefixMatcher(), (Consumer<LookupElement>)((Consumer)element -> {
                if (!session.alreadyProcessed((LookupElement)element)) {
                    result.addElement(JavaCompletionUtil.highlightIfNeeded(null, element, element.getObject(), parameters2.getPosition()));
                }
            }));
        } else {
            JavaCompletionContributor.advertiseSecondCompletion(parameters2.getPosition().getProject(), result);
        }
    }

    public static void advertiseSecondCompletion(Project project, CompletionResultSet result) {
        if (FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup("editing.completion.second.basic", project)) {
            result.addLookupAdvertisement("Press " + JavaCompletionContributor.getActionShortcut((String)"CodeCompletion") + " to see non-imported classes");
        }
    }

    private static MultiMap<CompletionResultSet, LookupElement> addReferenceVariants(CompletionParameters parameters2, CompletionResultSet result, JavaCompletionSession session) {
        MultiMap items = MultiMap.create();
        PsiElement position = parameters2.getPosition();
        boolean first = parameters2.getInvocationCount() <= 1;
        boolean isSwitchLabel = SWITCH_LABEL.accepts((Object)position);
        boolean isAfterNew = JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)position);
        boolean pkgContext = JavaCompletionUtil.inSomePackage(position);
        PsiType[] expectedTypes = ExpectedTypesGetter.getExpectedTypes(parameters2.getPosition(), true);
        LegacyCompletionContributor.processReferences((CompletionParameters)parameters2, (CompletionResultSet)result, (reference, result1) -> {
            if (reference instanceof PsiJavaReference) {
                ElementFilter filter = JavaCompletionContributor.getReferenceFilter(position);
                if (filter != null) {
                    if (INSIDE_CONSTRUCTOR.accepts((Object)position) && (parameters2.getInvocationCount() <= 1 || CheckInitialized.isInsideConstructorCall(position))) {
                        filter = new AndFilter(filter, (ElementFilter)new CheckInitialized(position));
                    }
                    PsiFile originalFile = parameters2.getOriginalFile();
                    JavaCompletionProcessor.Options options = JavaCompletionProcessor.Options.DEFAULT_OPTIONS.withCheckAccess(first).withFilterStaticAfterInstance(first).withShowInstanceInStaticContext(!first);
                    for (LookupElement element : JavaCompletionUtil.processJavaReference(position, (PsiJavaReference)reference, new ElementExtractorFilter(filter), options, result1.getPrefixMatcher(), parameters2)) {
                        JavaMethodCallElement call;
                        PsiMethod method;
                        if (session.alreadyProcessed(element)) continue;
                        if (isSwitchLabel) {
                            items.putValue(result1, (Object)new IndentingDecorator((LookupElement)TailTypeDecorator.withTail((LookupElement)element, (TailType)TailType.createSimpleTailType((char)':'))));
                            continue;
                        }
                        LookupItem item = (LookupItem)element.as(LookupItem.CLASS_CONDITION_KEY);
                        if (originalFile instanceof PsiJavaCodeReferenceCodeFragment && !((PsiJavaCodeReferenceCodeFragment)originalFile).isClassesAccepted() && item != null) {
                            item.setTailType(TailType.NONE);
                        }
                        if (item instanceof JavaMethodCallElement && (method = (PsiMethod)(call = (JavaMethodCallElement)item).getObject()).getTypeParameters().length > 0) {
                            PsiType matchingExpectation;
                            PsiType returned = TypeConversionUtil.erasure((PsiType)method.getReturnType());
                            PsiType psiType = matchingExpectation = returned == null ? null : (PsiType)ContainerUtil.find((Object[])expectedTypes, type2 -> type2.isAssignableFrom(returned));
                            if (matchingExpectation != null) {
                                call.setInferenceSubstitutorFromExpectedType(position, matchingExpectation);
                            }
                        }
                        items.putValue(result1, (Object)element);
                    }
                }
                return;
            }
            if (reference instanceof PsiLabelReference) {
                items.putValues(result1, LabelReferenceCompletion.processLabelReference((PsiLabelReference)reference));
                return;
            }
            Object[] variants = reference.getVariants();
            if (variants == null) {
                LOG.error("Reference=" + reference);
            }
            for (Object completion : variants) {
                if (completion == null) {
                    LOG.error("Position=" + position + "\n;Reference=" + reference + "\n;variants=" + Arrays.toString(variants));
                }
                if (completion instanceof LookupElement && !session.alreadyProcessed((LookupElement)completion)) {
                    items.putValue(result1, (Object)((LookupElement)completion));
                    continue;
                }
                if (completion instanceof PsiClass) {
                    Condition condition2 = psiClass -> !session.alreadyProcessed((PsiClass)psiClass) && JavaCompletionUtil.isSourceLevelAccessible(position, psiClass, pkgContext);
                    items.putValues(result1, JavaClassNameCompletionContributor.createClassLookupItems((PsiClass)completion, isAfterNew, JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER, (Condition<PsiClass>)condition2));
                    continue;
                }
                items.putValue(result1, (Object)LookupItemUtil.objectToLookupItem(completion));
            }
        });
        return items;
    }

    static boolean isClassNamePossible(CompletionParameters parameters2) {
        boolean isSecondCompletion = parameters2.getInvocationCount() >= 2;
        PsiElement position = parameters2.getPosition();
        if (JavaKeywordCompletion.isInstanceofPlace(position) || JavaMemberNameCompletionContributor.INSIDE_TYPE_PARAMS_PATTERN.accepts((Object)position)) {
            return false;
        }
        PsiElement parent = position.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement)) {
            return isSecondCompletion;
        }
        if (((PsiJavaCodeReferenceElement)parent).getQualifier() != null) {
            return isSecondCompletion;
        }
        if (parent instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)parent).getKindEnum(parent.getContainingFile()) == PsiJavaCodeReferenceElementImpl.Kind.PACKAGE_NAME_KIND) {
            return false;
        }
        PsiElement grand = parent.getParent();
        if (grand instanceof PsiSwitchLabelStatement) {
            return false;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiImportStatement.class)).accepts((Object)parent)) {
            return isSecondCompletion;
        }
        if (grand instanceof PsiAnonymousClass) {
            grand = grand.getParent();
        }
        if (grand instanceof PsiNewExpression && ((PsiNewExpression)grand).getQualifier() != null) {
            return false;
        }
        return !JavaKeywordCompletion.isAfterPrimitiveOrArrayType(position);
    }

    public static boolean mayStartClassName(CompletionResultSet result) {
        return StringUtil.isNotEmpty((String)result.getPrefixMatcher().getPrefix());
    }

    private static void completeAnnotationAttributeName(CompletionResultSet result, PsiElement insertedElement, CompletionParameters parameters2) {
        PsiElement element;
        PsiNameValuePair pair = (PsiNameValuePair)PsiTreeUtil.getParentOfType((PsiElement)insertedElement, PsiNameValuePair.class);
        PsiAnnotationParameterList parameterList = (PsiAnnotationParameterList)((PsiNameValuePair)ObjectUtils.assertNotNull((Object)pair)).getParent();
        PsiAnnotation anno = (PsiAnnotation)parameterList.getParent();
        boolean showClasses = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"("})).accepts((Object)insertedElement);
        PsiClass annoClass = null;
        PsiJavaCodeReferenceElement referenceElement = anno.getNameReferenceElement();
        if (referenceElement != null && (element = referenceElement.resolve()) instanceof PsiClass && (annoClass = (PsiClass)element).findMethodsByName("value", false).length == 0) {
            showClasses = false;
        }
        if (showClasses && insertedElement.getParent() instanceof PsiReferenceExpression) {
            Set<LookupElement> set = JavaCompletionUtil.processJavaReference(insertedElement, (PsiJavaReference)insertedElement.getParent(), new ElementExtractorFilter(JavaCompletionContributor.createAnnotationFilter(insertedElement)), JavaCompletionProcessor.Options.DEFAULT_OPTIONS, result.getPrefixMatcher(), parameters2);
            for (LookupElement element2 : set) {
                result.addElement(element2);
            }
            JavaCompletionContributor.addAllClasses(parameters2, result, new JavaCompletionSession(result));
        }
        if (annoClass != null && annoClass.isAnnotationType()) {
            PsiNameValuePair[] existingPairs = parameterList.getAttributes();
            block1: for (PsiMethod method : annoClass.getMethods()) {
                if (!(method instanceof PsiAnnotationMethod)) continue;
                String attrName = method.getName();
                for (PsiNameValuePair existingAttr : existingPairs) {
                    if (PsiTreeUtil.isAncestor((PsiElement)existingAttr, (PsiElement)insertedElement, (boolean)false)) break;
                    if (Comparing.equal((String)existingAttr.getName(), (String)attrName) || "value".equals(attrName) && existingAttr.getName() == null) continue block1;
                }
                LookupElementBuilder element3 = LookupElementBuilder.createWithIcon((PsiNamedElement)method).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        Editor editor = context.getEditor();
                        TailType.EQ.processTail(editor, editor.getCaretModel().getOffset());
                        context.setAddCompletionChar(false);
                        context.commitDocument();
                        PsiAnnotationParameterList paramList = (PsiAnnotationParameterList)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiAnnotationParameterList.class, (boolean)false);
                        if (paramList != null && paramList.getAttributes().length > 0 && paramList.getAttributes()[0].getName() == null) {
                            int valueOffset = paramList.getAttributes()[0].getTextRange().getStartOffset();
                            context.getDocument().insertString(valueOffset, (CharSequence)"value");
                            TailType.EQ.processTail(editor, valueOffset + "value".length());
                        }
                    }
                });
                PsiAnnotationMemberValue defaultValue = ((PsiAnnotationMethod)method).getDefaultValue();
                if (defaultValue != null) {
                    element3 = element3.withTailText(" default " + defaultValue.getText(), true);
                }
                result.addElement((LookupElement)element3);
            }
        }
    }

    public String advertise(@NotNull CompletionParameters parameters2) {
        PsiType[] psiTypes;
        String shortcut;
        String shortcut2;
        if (parameters2 == null) {
            JavaCompletionContributor.$$$reportNull$$$0(6);
        }
        if (!(parameters2.getOriginalFile() instanceof PsiJavaFile)) {
            return null;
        }
        if (parameters2.getCompletionType() == CompletionType.BASIC && parameters2.getInvocationCount() > 0) {
            PsiElement position = parameters2.getPosition();
            if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().withFirstChild((ElementPattern)PsiJavaPatterns.psiReferenceExpression().referencing((ElementPattern)PsiJavaPatterns.psiClass())))).accepts((Object)position) && CompletionUtil.shouldShowFeature((CompletionParameters)parameters2, (String)"editing.completion.global.member.name") && StringUtil.isNotEmpty((String)(shortcut2 = JavaCompletionContributor.getActionShortcut((String)"CodeCompletion")))) {
                return "Pressing " + shortcut2 + " twice without a class qualifier would show all accessible static methods";
            }
        }
        if (parameters2.getCompletionType() != CompletionType.SMART && JavaCompletionContributor.shouldSuggestSmartCompletion(parameters2.getPosition()) && CompletionUtil.shouldShowFeature((CompletionParameters)parameters2, (String)"editing.completion.smarttype.general") && StringUtil.isNotEmpty((String)(shortcut = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")))) {
            return CompletionBundle.message("completion.smart.hint", shortcut);
        }
        if (parameters2.getCompletionType() == CompletionType.SMART && parameters2.getInvocationCount() == 1 && (psiTypes = ExpectedTypesGetter.getExpectedTypes(parameters2.getPosition(), true)).length > 0) {
            if (CompletionUtil.shouldShowFeature((CompletionParameters)parameters2, (String)"editing.completion.second.smarttype.toar") && StringUtil.isNotEmpty((String)(shortcut2 = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")))) {
                for (PsiType psiType : psiTypes) {
                    PsiType type2 = PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)false);
                    if (type2 == null) continue;
                    return CompletionBundle.message("completion.smart.aslist.hint", shortcut2, type2.getPresentableText());
                }
            }
            if (CompletionUtil.shouldShowFeature((CompletionParameters)parameters2, (String)"editing.completion.second.smarttype.aslist") && StringUtil.isNotEmpty((String)(shortcut2 = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")))) {
                for (PsiType psiType : psiTypes) {
                    PsiType componentType;
                    if (!(psiType instanceof PsiArrayType) || (componentType = ((PsiArrayType)psiType).getComponentType()) instanceof PsiPrimitiveType) continue;
                    return CompletionBundle.message("completion.smart.toar.hint", shortcut2, componentType.getPresentableText());
                }
            }
            if (CompletionUtil.shouldShowFeature((CompletionParameters)parameters2, (String)"editing.completion.second.smarttype.chain") && StringUtil.isNotEmpty((String)(shortcut2 = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")))) {
                return CompletionBundle.message("completion.smart.chain.hint", shortcut2);
            }
        }
        return null;
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters2, Editor editor) {
        String suffix;
        if (parameters2 == null) {
            JavaCompletionContributor.$$$reportNull$$$0(7);
        }
        if (!(parameters2.getOriginalFile() instanceof PsiJavaFile)) {
            return null;
        }
        String ad = this.advertise(parameters2);
        String string = suffix = ad == null ? "" : "; " + StringUtil.decapitalize((String)ad);
        if (parameters2.getCompletionType() == CompletionType.SMART) {
            PsiInstanceOfExpression instanceOfExpression;
            PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)parameters2.getPosition(), PsiExpression.class, (boolean)true);
            if (expression2 instanceof PsiLiteralExpression) {
                return LangBundle.message((String)"completion.no.suggestions", (Object[])new Object[0]) + suffix;
            }
            if (expression2 instanceof PsiInstanceOfExpression && PsiTreeUtil.isAncestor((PsiElement)(instanceOfExpression = (PsiInstanceOfExpression)expression2).getCheckType(), (PsiElement)parameters2.getPosition(), (boolean)false)) {
                return LangBundle.message((String)"completion.no.suggestions", (Object[])new Object[0]) + suffix;
            }
            Set<PsiType> expectedTypes = JavaCompletionUtil.getExpectedTypes(parameters2);
            if (expectedTypes != null) {
                PsiType type2;
                PsiType psiType = type2 = expectedTypes.size() == 1 ? expectedTypes.iterator().next() : null;
                if (type2 != null) {
                    PsiType deepComponentType = type2.getDeepComponentType();
                    String expectedType = type2.getPresentableText();
                    if (expectedType.contains(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED)) {
                        return null;
                    }
                    if (deepComponentType instanceof PsiClassType) {
                        if (((PsiClassType)deepComponentType).resolve() != null) {
                            return CompletionBundle.message("completion.no.suggestions.of.type", expectedType) + suffix;
                        }
                        return CompletionBundle.message("completion.unknown.type", expectedType) + suffix;
                    }
                    if (!PsiType.NULL.equals((Object)type2)) {
                        return CompletionBundle.message("completion.no.suggestions.of.type", expectedType) + suffix;
                    }
                }
            }
        }
        return LangBundle.message((String)"completion.no.suggestions", (Object[])new Object[0]) + suffix;
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            JavaCompletionContributor.$$$reportNull$$$0(8);
        }
        return typeChar == ':' && JavaTokenType.COLON == position.getNode().getElementType();
    }

    private static boolean shouldSuggestSmartCompletion(PsiElement element) {
        if (JavaCompletionContributor.shouldSuggestClassNameCompletion(element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiReferenceExpression && ((PsiReferenceExpression)parent).getQualifier() != null) {
            return false;
        }
        if (parent instanceof PsiReferenceExpression && parent.getParent() instanceof PsiReferenceExpression) {
            return true;
        }
        return ExpectedTypesGetter.getExpectedTypes(element, false).length > 0;
    }

    private static boolean shouldSuggestClassNameCompletion(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getParent() instanceof PsiTypeElement || parent.getParent() instanceof PsiExpressionStatement || parent.getParent() instanceof PsiReferenceList;
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiFile file;
        if (context == null) {
            JavaCompletionContributor.$$$reportNull$$$0(9);
        }
        if ((file = context.getFile()) instanceof PsiJavaFile) {
            if (context.getInvocationCount() > 0) {
                PsiType type2;
                PsiTypeElement typeElement;
                PsiVariable variable;
                JavaCompletionContributor.autoImport(file, context.getStartOffset() - 1, context.getEditor());
                PsiElement leaf = file.findElementAt(context.getStartOffset() - 1);
                if (leaf != null) {
                    leaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)leaf);
                }
                if ((variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiVariable.class)) != null && (typeElement = variable.getTypeElement()) != null && (type2 = typeElement.getType()) instanceof PsiClassType && ((PsiClassType)type2).resolve() == null) {
                    JavaCompletionContributor.autoImportReference(file, context.getEditor(), typeElement.getInnermostComponentReferenceElement());
                }
            }
            if (context.getCompletionType() == CompletionType.BASIC) {
                if (PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(context.getStartOffset() - 1), PsiReferenceParameterList.class, (boolean)false) != null) {
                    context.setDummyIdentifier("IntellijIdeaRulezzz");
                    return;
                }
                if (JavaCompletionContributor.semicolonNeeded(context.getEditor(), file, context.getStartOffset())) {
                    context.setDummyIdentifier("IntellijIdeaRulezzz ".trim() + ";");
                    return;
                }
                PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)context.getStartOffset(), PsiJavaCodeReferenceElement.class, (boolean)false);
                if (ref != null && !(ref instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiElement element = file.findElementAt(context.getStartOffset());
                if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiAnnotation.class)).accepts((Object)element)) {
                    return;
                }
                context.setDummyIdentifier("IntellijIdeaRulezzz");
            }
        }
    }

    public static boolean semicolonNeeded(Editor editor, PsiFile file, int startOffset) {
        PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)startOffset, PsiJavaCodeReferenceElement.class, (boolean)false);
        if (ref != null && !(ref instanceof PsiReferenceExpression) && ref.getParent() instanceof PsiTypeElement) {
            return true;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiIdentifier.class).withParent((ElementPattern)PsiJavaPatterns.psiParameter())).accepts((Object)file.findElementAt(startOffset))) {
            return true;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(startOffset);
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getTokenType() == JavaTokenType.IDENTIFIER) {
            iterator.advance();
        }
        while (!iterator.atEnd() && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (!iterator.atEnd() && iterator.getTokenType() == JavaTokenType.LPARENTH && PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiExpression.class, PsiClass.class}) == null) {
            return true;
        }
        if (!iterator.atEnd() && iterator.getTokenType() == JavaTokenType.COLON && PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)startOffset, PsiConditionalExpression.class, (boolean)false) == null) {
            return true;
        }
        while (!iterator.atEnd() && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (iterator.atEnd() || iterator.getTokenType() != JavaTokenType.IDENTIFIER) {
            return false;
        }
        iterator.advance();
        while (!iterator.atEnd() && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (iterator.atEnd()) {
            return false;
        }
        return iterator.getTokenType() == JavaTokenType.EQ;
    }

    private static void autoImport(@NotNull PsiFile file, int offset, @NotNull Editor editor) {
        if (file == null) {
            JavaCompletionContributor.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            JavaCompletionContributor.$$$reportNull$$$0(11);
        }
        CharSequence text2 = editor.getDocument().getCharsSequence();
        while (offset > 0 && Character.isJavaIdentifierPart(text2.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return;
        }
        while (offset > 0 && Character.isWhitespace(text2.charAt(offset))) {
            --offset;
        }
        if (offset <= 0 || text2.charAt(offset) != '.') {
            return;
        }
        --offset;
        while (offset > 0 && Character.isWhitespace(text2.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return;
        }
        JavaCompletionContributor.autoImportReference(file, editor, JavaCompletionContributor.extractReference(PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiExpression.class, (boolean)false)));
    }

    private static void autoImportReference(@NotNull PsiFile file, @NotNull Editor editor, @Nullable PsiJavaCodeReferenceElement element) {
        PsiJavaCodeReferenceElement qualifier;
        if (file == null) {
            JavaCompletionContributor.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            JavaCompletionContributor.$$$reportNull$$$0(13);
        }
        if (element == null) {
            return;
        }
        while ((qualifier = JavaCompletionContributor.extractReference(element.getQualifier())) != null) {
            element = qualifier;
        }
        if (!(element.getParent() instanceof PsiMethodCallExpression) && element.multiResolve(true).length == 0) {
            new ImportClassFix(element).doFix(editor, false, false);
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        }
    }

    @Nullable
    private static PsiJavaCodeReferenceElement extractReference(@Nullable PsiElement expression2) {
        if (expression2 instanceof PsiJavaCodeReferenceElement) {
            return (PsiJavaCodeReferenceElement)expression2;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)expression2).getMethodExpression();
        }
        return null;
    }

    private static void addExpectedTypeMembers(CompletionParameters parameters2, Consumer<LookupElement> result) {
        if (parameters2.getInvocationCount() <= 1) {
            for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters2)) {
                new JavaMembersGetter(info.getDefaultType(), parameters2).addMembers(false, result);
            }
        }
    }

    private static void addModuleReferences(PsiElement moduleRef, PsiFile originalFile, CompletionResultSet result) {
        PsiElement parent;
        PsiElement statement = moduleRef.getParent();
        boolean requires = statement instanceof PsiRequiresStatement;
        if ((requires || statement instanceof PsiPackageAccessibilityStatement) && (parent = statement.getParent()) != null) {
            Module module;
            Project project = moduleRef.getProject();
            HashSet<String> filter = new HashSet<String>();
            filter.add(((PsiJavaModule)parent).getName());
            JavaModuleNameIndex index = JavaModuleNameIndex.getInstance();
            GlobalSearchScope scope = ProjectScope.getAllScope((Project)project);
            for (String name : index.getAllKeys(project)) {
                if (index.get(name, project, scope).size() <= 0 || !filter.add(name)) continue;
                LookupElementBuilder lookup = LookupElementBuilder.create((String)name).withIcon(AllIcons.Nodes.JavaModule);
                if (requires) {
                    lookup = TailTypeDecorator.withTail((LookupElement)lookup, (TailType)TailType.SEMICOLON);
                }
                result.addElement((LookupElement)lookup);
            }
            if (requires && (module = ModuleUtilCore.findModuleForFile((PsiFile)originalFile)) != null) {
                VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).orderEntries().withoutSdk().librariesOnly().getClassesRoots();
                scope = GlobalSearchScope.filesScope((Project)project, Arrays.asList(roots));
                for (String name : JavaAutoModuleNameIndex.getAllKeys(project)) {
                    if (JavaAutoModuleNameIndex.getFilesByKey(name, scope).size() <= 0 || !PsiNameHelper.isValidModuleName((String)name, (PsiElement)parent) || !filter.add(name)) continue;
                    LookupElementBuilder lookup = LookupElementBuilder.create((String)name).withIcon(AllIcons.FileTypes.Archive);
                    lookup = TailTypeDecorator.withTail((LookupElement)lookup, (TailType)TailType.SEMICOLON);
                    lookup = PrioritizedLookupElement.withPriority((LookupElement)lookup, (double)-1.0);
                    result.addElement((LookupElement)lookup);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_result";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addIdentifierVariants";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getFastIdentifierVariants";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addExpressionVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "advertise";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "handleEmptyLookup";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeAutoPopup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "autoImport";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "autoImportReference";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getFastIdentifierVariants$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SearchScopeFilter
    implements ElementFilter {
        private final GlobalSearchScope myScope;

        public SearchScopeFilter(GlobalSearchScope scope) {
            this.myScope = scope;
        }

        public boolean isAcceptable(Object element, @Nullable PsiElement context) {
            PsiFile psiFile;
            if (element instanceof PsiPackage) {
                return ((PsiDirectoryContainer)element).getDirectories(this.myScope).length > 0;
            }
            if (element instanceof PsiElement && (psiFile = ((PsiElement)element).getContainingFile()) != null) {
                VirtualFile file = psiFile.getVirtualFile();
                return file != null && this.myScope.contains(file);
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }

    static class IndentingDecorator
    extends LookupElementDecorator<LookupElement> {
        public IndentingDecorator(LookupElement delegate) {
            super(delegate);
        }

        public void handleInsert(InsertionContext context) {
            super.handleInsert(context);
            Project project = context.getProject();
            Document document = context.getDocument();
            int lineStartOffset = DocumentUtil.getLineStartOffset((int)context.getStartOffset(), (Document)document);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(context.getFile(), lineStartOffset);
        }
    }
}

