/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.tree.java.MethodReferenceResolver;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionalExpressionCompletionProvider
extends CompletionProvider<CompletionParameters> {
    static final Key<Boolean> LAMBDA_ITEM = Key.create((String)"LAMBDA_ITEM");
    static final Key<Boolean> METHOD_REF_ITEM = Key.create((String)"METHOD_REF_ITEM");
    private static final InsertHandler<LookupElement> CONSTRUCTOR_REF_INSERT_HANDLER = (context, item) -> {
        int start = context.getStartOffset();
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)((PsiType)item.getObject()));
        if (psiClass != null) {
            String insertedName = StringUtil.trimEnd((String)item.getLookupString(), (String)"::new");
            while (insertedName.endsWith("[]")) {
                insertedName = insertedName.substring(0, insertedName.length() - 2);
            }
            JavaCompletionUtil.insertClassReference(psiClass, context.getFile(), start, start + insertedName.length());
        }
    };

    private static boolean isLambdaContext(@NotNull PsiElement element) {
        PsiElement rulezzRef;
        if (element == null) {
            FunctionalExpressionCompletionProvider.$$$reportNull$$$0(0);
        }
        return (rulezzRef = element.getParent()) instanceof PsiReferenceExpression && ((PsiReferenceExpression)rulezzRef).getQualifier() == null && LambdaUtil.isValidLambdaContext((PsiElement)rulezzRef.getParent());
    }

    static boolean isFunExprItem(LookupElement item) {
        return item.getUserData(LAMBDA_ITEM) != null || item.getUserData(METHOD_REF_ITEM) != null;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters2 == null) {
            FunctionalExpressionCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            FunctionalExpressionCompletionProvider.$$$reportNull$$$0(2);
        }
        FunctionalExpressionCompletionProvider.addFunctionalVariants(parameters2, true, true, result.getPrefixMatcher(), (Consumer<LookupElement>)result);
    }

    static void addFunctionalVariants(@NotNull CompletionParameters parameters2, boolean smart, boolean addInheritors, PrefixMatcher matcher, Consumer<LookupElement> result) {
        ExpectedTypeInfo[] expectedTypes;
        if (parameters2 == null) {
            FunctionalExpressionCompletionProvider.$$$reportNull$$$0(3);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)parameters2.getOriginalFile()) || !FunctionalExpressionCompletionProvider.isLambdaContext(parameters2.getPosition())) {
            return;
        }
        for (ExpectedTypeInfo expectedType : expectedTypes = JavaSmartCompletionContributor.getExpectedTypes(parameters2)) {
            PsiType functionalInterfaceType;
            PsiMethod functionalInterfaceMethod;
            PsiType defaultType = expectedType.getDefaultType();
            if (!LambdaUtil.isFunctionalType((PsiType)defaultType) || (functionalInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)(functionalInterfaceType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(defaultType)))) == null) continue;
            Object[] params = PsiParameter.EMPTY_ARRAY;
            PsiElement originalPosition = parameters2.getPosition();
            PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)functionalInterfaceMethod, (PsiClassType.ClassResolveResult)PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType));
            if (!functionalInterfaceMethod.hasTypeParameters()) {
                params = functionalInterfaceMethod.getParameterList().getParameters();
                Project project = functionalInterfaceMethod.getProject();
                JVMElementFactory jvmElementFactory = JVMElementFactories.getFactory((Language)originalPosition.getLanguage(), (Project)project);
                JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                if (jvmElementFactory != null) {
                    params = GenerateMembersUtil.overriddenParameters((PsiParameter[])params, jvmElementFactory, javaCodeStyleManager, substitutor, originalPosition);
                }
                String paramsString = params.length == 1 ? FunctionalExpressionCompletionProvider.getParamName(params[0], originalPosition) : "(" + StringUtil.join((Object[])params, parameter2 -> FunctionalExpressionCompletionProvider.getParamName(parameter2, originalPosition), (String)",") + ")";
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(paramsString + " -> {}", null);
                lambdaExpression = (PsiLambdaExpression)codeStyleManager.reformat((PsiElement)lambdaExpression);
                paramsString = lambdaExpression.getParameterList().getText();
                LookupElementBuilder builder = LookupElementBuilder.create((Object)functionalInterfaceMethod, (String)(paramsString + " -> ")).withPresentableText(paramsString + " -> {}").withTypeText(functionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.Function);
                builder.putUserData(LAMBDA_ITEM, (Object)true);
                result.consume((Object)builder.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE));
            }
            FunctionalExpressionCompletionProvider.addMethodReferenceVariants(smart, addInheritors, parameters2, matcher, functionalInterfaceType, functionalInterfaceMethod, (PsiParameter[])params, originalPosition, substitutor, (Consumer<LookupElement>)((Consumer)element -> {
                element.putUserData(METHOD_REF_ITEM, (Object)true);
                result.consume((Object)(smart ? JavaSmartCompletionContributor.decorate(element, Arrays.asList(expectedTypes)) : element));
            }));
        }
    }

    private static void addMethodReferenceVariants(boolean smart, boolean addInheritors, CompletionParameters parameters2, PrefixMatcher matcher, PsiType functionalInterfaceType, PsiMethod functionalInterfaceMethod, PsiParameter[] params, PsiElement originalPosition, PsiSubstitutor substitutor, Consumer<LookupElement> result) {
        PsiType expectedReturnType = substitutor.substitute(functionalInterfaceMethod.getReturnType());
        if (expectedReturnType == null) {
            return;
        }
        if (params.length > 0) {
            for (LookupElement element : FunctionalExpressionCompletionProvider.collectVariantsByReceiver(!smart, functionalInterfaceType, params, originalPosition, substitutor, expectedReturnType)) {
                result.consume((Object)element);
            }
        }
        for (LookupElement element : FunctionalExpressionCompletionProvider.collectThisVariants(functionalInterfaceType, params, originalPosition, substitutor, expectedReturnType)) {
            result.consume((Object)element);
        }
        for (LookupElement element : FunctionalExpressionCompletionProvider.collectStaticVariants(functionalInterfaceType, params, originalPosition, substitutor, expectedReturnType)) {
            result.consume((Object)element);
        }
        Consumer consumer = eachReturnType -> {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)eachReturnType);
            if (psiClass == null) {
                return;
            }
            if (eachReturnType.getArrayDimensions() == 0) {
                PsiMethod[] constructors;
                if (!MethodReferenceResolver.canBeConstructed(psiClass)) {
                    return;
                }
                for (PsiMethod psiMethod : constructors = psiClass.getConstructors()) {
                    if (!FunctionalExpressionCompletionProvider.isSignatureAppropriate(psiMethod, params, substitutor, 0, originalPosition, null)) continue;
                    result.consume((Object)FunctionalExpressionCompletionProvider.createConstructorReferenceLookup(functionalInterfaceType, eachReturnType));
                }
                if (constructors.length == 0 && params.length == 0) {
                    result.consume((Object)FunctionalExpressionCompletionProvider.createConstructorReferenceLookup(functionalInterfaceType, eachReturnType));
                }
            } else if (params.length == 1 && PsiType.INT.equals((Object)params[0].getType())) {
                result.consume((Object)FunctionalExpressionCompletionProvider.createConstructorReferenceLookup(functionalInterfaceType, eachReturnType));
            }
        };
        if (addInheritors && expectedReturnType instanceof PsiClassType) {
            JavaInheritorsGetter.processInheritors(parameters2, Collections.singletonList((PsiClassType)expectedReturnType), matcher, (Consumer<PsiType>)consumer);
        } else {
            consumer.consume((Object)expectedReturnType);
        }
    }

    private static LookupElement createConstructorReferenceLookup(@NotNull PsiType functionalInterfaceType, @NotNull PsiType constructedType) {
        if (functionalInterfaceType == null) {
            FunctionalExpressionCompletionProvider.$$$reportNull$$$0(4);
        }
        if (constructedType == null) {
            FunctionalExpressionCompletionProvider.$$$reportNull$$$0(5);
        }
        constructedType = TypeConversionUtil.erasure((PsiType)constructedType);
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)constructedType);
        return LookupElementBuilder.create((Object)constructedType, (String)(constructedType.getPresentableText() + "::new")).withTypeText(functionalInterfaceType.getPresentableText()).withTailText(psiClass != null ? " (" + PsiFormatUtil.getPackageDisplayName((PsiClass)psiClass) + ")" : null, true).withPsiElement((PsiElement)psiClass).withIcon(AllIcons.Nodes.MethodReference).withInsertHandler(CONSTRUCTOR_REF_INSERT_HANDLER).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
    }

    @NotNull
    private static LookupElement createMethodRefOnThis(PsiType functionalInterfaceType, PsiMethod psiMethod, @Nullable PsiClass outerClass) {
        String fullString = (outerClass == null ? "" : outerClass.getName() + ".") + "this::" + psiMethod.getName();
        LookupElement lookupElement = LookupElementBuilder.create((Object)psiMethod, (String)fullString).withLookupString(psiMethod.getName()).withPresentableText(fullString).withTypeText(functionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.MethodReference).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        if (lookupElement == null) {
            FunctionalExpressionCompletionProvider.$$$reportNull$$$0(6);
        }
        return lookupElement;
    }

    @NotNull
    private static LookupElement createMethodRefOnClass(PsiType functionalInterfaceType, PsiMethod psiMethod, PsiClass qualifierClass) {
        String presentableText = qualifierClass.getName() + "::" + psiMethod.getName();
        LookupElement lookupElement = LookupElementBuilder.create((PsiNamedElement)psiMethod).withLookupString(presentableText).withPresentableText(presentableText).withInsertHandler((context, item) -> {
            context.getDocument().insertString(context.getStartOffset(), (CharSequence)"::");
            JavaCompletionUtil.insertClassReference(qualifierClass, context.getFile(), context.getStartOffset());
        }).withTypeText(functionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.MethodReference).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        if (lookupElement == null) {
            FunctionalExpressionCompletionProvider.$$$reportNull$$$0(7);
        }
        return lookupElement;
    }

    private static List<LookupElement> collectThisVariants(PsiType functionalInterfaceType, PsiParameter[] params, PsiElement originalPosition, PsiSubstitutor substitutor, PsiType expectedReturnType) {
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        JBIterable instanceClasses = JBIterable.generate((Object)originalPosition, PsiElement::getParent).filter(PsiMember.class).takeWhile(m -> !m.hasModifierProperty("static")).filter(PsiClass.class);
        boolean first = true;
        for (PsiClass psiClass : instanceClasses) {
            if (!first && psiClass.getName() == null) continue;
            for (PsiMethod psiMethod : psiClass.getMethods()) {
                if (psiMethod.hasModifierProperty("static") || !FunctionalExpressionCompletionProvider.hasAppropriateReturnType(expectedReturnType, psiMethod, substitutor) || !FunctionalExpressionCompletionProvider.isSignatureAppropriate(psiMethod, params, substitutor, 0, originalPosition, null)) continue;
                result.add(FunctionalExpressionCompletionProvider.createMethodRefOnThis(functionalInterfaceType, psiMethod, first ? null : psiClass));
            }
            first = false;
        }
        return result;
    }

    private static List<LookupElement> collectStaticVariants(PsiType functionalInterfaceType, PsiParameter[] params, PsiElement originalPosition, PsiSubstitutor substitutor, PsiType expectedReturnType) {
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        for (PsiClass psiClass : JBIterable.generate((Object)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, PsiClass.class), PsiClass::getContainingClass)) {
            PsiMethod[] psiMethodArray = psiClass.getMethods();
            int n = psiMethodArray.length;
            for (int i = 0; i < n; ++i) {
                PsiMethod psiMethod = psiMethodArray[i];
                if (!FunctionalExpressionCompletionProvider.isMatchingStaticMethod(params, originalPosition, substitutor, expectedReturnType, psiMethod)) continue;
                result.add(FunctionalExpressionCompletionProvider.createMethodRefOnClass(functionalInterfaceType, psiMethod, psiClass));
            }
        }
        PsiClass objects = JavaPsiFacade.getInstance((Project)originalPosition.getProject()).findClass("java.util.Objects", originalPosition.getResolveScope());
        if (objects != null) {
            for (PsiMethod nonNull : objects.getMethods()) {
                if (!FunctionalExpressionCompletionProvider.isMatchingStaticMethod(params, originalPosition, substitutor, expectedReturnType, nonNull)) continue;
                result.add(FunctionalExpressionCompletionProvider.createMethodRefOnClass(functionalInterfaceType, nonNull, objects));
            }
        }
        return result;
    }

    private static boolean isMatchingStaticMethod(PsiParameter[] params, PsiElement originalPosition, PsiSubstitutor substitutor, PsiType expectedReturnType, PsiMethod psiMethod) {
        return psiMethod.hasModifierProperty("static") && FunctionalExpressionCompletionProvider.hasAppropriateReturnType(expectedReturnType, psiMethod, substitutor) && FunctionalExpressionCompletionProvider.isSignatureAppropriate(psiMethod, params, substitutor, 0, originalPosition, null);
    }

    private static List<LookupElement> collectVariantsByReceiver(boolean prioritize, PsiType functionalInterfaceType, PsiParameter[] params, PsiElement originalPosition, PsiSubstitutor substitutor, PsiType expectedReturnType) {
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        PsiType functionalInterfaceParamType = substitutor.substitute(params[0].getType());
        PsiClass paramClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)functionalInterfaceParamType);
        if (paramClass != null) {
            HashSet<String> visited = new HashSet<String>();
            for (PsiMethod psiMethod : paramClass.getAllMethods()) {
                PsiClass qualifierClass;
                PsiClass containingClass = psiMethod.getContainingClass();
                PsiClass psiClass = qualifierClass = containingClass != null ? containingClass : paramClass;
                if (!visited.add(psiMethod.getName()) || psiMethod.hasModifierProperty("static") || !FunctionalExpressionCompletionProvider.hasAppropriateReturnType(expectedReturnType, psiMethod, substitutor) || !FunctionalExpressionCompletionProvider.isSignatureAppropriate(psiMethod, params, substitutor, 1, originalPosition, paramClass)) continue;
                LookupElement methodRefLookupElement = FunctionalExpressionCompletionProvider.createMethodRefOnClass(functionalInterfaceType, psiMethod, qualifierClass);
                if (prioritize && containingClass == paramClass) {
                    methodRefLookupElement = PrioritizedLookupElement.withExplicitProximity((LookupElement)methodRefLookupElement, (int)1);
                }
                result.add(methodRefLookupElement);
            }
        }
        return result;
    }

    private static boolean hasAppropriateReturnType(PsiType expectedReturnType, PsiMethod psiMethod, PsiSubstitutor substitutor) {
        PsiType returnType = psiMethod.getReturnType();
        return returnType != null && TypeConversionUtil.isAssignable((PsiType)expectedReturnType, (PsiType)substitutor.substitute(returnType));
    }

    private static boolean isSignatureAppropriate(PsiMethod psiMethod, PsiParameter[] params, PsiSubstitutor substitutor, int offset, PsiElement place, PsiClass accessObjectClass) {
        if (!PsiUtil.isAccessible((PsiMember)psiMethod, (PsiElement)place, (PsiClass)accessObjectClass)) {
            return false;
        }
        PsiParameterList parameterList = psiMethod.getParameterList();
        if (parameterList.getParametersCount() == params.length - offset) {
            PsiParameter[] referenceMethodParams = parameterList.getParameters();
            for (int i = 0; i < params.length - offset; ++i) {
                if (TypeConversionUtil.isAssignable((PsiType)referenceMethodParams[i].getType(), (PsiType)substitutor.substitute(params[i + offset].getType()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getParamName(PsiParameter param, PsiElement originalPosition) {
        return JavaCodeStyleManager.getInstance((Project)originalPosition.getProject()).suggestUniqueVariableName((String)ObjectUtils.assertNotNull((Object)param.getName()), originalPosition, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionalInterfaceType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructedType";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodRefOnThis";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodRefOnClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLambdaContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFunctionalVariants";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorReferenceLookup";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

