/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NullableNotNullManager")
public class NullableNotNullManagerImpl
extends NullableNotNullManager
implements PersistentStateComponent<Element> {
    public static final String TYPE_QUALIFIER_NICKNAME = "javax.annotation.meta.TypeQualifierNickname";
    private static final String INSTRUMENTED_NOT_NULLS_TAG = "instrumentedNotNulls";
    public String myDefaultNullable = "org.jetbrains.annotations.Nullable";
    public String myDefaultNotNull = "org.jetbrains.annotations.NotNull";
    public final JDOMExternalizableStringList myNullables = new JDOMExternalizableStringList(Arrays.asList(DEFAULT_NULLABLES));
    public final JDOMExternalizableStringList myNotNulls = new JDOMExternalizableStringList(Arrays.asList(DEFAULT_NOT_NULLS));
    private List<String> myInstrumentedNotNulls = ContainerUtil.newArrayList((Object[])new String[]{"org.jetbrains.annotations.NotNull"});

    public NullableNotNullManagerImpl(Project project) {
        super(project);
    }

    public void setNotNulls(String ... annotations2) {
        if (annotations2 == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(0);
        }
        this.myNotNulls.clear();
        Collections.addAll(this.myNotNulls, annotations2);
        this.normalizeDefaults();
    }

    public void setNullables(String ... annotations2) {
        if (annotations2 == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(1);
        }
        this.myNullables.clear();
        Collections.addAll(this.myNullables, annotations2);
        this.normalizeDefaults();
    }

    @NotNull
    public String getDefaultNullable() {
        String string = this.myDefaultNullable;
        if (string == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setDefaultNullable(@NotNull String defaultNullable) {
        if (defaultNullable == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(this.getNullables().contains(defaultNullable));
        this.myDefaultNullable = defaultNullable;
    }

    @NotNull
    public String getDefaultNotNull() {
        String string = this.myDefaultNotNull;
        if (string == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setDefaultNotNull(@NotNull String defaultNotNull) {
        if (defaultNotNull == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(this.getNotNulls().contains(defaultNotNull));
        this.myDefaultNotNull = defaultNotNull;
    }

    @NotNull
    public List<String> getNullables() {
        List<String> list = Collections.unmodifiableList(this.myNullables);
        if (list == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<String> getNotNulls() {
        List<String> list = Collections.unmodifiableList(this.myNotNulls);
        if (list == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<String> getInstrumentedNotNulls() {
        List<String> list = Collections.unmodifiableList(this.myInstrumentedNotNulls);
        if (list == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void setInstrumentedNotNulls(@NotNull List<String> names) {
        if (names == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(9);
        }
        this.myInstrumentedNotNulls = ContainerUtil.sorted(names);
    }

    protected boolean hasHardcodedContracts(PsiElement element) {
        return HardcodedContracts.hasHardcodedContracts(element);
    }

    public Element getState() {
        Element component = new Element("component");
        if (!this.hasDefaultValues()) {
            try {
                DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)component);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myInstrumentedNotNulls.size() != 1 || !"org.jetbrains.annotations.NotNull".equals(this.myInstrumentedNotNulls.get(0))) {
            Element instrumentedNotNulls = new Element(INSTRUMENTED_NOT_NULLS_TAG);
            for (String value2 : this.myInstrumentedNotNulls) {
                instrumentedNotNulls.addContent(new Element("option").setAttribute("value", value2));
            }
            component.addContent(instrumentedNotNulls);
        }
        return component;
    }

    private boolean hasDefaultValues() {
        return "org.jetbrains.annotations.NotNull".equals(this.myDefaultNotNull) && "org.jetbrains.annotations.Nullable".equals(this.myDefaultNullable) && new HashSet(this.myNullables).equals(ContainerUtil.newHashSet((Object[])DEFAULT_NULLABLES)) && new HashSet(this.myNotNulls).equals(ContainerUtil.newHashSet((Object[])DEFAULT_NOT_NULLS));
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(10);
        }
        try {
            DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)state);
            this.normalizeDefaults();
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        Element instrumented = state.getChild(INSTRUMENTED_NOT_NULLS_TAG);
        this.myInstrumentedNotNulls = instrumented != null ? ContainerUtil.mapNotNull((Collection)instrumented.getChildren("option"), o -> o.getAttributeValue("value")) : ContainerUtil.newArrayList((Object[])new String[]{"org.jetbrains.annotations.NotNull"});
    }

    private void normalizeDefaults() {
        this.myNotNulls.removeAll((Collection)ContainerUtil.newHashSet((Object[])DEFAULT_NULLABLES));
        this.myNullables.removeAll((Collection)ContainerUtil.newHashSet((Object[])DEFAULT_NOT_NULLS));
        this.myNullables.addAll((Collection)ContainerUtil.filter((Object[])DEFAULT_NULLABLES, s -> !this.myNullables.contains(s)));
        this.myNotNulls.addAll((Collection)ContainerUtil.filter((Object[])DEFAULT_NOT_NULLS, s -> !this.myNotNulls.contains(s)));
    }

    private List<PsiClass> getAllNullabilityNickNames() {
        if (!this.getNotNulls().contains("javax.annotation.Nonnull")) {
            return Collections.emptyList();
        }
        return (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> {
            PsiClass[] nickDeclarations;
            ArrayList<PsiClass> result = new ArrayList<PsiClass>();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
            for (PsiClass tqNick : nickDeclarations = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(TYPE_QUALIFIER_NICKNAME, scope)) {
                result.addAll(ContainerUtil.findAll((Collection)MetaAnnotationUtil.getChildren((PsiClass)tqNick, (GlobalSearchScope)scope), NullableNotNullManagerImpl::isNullabilityNickName));
            }
            if (nickDeclarations.length == 0) {
                result.addAll(this.getUnresolvedNicknameUsages());
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private List<PsiClass> getUnresolvedNicknameUsages() {
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        Collection<PsiAnnotation> annotations2 = JavaAnnotationIndex.getInstance().get(StringUtil.getShortName((String)TYPE_QUALIFIER_NICKNAME), this.myProject, GlobalSearchScope.allScope((Project)this.myProject));
        for (PsiAnnotation annotation : annotations2) {
            PsiClass ownerClass;
            PsiElement context = annotation.getContext();
            if (!(context instanceof PsiModifierList) || !(context.getContext() instanceof PsiClass) || !(ownerClass = (PsiClass)context.getContext()).isAnnotationType() || !NullableNotNullManagerImpl.isNullabilityNickName(ownerClass)) continue;
            result.add(ownerClass);
        }
        return result;
    }

    protected NullabilityAnnotationInfo isJsr305Default(@NotNull PsiAnnotation annotation, @NotNull PsiAnnotation.TargetType[] placeTargetTypes) {
        PsiClass declaration2;
        PsiModifierList modList;
        if (annotation == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(11);
        }
        if (placeTargetTypes == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(12);
        }
        PsiModifierList psiModifierList = modList = (declaration2 = NullableNotNullManagerImpl.resolveAnnotationType(annotation)) == null ? null : declaration2.getModifierList();
        if (modList == null) {
            return null;
        }
        PsiAnnotation tqDefault = AnnotationUtil.findAnnotation((PsiModifierListOwner)declaration2, (boolean)true, (String[])new String[]{"javax.annotation.meta.TypeQualifierDefault"});
        if (tqDefault == null) {
            return null;
        }
        Set required = AnnotationTargetUtil.extractRequiredAnnotationTargets((PsiAnnotationMemberValue)tqDefault.findAttributeValue(null));
        if (required == null || !required.isEmpty() && !ContainerUtil.intersects((Collection)required, Arrays.asList(placeTargetTypes))) {
            return null;
        }
        for (PsiAnnotation qualifier : modList.getAnnotations()) {
            Nullability nullability = this.getJsr305QualifierNullability(qualifier);
            if (nullability == null) continue;
            return new NullabilityAnnotationInfo(annotation, nullability, true);
        }
        return null;
    }

    @Nullable
    private static PsiClass resolveAnnotationType(@NotNull PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement element;
        PsiElement declaration2;
        if (annotation == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(13);
        }
        PsiElement psiElement = declaration2 = (element = annotation.getNameReferenceElement()) == null ? null : element.resolve();
        if (!(declaration2 instanceof PsiClass) || !((PsiClass)declaration2).isAnnotationType()) {
            return null;
        }
        return (PsiClass)declaration2;
    }

    @Nullable
    private Nullability getJsr305QualifierNullability(@NotNull PsiAnnotation qualifier) {
        String qName;
        if (qualifier == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(14);
        }
        if ((qName = qualifier.getQualifiedName()) == null || !qName.startsWith("javax.annotation.")) {
            return null;
        }
        if (qName.equals("javax.annotation.Nullable") && this.getNullables().contains(qName)) {
            return Nullability.NULLABLE;
        }
        if (qName.equals("javax.annotation.Nonnull")) {
            return NullableNotNullManagerImpl.extractNullityFromWhenValue(qualifier);
        }
        return null;
    }

    private static boolean isNullabilityNickName(@NotNull PsiClass candidate) {
        String qname;
        if (candidate == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(15);
        }
        if ((qname = candidate.getQualifiedName()) == null || qname.startsWith("javax.annotation.")) {
            return false;
        }
        return NullableNotNullManagerImpl.getNickNamedNullability(candidate) != Nullability.UNKNOWN;
    }

    private static Nullability getNickNamedNullability(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(16);
        }
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{TYPE_QUALIFIER_NICKNAME}) == null) {
            return Nullability.UNKNOWN;
        }
        PsiAnnotation nonNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"javax.annotation.Nonnull"});
        return nonNull != null ? NullableNotNullManagerImpl.extractNullityFromWhenValue(nonNull) : Nullability.UNKNOWN;
    }

    @NotNull
    private static Nullability extractNullityFromWhenValue(PsiAnnotation nonNull) {
        PsiAnnotationMemberValue when = nonNull.findAttributeValue("when");
        if (when instanceof PsiReferenceExpression) {
            String refName = ((PsiReferenceExpression)when).getReferenceName();
            if ("ALWAYS".equals(refName)) {
                Nullability nullability = Nullability.NOT_NULL;
                if (nullability == null) {
                    NullableNotNullManagerImpl.$$$reportNull$$$0(17);
                }
                return nullability;
            }
            if ("MAYBE".equals(refName) || "NEVER".equals(refName)) {
                Nullability nullability = Nullability.NULLABLE;
                if (nullability == null) {
                    NullableNotNullManagerImpl.$$$reportNull$$$0(18);
                }
                return nullability;
            }
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(19);
        }
        return nullability;
    }

    private List<String> filterNickNames(Nullability nullability) {
        return ((StreamEx)StreamEx.of(this.getAllNullabilityNickNames()).filter(c -> NullableNotNullManagerImpl.getNickNamedNullability(c) == nullability)).map(PsiClass::getQualifiedName).toList();
    }

    @NotNull
    protected List<String> getNullablesWithNickNames() {
        List list = (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)ContainerUtil.concat(this.getNullables(), this.filterNickNames(Nullability.NULLABLE)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (list == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    protected List<String> getNotNullsWithNickNames() {
        List list = (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)ContainerUtil.concat(this.getNotNulls(), this.filterNickNames(Nullability.NOT_NULL)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (list == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/NullableNotNullManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultNullable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultNotNull";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeTargetTypes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/NullableNotNullManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultNullable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultNotNull";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullables";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNulls";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstrumentedNotNulls";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNullityFromWhenValue";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullablesWithNickNames";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullsWithNickNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setNotNulls";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNullables";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultNullable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultNotNull";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setInstrumentedNotNulls";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isJsr305Default";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveAnnotationType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getJsr305QualifierNullability";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isNullabilityNickName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNickNamedNullability";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

