/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.inference.JavaSourceInference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferredAnnotationsManagerImpl
extends InferredAnnotationsManager {
    private static final Key<Boolean> INFERRED_ANNOTATION = Key.create((String)"INFERRED_ANNOTATION");
    private static final Set<String> INFERRED_ANNOTATIONS = ContainerUtil.set((Object[])new String[]{"org.jetbrains.annotations.NotNull", "org.jetbrains.annotations.Nullable", JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT, Mutability.UNMODIFIABLE_ANNOTATION, Mutability.UNMODIFIABLE_VIEW_ANNOTATION});
    private static final Set<String> EXPERIMENTAL_INFERRED_ANNOTATIONS = ContainerUtil.set((Object[])new String[]{Mutability.UNMODIFIABLE_ANNOTATION, Mutability.UNMODIFIABLE_VIEW_ANNOTATION});
    private final Project myProject;
    private static final CallMatcher IMMUTABLE_FACTORY = CallMatcher.anyOf(CallMatcher.staticCall("java.util.List", "of", "copyOf"), CallMatcher.staticCall("java.util.Set", "of", "copyOf"), CallMatcher.staticCall("java.util.Map", "of", "ofEntries", "copyOf", "entry"));

    public InferredAnnotationsManagerImpl(Project project) {
        this.myProject = project;
    }

    @Nullable
    public PsiAnnotation findInferredAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        PsiAnnotation anno;
        if (listOwner == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(0);
        }
        if (annotationFQN == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(1);
        }
        if (!INFERRED_ANNOTATIONS.contains(annotationFQN)) {
            return null;
        }
        listOwner = PsiUtil.preferCompiledElement((PsiModifierListOwner)listOwner);
        if (JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotationFQN) && listOwner instanceof PsiMethod && (anno = this.getHardcodedContractAnnotation((PsiMethod)listOwner)) != null) {
            return anno;
        }
        if (this.ignoreInference(listOwner, annotationFQN)) {
            return null;
        }
        PsiAnnotation fromBytecode = ProjectBytecodeAnalysis.getInstance(this.myProject).findInferredAnnotation(listOwner, annotationFQN);
        if (fromBytecode != null) {
            return fromBytecode;
        }
        if ("org.jetbrains.annotations.NotNull".equals(annotationFQN) || "org.jetbrains.annotations.Nullable".equals(annotationFQN)) {
            PsiAnnotation anno2 = null;
            if (listOwner instanceof PsiMethodImpl) {
                anno2 = this.getInferredNullabilityAnnotation((PsiMethodImpl)listOwner);
            }
            if (listOwner instanceof PsiParameter) {
                anno2 = this.getInferredNullabilityAnnotation((PsiParameter)listOwner);
            }
            return anno2 == null ? null : (annotationFQN.equals(anno2.getQualifiedName()) ? anno2 : null);
        }
        if (Mutability.UNMODIFIABLE_ANNOTATION.equals(annotationFQN) || Mutability.UNMODIFIABLE_VIEW_ANNOTATION.equals(annotationFQN)) {
            return this.getInferredMutabilityAnnotation(listOwner);
        }
        if (listOwner instanceof PsiMethodImpl && JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotationFQN)) {
            return this.getInferredContractAnnotation((PsiMethodImpl)listOwner);
        }
        return null;
    }

    @Nullable
    private PsiAnnotation getHardcodedContractAnnotation(PsiMethod method) {
        List<MethodContract> contracts2 = HardcodedContracts.getHardcodedContracts(method, null);
        return contracts2.isEmpty() ? null : this.createContractAnnotation(contracts2, HardcodedContracts.isHardcodedPure(method));
    }

    public boolean ignoreInference(@NotNull PsiModifierListOwner owner, @Nullable String annotationFQN) {
        if (owner == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(2);
        }
        if (owner instanceof PsiMethod && PsiUtil.canBeOverridden((PsiMethod)((PsiMethod)owner))) {
            return true;
        }
        if (JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotationFQN) && HardcodedContracts.hasHardcodedContracts((PsiElement)owner)) {
            return true;
        }
        if ("org.jetbrains.annotations.NotNull".equals(annotationFQN) && owner instanceof PsiParameter && owner.getParent() != null) {
            List annotations2 = NullableNotNullManager.getInstance((Project)owner.getProject()).getNullables();
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (Collection)annotations2, (int)14)) {
                return true;
            }
            if (HardcodedContracts.hasHardcodedContracts((PsiElement)owner)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private PsiAnnotation getInferredMutabilityAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(3);
        }
        if (owner instanceof PsiMethod && IMMUTABLE_FACTORY.methodMatches((PsiMethod)owner)) {
            return Mutability.UNMODIFIABLE.asAnnotation(this.myProject);
        }
        if (!(owner instanceof PsiMethodImpl)) {
            return null;
        }
        PsiMethodImpl method = (PsiMethodImpl)owner;
        PsiModifierList modifiers = method.getModifierList();
        if (modifiers.hasAnnotation(Mutability.UNMODIFIABLE_ANNOTATION) || modifiers.hasAnnotation(Mutability.UNMODIFIABLE_VIEW_ANNOTATION)) {
            return null;
        }
        return JavaSourceInference.inferMutability(method).asAnnotation(this.myProject);
    }

    @Nullable
    private PsiAnnotation getInferredContractAnnotation(PsiMethodImpl method) {
        if (method.getModifierList().hasAnnotation(JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT)) {
            return null;
        }
        return this.createContractAnnotation(JavaSourceInference.inferContracts(method), JavaSourceInference.inferPurity(method));
    }

    @Nullable
    private PsiAnnotation getInferredNullabilityAnnotation(PsiMethodImpl method) {
        if (this.hasExplicitNullability((PsiModifierListOwner)method)) {
            return null;
        }
        Nullability nullability = JavaSourceInference.inferNullability(method);
        if (nullability == Nullability.NOT_NULL) {
            return ProjectBytecodeAnalysis.getInstance(this.myProject).getNotNullAnnotation();
        }
        if (nullability == Nullability.NULLABLE) {
            return ProjectBytecodeAnalysis.getInstance(this.myProject).getNullableAnnotation();
        }
        return null;
    }

    private boolean hasExplicitNullability(PsiModifierListOwner owner) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)this.myProject);
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (Collection)manager.getNotNulls(), (boolean)true) != null || AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (Collection)manager.getNullables(), (boolean)true) != null || manager.findNullityDefaultInHierarchy(owner) != null;
    }

    @Nullable
    private PsiAnnotation getInferredNullabilityAnnotation(PsiParameter parameter2) {
        String className;
        PsiClass containingClass;
        PsiMethod method;
        if (this.hasExplicitNullability((PsiModifierListOwner)parameter2)) {
            return null;
        }
        PsiElement parent = parameter2.getParent();
        if (!(parent instanceof PsiParameterList)) {
            return null;
        }
        PsiElement scope = parent.getParent();
        if (scope instanceof PsiMethod && (method = (PsiMethod)scope).getName().equals("of") && (containingClass = method.getContainingClass()) != null && ("java.util.List".equals(className = containingClass.getQualifiedName()) || "java.util.Set".equals(className) || "java.util.Map".equals(className) || "java.util.EnumSet".equals(className))) {
            return ProjectBytecodeAnalysis.getInstance(this.myProject).getNotNullAnnotation();
        }
        Nullability nullability = JavaSourceInference.inferNullability(parameter2);
        return nullability == Nullability.NOT_NULL ? ProjectBytecodeAnalysis.getInstance(this.myProject).getNotNullAnnotation() : null;
    }

    @Nullable
    private PsiAnnotation createContractAnnotation(List<? extends MethodContract> contracts2, boolean pure) {
        return InferredAnnotationsManagerImpl.createContractAnnotation(this.myProject, pure, StreamEx.of(contracts2).select(StandardMethodContract.class).joining((CharSequence)"; "), "");
    }

    @Nullable
    public static PsiAnnotation createContractAnnotation(Project project, boolean pure, String contracts2, String mutates) {
        LinkedHashMap<String, String> attrMap = new LinkedHashMap<String, String>();
        if (!contracts2.isEmpty()) {
            attrMap.put("value", StringUtil.wrapWithDoubleQuote((String)contracts2));
        }
        if (pure) {
            attrMap.put("pure", "true");
        } else if (!mutates.trim().isEmpty()) {
            attrMap.put("mutates", StringUtil.wrapWithDoubleQuote((String)mutates));
        }
        if (attrMap.isEmpty()) {
            return null;
        }
        String attrs = attrMap.keySet().equals(Collections.singleton("value")) ? (String)attrMap.get("value") : EntryStream.of(attrMap).join((CharSequence)" = ").joining((CharSequence)", ");
        return ProjectBytecodeAnalysis.getInstance(project).createContractAnnotation(attrs);
    }

    @NotNull
    public PsiAnnotation[] findInferredAnnotations(@NotNull PsiModifierListOwner listOwner) {
        PsiAnnotation[] fromBytecode;
        if (listOwner == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(4);
        }
        listOwner = PsiUtil.preferCompiledElement((PsiModifierListOwner)listOwner);
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiAnnotation annotation : fromBytecode = ProjectBytecodeAnalysis.getInstance(this.myProject).findInferredAnnotations(listOwner)) {
            if (this.ignoreInference(listOwner, annotation.getQualifiedName())) continue;
            result.add(annotation);
        }
        if (listOwner instanceof PsiMethod) {
            PsiAnnotation hardcoded = this.getHardcodedContractAnnotation((PsiMethod)listOwner);
            ContainerUtil.addIfNotNull((Collection)result, (Object)hardcoded);
            if (listOwner instanceof PsiMethodImpl) {
                PsiAnnotation annotation;
                if (hardcoded == null && !this.ignoreInference(listOwner, JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT)) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)this.getInferredContractAnnotation((PsiMethodImpl)listOwner));
                }
                if (!(this.ignoreInference(listOwner, "org.jetbrains.annotations.NotNull") && this.ignoreInference(listOwner, "org.jetbrains.annotations.Nullable") || (annotation = this.getInferredNullabilityAnnotation((PsiMethodImpl)listOwner)) == null || this.ignoreInference(listOwner, annotation.getQualifiedName()))) {
                    result.add(annotation);
                }
            }
        }
        if (listOwner instanceof PsiParameter && !this.ignoreInference(listOwner, "org.jetbrains.annotations.NotNull")) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)this.getInferredNullabilityAnnotation((PsiParameter)listOwner));
        }
        ContainerUtil.addIfNotNull((Collection)result, (Object)this.getInferredMutabilityAnnotation(listOwner));
        PsiAnnotation[] psiAnnotationArray = result.toArray(PsiAnnotation.EMPTY_ARRAY);
        if (psiAnnotationArray == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(5);
        }
        return psiAnnotationArray;
    }

    public boolean isInferredAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(6);
        }
        return annotation.getUserData(INFERRED_ANNOTATION) != null;
    }

    public static void markInferred(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(7);
        }
        annotation.putUserData(INFERRED_ANNOTATION, (Object)Boolean.TRUE);
    }

    public static boolean isExperimentalInferredAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(8);
        }
        return EXPERIMENTAL_INFERRED_ANNOTATIONS.contains(annotation.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/InferredAnnotationsManagerImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/InferredAnnotationsManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findInferredAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInferredAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "ignoreInference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInferredMutabilityAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findInferredAnnotations";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInferredAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markInferred";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isExperimentalInferredAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

