/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.ExpectedTypeUtil;
import com.intellij.codeInsight.FunctionalInterfaceSuggester;
import com.intellij.codeInsight.HardcodedDefaultTypesKt;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.resolve.CompletionParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypesProvider {
    private static final ExpectedTypeInfo VOID_EXPECTED = ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.VOID, 1, (PsiType)PsiType.VOID, TailType.SEMICOLON);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.ExpectedTypesProvider");
    private static final int MAX_COUNT = 50;
    private static final ExpectedClassProvider ourGlobalScopeClassProvider = new ExpectedClassProvider(){

        @Override
        @NotNull
        public PsiField[] findDeclaredFields(@NotNull PsiManager manager, @NotNull String name) {
            if (manager == null) {
                1.$$$reportNull$$$0(0);
            }
            if (name == null) {
                1.$$$reportNull$$$0(1);
            }
            PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)manager.getProject());
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)manager.getProject());
            PsiField[] psiFieldArray = cache.getFieldsByName(name, scope);
            if (psiFieldArray == null) {
                1.$$$reportNull$$$0(2);
            }
            return psiFieldArray;
        }

        @Override
        @NotNull
        public PsiMethod[] findDeclaredMethods(@NotNull PsiManager manager, @NotNull String name) {
            if (manager == null) {
                1.$$$reportNull$$$0(3);
            }
            if (name == null) {
                1.$$$reportNull$$$0(4);
            }
            Project project = manager.getProject();
            PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
            GlobalSearchScope sources = GlobalSearchScope.projectScope((Project)project);
            GlobalSearchScope libraries = GlobalSearchScope.notScope((GlobalSearchScope)sources);
            Object[] sourceMethods = cache.getMethodsByNameIfNotMoreThan(name, sources, 50);
            if (sourceMethods.length == 50) {
                if (sourceMethods == null) {
                    1.$$$reportNull$$$0(5);
                }
                return sourceMethods;
            }
            Object[] libraryMethods = cache.getMethodsByNameIfNotMoreThan(name, libraries, 50 - sourceMethods.length);
            PsiMethod[] psiMethodArray = (PsiMethod[])ArrayUtil.mergeArrays((Object[])sourceMethods, (Object[])libraryMethods);
            if (psiMethodArray == null) {
                1.$$$reportNull$$$0(6);
            }
            return psiMethodArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/ExpectedTypesProvider$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/ExpectedTypesProvider$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findDeclaredFields";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findDeclaredMethods";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findDeclaredFields";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findDeclaredMethods";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final PsiType[] PRIMITIVE_TYPES = new PsiType[]{PsiType.BYTE, PsiType.CHAR, PsiType.SHORT, PsiType.INT, PsiType.LONG, PsiType.FLOAT, PsiType.DOUBLE};

    private ExpectedTypesProvider() {
    }

    public static ExpectedTypesProvider getInstance(@NotNull Project project) {
        if (project == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(0);
        }
        return (ExpectedTypesProvider)ServiceManager.getService((Project)project, ExpectedTypesProvider.class);
    }

    @NotNull
    public static ExpectedTypeInfo createInfo(@NotNull PsiType type2, @ExpectedTypeInfo.Type int kind2, PsiType defaultType, @NotNull TailType tailType) {
        if (type2 == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(1);
        }
        if (tailType == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(2);
        }
        ExpectedTypeInfoImpl expectedTypeInfoImpl = ExpectedTypesProvider.createInfoImpl(type2, kind2, defaultType, tailType);
        if (expectedTypeInfoImpl == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(3);
        }
        return expectedTypeInfoImpl;
    }

    @NotNull
    private static ExpectedTypeInfoImpl createInfoImpl(@NotNull PsiType type2, PsiType defaultType) {
        if (type2 == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(4);
        }
        ExpectedTypeInfoImpl expectedTypeInfoImpl = ExpectedTypesProvider.createInfoImpl(type2, 1, defaultType, TailType.NONE);
        if (expectedTypeInfoImpl == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(5);
        }
        return expectedTypeInfoImpl;
    }

    @NotNull
    private static ExpectedTypeInfoImpl createInfoImpl(@NotNull PsiType type2, @ExpectedTypeInfo.Type int kind2, PsiType defaultType, @NotNull TailType tailType) {
        if (type2 == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(6);
        }
        if (tailType == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(7);
        }
        ExpectedTypeInfoImpl expectedTypeInfoImpl = new ExpectedTypeInfoImpl(type2, kind2, defaultType, tailType, null, ExpectedTypeInfoImpl.NULL);
        if (expectedTypeInfoImpl == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(8);
        }
        return expectedTypeInfoImpl;
    }

    @NotNull
    private static ExpectedTypeInfoImpl createInfoImpl(@NotNull PsiType type2, int kind2, PsiType defaultType, @NotNull TailType tailType, PsiMethod calledMethod, NullableComputable<String> expectedName) {
        if (type2 == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(9);
        }
        if (tailType == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(10);
        }
        ExpectedTypeInfoImpl expectedTypeInfoImpl = new ExpectedTypeInfoImpl(type2, kind2, defaultType, tailType, calledMethod, expectedName);
        if (expectedTypeInfoImpl == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(11);
        }
        return expectedTypeInfoImpl;
    }

    @NotNull
    public static ExpectedTypeInfo[] getExpectedTypes(@Nullable PsiExpression expr, boolean forCompletion) {
        ExpectedTypeInfo[] expectedTypeInfoArray = ExpectedTypesProvider.getExpectedTypes(expr, forCompletion, false, false);
        if (expectedTypeInfoArray == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(12);
        }
        return expectedTypeInfoArray;
    }

    @NotNull
    public static ExpectedTypeInfo[] getExpectedTypes(@Nullable PsiExpression expr, boolean forCompletion, boolean voidable, boolean usedAfter) {
        ExpectedTypeInfo[] expectedTypeInfoArray = ExpectedTypesProvider.getExpectedTypes(expr, forCompletion, ourGlobalScopeClassProvider, voidable, usedAfter);
        if (expectedTypeInfoArray == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(13);
        }
        return expectedTypeInfoArray;
    }

    @NotNull
    public static ExpectedTypeInfo[] getExpectedTypes(@Nullable PsiExpression expr, boolean forCompletion, ExpectedClassProvider classProvider, boolean usedAfter) {
        ExpectedTypeInfo[] expectedTypeInfoArray = ExpectedTypesProvider.getExpectedTypes(expr, forCompletion, classProvider, false, usedAfter);
        if (expectedTypeInfoArray == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(14);
        }
        return expectedTypeInfoArray;
    }

    @NotNull
    public static ExpectedTypeInfo[] getExpectedTypes(@Nullable PsiExpression expr, boolean forCompletion, ExpectedClassProvider classProvider, boolean voidable, boolean usedAfter) {
        if (expr == null) {
            if (ExpectedTypeInfo.EMPTY_ARRAY == null) {
                ExpectedTypesProvider.$$$reportNull$$$0(15);
            }
            return ExpectedTypeInfo.EMPTY_ARRAY;
        }
        PsiElement parent = expr.getParent();
        if (expr instanceof PsiFunctionalExpression && parent instanceof PsiExpressionStatement) {
            Collection<? extends PsiType> types = FunctionalInterfaceSuggester.suggestFunctionalInterfaces((PsiFunctionalExpression)expr);
            if (types.isEmpty()) {
                if (ExpectedTypeInfo.EMPTY_ARRAY == null) {
                    ExpectedTypesProvider.$$$reportNull$$$0(16);
                }
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            ExpectedTypeInfo[] result = new ExpectedTypeInfo[types.size()];
            int i = 0;
            for (PsiType psiType : types) {
                result[i++] = new ExpectedTypeInfoImpl(psiType, 4, psiType, TailType.NONE, null, ExpectedTypeInfoImpl.NULL);
            }
            if (result == null) {
                ExpectedTypesProvider.$$$reportNull$$$0(17);
            }
            return result;
        }
        MyParentVisitor visitor = new MyParentVisitor(expr, forCompletion, classProvider, voidable, usedAfter);
        if (parent != null) {
            parent.accept((PsiElementVisitor)visitor);
        }
        ExpectedTypeInfo[] expectedTypeInfoArray = visitor.getResult();
        if (expectedTypeInfoArray == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(18);
        }
        return expectedTypeInfoArray;
    }

    @NotNull
    public static PsiType[] processExpectedTypes(@NotNull ExpectedTypeInfo[] infos, @NotNull PsiTypeVisitor<PsiType> visitor, @NotNull Project project) {
        if (infos == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(19);
        }
        if (visitor == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(20);
        }
        if (project == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(21);
        }
        LinkedHashSet set = new LinkedHashSet();
        for (ExpectedTypeInfo info : infos) {
            ExpectedTypeInfoImpl infoImpl = (ExpectedTypeInfoImpl)info;
            if (infoImpl.getDefaultType() instanceof PsiClassType) {
                PsiClassType.ClassResolveResult result = ((PsiClassType)infoImpl.getDefaultType()).resolveGenerics();
                PsiClass aClass = (PsiClass)result.getElement();
                if (aClass instanceof PsiAnonymousClass) {
                    ExpectedTypesProvider.processType((PsiType)((PsiAnonymousClass)aClass).getBaseClassType(), visitor, set);
                    ((PsiAnonymousClass)aClass).getBaseClassType().accept(visitor);
                } else {
                    ExpectedTypesProvider.processType(infoImpl.getDefaultType(), visitor, set);
                }
            } else {
                ExpectedTypesProvider.processType(infoImpl.getDefaultType(), visitor, set);
            }
            if (infoImpl.getKind() == 2) {
                ExpectedTypesProvider.processAllSuperTypes(infoImpl.getType(), visitor, project, set, new HashSet());
                continue;
            }
            if (infoImpl.getKind() != 1 || !(infoImpl.getType() instanceof PsiPrimitiveType)) continue;
            ExpectedTypesProvider.processPrimitiveTypeAndSubtypes((PsiPrimitiveType)infoImpl.getType(), visitor, set);
        }
        PsiType[] psiTypeArray = set.toArray(PsiType.createArray((int)set.size()));
        if (psiTypeArray == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(22);
        }
        return psiTypeArray;
    }

    private static void processType(@NotNull PsiType type2, @NotNull PsiTypeVisitor<PsiType> visitor, @NotNull Set<? super PsiType> typeSet) {
        PsiType accepted;
        if (type2 == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(23);
        }
        if (visitor == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(24);
        }
        if (typeSet == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(25);
        }
        if ((accepted = (PsiType)type2.accept(visitor)) != null) {
            typeSet.add((PsiType)accepted);
        }
    }

    private static void processPrimitiveTypeAndSubtypes(@NotNull PsiPrimitiveType type2, @NotNull PsiTypeVisitor<PsiType> visitor, @NotNull Set<? super PsiType> set) {
        if (type2 == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(26);
        }
        if (visitor == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(27);
        }
        if (set == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(28);
        }
        if (type2.equals((Object)PsiType.BOOLEAN) || type2.equals((Object)PsiType.VOID) || type2.equals((Object)PsiType.NULL)) {
            return;
        }
        int i = 0;
        while (true) {
            PsiType primitive = PRIMITIVE_TYPES[i];
            ExpectedTypesProvider.processType(primitive, visitor, set);
            if (primitive.equals(type2)) {
                return;
            }
            ++i;
        }
    }

    public static void processAllSuperTypes(@NotNull PsiType type2, @NotNull PsiTypeVisitor<PsiType> visitor, @NotNull Project project, @NotNull Set<? super PsiType> set, @NotNull Set<? super PsiType> visited) {
        block12: {
            block11: {
                if (type2 == null) {
                    ExpectedTypesProvider.$$$reportNull$$$0(29);
                }
                if (visitor == null) {
                    ExpectedTypesProvider.$$$reportNull$$$0(30);
                }
                if (project == null) {
                    ExpectedTypesProvider.$$$reportNull$$$0(31);
                }
                if (set == null) {
                    ExpectedTypesProvider.$$$reportNull$$$0(32);
                }
                if (visited == null) {
                    ExpectedTypesProvider.$$$reportNull$$$0(33);
                }
                if (!visited.add((PsiType)type2)) {
                    return;
                }
                if (!(type2 instanceof PsiPrimitiveType)) break block11;
                if (type2.equals(PsiType.BOOLEAN) || type2.equals(PsiType.VOID) || type2.equals(PsiType.NULL)) {
                    return;
                }
                Stack stack = new Stack();
                int i = PRIMITIVE_TYPES.length - 1;
                while (!PRIMITIVE_TYPES[i].equals(type2)) {
                    stack.push((Object)PRIMITIVE_TYPES[i]);
                    --i;
                }
                while (!stack.empty()) {
                    ExpectedTypesProvider.processType((PsiType)stack.pop(), visitor, set);
                }
                break block12;
            }
            PsiManager manager = PsiManager.getInstance((Project)project);
            GlobalSearchScope resolveScope = type2.getResolveScope();
            if (resolveScope == null) {
                resolveScope = GlobalSearchScope.allScope((Project)project);
            }
            PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)resolveScope);
            ExpectedTypesProvider.processType((PsiType)objectType, visitor, set);
            if (!(type2 instanceof PsiClassType)) break block12;
            for (PsiType superType : type2.getSuperTypes()) {
                ExpectedTypesProvider.processType(superType, visitor, set);
                ExpectedTypesProvider.processAllSuperTypes(superType, visitor, project, set, visited);
            }
        }
    }

    @NotNull
    public static TailType getFinalCallParameterTailType(@NotNull PsiElement call, @Nullable PsiType returnType, @NotNull PsiMethod method) {
        boolean statementContext;
        if (call == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(34);
        }
        if (method == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(35);
        }
        if (method.isConstructor() && call instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)call).getMethodExpression() instanceof PsiSuperExpression) {
            TailType tailType = TailTypes.CALL_RPARENTH_SEMICOLON;
            if (tailType == null) {
                ExpectedTypesProvider.$$$reportNull$$$0(36);
            }
            return tailType;
        }
        boolean chainable = !PsiType.VOID.equals((Object)returnType) && returnType != null || method.isConstructor() && call instanceof PsiNewExpression;
        PsiElement parent = call.getParent();
        boolean bl = statementContext = parent instanceof PsiExpressionStatement || parent instanceof PsiVariable || parent instanceof PsiCodeBlock;
        if (parent instanceof PsiThrowStatement || statementContext && !chainable) {
            TailType tailType = TailTypes.CALL_RPARENTH_SEMICOLON;
            if (tailType == null) {
                ExpectedTypesProvider.$$$reportNull$$$0(37);
            }
            return tailType;
        }
        TailType tailType = TailTypes.CALL_RPARENTH;
        if (tailType == null) {
            ExpectedTypesProvider.$$$reportNull$$$0(38);
        }
        return tailType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tailType";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/ExpectedTypesProvider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 20: 
            case 24: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSet";
                break;
            }
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/ExpectedTypesProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfo";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfoImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypes";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "processExpectedTypes";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalCallParameterTailType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createInfoImpl";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processExpectedTypes";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processType";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processPrimitiveTypeAndSubtypes";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processAllSuperTypes";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFinalCallParameterTailType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ExpectedClassProvider {
        @NotNull
        public PsiField[] findDeclaredFields(@NotNull PsiManager var1, @NotNull String var2);

        @NotNull
        public PsiMethod[] findDeclaredMethods(@NotNull PsiManager var1, @NotNull String var2);
    }

    private static class MyParentVisitor
    extends JavaElementVisitor {
        private PsiExpression myExpr;
        private final boolean myForCompletion;
        private final boolean myUsedAfter;
        private final ExpectedClassProvider myClassProvider;
        private final boolean myVoidable;
        final List<ExpectedTypeInfo> myResult = ContainerUtil.newArrayList();
        @NonNls
        private static final String LENGTH_SYNTHETIC_ARRAY_FIELD = "length";

        private MyParentVisitor(PsiExpression expr, boolean forCompletion, ExpectedClassProvider classProvider, boolean voidable, boolean usedAfter) {
            this.myExpr = expr;
            this.myForCompletion = forCompletion;
            this.myClassProvider = classProvider;
            this.myVoidable = voidable;
            this.myUsedAfter = usedAfter;
        }

        @NotNull
        public ExpectedTypeInfo[] getResult() {
            ExpectedTypeInfo[] expectedTypeInfoArray = this.myResult.toArray(ExpectedTypeInfo.EMPTY_ARRAY);
            if (expectedTypeInfoArray == null) {
                MyParentVisitor.$$$reportNull$$$0(0);
            }
            return expectedTypeInfoArray;
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
            PsiElement parent = expression2.getParent();
            if (parent != null) {
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expression2, this.myForCompletion, this.myClassProvider, this.myVoidable, this.myUsedAfter);
                parent.accept((PsiElementVisitor)visitor);
                for (ExpectedTypeInfo info : visitor.myResult) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl(info.getType(), info.getKind(), info.getDefaultType(), TailTypes.RPARENTH, info.getCalledMethod(), (NullableComputable<String>)((ExpectedTypeInfoImpl)info)::getExpectedName));
                }
            }
        }

        public void visitAnnotationMethod(@NotNull PsiAnnotationMethod method) {
            PsiType type2;
            if (method == null) {
                MyParentVisitor.$$$reportNull$$$0(1);
            }
            if (this.myExpr == method.getDefaultValue() && (type2 = method.getReturnType()) != null) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type2, 1, type2, TailType.SEMICOLON));
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            if (expression2 == null) {
                MyParentVisitor.$$$reportNull$$$0(2);
            }
            if (this.myForCompletion) {
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expression2, true, this.myClassProvider, this.myVoidable, this.myUsedAfter);
                expression2.getParent().accept((PsiElementVisitor)visitor);
                this.myResult.addAll(visitor.myResult);
                return;
            }
            String referenceName = expression2.getReferenceName();
            if (referenceName != null) {
                PsiElement parent = expression2.getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    Collections.addAll(this.myResult, this.findClassesWithDeclaredMethod((PsiMethodCallExpression)parent));
                } else if (parent instanceof PsiReferenceExpression || parent instanceof PsiVariable || parent instanceof PsiExpression) {
                    if (LENGTH_SYNTHETIC_ARRAY_FIELD.equals(referenceName)) {
                        this.myResult.addAll(this.anyArrayType());
                    } else {
                        Collections.addAll(this.myResult, this.findClassesWithDeclaredField(expression2));
                    }
                }
            }
        }

        public void visitExpressionStatement(PsiExpressionStatement statement) {
            if (this.myVoidable) {
                this.myResult.add(VOID_EXPECTED);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                MyParentVisitor.$$$reportNull$$$0(3);
            }
            this.myExpr = (PsiExpression)this.myExpr.getParent();
            expression2.getParent().accept((PsiElementVisitor)this);
        }

        public void visitAnnotationArrayInitializer(@NotNull PsiArrayInitializerMemberValue initializer) {
            if (initializer == null) {
                MyParentVisitor.$$$reportNull$$$0(4);
            }
            PsiElement parent = initializer.getParent();
            while (parent instanceof PsiArrayInitializerMemberValue) {
                parent = parent.getParent();
            }
            PsiType type2 = parent instanceof PsiNameValuePair ? MyParentVisitor.getAnnotationMethodType((PsiNameValuePair)parent) : ((PsiAnnotationMethod)parent).getReturnType();
            if (type2 instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)type2).getComponentType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(componentType, componentType));
            }
        }

        public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
            PsiType type2;
            if (pair == null) {
                MyParentVisitor.$$$reportNull$$$0(5);
            }
            if ((type2 = MyParentVisitor.getAnnotationMethodType(pair)) == null) {
                return;
            }
            if (type2 instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)type2).getComponentType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(componentType, componentType));
            } else {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type2, type2));
            }
        }

        @Nullable
        private static PsiType getAnnotationMethodType(@NotNull PsiNameValuePair pair) {
            PsiElement method;
            PsiReference reference;
            if (pair == null) {
                MyParentVisitor.$$$reportNull$$$0(6);
            }
            if ((reference = pair.getReference()) != null && (method = reference.resolve()) instanceof PsiMethod) {
                return ((PsiMethod)method).getReturnType();
            }
            return null;
        }

        public void visitLambdaExpression(PsiLambdaExpression lambdaExpression) {
            super.visitLambdaExpression(lambdaExpression);
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            PsiMethod scopeMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
            if (scopeMethod != null) {
                this.visitMethodReturnType(scopeMethod, LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType), LambdaHighlightingUtil.insertSemicolonAfter(lambdaExpression));
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            boolean tailTypeSemicolon;
            PsiType type2;
            PsiMethod method;
            NavigatablePsiElement psiElement = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class});
            if (psiElement instanceof PsiLambdaExpression) {
                PsiType functionalInterfaceType = ((PsiLambdaExpression)psiElement).getFunctionalInterfaceType();
                method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
                type2 = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
                tailTypeSemicolon = LambdaHighlightingUtil.insertSemicolonAfter((PsiLambdaExpression)psiElement);
            } else if (psiElement instanceof PsiMethod) {
                method = (PsiMethod)psiElement;
                type2 = method.getReturnType();
                tailTypeSemicolon = true;
            } else {
                method = null;
                type2 = null;
                tailTypeSemicolon = true;
            }
            if (method != null) {
                this.visitMethodReturnType(method, type2, tailTypeSemicolon);
            }
        }

        private void visitMethodReturnType(PsiMethod scopeMethod, PsiType type2, boolean tailTypeSemicolon) {
            if (type2 != null) {
                NullableComputable expectedName = PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)scopeMethod) ? () -> PropertyUtilBase.getPropertyName((PsiMethod)scopeMethod) : ExpectedTypeInfoImpl.NULL;
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type2, 1, type2, tailTypeSemicolon ? TailType.SEMICOLON : TailType.NONE, null, (NullableComputable<String>)expectedName));
            }
        }

        public void visitIfStatement(PsiIfStatement statement) {
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailTypes.IF_RPARENTH));
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailTypes.WHILE_RPARENTH));
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailTypes.WHILE_RPARENTH));
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                MyParentVisitor.$$$reportNull$$$0(7);
            }
            if (this.myExpr.equals(statement.getCondition())) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.SEMICOLON));
            }
        }

        public void visitAssertStatement(@NotNull PsiAssertStatement statement) {
            if (statement == null) {
                MyParentVisitor.$$$reportNull$$$0(8);
            }
            if (statement.getAssertDescription() == this.myExpr) {
                PsiClassType stringType = PsiType.getJavaLangString((PsiManager)this.myExpr.getManager(), (GlobalSearchScope)this.myExpr.getResolveScope());
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)stringType, 0, (PsiType)stringType, TailType.SEMICOLON));
            } else {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.SEMICOLON));
            }
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                MyParentVisitor.$$$reportNull$$$0(9);
            }
            if (this.myExpr.equals(statement.getIteratedValue())) {
                PsiType type2 = statement.getIterationParameter().getType();
                PsiArrayType arrayType = type2.createArrayType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)arrayType, (PsiType)arrayType));
                PsiManager manager = statement.getManager();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
                PsiClass iterableClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Iterable", statement.getResolveScope());
                if (iterableClass != null && iterableClass.getTypeParameters().length == 1 && !PsiType.NULL.equals((Object)type2)) {
                    HashMap<PsiTypeParameter, PsiWildcardType> map = new HashMap<PsiTypeParameter, PsiWildcardType>();
                    map.put(iterableClass.getTypeParameters()[0], PsiWildcardType.createExtends((PsiManager)manager, (PsiType)type2));
                    PsiClassType iterableType = factory.createType(iterableClass, factory.createSubstitutor(map));
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)iterableType, (PsiType)iterableType));
                }
            }
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                MyParentVisitor.$$$reportNull$$$0(10);
            }
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, (PsiType)PsiType.INT));
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)statement)) {
                return;
            }
            PsiManager manager = statement.getManager();
            PsiClassType enumType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Enum", statement.getResolveScope());
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)enumType, (PsiType)enumType));
        }

        public void visitSwitchLabelStatement(@NotNull PsiSwitchLabelStatement statement) {
            PsiType type2;
            PsiExpression expression2;
            PsiSwitchStatement switchStatement;
            if (statement == null) {
                MyParentVisitor.$$$reportNull$$$0(11);
            }
            if ((switchStatement = statement.getEnclosingSwitchStatement()) != null && (expression2 = switchStatement.getExpression()) != null && (type2 = expression2.getType()) != null) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type2, 1, type2, TailType.CASE_COLON));
            }
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                MyParentVisitor.$$$reportNull$$$0(12);
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)statement.getProject()).getElementFactory();
            PsiClassType objectType = factory.createTypeByFQClassName("java.lang.Object", this.myExpr.getResolveScope());
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)objectType, (PsiType)objectType));
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                MyParentVisitor.$$$reportNull$$$0(13);
            }
            PsiType type2 = variable.getType();
            TailType tail = variable instanceof PsiResourceVariable ? TailType.NONE : TailType.SEMICOLON;
            this.myResult.add(ExpectedTypesProvider.createInfoImpl(type2, 1, type2, tail, null, (NullableComputable<String>)MyParentVisitor.getPropertyName(variable)));
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                MyParentVisitor.$$$reportNull$$$0(14);
            }
            if (this.myExpr.equals(assignment.getRExpression())) {
                PsiExpression lExpr = assignment.getLExpression();
                PsiType type2 = lExpr.getType();
                if (type2 != null) {
                    PsiElement refElement;
                    TailType tailType = MyParentVisitor.getAssignmentRValueTailType(assignment);
                    NullableComputable<String> expectedName = ExpectedTypeInfoImpl.NULL;
                    if (lExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)lExpr).resolve()) instanceof PsiVariable) {
                        expectedName = MyParentVisitor.getPropertyName((PsiVariable)refElement);
                    }
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl(type2, 1, type2, tailType, null, (NullableComputable<String>)expectedName));
                }
            } else {
                PsiType type3;
                if (this.myForCompletion) {
                    this.myExpr = (PsiExpression)this.myExpr.getParent();
                    assignment.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                PsiExpression rExpr = assignment.getRExpression();
                if (rExpr != null && (type3 = rExpr.getType()) != null && type3 != PsiType.NULL) {
                    PsiClass resolved;
                    if (type3 instanceof PsiClassType && (resolved = ((PsiClassType)type3).resolve()) instanceof PsiAnonymousClass) {
                        type3 = ((PsiAnonymousClass)resolved).getBaseClassType();
                    }
                    int kind2 = assignment.getOperationTokenType() != JavaTokenType.EQ ? 0 : 2;
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl(type3, kind2, type3, TailType.NONE));
                }
            }
        }

        @NotNull
        private static TailType getAssignmentRValueTailType(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                MyParentVisitor.$$$reportNull$$$0(15);
            }
            if (assignment.getParent() instanceof PsiExpressionStatement) {
                if (!(assignment.getParent().getParent() instanceof PsiForStatement)) {
                    TailType tailType = TailType.SEMICOLON;
                    if (tailType == null) {
                        MyParentVisitor.$$$reportNull$$$0(16);
                    }
                    return tailType;
                }
                PsiForStatement forStatement = (PsiForStatement)assignment.getParent().getParent();
                if (!assignment.getParent().equals(forStatement.getUpdate())) {
                    TailType tailType = TailType.SEMICOLON;
                    if (tailType == null) {
                        MyParentVisitor.$$$reportNull$$$0(17);
                    }
                    return tailType;
                }
            }
            TailType tailType = TailType.NONE;
            if (tailType == null) {
                MyParentVisitor.$$$reportNull$$$0(18);
            }
            return tailType;
        }

        public void visitExpressionList(@NotNull PsiExpressionList list) {
            if (list == null) {
                MyParentVisitor.$$$reportNull$$$0(19);
            }
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)list.getProject()).getResolveHelper();
            PsiElement parent = list.getParent();
            if (parent instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
                CandidateInfo[] candidates = helper.getReferencedMethodCandidates((PsiCallExpression)methodCall, false, true);
                Collections.addAll(this.myResult, this.getExpectedArgumentTypesForMethodCall(candidates, list, this.myExpr, this.myForCompletion, methodCall.resolveMethod()));
            } else if (parent instanceof PsiEnumConstant) {
                this.getExpectedArgumentsTypesForEnumConstant((PsiEnumConstant)parent, list);
            } else if (parent instanceof PsiNewExpression) {
                this.getExpectedArgumentsTypesForNewExpression((PsiNewExpression)parent, list);
            } else if (parent instanceof PsiAnonymousClass) {
                this.getExpectedArgumentsTypesForNewExpression((PsiNewExpression)parent.getParent(), list);
            }
        }

        private void getExpectedArgumentsTypesForEnumConstant(@NotNull PsiEnumConstant enumConstant, @NotNull PsiExpressionList list) {
            PsiClass aClass;
            if (enumConstant == null) {
                MyParentVisitor.$$$reportNull$$$0(20);
            }
            if (list == null) {
                MyParentVisitor.$$$reportNull$$$0(21);
            }
            if ((aClass = enumConstant.getContainingClass()) != null) {
                LOG.assertTrue(aClass.isEnum());
                this.getExpectedTypesForConstructorCall(aClass, list, PsiSubstitutor.EMPTY, enumConstant.resolveMethod());
            }
        }

        private void getExpectedArgumentsTypesForNewExpression(@NotNull PsiNewExpression newExpr, @NotNull PsiExpressionList list) {
            if (newExpr == null) {
                MyParentVisitor.$$$reportNull$$$0(22);
            }
            if (list == null) {
                MyParentVisitor.$$$reportNull$$$0(23);
            }
            if (PsiDiamondType.hasDiamond((PsiNewExpression)newExpr)) {
                Object[] candidates = PsiDiamondTypeImpl.collectStaticFactories(newExpr, DuplicateConflictResolver.INSTANCE);
                if (candidates != null) {
                    PsiExpressionList argumentList = newExpr.getArgumentList();
                    Collections.addAll(this.myResult, this.getExpectedArgumentTypesForMethodCall((CandidateInfo[])ContainerUtil.map((Object[])candidates, candidate -> (CandidateInfo)candidate, (Object[])CandidateInfo.EMPTY_ARRAY), argumentList, this.myExpr, this.myForCompletion, newExpr.resolveMethod()));
                }
                return;
            }
            PsiType newType = newExpr.getType();
            if (newType instanceof PsiClassType) {
                PsiSubstitutor substitutor;
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)newType);
                PsiClass newClass = (PsiClass)resolveResult.getElement();
                if (newClass instanceof PsiAnonymousClass) {
                    PsiAnonymousClass anonymous = (PsiAnonymousClass)newClass;
                    if ((newClass = anonymous.getBaseClassType().resolve()) == null) {
                        return;
                    }
                    substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)newClass, (PsiClass)anonymous, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                } else if (newClass != null) {
                    substitutor = resolveResult.getSubstitutor();
                } else {
                    return;
                }
                this.getExpectedTypesForConstructorCall(newClass, list, substitutor, newExpr.resolveMethod());
            }
        }

        private void getExpectedTypesForConstructorCall(@NotNull PsiClass referencedClass, @NotNull PsiExpressionList argumentList, @NotNull PsiSubstitutor substitutor, PsiMethod method) {
            if (referencedClass == null) {
                MyParentVisitor.$$$reportNull$$$0(24);
            }
            if (argumentList == null) {
                MyParentVisitor.$$$reportNull$$$0(25);
            }
            if (substitutor == null) {
                MyParentVisitor.$$$reportNull$$$0(26);
            }
            ArrayList<MethodCandidateInfo> array = new ArrayList<MethodCandidateInfo>();
            for (PsiMethod constructor : referencedClass.getConstructors()) {
                array.add(new MethodCandidateInfo((PsiElement)constructor, substitutor, false, false, (PsiElement)argumentList, null, argumentList.getExpressionTypes(), null));
            }
            CandidateInfo[] candidates = array.toArray(CandidateInfo.EMPTY_ARRAY);
            Collections.addAll(this.myResult, this.getExpectedArgumentTypesForMethodCall(candidates, argumentList, this.myExpr, this.myForCompletion, method));
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expr) {
            PsiType anotherType;
            PsiExpression anotherExpr;
            PsiExpression[] operands2;
            int index;
            if (expr == null) {
                MyParentVisitor.$$$reportNull$$$0(27);
            }
            if ((index = Arrays.asList(operands2 = expr.getOperands()).indexOf(this.myExpr)) < 0) {
                return;
            }
            IElementType op = expr.getOperationTokenType();
            Object object = index > 0 ? operands2[0] : (anotherExpr = 1 < operands2.length ? operands2[1] : null);
            if (this.myForCompletion && index == 0) {
                if (op == JavaTokenType.EQEQ || op == JavaTokenType.NE) {
                    ContainerUtil.addIfNotNull(this.myResult, (Object)MyParentVisitor.getEqualsType(anotherExpr));
                }
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expr, true, this.myClassProvider, this.myVoidable, this.myUsedAfter);
                this.myExpr = (PsiExpression)this.myExpr.getParent();
                expr.getParent().accept((PsiElementVisitor)visitor);
                this.myResult.addAll(visitor.myResult);
                if (!(expr.getParent() instanceof PsiExpressionList)) {
                    for (int i = 0; i < this.myResult.size(); ++i) {
                        ExpectedTypeInfo info = this.myResult.get(i);
                        this.myResult.set(i, ExpectedTypesProvider.createInfoImpl(info.getType(), info.getKind(), info.getDefaultType(), TailType.NONE, info.getCalledMethod(), (NullableComputable<String>)((ExpectedTypeInfoImpl)info)::getExpectedName));
                    }
                }
                return;
            }
            PsiType psiType = anotherType = anotherExpr != null ? anotherExpr.getType() : null;
            if (op == JavaTokenType.MINUS || op == JavaTokenType.ASTERISK || op == JavaTokenType.DIV || op == JavaTokenType.PERC || op == JavaTokenType.LT || op == JavaTokenType.GT || op == JavaTokenType.LE || op == JavaTokenType.GE) {
                if (anotherType != null) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, anotherType));
                }
            } else if (op == JavaTokenType.PLUS) {
                if (anotherType == null || anotherType.equalsToText("java.lang.String")) {
                    PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)expr.getManager(), (GlobalSearchScope)expr.getResolveScope());
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)objectType, (PsiType)(anotherType != null ? anotherType : objectType)));
                } else if (PsiType.DOUBLE.isAssignableFrom(anotherType)) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, anotherType));
                }
            } else if (op == JavaTokenType.EQEQ || op == JavaTokenType.NE) {
                ContainerUtil.addIfNotNull(this.myResult, (Object)MyParentVisitor.getEqualsType(anotherExpr));
            } else if (op == JavaTokenType.LTLT || op == JavaTokenType.GTGT || op == JavaTokenType.GTGTGT) {
                if (anotherType != null) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, 3, (PsiType)PsiType.SHORT, TailType.NONE));
                }
            } else if (op == JavaTokenType.OROR || op == JavaTokenType.ANDAND) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.NONE));
            } else if ((op == JavaTokenType.OR || op == JavaTokenType.XOR || op == JavaTokenType.AND) && anotherType != null) {
                ExpectedTypeInfoImpl info = PsiType.BOOLEAN.equals((Object)anotherType) ? ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE) : ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, anotherType);
                this.myResult.add(info);
            }
        }

        @Nullable
        private static ExpectedTypeInfo getEqualsType(@Nullable PsiExpression anotherExpr) {
            ExpectedTypeInfoImpl info;
            PsiElement refElement;
            PsiType anotherType;
            PsiType psiType = anotherType = anotherExpr != null ? anotherExpr.getType() : null;
            if (anotherType == null) {
                return null;
            }
            NullableComputable<String> expectedName = ExpectedTypeInfoImpl.NULL;
            if (anotherExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)anotherExpr).resolve()) instanceof PsiVariable) {
                expectedName = MyParentVisitor.getPropertyName((PsiVariable)refElement);
            }
            if (anotherType instanceof PsiPrimitiveType) {
                if (PsiType.BOOLEAN.equals((Object)anotherType)) {
                    info = ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE, null, (NullableComputable<String>)expectedName);
                } else if (PsiType.NULL.equals((Object)anotherType)) {
                    PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)anotherExpr.getManager(), (GlobalSearchScope)anotherExpr.getResolveScope());
                    info = ExpectedTypesProvider.createInfoImpl((PsiType)objectType, 1, (PsiType)objectType, TailType.NONE, null, (NullableComputable<String>)expectedName);
                } else {
                    info = ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, 1, anotherType, TailType.NONE, null, (NullableComputable<String>)expectedName);
                }
            } else {
                info = ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE, null, (NullableComputable<String>)expectedName);
            }
            return info;
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expr) {
            TailType tailType;
            if (expr == null) {
                MyParentVisitor.$$$reportNull$$$0(28);
            }
            IElementType i = expr.getOperationTokenType();
            PsiType type2 = expr.getType();
            PsiElement parent = expr.getParent();
            TailType tailType2 = tailType = parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getRExpression() == expr ? MyParentVisitor.getAssignmentRValueTailType((PsiAssignmentExpression)parent) : TailType.NONE;
            if (i == JavaTokenType.PLUSPLUS || i == JavaTokenType.MINUSMINUS || i == JavaTokenType.TILDE) {
                ExpectedTypeInfoImpl info = this.myUsedAfter && type2 != null ? ExpectedTypesProvider.createInfoImpl(type2, 0, type2, tailType) : (type2 != null ? ExpectedTypesProvider.createInfoImpl(type2, type2 instanceof PsiPrimitiveType ? 2 : 1, (PsiType)PsiType.INT, tailType) : ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, 1, (PsiType)PsiType.INT, tailType));
                this.myResult.add(info);
            } else if (i == JavaTokenType.PLUS || i == JavaTokenType.MINUS) {
                if (parent instanceof PsiStatement) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, 1, (PsiType)PsiType.INT, tailType));
                } else {
                    this.myExpr = (PsiExpression)this.myExpr.getParent();
                    parent.accept((PsiElementVisitor)this);
                }
            } else if (i == JavaTokenType.EXCL) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, tailType));
            }
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expr) {
            if (expr == null) {
                MyParentVisitor.$$$reportNull$$$0(29);
            }
            if (this.myForCompletion) {
                return;
            }
            PsiType type2 = expr.getType();
            ExpectedTypeInfoImpl info = this.myUsedAfter && type2 != null ? ExpectedTypesProvider.createInfoImpl(type2, 0, type2, TailType.NONE) : (type2 != null ? ExpectedTypesProvider.createInfoImpl(type2, type2 instanceof PsiPrimitiveType ? 2 : 1, (PsiType)PsiType.INT, TailType.NONE) : ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, (PsiType)PsiType.INT));
            this.myResult.add(info);
        }

        public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expr) {
            PsiType type2;
            if (expr == null) {
                MyParentVisitor.$$$reportNull$$$0(30);
            }
            PsiElement pParent = expr.getParent();
            PsiType arrayType = null;
            if (pParent instanceof PsiVariable) {
                arrayType = ((PsiVariable)pParent).getType();
            } else if (pParent instanceof PsiNewExpression) {
                arrayType = ((PsiNewExpression)pParent).getType();
            } else if (pParent instanceof PsiArrayInitializerExpression && (type2 = ((PsiArrayInitializerExpression)pParent).getType()) instanceof PsiArrayType) {
                arrayType = ((PsiArrayType)type2).getComponentType();
            }
            if (arrayType instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)arrayType).getComponentType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(componentType, componentType));
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            PsiExpression[] arrayDimensions;
            if (expression2 == null) {
                MyParentVisitor.$$$reportNull$$$0(31);
            }
            for (PsiExpression dimension : arrayDimensions = expression2.getArrayDimensions()) {
                if (!this.myExpr.equals(dimension)) continue;
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.INT, (PsiType)PsiType.INT));
                return;
            }
        }

        public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expr) {
            if (expr == null) {
                MyParentVisitor.$$$reportNull$$$0(32);
            }
            if (this.myExpr.equals(expr.getIndexExpression())) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.INT, (PsiType)PsiType.INT));
            } else if (this.myExpr.equals(expr.getArrayExpression())) {
                if (this.myForCompletion) {
                    this.myExpr = (PsiExpression)this.myExpr.getParent();
                    expr.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                PsiElement parent = expr.getParent();
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expr, false, this.myClassProvider, this.myVoidable, this.myUsedAfter);
                this.myExpr = (PsiExpression)this.myExpr.getParent();
                parent.accept((PsiElementVisitor)visitor);
                ExpectedTypeInfo[] componentTypeInfo = visitor.getResult();
                if (componentTypeInfo.length == 0) {
                    this.myResult.addAll(this.anyArrayType());
                } else {
                    for (ExpectedTypeInfo compInfo : componentTypeInfo) {
                        PsiArrayType expectedArrayType = compInfo.getType().createArrayType();
                        this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)expectedArrayType, (PsiType)expectedArrayType));
                    }
                }
            }
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expr) {
            if (expr == null) {
                MyParentVisitor.$$$reportNull$$$0(33);
            }
            if (this.myExpr.equals(expr.getCondition())) {
                if (this.myForCompletion) {
                    this.myExpr = expr;
                    this.myExpr.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.NONE));
            } else if (this.myExpr.equals(expr.getThenExpression())) {
                ExpectedTypeInfo[] types = ExpectedTypesProvider.getExpectedTypes((PsiExpression)expr, this.myForCompletion);
                for (int i = 0; i < types.length; ++i) {
                    ExpectedTypeInfo info = types[i];
                    types[i] = ExpectedTypesProvider.createInfoImpl(info.getType(), info.getKind(), info.getDefaultType(), TailType.COND_EXPR_COLON, info.getCalledMethod(), (NullableComputable<String>)((ExpectedTypeInfoImpl)info)::getExpectedName);
                }
                Collections.addAll(this.myResult, types);
            } else {
                if (!this.myExpr.equals(expr.getElseExpression())) {
                    LOG.error(Arrays.asList(expr.getChildren()) + "; " + this.myExpr);
                }
                Collections.addAll(this.myResult, ExpectedTypesProvider.getExpectedTypes((PsiExpression)expr, this.myForCompletion));
            }
        }

        public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
            if (statement == null) {
                MyParentVisitor.$$$reportNull$$$0(34);
            }
            if (statement.getException() == this.myExpr) {
                PsiMethod method;
                PsiManager manager = statement.getManager();
                PsiClassType throwableType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Throwable", this.myExpr.getResolveScope());
                PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class, PsiClass.class});
                PsiType[] throwsTypes = PsiType.EMPTY_ARRAY;
                if (container instanceof PsiMethod) {
                    throwsTypes = ((PsiMethod)container).getThrowsList().getReferencedTypes();
                } else if (container instanceof PsiLambdaExpression && (method = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)container)) != null) {
                    throwsTypes = method.getThrowsList().getReferencedTypes();
                }
                if (throwsTypes.length == 0) {
                    PsiClassType exceptionType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Exception", this.myExpr.getResolveScope());
                    throwsTypes = new PsiClassType[]{exceptionType};
                }
                for (PsiType throwsType : throwsTypes) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)(this.myExpr instanceof PsiTypeCastExpression && this.myForCompletion ? throwsType : throwableType), 1, throwsType, TailType.SEMICOLON));
                }
            }
        }

        public void visitCodeFragment(@NotNull JavaCodeFragment codeFragment) {
            PsiType type2;
            if (codeFragment == null) {
                MyParentVisitor.$$$reportNull$$$0(35);
            }
            if (codeFragment instanceof PsiExpressionCodeFragment && (type2 = ((PsiExpressionCodeFragment)codeFragment).getExpectedType()) != null) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type2, type2));
            }
        }

        @NotNull
        private ExpectedTypeInfo[] getExpectedArgumentTypesForMethodCall(@NotNull CandidateInfo[] allCandidates, @NotNull PsiExpressionList argumentList, @NotNull PsiExpression argument, boolean forCompletion, @Nullable PsiMethod targetMethod) {
            PsiSubstitutor substitutor;
            PsiMethod method;
            PsiExpression[] leftArgs;
            if (allCandidates == null) {
                MyParentVisitor.$$$reportNull$$$0(36);
            }
            if (argumentList == null) {
                MyParentVisitor.$$$reportNull$$$0(37);
            }
            if (argument == null) {
                MyParentVisitor.$$$reportNull$$$0(38);
            }
            if (allCandidates.length == 0) {
                if (ExpectedTypeInfo.EMPTY_ARRAY == null) {
                    MyParentVisitor.$$$reportNull$$$0(39);
                }
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            PsiMethod toExclude = JavaPsiConstructorUtil.isConstructorCall((PsiElement)argumentList.getParent()) ? (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)argument, PsiMethod.class) : null;
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)this.myExpr.getProject()).getResolveHelper();
            ArrayList<CandidateInfo> methodCandidates = new ArrayList<CandidateInfo>();
            for (CandidateInfo candidate : allCandidates) {
                PsiElement element = candidate.getElement();
                if (!(element instanceof PsiMethod) || !helper.isAccessible((PsiMember)element, (PsiElement)argumentList, null) || element == toExclude) continue;
                methodCandidates.add(candidate);
            }
            if (methodCandidates.isEmpty()) {
                Collections.addAll(methodCandidates, allCandidates);
                methodCandidates.remove(toExclude);
            }
            Object[] args = (PsiExpression[])argumentList.getExpressions().clone();
            int index = ArrayUtil.indexOf((Object[])args, (Object)argument);
            LOG.assertTrue(index >= 0);
            if (index <= args.length - 1) {
                leftArgs = new PsiExpression[index];
                System.arraycopy(args, 0, leftArgs, 0, index);
                if (forCompletion) {
                    args[index] = null;
                }
            } else {
                leftArgs = null;
            }
            CompletionParameterTypeInferencePolicy policy = forCompletion ? CompletionParameterTypeInferencePolicy.INSTANCE : DefaultParameterTypeInferencePolicy.INSTANCE;
            LinkedHashSet<ExpectedTypeInfoImpl> array = new LinkedHashSet<ExpectedTypeInfoImpl>();
            for (CandidateInfo candidateInfo : methodCandidates) {
                method = (PsiMethod)candidateInfo.getElement();
                if (candidateInfo instanceof MethodCandidateInfo) {
                    MethodCandidateInfo info = (MethodCandidateInfo)candidateInfo;
                    Computable computable = () -> MyParentVisitor.lambda$getExpectedArgumentTypesForMethodCall$2(info, (ParameterTypeInferencePolicy)policy, (PsiExpression[])args);
                    PsiSubstitutor psiSubstitutor = substitutor = info.isInferencePossible() && targetMethod == method ? (PsiSubstitutor)computable.compute() : (PsiSubstitutor)MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion((Object)argumentList, false, computable);
                    if (!info.isStaticsScopeCorrect() && !method.hasModifierProperty("static") || info.getInferenceErrorMessage() != null) {
                        continue;
                    }
                } else {
                    substitutor = (PsiSubstitutor)MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion((Object)argumentList, false, () -> ((CandidateInfo)candidateInfo).getSubstitutor());
                }
                if (substitutor == null) {
                    if (ExpectedTypeInfo.EMPTY_ARRAY == null) {
                        MyParentVisitor.$$$reportNull$$$0(40);
                    }
                    return ExpectedTypeInfo.EMPTY_ARRAY;
                }
                MyParentVisitor.inferMethodCallArgumentTypes(argument, forCompletion, (PsiExpression[])args, index, method, substitutor, array);
                if (leftArgs == null || !(candidateInfo instanceof MethodCandidateInfo)) continue;
                Computable computable = () -> MyParentVisitor.lambda$getExpectedArgumentTypesForMethodCall$3(candidateInfo, (ParameterTypeInferencePolicy)policy, leftArgs);
                substitutor = ((MethodCandidateInfo)candidateInfo).isInferencePossible() && targetMethod == method ? (PsiSubstitutor)computable.compute() : (PsiSubstitutor)MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion((Object)argumentList, false, computable);
                if (substitutor == null) continue;
                MyParentVisitor.inferMethodCallArgumentTypes(argument, forCompletion, leftArgs, index, method, substitutor, array);
            }
            if (forCompletion && array.isEmpty()) {
                for (CandidateInfo candidate : methodCandidates) {
                    method = (PsiMethod)candidate.getElement();
                    substitutor = candidate.getSubstitutor();
                    PsiParameter[] params = method.getParameterList().getParameters();
                    if (params.length <= index) continue;
                    PsiParameter param = params[index];
                    PsiType paramType = MyParentVisitor.getParameterType(param, substitutor);
                    TailType tailType = MyParentVisitor.getMethodArgumentTailType(argument, index, method, substitutor, params);
                    ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(paramType, 1, paramType, tailType, method, (NullableComputable<String>)MyParentVisitor.getPropertyName((PsiVariable)param));
                    array.add(info);
                }
            }
            ExpectedTypeInfo[] expectedTypeInfoArray = array.toArray(ExpectedTypeInfo.EMPTY_ARRAY);
            if (expectedTypeInfoArray == null) {
                MyParentVisitor.$$$reportNull$$$0(41);
            }
            return expectedTypeInfoArray;
        }

        @NotNull
        private static TailType getMethodArgumentTailType(@NotNull PsiExpression argument, int index, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull PsiParameter[] params) {
            if (argument == null) {
                MyParentVisitor.$$$reportNull$$$0(42);
            }
            if (method == null) {
                MyParentVisitor.$$$reportNull$$$0(43);
            }
            if (substitutor == null) {
                MyParentVisitor.$$$reportNull$$$0(44);
            }
            if (params == null) {
                MyParentVisitor.$$$reportNull$$$0(45);
            }
            if (index >= params.length || index == params.length - 2 && params[index + 1].isVarArgs()) {
                TailType tailType = TailType.NONE;
                if (tailType == null) {
                    MyParentVisitor.$$$reportNull$$$0(46);
                }
                return tailType;
            }
            if (index == params.length - 1) {
                PsiElement call = argument.getParent().getParent();
                if (call instanceof SyntheticElement) {
                    TailType tailType = TailType.NONE;
                    if (tailType == null) {
                        MyParentVisitor.$$$reportNull$$$0(47);
                    }
                    return tailType;
                }
                PsiType returnType = method.getReturnType();
                if (returnType != null) {
                    returnType = substitutor.substitute(returnType);
                }
                TailType tailType = ExpectedTypesProvider.getFinalCallParameterTailType(call, returnType, method);
                if (tailType == null) {
                    MyParentVisitor.$$$reportNull$$$0(48);
                }
                return tailType;
            }
            TailType tailType = TailType.COMMA;
            if (tailType == null) {
                MyParentVisitor.$$$reportNull$$$0(49);
            }
            return tailType;
        }

        private static void inferMethodCallArgumentTypes(@NotNull PsiExpression argument, boolean forCompletion, @NotNull PsiExpression[] args, int index, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull Set<? super ExpectedTypeInfo> array) {
            if (argument == null) {
                MyParentVisitor.$$$reportNull$$$0(50);
            }
            if (args == null) {
                MyParentVisitor.$$$reportNull$$$0(51);
            }
            if (method == null) {
                MyParentVisitor.$$$reportNull$$$0(52);
            }
            if (substitutor == null) {
                MyParentVisitor.$$$reportNull$$$0(53);
            }
            if (array == null) {
                MyParentVisitor.$$$reportNull$$$0(54);
            }
            LOG.assertTrue(substitutor.isValid());
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (!forCompletion && parameters2.length != args.length && !method.isVarArgs()) {
                return;
            }
            if (parameters2.length <= index && !method.isVarArgs()) {
                return;
            }
            for (int j = 0; j < index; ++j) {
                PsiType paramType = MyParentVisitor.getParameterType(parameters2[Math.min(parameters2.length - 1, j)], substitutor);
                PsiType argType = args[j].getType();
                if (argType == null || paramType.isAssignableFrom(argType)) continue;
                return;
            }
            PsiParameter parameter2 = parameters2[Math.min(parameters2.length - 1, index)];
            PsiType parameterType = MyParentVisitor.getParameterType(parameter2, substitutor);
            TailType tailType = MyParentVisitor.getMethodArgumentTailType(argument, index, method, substitutor, parameters2);
            PsiType defaultType = MyParentVisitor.getDefaultType(method, substitutor, parameterType, argument, args, index);
            NullableComputable<String> propertyName = MyParentVisitor.getPropertyName((PsiVariable)parameter2);
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(parameterType, 1, defaultType, tailType, method, (NullableComputable<String>)propertyName);
            array.add(info);
            if (index == parameters2.length - 1 && parameter2.isVarArgs()) {
                PsiArrayType arrayType = parameterType.createArrayType();
                ExpectedTypeInfoImpl info1 = ExpectedTypesProvider.createInfoImpl((PsiType)arrayType, 1, (PsiType)arrayType, tailType, method, (NullableComputable<String>)propertyName);
                array.add(info1);
            }
        }

        @Nullable
        private static PsiType getDefaultType(@NotNull PsiMethod method, PsiSubstitutor substitutor, @NotNull PsiType parameterType, @NotNull PsiExpression argument, @NotNull PsiExpression[] args, int index) {
            PsiType typeArg;
            String className;
            PsiClass containingClass;
            if (method == null) {
                MyParentVisitor.$$$reportNull$$$0(55);
            }
            if (parameterType == null) {
                MyParentVisitor.$$$reportNull$$$0(56);
            }
            if (argument == null) {
                MyParentVisitor.$$$reportNull$$$0(57);
            }
            if (args == null) {
                MyParentVisitor.$$$reportNull$$$0(58);
            }
            if ((containingClass = method.getContainingClass()) == null) {
                return parameterType;
            }
            PsiType hardcoded = HardcodedDefaultTypesKt.getDefaultType(method, substitutor, index, argument);
            if (hardcoded != null) {
                return hardcoded;
            }
            String name = method.getName();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)containingClass.getProject());
            int argCount = Math.max(index + 1, args.length);
            if (("assertEquals".equals(name) || "assertSame".equals(name) && method.getParameterList().getParametersCount() == argCount) && (argCount == 2 || argCount == 3 && method.getParameterList().getParameters()[0].getType().equalsToText("java.lang.String"))) {
                ExpectedTypeInfo info;
                int other;
                int n = other = index == argCount - 1 ? index - 1 : index + 1;
                if (args.length > other && (info = MyParentVisitor.getEqualsType(args[other])) != null && parameterType.isAssignableFrom(info.getDefaultType())) {
                    return info.getDefaultType();
                }
            }
            if ((className = containingClass.getName()) != null && className.startsWith("Log") && parameterType instanceof PsiClassType && ((typeArg = PsiUtil.substituteTypeParameter((PsiType)parameterType, (String)"java.lang.Class", (int)0, (boolean)true)) instanceof PsiWildcardType && !((PsiWildcardType)typeArg).isBounded() || typeArg != null && TypeConversionUtil.erasure((PsiType)typeArg).equalsToText("java.lang.Object"))) {
                PsiClass placeClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)argument, (Class[])new Class[]{PsiClass.class});
                PsiClass classClass = ((PsiClassType)parameterType).resolve();
                if (placeClass != null && classClass != null && classClass.getTypeParameters().length == 1) {
                    return factory.createType(classClass, (PsiType)factory.createType(placeClass));
                }
            }
            return parameterType;
        }

        private static PsiType getParameterType(@NotNull PsiParameter parameter2, @NotNull PsiSubstitutor substitutor) {
            PsiType parameterType;
            if (parameter2 == null) {
                MyParentVisitor.$$$reportNull$$$0(59);
            }
            if (substitutor == null) {
                MyParentVisitor.$$$reportNull$$$0(60);
            }
            PsiType type2 = parameter2.getType();
            LOG.assertTrue(type2.isValid());
            if (parameter2.isVarArgs()) {
                if (type2 instanceof PsiArrayType) {
                    type2 = ((PsiArrayType)type2).getComponentType();
                } else {
                    LOG.error("Vararg parameter with non-array type. Class=" + parameter2.getClass() + "; type=" + parameter2.getType());
                }
            }
            if ((parameterType = substitutor.substitute(type2)) instanceof PsiCapturedWildcardType) {
                parameterType = ((PsiCapturedWildcardType)parameterType).getWildcard();
            }
            if (parameterType instanceof PsiWildcardType) {
                PsiType bound = ((PsiWildcardType)parameterType).getBound();
                return bound != null ? bound : PsiType.getJavaLangObject((PsiManager)parameter2.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)parameter2.getProject()));
            }
            return parameterType;
        }

        @NotNull
        private static NullableComputable<String> getPropertyName(@NotNull PsiVariable variable) {
            if (variable == null) {
                MyParentVisitor.$$$reportNull$$$0(61);
            }
            NullableComputable nullableComputable = () -> {
                String name;
                if (variable == null) {
                    MyParentVisitor.$$$reportNull$$$0(69);
                }
                if ((name = variable.getName()) == null) {
                    return null;
                }
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)variable.getProject());
                VariableKind variableKind = codeStyleManager.getVariableKind(variable);
                return codeStyleManager.variableNameToPropertyName(name, variableKind);
            };
            if (nullableComputable == null) {
                MyParentVisitor.$$$reportNull$$$0(62);
            }
            return nullableComputable;
        }

        @NotNull
        private List<ExpectedTypeInfo> anyArrayType() {
            PsiArrayType objType = PsiType.getJavaLangObject((PsiManager)this.myExpr.getManager(), (GlobalSearchScope)this.myExpr.getResolveScope()).createArrayType();
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl((PsiType)objType, (PsiType)objType);
            ExpectedTypeInfoImpl info1 = ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE.createArrayType(), (PsiType)PsiType.INT.createArrayType());
            PsiArrayType booleanType = PsiType.BOOLEAN.createArrayType();
            ExpectedTypeInfoImpl info2 = ExpectedTypesProvider.createInfoImpl((PsiType)booleanType, 0, (PsiType)booleanType, TailType.NONE);
            List<ExpectedTypeInfo> list = Arrays.asList(info, info1, info2);
            if (list == null) {
                MyParentVisitor.$$$reportNull$$$0(63);
            }
            return list;
        }

        @NotNull
        private ExpectedTypeInfo[] findClassesWithDeclaredMethod(@NotNull PsiMethodCallExpression methodCallExpr) {
            if (methodCallExpr == null) {
                MyParentVisitor.$$$reportNull$$$0(64);
            }
            PsiUtilCore.ensureValid((PsiElement)methodCallExpr);
            PsiReferenceExpression reference = methodCallExpr.getMethodExpression();
            if (reference.getQualifierExpression() instanceof PsiClassObjectAccessExpression) {
                if (ExpectedTypeInfo.EMPTY_ARRAY == null) {
                    MyParentVisitor.$$$reportNull$$$0(65);
                }
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            PsiManager manager = methodCallExpr.getManager();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            Set<PsiMethod> psiMethods = MyParentVisitor.mapToDeepestSuperMethods(this.myClassProvider.findDeclaredMethods(manager, reference.getReferenceName()));
            THashSet types = new THashSet();
            for (PsiMethod method : psiMethods) {
                PsiClassType type2;
                PsiClass aClass = method.getContainingClass();
                if (aClass == null || !facade.getResolveHelper().isAccessible((PsiMember)method, (PsiElement)reference, aClass)) continue;
                PsiSubstitutor substitutor = ExpectedTypeUtil.inferSubstitutor(method, methodCallExpr, false);
                PsiClassType psiClassType = type2 = substitutor == null ? facade.getElementFactory().createType(aClass) : facade.getElementFactory().createType(aClass, substitutor);
                if (method.hasModifierProperty("static") || method.hasModifierProperty("private")) {
                    types.add(ExpectedTypesProvider.createInfoImpl((PsiType)type2, 0, (PsiType)type2, TailType.DOT));
                    continue;
                }
                types.add(ExpectedTypesProvider.createInfoImpl((PsiType)type2, 1, (PsiType)type2, TailType.DOT));
            }
            ExpectedTypeInfo[] expectedTypeInfoArray = types.toArray(ExpectedTypeInfo.EMPTY_ARRAY);
            if (expectedTypeInfoArray == null) {
                MyParentVisitor.$$$reportNull$$$0(66);
            }
            return expectedTypeInfoArray;
        }

        private static Set<PsiMethod> mapToDeepestSuperMethods(PsiMethod[] methods) {
            LinkedHashSet<PsiMethod> psiMethods = new LinkedHashSet<PsiMethod>();
            for (PsiMethod m : methods) {
                if (m.hasModifierProperty("static") || m.hasModifierProperty("private")) {
                    psiMethods.add(m);
                    continue;
                }
                PsiMethod[] superMethods = m.findDeepestSuperMethods();
                if (superMethods.length > 0) {
                    psiMethods.addAll(Arrays.asList(superMethods));
                    continue;
                }
                psiMethods.add(m);
            }
            return psiMethods;
        }

        @NotNull
        private ExpectedTypeInfo[] findClassesWithDeclaredField(@NotNull PsiReferenceExpression expression2) {
            if (expression2 == null) {
                MyParentVisitor.$$$reportNull$$$0(67);
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression2.getProject());
            PsiField[] fields = this.myClassProvider.findDeclaredFields(expression2.getManager(), expression2.getReferenceName());
            ArrayList<ExpectedTypeInfoImpl> types = new ArrayList<ExpectedTypeInfoImpl>();
            for (PsiField field : fields) {
                PsiClass aClass = field.getContainingClass();
                if (aClass == null || !facade.getResolveHelper().isAccessible((PsiMember)field, (PsiElement)expression2, aClass)) continue;
                PsiClassType type2 = facade.getElementFactory().createType(aClass);
                int kind2 = field.hasModifierProperty("static") || field.hasModifierProperty("final") || field.hasModifierProperty("private") ? 0 : 1;
                ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl((PsiType)type2, kind2, (PsiType)type2, TailType.DOT);
                types.add(info);
            }
            ExpectedTypeInfo[] expectedTypeInfoArray = types.toArray(ExpectedTypeInfo.EMPTY_ARRAY);
            if (expectedTypeInfoArray == null) {
                MyParentVisitor.$$$reportNull$$$0(68);
            }
            return expectedTypeInfoArray;
        }

        private static /* synthetic */ PsiSubstitutor lambda$getExpectedArgumentTypesForMethodCall$3(CandidateInfo candidateInfo, ParameterTypeInferencePolicy policy, PsiExpression[] leftArgs) {
            return ((MethodCandidateInfo)candidateInfo).inferSubstitutorFromArgs(policy, leftArgs);
        }

        private static /* synthetic */ PsiSubstitutor lambda$getExpectedArgumentTypesForMethodCall$2(MethodCandidateInfo info, ParameterTypeInferencePolicy policy, PsiExpression[] args) {
            return info.inferSubstitutorFromArgs(policy, args);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 64: 
                case 67: 
                case 69: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 64: 
                case 67: 
                case 69: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor";
                    break;
                }
                case 1: 
                case 43: 
                case 52: 
                case 55: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: 
                case 3: 
                case 31: 
                case 67: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pair";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 13: 
                case 61: 
                case 69: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 19: 
                case 21: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumConstant";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newExpr";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referencedClass";
                    break;
                }
                case 25: 
                case 37: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argumentList";
                    break;
                }
                case 26: 
                case 44: 
                case 53: 
                case 60: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutor";
                    break;
                }
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 32: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codeFragment";
                    break;
                }
                case 36: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allCandidates";
                    break;
                }
                case 38: 
                case 42: 
                case 50: 
                case 57: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 45: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "params";
                    break;
                }
                case 51: 
                case 58: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
                case 54: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 56: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterType";
                    break;
                }
                case 59: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 64: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodCallExpr";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 64: 
                case 67: 
                case 69: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAssignmentRValueTailType";
                    break;
                }
                case 39: 
                case 40: 
                case 41: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpectedArgumentTypesForMethodCall";
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodArgumentTailType";
                    break;
                }
                case 62: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPropertyName";
                    break;
                }
                case 63: {
                    objectArray = objectArray2;
                    objectArray2[1] = "anyArrayType";
                    break;
                }
                case 65: 
                case 66: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findClassesWithDeclaredMethod";
                    break;
                }
                case 68: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findClassesWithDeclaredField";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAnnotationMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitReferenceExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitMethodCallExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAnnotationArrayInitializer";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitNameValuePair";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getAnnotationMethodType";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitForStatement";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAssertStatement";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "visitForeachStatement";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSwitchStatement";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSwitchLabelStatement";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSynchronizedStatement";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "visitVariable";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAssignmentExpression";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getAssignmentRValueTailType";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "visitExpressionList";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpectedArgumentsTypesForEnumConstant";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpectedArgumentsTypesForNewExpression";
                    break;
                }
                case 24: 
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpectedTypesForConstructorCall";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPolyadicExpression";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPrefixExpression";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPostfixExpression";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "visitArrayInitializerExpression";
                    break;
                }
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "visitNewExpression";
                    break;
                }
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "visitArrayAccessExpression";
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "visitConditionalExpression";
                    break;
                }
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "visitThrowStatement";
                    break;
                }
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "visitCodeFragment";
                    break;
                }
                case 36: 
                case 37: 
                case 38: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpectedArgumentTypesForMethodCall";
                    break;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    objectArray = objectArray;
                    objectArray[2] = "getMethodArgumentTailType";
                    break;
                }
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: {
                    objectArray = objectArray;
                    objectArray[2] = "inferMethodCallArgumentTypes";
                    break;
                }
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultType";
                    break;
                }
                case 59: 
                case 60: {
                    objectArray = objectArray;
                    objectArray[2] = "getParameterType";
                    break;
                }
                case 61: {
                    objectArray = objectArray;
                    objectArray[2] = "getPropertyName";
                    break;
                }
                case 64: {
                    objectArray = objectArray;
                    objectArray[2] = "findClassesWithDeclaredMethod";
                    break;
                }
                case 67: {
                    objectArray = objectArray;
                    objectArray[2] = "findClassesWithDeclaredField";
                    break;
                }
                case 69: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getPropertyName$4";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 64: 
                case 67: 
                case 69: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

