/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.config.UpdateMethod;
import git4idea.push.PushUpdateSettings;
import git4idea.repo.GitRepository;
import git4idea.util.GitUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitRejectedPushUpdateDialog
extends DialogWrapper {
    static final int MERGE_EXIT_CODE = 2;
    static final int REBASE_EXIT_CODE = 3;
    private static final String HTML_IDENT = "&nbsp;&nbsp;&nbsp;&nbsp;";
    public static final String DESCRIPTION_START = "Push of current branch ";
    private final Project myProject;
    private final Collection<GitRepository> myRepositories;
    private final boolean myRebaseOverMergeProblemDetected;
    private final JCheckBox myUpdateAllRoots;
    private final RebaseAction myRebaseAction;
    private final MergeAction myMergeAction;
    private final JCheckBox myAutoUpdateInFuture;

    protected GitRejectedPushUpdateDialog(@NotNull Project project, @NotNull Collection<GitRepository> repositories, @NotNull PushUpdateSettings initialSettings, boolean rebaseOverMergeProblemDetected) {
        if (project == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(0);
        }
        if (repositories == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(1);
        }
        if (initialSettings == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.myRepositories = repositories;
        this.myRebaseOverMergeProblemDetected = rebaseOverMergeProblemDetected;
        this.myUpdateAllRoots = new JCheckBox("Update not rejected repositories as well", initialSettings.shouldUpdateAllRoots());
        this.myUpdateAllRoots.setMnemonic('u');
        this.myAutoUpdateInFuture = new JCheckBox("<html>Remember the update method choice and <u>s</u>ilently update in future <br/>(you may change this in the Settings)</html>");
        this.myAutoUpdateInFuture.setMnemonic('s');
        this.myMergeAction = new MergeAction();
        this.myRebaseAction = new RebaseAction();
        this.setDefaultAndFocusedActions(initialSettings.getUpdateMethod());
        this.init();
        this.setTitle("Push Rejected");
    }

    private void setDefaultAndFocusedActions(@Nullable UpdateMethod updateMethod) {
        Action focusedAction;
        AbstractAction defaultAction;
        if (this.myRebaseOverMergeProblemDetected) {
            defaultAction = this.myMergeAction;
            focusedAction = this.getCancelAction();
        } else if (updateMethod == UpdateMethod.REBASE) {
            defaultAction = this.myRebaseAction;
            focusedAction = this.myMergeAction;
        } else {
            defaultAction = this.myMergeAction;
            focusedAction = this.myRebaseAction;
        }
        defaultAction.putValue("DefaultAction", Boolean.TRUE);
        focusedAction.putValue("FocusedAction", Boolean.TRUE);
    }

    protected JComponent createCenterPanel() {
        JBLabel desc = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)this.makeDescription()));
        JPanel options = new JPanel(new BorderLayout());
        if (!this.myRebaseOverMergeProblemDetected) {
            options.add((Component)this.myAutoUpdateInFuture, "South");
        }
        if (!GitUtil.justOneGitRepository(this.myProject)) {
            options.add(this.myUpdateAllRoots);
        }
        int GAP = 15;
        JPanel rootPanel = new JPanel(new BorderLayout(15, 15));
        rootPanel.add((Component)desc);
        rootPanel.add((Component)options, "South");
        JLabel iconLabel = new JLabel(this.myRebaseOverMergeProblemDetected ? UIUtil.getWarningIcon() : UIUtil.getQuestionIcon());
        rootPanel.add((Component)iconLabel, "West");
        return rootPanel;
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.UpdateOnRejectedPushDialog";
    }

    private String makeDescription() {
        if (GitUtil.justOneGitRepository(this.myProject)) {
            assert (!this.myRepositories.isEmpty()) : "repositories are empty";
            GitRepository repository = this.myRepositories.iterator().next();
            GitBranch currentBranch = GitRejectedPushUpdateDialog.getCurrentBranch(repository);
            return DESCRIPTION_START + GitUIUtil.code(currentBranch.getName()) + " was rejected. <br/>" + this.descriptionEnding();
        }
        if (this.myRepositories.size() == 1) {
            GitRepository repository = this.myRepositories.iterator().next();
            GitBranch currentBranch = GitRejectedPushUpdateDialog.getCurrentBranch(repository);
            return DESCRIPTION_START + GitUIUtil.code(currentBranch.getName()) + " in repository <br/>" + GitUIUtil.code(repository.getPresentableUrl()) + " was rejected. <br/>" + this.descriptionEnding();
        }
        Map<GitRepository, GitBranch> currentBranches = this.getCurrentBranches();
        if (GitRejectedPushUpdateDialog.allBranchesHaveTheSameName(currentBranches)) {
            String branchName = currentBranches.values().iterator().next().getName();
            StringBuilder sb = new StringBuilder(DESCRIPTION_START + GitUIUtil.code(branchName) + " was rejected in repositories <br/>");
            for (GitRepository repository : DvcsUtil.sortRepositories(currentBranches.keySet())) {
                sb.append(HTML_IDENT).append(GitUIUtil.code(repository.getPresentableUrl())).append("<br/>");
            }
            sb.append(this.descriptionEnding());
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder("<html>Push of current branch was rejected: <br/>");
        for (Map.Entry<GitRepository, GitBranch> entry : currentBranches.entrySet()) {
            GitRepository repository = entry.getKey();
            GitBranch currentBranch = entry.getValue();
            sb.append(HTML_IDENT + GitUIUtil.code(currentBranch.getName()) + " in " + GitUIUtil.code(repository.getPresentableUrl()) + "<br/>");
        }
        sb.append(this.descriptionEnding());
        return sb.toString();
    }

    @NotNull
    private String descriptionEnding() {
        String desc = "Remote changes need to be merged before pushing.";
        if (this.myRebaseOverMergeProblemDetected) {
            desc = desc + "<br/><br/>In this case <b>merge is highly recommended</b>, because there are non-pushed merge commits. <br/>Rebasing them can lead to problems.";
        }
        String string = desc;
        if (string == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static boolean allBranchesHaveTheSameName(@NotNull Map<GitRepository, GitBranch> branches2) {
        if (branches2 == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(4);
        }
        String name = null;
        for (GitBranch branch : branches2.values()) {
            if (name == null) {
                name = branch.getName();
                continue;
            }
            if (name.equals(branch.getName())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Map<GitRepository, GitBranch> getCurrentBranches() {
        HashMap<GitRepository, GitBranch> currentBranches = new HashMap<GitRepository, GitBranch>();
        for (GitRepository repository : this.myRepositories) {
            currentBranches.put(repository, GitRejectedPushUpdateDialog.getCurrentBranch(repository));
        }
        HashMap<GitRepository, GitBranch> hashMap = currentBranches;
        if (hashMap == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    @NotNull
    private static GitBranch getCurrentBranch(GitRepository repository) {
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        assert (currentBranch != null) : "Current branch can't be null here. " + repository;
        GitLocalBranch gitLocalBranch = currentBranch;
        if (gitLocalBranch == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(6);
        }
        return gitLocalBranch;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction(), this.myMergeAction, this.myRebaseAction};
        if (actionArray == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(7);
        }
        return actionArray;
    }

    boolean shouldUpdateAll() {
        return this.myUpdateAllRoots.isSelected();
    }

    boolean shouldAutoUpdateInFuture() {
        return this.myAutoUpdateInFuture.isSelected();
    }

    boolean warnsAboutRebaseOverMerge() {
        return this.myRebaseOverMergeProblemDetected;
    }

    @NotNull
    Action getDefaultAction() {
        AbstractAction abstractAction = Boolean.TRUE.equals(this.myMergeAction.getValue("DefaultAction")) ? this.myMergeAction : this.myRebaseAction;
        if (abstractAction == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(8);
        }
        return abstractAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSettings";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitRejectedPushUpdateDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitRejectedPushUpdateDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "descriptionEnding";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranches";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranch";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "allBranchesHaveTheSameName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RebaseAction
    extends AbstractAction {
        RebaseAction() {
            super(GitRejectedPushUpdateDialog.this.myRebaseOverMergeProblemDetected ? "Rebase Anyway" : "&Rebase");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GitRejectedPushUpdateDialog.this.close(3);
        }
    }

    private class MergeAction
    extends AbstractAction {
        MergeAction() {
            super("&Merge");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GitRejectedPushUpdateDialog.this.close(2);
        }
    }
}

