/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsConfigurable;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.config.UpdateMethod;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.NumberFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitVcsPanel
implements ConfigurableUi<GitVcsConfigurable.GitVcsSettingsHolder> {
    private static final String IDEA_SSH = GitBundle.getString("git.vcs.config.ssh.mode.idea");
    private static final String NATIVE_SSH = GitBundle.getString("git.vcs.config.ssh.mode.native");
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitExecutableManager myExecutableManager;
    private String myApplicationGitPath;
    private volatile boolean versionCheckRequested;
    private JButton myTestButton;
    private JComponent myRootPanel;
    private TextFieldWithBrowseButton myGitField;
    private JBCheckBox myProjectGitPathCheckBox;
    private JComboBox mySSHExecutableComboBox;
    private JCheckBox myAutoUpdateIfPushRejected;
    private JBCheckBox mySyncControl;
    private JCheckBox myAutoCommitOnCherryPick;
    private JCheckBox myAddCherryPickSuffix;
    private JBCheckBox myWarnAboutCrlf;
    private JCheckBox myWarnAboutDetachedHead;
    private JTextField myProtectedBranchesField;
    private JBLabel myProtectedBranchesLabel;
    private JComboBox myUpdateMethodComboBox;
    private JCheckBox myUpdateBranchInfoCheckBox;
    private JFormattedTextField myBranchUpdateTimeField;
    private JPanel myBranchTimePanel;
    private JBLabel mySupportedBranchUpLabel;
    private JPanel myIncomingOutgoingSettingPanel;
    private JBCheckBox myPreviewPushOnCommitAndPush;
    private JBCheckBox myPreviewPushProtectedOnly;
    private JPanel myPreviewPushProtectedOnlyBorder;

    public GitVcsPanel(@NotNull Project project, @NotNull GitExecutableManager executableManager) {
        if (project == null) {
            GitVcsPanel.$$$reportNull$$$0(0);
        }
        if (executableManager == null) {
            GitVcsPanel.$$$reportNull$$$0(1);
        }
        this.versionCheckRequested = false;
        this.myProject = project;
        this.myExecutableManager = executableManager;
        this.$$$setupUI$$$();
        this.mySSHExecutableComboBox.addItem(IDEA_SSH);
        this.mySSHExecutableComboBox.addItem(NATIVE_SSH);
        this.mySSHExecutableComboBox.setSelectedItem(IDEA_SSH);
        this.mySSHExecutableComboBox.setToolTipText(GitBundle.message("git.vcs.config.ssh.mode.tooltip", ApplicationNamesInfo.getInstance().getFullProductName()));
        this.myTestButton.addActionListener(e -> this.testExecutable());
        this.myGitField.addBrowseFolderListener(GitBundle.getString("find.git.title"), GitBundle.getString("find.git.description"), project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myProjectGitPathCheckBox.addActionListener(e -> this.handleProjectOverrideStateChanged());
        if (!project.isDefault()) {
            GitRepositoryManager repositoryManager = GitRepositoryManager.getInstance(project);
            this.mySyncControl.setVisible(repositoryManager.moreThanOneRoot());
        } else {
            this.mySyncControl.setVisible(true);
        }
        this.mySyncControl.setToolTipText(DvcsBundle.message((String)"sync.setting.description", (Object[])new Object[]{"Git"}));
        this.myProtectedBranchesLabel.setLabelFor((Component)this.myProtectedBranchesField);
        this.myUpdateBranchInfoCheckBox.addItemListener(e -> UIUtil.setEnabled((Component)this.myBranchTimePanel, (boolean)this.myUpdateBranchInfoCheckBox.isSelected(), (boolean)true));
        this.myPreviewPushOnCommitAndPush.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitVcsPanel.this.updateEnabled();
            }
        });
        Insets insets = this.myPreviewPushProtectedOnly.getBorder().getBorderInsets((Component)this.myPreviewPushProtectedOnly);
        this.myPreviewPushProtectedOnlyBorder.setBorder((Border)JBUI.Borders.emptyLeft((int)(UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)this.myPreviewPushOnCommitAndPush) - insets.left)));
    }

    private void updateEnabled() {
        this.myPreviewPushProtectedOnly.setEnabled(this.myPreviewPushOnCommitAndPush.isSelected());
    }

    private void testExecutable() {
        final String pathToGit = (String)ObjectUtils.notNull((Object)this.getCurrentExecutablePath(), (Object)this.myExecutableManager.getDetectedExecutable());
        new Task.Modal(this.myProject, GitBundle.getString("git.executable.version.progress.title"), true){
            private GitVersion myVersion;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.myVersion = GitVcsPanel.this.myExecutableManager.identifyVersion(pathToGit);
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    2.$$$reportNull$$$0(1);
                }
                GitExecutableProblemsNotifier.showExecutionErrorDialog(error, this.myProject);
            }

            public void onSuccess() {
                if (this.myVersion.isSupported()) {
                    Messages.showInfoMessage((Component)GitVcsPanel.this.myRootPanel, (String)GitBundle.message("git.executable.version.is", this.myVersion.getPresentation()), (String)GitBundle.getString("git.executable.version.success.title"));
                } else {
                    GitExecutableProblemsNotifier.showUnsupportedVersionDialog(this.myVersion, this.myProject);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/config/GitVcsPanel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
    }

    private void handleProjectOverrideStateChanged() {
        if (!this.myProjectGitPathCheckBox.isSelected() && !Objects.equals(this.getCurrentExecutablePath(), this.myApplicationGitPath)) {
            switch (Messages.showYesNoCancelDialog((Component)this.myRootPanel, (String)VcsBundle.getString((String)"executable.project.override.reset.message"), (String)VcsBundle.getString((String)"executable.project.override.reset.title"), (String)VcsBundle.getString((String)"executable.project.override.reset.globalize"), (String)VcsBundle.getString((String)"executable.project.override.reset.revert"), (String)Messages.CANCEL_BUTTON, null)) {
                case 1: {
                    this.myGitField.setText(this.myApplicationGitPath);
                    break;
                }
                case 2: {
                    this.myProjectGitPathCheckBox.setSelected(true);
                }
            }
        }
    }

    @Nullable
    private String getCurrentExecutablePath() {
        return StringUtil.nullize((String)this.myGitField.getText().trim());
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myRootPanel;
        if (jComponent == null) {
            GitVcsPanel.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public void reset(@NotNull GitVcsConfigurable.GitVcsSettingsHolder settings) {
        if (settings == null) {
            GitVcsPanel.$$$reportNull$$$0(3);
        }
        GitVcsApplicationSettings applicationSettings = settings.getApplicationSettings();
        GitVcsSettings projectSettings = settings.getProjectSettings();
        GitSharedSettings sharedSettings = settings.getSharedSettings();
        this.myApplicationGitPath = applicationSettings.getSavedPathToGit();
        String projectSettingsPathToGit = projectSettings.getPathToGit();
        this.myGitField.setText((String)ObjectUtils.coalesce((Object)projectSettingsPathToGit, (Object)this.myApplicationGitPath));
        this.myProjectGitPathCheckBox.setSelected(projectSettingsPathToGit != null);
        this.mySSHExecutableComboBox.setSelectedItem(projectSettings.isIdeaSsh() ? IDEA_SSH : NATIVE_SSH);
        this.myAutoUpdateIfPushRejected.setSelected(projectSettings.autoUpdateIfPushRejected());
        this.mySyncControl.setSelected(projectSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC);
        this.myAutoCommitOnCherryPick.setSelected(projectSettings.isAutoCommitOnCherryPick());
        this.myAddCherryPickSuffix.setSelected(projectSettings.shouldAddSuffixToCherryPicksOfPublishedCommits());
        this.myWarnAboutCrlf.setSelected(projectSettings.warnAboutCrlf());
        this.myWarnAboutDetachedHead.setSelected(projectSettings.warnAboutDetachedHead());
        this.myUpdateMethodComboBox.setSelectedItem((Object)projectSettings.getUpdateType());
        this.myProtectedBranchesField.setText((String)ParametersListUtil.COLON_LINE_JOINER.fun(sharedSettings.getForcePushProhibitedPatterns()));
        boolean branchInfoSupported = this.isBranchInfoSupported();
        this.myUpdateBranchInfoCheckBox.setSelected(branchInfoSupported && projectSettings.shouldUpdateBranchInfo());
        this.myUpdateBranchInfoCheckBox.setEnabled(branchInfoSupported);
        this.myBranchUpdateTimeField.setValue(projectSettings.getBranchInfoUpdateTime());
        this.myPreviewPushOnCommitAndPush.setSelected(projectSettings.shouldPreviewPushOnCommitAndPush());
        this.myPreviewPushProtectedOnly.setSelected(projectSettings.isPreviewPushProtectedOnly());
        this.updateEnabled();
    }

    private boolean isBranchInfoSupported() {
        return GitVersionSpecialty.INCOMING_OUTGOING_BRANCH_INFO.existsIn(this.myProject);
    }

    public boolean isModified(@NotNull GitVcsConfigurable.GitVcsSettingsHolder settings) {
        if (settings == null) {
            GitVcsPanel.$$$reportNull$$$0(4);
        }
        GitVcsApplicationSettings applicationSettings = settings.getApplicationSettings();
        GitVcsSettings projectSettings = settings.getProjectSettings();
        GitSharedSettings sharedSettings = settings.getSharedSettings();
        return this.isGitPathModified(applicationSettings, projectSettings) || projectSettings.isIdeaSsh() != IDEA_SSH.equals(this.mySSHExecutableComboBox.getSelectedItem()) || !projectSettings.autoUpdateIfPushRejected() == this.myAutoUpdateIfPushRejected.isSelected() || projectSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC != this.mySyncControl.isSelected() || projectSettings.isAutoCommitOnCherryPick() != this.myAutoCommitOnCherryPick.isSelected() || projectSettings.shouldAddSuffixToCherryPicksOfPublishedCommits() != this.myAddCherryPickSuffix.isSelected() || projectSettings.warnAboutCrlf() != this.myWarnAboutCrlf.isSelected() || projectSettings.warnAboutDetachedHead() != this.myWarnAboutDetachedHead.isSelected() || projectSettings.shouldPreviewPushOnCommitAndPush() != this.myPreviewPushOnCommitAndPush.isSelected() || projectSettings.isPreviewPushProtectedOnly() != this.myPreviewPushProtectedOnly.isSelected() || projectSettings.getUpdateType() != this.myUpdateMethodComboBox.getModel().getSelectedItem() || this.isUpdateBranchSettingsModified(projectSettings) || !ContainerUtil.sorted(sharedSettings.getForcePushProhibitedPatterns()).equals(ContainerUtil.sorted(this.getProtectedBranchesPatterns()));
    }

    private boolean isGitPathModified(@NotNull GitVcsApplicationSettings applicationSettings, @NotNull GitVcsSettings projectSettings) {
        if (applicationSettings == null) {
            GitVcsPanel.$$$reportNull$$$0(5);
        }
        if (projectSettings == null) {
            GitVcsPanel.$$$reportNull$$$0(6);
        }
        return this.myProjectGitPathCheckBox.isSelected() ? !Objects.equals(this.getCurrentExecutablePath(), projectSettings.getPathToGit()) : !Objects.equals(this.getCurrentExecutablePath(), applicationSettings.getSavedPathToGit()) || projectSettings.getPathToGit() != null;
    }

    public void apply(@NotNull GitVcsConfigurable.GitVcsSettingsHolder settings) {
        if (settings == null) {
            GitVcsPanel.$$$reportNull$$$0(7);
        }
        GitVcsApplicationSettings applicationSettings = settings.getApplicationSettings();
        GitVcsSettings projectSettings = settings.getProjectSettings();
        GitSharedSettings sharedSettings = settings.getSharedSettings();
        if (this.myProjectGitPathCheckBox.isSelected()) {
            projectSettings.setPathToGit(this.getCurrentExecutablePath());
        } else {
            this.myApplicationGitPath = this.getCurrentExecutablePath();
            applicationSettings.setPathToGit(this.getCurrentExecutablePath());
            projectSettings.setPathToGit(null);
        }
        applicationSettings.setIdeaSsh(IDEA_SSH.equals(this.mySSHExecutableComboBox.getSelectedItem()) ? GitVcsApplicationSettings.SshExecutable.IDEA_SSH : GitVcsApplicationSettings.SshExecutable.NATIVE_SSH);
        projectSettings.setAutoUpdateIfPushRejected(this.myAutoUpdateIfPushRejected.isSelected());
        projectSettings.setSyncSetting(this.mySyncControl.isSelected() ? DvcsSyncSettings.Value.SYNC : DvcsSyncSettings.Value.DONT_SYNC);
        projectSettings.setAutoCommitOnCherryPick(this.myAutoCommitOnCherryPick.isSelected());
        projectSettings.setAddSuffixToCherryPicks(this.myAddCherryPickSuffix.isSelected());
        projectSettings.setWarnAboutCrlf(this.myWarnAboutCrlf.isSelected());
        projectSettings.setWarnAboutDetachedHead(this.myWarnAboutDetachedHead.isSelected());
        projectSettings.setUpdateType((UpdateMethod)((Object)this.myUpdateMethodComboBox.getSelectedItem()));
        projectSettings.setPreviewPushOnCommitAndPush(this.myPreviewPushOnCommitAndPush.isSelected());
        projectSettings.setPreviewPushProtectedOnly(this.myPreviewPushProtectedOnly.isSelected());
        sharedSettings.setForcePushProhibitedPatters(this.getProtectedBranchesPatterns());
        this.applyBranchUpdateInfo(projectSettings);
        this.validateExecutableOnceAfterClose();
    }

    public void validateExecutableOnceAfterClose() {
        if (!this.versionCheckRequested) {
            ApplicationManager.getApplication().invokeLater(() -> {
                new Task.Backgroundable(this.myProject, GitBundle.getString("git.executable.version.progress.title"), true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        GitVcsPanel.this.myExecutableManager.testGitExecutableVersionValid(this.myProject);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/config/GitVcsPanel$3", "run"));
                    }
                }.queue();
                this.versionCheckRequested = false;
            }, ModalityState.NON_MODAL);
            this.versionCheckRequested = true;
        }
    }

    private void applyBranchUpdateInfo(@NotNull GitVcsSettings projectSettings) {
        if (projectSettings == null) {
            GitVcsPanel.$$$reportNull$$$0(8);
        }
        boolean branchInfoSupported = this.isBranchInfoSupported();
        this.myUpdateBranchInfoCheckBox.setEnabled(branchInfoSupported);
        if (!branchInfoSupported) {
            this.myUpdateBranchInfoCheckBox.setSelected(false);
        }
        if (this.isUpdateBranchSettingsModified(projectSettings)) {
            projectSettings.setBranchInfoUpdateTime((Integer)this.myBranchUpdateTimeField.getValue());
            projectSettings.setUpdateBranchInfo(this.myUpdateBranchInfoCheckBox.isSelected());
            GitBranchIncomingOutgoingManager incomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(this.myProject);
            incomingOutgoingManager.stopScheduling();
            if (projectSettings.shouldUpdateBranchInfo()) {
                incomingOutgoingManager.startScheduling();
            }
        }
    }

    private boolean isUpdateBranchSettingsModified(@NotNull GitVcsSettings projectSettings) {
        if (projectSettings == null) {
            GitVcsPanel.$$$reportNull$$$0(9);
        }
        return projectSettings.getBranchInfoUpdateTime() != ((Integer)this.myBranchUpdateTimeField.getValue()).intValue() || projectSettings.shouldUpdateBranchInfo() != this.myUpdateBranchInfoCheckBox.isSelected();
    }

    @NotNull
    private List<String> getProtectedBranchesPatterns() {
        List list = (List)ParametersListUtil.COLON_LINE_PARSER.fun((Object)this.myProtectedBranchesField.getText());
        if (list == null) {
            GitVcsPanel.$$$reportNull$$$0(10);
        }
        return list;
    }

    private void createUIComponents() {
        JBTextField textField = new JBTextField();
        textField.getEmptyText().setText("Auto-detected: " + this.myExecutableManager.getDetectedExecutable());
        this.myGitField = new TextFieldWithBrowseButton((JTextField)textField);
        this.myProtectedBranchesField = new ExpandableTextField(ParametersListUtil.COLON_LINE_PARSER, ParametersListUtil.COLON_LINE_JOINER);
        this.myUpdateMethodComboBox = new ComboBox((ComboBoxModel)new EnumComboBoxModel(UpdateMethod.class));
        this.myUpdateMethodComboBox.setRenderer(new ListCellRendererWrapper<UpdateMethod>(){

            public void customize(JList list, UpdateMethod value, int index, boolean selected, boolean hasFocus) {
                this.setText(StringUtil.capitalize((String)StringUtil.toLowerCase((String)value.name().replace('_', ' '))));
            }
        });
        this.myIncomingOutgoingSettingPanel = new JPanel(new BorderLayout());
        this.myIncomingOutgoingSettingPanel.setVisible(false);
        NumberFormatter numberFormatter = new NumberFormatter(NumberFormat.getIntegerInstance());
        numberFormatter.setMinimum(Integer.valueOf(1));
        numberFormatter.setAllowsInvalid(true);
        this.myBranchUpdateTimeField = new JFormattedTextField(numberFormatter);
        this.mySupportedBranchUpLabel = new JBLabel("Supported from Git 2.9+");
        this.mySupportedBranchUpLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableManager";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitVcsPanel";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationSettings";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitVcsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtectedBranchesPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isGitPathModified";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyBranchUpdateInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUpdateBranchSettingsModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JBCheckBox jBCheckBox3;
        JBLabel jBLabel;
        JCheckBox jCheckBox4;
        JBCheckBox jBCheckBox4;
        JCheckBox jCheckBox5;
        JBCheckBox jBCheckBox5;
        JButton jButton;
        JComboBox jComboBox;
        this.createUIComponents();
        JPanel jPanel3 = new JPanel();
        this.myRootPanel = jPanel3;
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 7, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.path.label"));
        jLabel.setVerifyInputWhenFocusTarget(false);
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.ssh.mode"));
        jPanel4.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySSHExecutableComboBox = jComboBox = new JComboBox();
        jPanel5.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myGitField;
        jPanel6.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myTestButton = jButton = new JButton();
        jButton.setHorizontalAlignment(0);
        jButton.setLabel(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.test.label"));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.test"));
        jPanel6.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 2, null, null, null));
        this.myProjectGitPathCheckBox = jBCheckBox5 = new JBCheckBox();
        jBCheckBox5.setEnabled(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("executable.path.project.override"));
        jPanel4.add((Component)jBCheckBox5, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(11, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAutoCommitOnCherryPick = jCheckBox5 = new JCheckBox();
        jCheckBox5.setIconTextGap(4);
        jCheckBox5.setText("Commit automatically on cherry-pick");
        jPanel7.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.myWarnAboutCrlf = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Warn if CRLF line separators are about to be committed");
        jBCheckBox4.setMnemonic('C');
        jBCheckBox4.setDisplayedMnemonicIndex(8);
        jPanel7.add((Component)jBCheckBox4, new GridConstraints(3, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myWarnAboutDetachedHead = jCheckBox4 = new JCheckBox();
        jCheckBox4.setSelected(true);
        jCheckBox4.setText("Warn when committing in detached HEAD or during rebase");
        jPanel7.add((Component)jCheckBox4, new GridConstraints(4, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        JTextField jTextField = this.myProtectedBranchesField;
        jTextField.setText("");
        jPanel7.add((Component)jTextField, new GridConstraints(10, 1, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myProtectedBranchesLabel = jBLabel = new JBLabel();
        jBLabel.setText("Protected branches:");
        jPanel7.add((Component)jBLabel, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.mySyncControl = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("sync.setting"));
        jBCheckBox3.setToolTipText("");
        jPanel7.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Update method:");
        jPanel7.add((Component)jBLabel2, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myAutoUpdateIfPushRejected = jCheckBox3 = new JCheckBox();
        jCheckBox3.setIconTextGap(4);
        jCheckBox3.setText("Auto-update if push of the current branch was rejected");
        jCheckBox3.setMnemonic('P');
        jCheckBox3.setDisplayedMnemonicIndex(15);
        jPanel7.add((Component)jCheckBox3, new GridConstraints(7, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox2 = this.myUpdateMethodComboBox;
        jPanel7.add((Component)jComboBox2, new GridConstraints(6, 1, 1, 1, 8, 1, 0, 0, null, null, null));
        JPanel jPanel8 = this.myIncomingOutgoingSettingPanel;
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 0, null, null, null));
        this.myUpdateBranchInfoCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        jCheckBox2.setText("Mark branches that have incoming/outgoing commits in the Branches popup. ");
        jPanel9.add((Component)jCheckBox2, "West");
        this.myBranchTimePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel2, "Center");
        JFormattedTextField jFormattedTextField = this.myBranchUpdateTimeField;
        jFormattedTextField.setHorizontalAlignment(2);
        jFormattedTextField.setMinimumSize(new Dimension(40, 26));
        jFormattedTextField.setText("");
        jPanel2.add((Component)jFormattedTextField, "Center");
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setHorizontalTextPosition(2);
        jBLabel3.setText(" minutes ");
        jPanel2.add((Component)jBLabel3, "East");
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Refresh every ");
        jPanel2.add((Component)jBLabel4, "West");
        JBLabel jBLabel5 = this.mySupportedBranchUpLabel;
        jBLabel5.setAlignmentX(0.0f);
        jBLabel5.setForeground(new Color(-8355712));
        jBLabel5.setHorizontalAlignment(2);
        jBLabel5.setHorizontalTextPosition(2);
        jBLabel5.setText(" Supported for Git 2.9+");
        jPanel8.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        Spacer spacer3 = new Spacer();
        jPanel7.add((Component)spacer3, new GridConstraints(6, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPreviewPushOnCommitAndPush = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Show Push dialog for Commit and Push");
        jPanel7.add((Component)jBCheckBox2, new GridConstraints(8, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myPreviewPushProtectedOnlyBorder = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel, new GridConstraints(9, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myPreviewPushProtectedOnly = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Show Push dialog only when committing to protected branches");
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAddCherryPickSuffix = jCheckBox = new JCheckBox();
        jCheckBox.setIconTextGap(4);
        jCheckBox.setSelected(true);
        jCheckBox.setText("Add the 'cherry-picked from <hash>' suffix when picking commits pushed to protected branches");
        jPanel7.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jBLabel2.setLabelFor(jComboBox2);
        jBLabel3.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

