/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.filter.BranchPopupBuilder;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.branch.DeepComparator;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DeepCompareAction
extends ToggleAction
implements DumbAware {
    public boolean isSelected(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project == null || ui == null) {
            return false;
        }
        return DeepComparator.getInstance(project, ui).hasHighlightingOrInProgress();
    }

    public void setSelected(AnActionEvent e, boolean selected) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogDataProvider dataProvider = (VcsLogDataProvider)e.getData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        if (project == null || ui == null || dataProvider == null) {
            return;
        }
        DeepComparator dc = DeepComparator.getInstance(project, ui);
        if (selected) {
            VcsLogUtil.triggerUsage((AnActionEvent)e);
            String singleBranchName = VcsLogUtil.getSingleFilteredBranch((VcsLogFilterCollection)ui.getFilterUi().getFilters(), (VcsLogRefs)ui.getDataPack().getRefs());
            if (singleBranchName == null) {
                DeepCompareAction.selectBranchAndPerformAction(ui, e, (Consumer<String>)((Consumer)selectedBranch -> {
                    ui.getFilterUi().setFilter((VcsLogFilter)VcsLogBranchFilterImpl.fromBranch((String)selectedBranch));
                    dc.highlightInBackground((String)selectedBranch, dataProvider);
                }), DeepCompareAction.getGitRoots(project, ui));
                return;
            }
            dc.highlightInBackground(singleBranchName, dataProvider);
        } else {
            dc.stopAndUnhighlight();
        }
    }

    private static void selectBranchAndPerformAction(@NotNull VcsLogUi ui, @NotNull AnActionEvent event, final @NotNull Consumer<String> consumer, @NotNull Collection<VirtualFile> visibleRoots) {
        if (ui == null) {
            DeepCompareAction.$$$reportNull$$$0(0);
        }
        if (event == null) {
            DeepCompareAction.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            DeepCompareAction.$$$reportNull$$$0(2);
        }
        if (visibleRoots == null) {
            DeepCompareAction.$$$reportNull$$$0(3);
        }
        VcsLogDataPack dataPack = ui.getDataPack();
        ActionGroup actionGroup = new BranchPopupBuilder(dataPack, visibleRoots, null){

            @NotNull
            protected AnAction createAction(final @NotNull String name, @NotNull Collection<VcsRef> refs) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (refs == null) {
                    1.$$$reportNull$$$0(1);
                }
                DumbAwareAction dumbAwareAction = new DumbAwareAction(name){

                    public void actionPerformed(AnActionEvent e) {
                        consumer.consume((Object)name);
                    }
                };
                if (dumbAwareAction == null) {
                    1.$$$reportNull$$$0(2);
                }
                return dumbAwareAction;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refs";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "git4idea/branch/DeepCompareAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "git4idea/branch/DeepCompareAction$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createAction";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.build();
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Select Branch to Compare", actionGroup, event.getDataContext(), false, false, false, null, -1, null);
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            popup.show(new RelativePoint((MouseEvent)inputEvent));
        } else if (ui instanceof AbstractVcsLogUi) {
            popup.showInCenterOf((Component)((AbstractVcsLogUi)ui).getTable());
        } else {
            popup.showInBestPositionFor(event.getDataContext());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DeepCompareAction.$$$reportNull$$$0(4);
        }
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project == null || ui == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            Set visibleRoots = VcsLogUtil.getVisibleRoots((VcsLogUi)ui);
            Set allRoots = visibleRoots;
            if (allRoots.isEmpty()) {
                allRoots = ContainerUtil.map2Set((Object[])ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots(), VcsRoot::getPath);
            }
            e.getPresentation().setEnabled(DeepCompareAction.hasGitRoots(project, visibleRoots));
            e.getPresentation().setVisible(DeepCompareAction.hasGitRoots(project, allRoots));
        }
    }

    @NotNull
    private static Collection<VirtualFile> getGitRoots(@NotNull Project project, @NotNull VcsLogUi ui) {
        if (project == null) {
            DeepCompareAction.$$$reportNull$$$0(5);
        }
        if (ui == null) {
            DeepCompareAction.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.filter((Collection)VcsLogUtil.getVisibleRoots((VcsLogUi)ui), root -> {
            if (project == null) {
                DeepCompareAction.$$$reportNull$$$0(13);
            }
            return DeepCompareAction.isGitRoot(project, root);
        });
        if (list == null) {
            DeepCompareAction.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static boolean hasGitRoots(@NotNull Project project, @NotNull Set<VirtualFile> roots) {
        if (project == null) {
            DeepCompareAction.$$$reportNull$$$0(8);
        }
        if (roots == null) {
            DeepCompareAction.$$$reportNull$$$0(9);
        }
        return ContainerUtil.exists(roots, root -> {
            if (project == null) {
                DeepCompareAction.$$$reportNull$$$0(12);
            }
            return DeepCompareAction.isGitRoot(project, root);
        });
    }

    private static boolean isGitRoot(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            DeepCompareAction.$$$reportNull$$$0(10);
        }
        if (root == null) {
            DeepCompareAction.$$$reportNull$$$0(11);
        }
        return GitRepositoryManager.getInstance(project).getRepositoryForRootQuick(root) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRoots";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/DeepCompareAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/DeepCompareAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGitRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectBranchAndPerformAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGitRoots";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasGitRoots";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isGitRoot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasGitRoots$2";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getGitRoots$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

