/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.StandardJavaFileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.Builder;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.groovy.CompilingGroovycRunner;
import org.jetbrains.jps.incremental.groovy.DefaultOutputConsumer;
import org.jetbrains.jps.incremental.groovy.EclipseOutputParser;
import org.jetbrains.jps.incremental.groovy.GreclipseJpsCompilerSettings;
import org.jetbrains.jps.incremental.groovy.GreclipseMain;
import org.jetbrains.jps.incremental.groovy.GreclipseSettings;
import org.jetbrains.jps.incremental.groovy.GroovyBuilder;
import org.jetbrains.jps.incremental.groovy.GroovycOutputParser;
import org.jetbrains.jps.incremental.groovy.JpsGroovycRunner;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.module.JpsModule;

public class GreclipseBuilder
extends ModuleLevelBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.groovy.GreclipseBuilder");
    private static final Key<Boolean> COMPILER_VERSION_INFO = Key.create((String)"_greclipse_compiler_info_");
    public static final String ID = "Groovy-Eclipse";
    private static final Object ourGlobalEnvironmentLock = new String("GreclipseBuilder lock");
    private String myGreclipseJar;
    private ClassLoader myGreclipseLoader;
    private final CompilingGroovycRunner myHelper = new CompilingGroovycRunner(true){

        @Override
        protected boolean acceptsFileType(String path) {
            return super.acceptsFileType(path) || path.endsWith(".java");
        }
    };

    protected GreclipseBuilder() {
        super(BuilderCategory.TRANSLATOR);
    }

    @Nullable
    private ClassLoader createGreclipseLoader(@Nullable String jar) {
        if (StringUtil.isEmpty((String)jar)) {
            return null;
        }
        if (jar.equals(this.myGreclipseJar)) {
            return this.myGreclipseLoader;
        }
        try {
            URL[] urls = new URL[]{new File(jar).toURI().toURL(), new File((String)ObjectUtils.assertNotNull((Object)PathManager.getJarPathForClass(GreclipseMain.class))).toURI().toURL()};
            URLClassLoader loader = new URLClassLoader(urls, StandardJavaFileManager.class.getClassLoader());
            Class.forName("org.eclipse.jdt.internal.compiler.batch.Main", false, loader);
            this.myGreclipseJar = jar;
            this.myGreclipseLoader = loader;
            return loader;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public List<String> getCompilableFileExtensions() {
        return Arrays.asList("groovy", "java");
    }

    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException {
        if (!GreclipseBuilder.useGreclipse(context)) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        try {
            Boolean notified;
            List<File> toCompile = this.myHelper.collectChangedFiles(context, dirtyFilesHolder, false, (Ref<Boolean>)Ref.create((Object)false));
            if (toCompile.isEmpty()) {
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            Map<ModuleBuildTarget, String> outputDirs = GroovyBuilder.getCanonicalModuleOutputs(context, chunk, (Builder)this);
            if (outputDirs == null) {
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            JpsProject project = context.getProjectDescriptor().getProject();
            GreclipseSettings greclipseSettings = GreclipseJpsCompilerSettings.getSettings(project);
            if (greclipseSettings == null) {
                String message = "Compiler settings component not initialized for " + project;
                LOG.error(message);
                context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, message));
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            ClassLoader loader = this.createGreclipseLoader(greclipseSettings.greclipsePath);
            if (loader == null) {
                context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, "Invalid jar path in the compiler settings: '" + greclipseSettings.greclipsePath + "'"));
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            Set modules = chunk.getModules();
            ProcessorConfigProfile profile = null;
            if (modules.size() == 1) {
                JpsJavaCompilerConfiguration compilerConfig = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project);
                assert (compilerConfig != null);
                profile = compilerConfig.getAnnotationProcessingProfile((JpsModule)modules.iterator().next());
            } else {
                String message = JavaBuilder.validateCycle((CompileContext)context, (ModuleChunk)chunk);
                if (message != null) {
                    context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, message));
                    return ModuleLevelBuilder.ExitCode.ABORT;
                }
            }
            String mainOutputDir = outputDirs.get(chunk.representativeTarget());
            List<String> args = GreclipseBuilder.createCommandLine(context, chunk, toCompile, mainOutputDir, profile, greclipseSettings);
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.debug("Compiling with args: " + args);
            }
            if ((notified = (Boolean)COMPILER_VERSION_INFO.get((UserDataHolder)context)) != Boolean.TRUE) {
                context.processMessage((BuildMessage)new CompilerMessage("", BuildMessage.Kind.INFO, "Using Groovy-Eclipse to compile Java & Groovy sources"));
                COMPILER_VERSION_INFO.set((UserDataHolder)context, (Object)Boolean.TRUE);
            }
            context.processMessage((BuildMessage)new ProgressMessage("Compiling java & groovy [" + chunk.getPresentableShortName() + "]"));
            StringWriter out = new StringWriter();
            StringWriter err = new StringWriter();
            HashMap outputMap = ContainerUtil.newHashMap();
            boolean success = this.performCompilation(args, out, err, outputMap, context, chunk);
            ArrayList items = ContainerUtil.newArrayList();
            for (String src : outputMap.keySet()) {
                for (String classFile : (List)outputMap.get(src)) {
                    items.add(new GroovycOutputParser.OutputItem(FileUtil.toSystemIndependentName((String)(mainOutputDir + classFile)), FileUtil.toSystemIndependentName((String)src)));
                }
            }
            MultiMap<ModuleBuildTarget, GroovycOutputParser.OutputItem> successfullyCompiled = this.myHelper.processCompiledFiles(context, chunk, outputDirs, mainOutputDir, items);
            EclipseOutputParser parser = new EclipseOutputParser(this.getPresentableName(), chunk);
            List messages = ContainerUtil.concat(parser.parseMessages(out.toString()), parser.parseMessages(err.toString()));
            boolean hasError = false;
            for (CompilerMessage message : messages) {
                if (message.getKind() == BuildMessage.Kind.ERROR) {
                    hasError = true;
                }
                context.processMessage((BuildMessage)message);
            }
            if (!success && !hasError) {
                context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, "Compilation failed"));
            }
            this.myHelper.updateDependencies(context, toCompile, successfullyCompiled, new DefaultOutputConsumer(outputConsumer), (Builder)this);
            return ModuleLevelBuilder.ExitCode.OK;
        }
        catch (Exception e) {
            throw new ProjectBuildException((Throwable)e);
        }
    }

    static boolean useGreclipse(CompileContext context) {
        JpsProject project = context.getProjectDescriptor().getProject();
        return ID.equals(JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project).getJavaCompilerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performCompilation(List<String> args, StringWriter out, StringWriter err, Map<String, List<String>> outputs, CompileContext context, ModuleChunk chunk) {
        String bytecodeTarget = JpsGroovycRunner.getBytecodeTarget(context, chunk);
        if (bytecodeTarget != null && System.getProperty("groovy.target.bytecode") == null) {
            Object object = ourGlobalEnvironmentLock;
            synchronized (object) {
                boolean bl;
                try {
                    System.setProperty("groovy.target.bytecode", bytecodeTarget);
                    bl = this.performCompilationInner(args, out, err, outputs, context, chunk);
                }
                catch (Throwable throwable) {
                    System.clearProperty("groovy.target.bytecode");
                    throw throwable;
                }
                System.clearProperty("groovy.target.bytecode");
                return bl;
            }
        }
        return this.performCompilationInner(args, out, err, outputs, context, chunk);
    }

    private boolean performCompilationInner(List<String> args, StringWriter out, StringWriter err, Map<String, List<String>> outputs, CompileContext context, ModuleChunk chunk) {
        try {
            Class<?> mainClass = Class.forName(GreclipseMain.class.getName(), true, this.myGreclipseLoader);
            Constructor<?> constructor = mainClass.getConstructor(PrintWriter.class, PrintWriter.class, Map.class, Map.class);
            Method compileMethod = mainClass.getMethod("compile", String[].class);
            HashMap customDefaultOptions = ContainerUtil.newHashMap();
            customDefaultOptions.put("org.eclipse.jdt.core.compiler.groovy.groovyClassLoaderPath", GreclipseBuilder.getClasspathString(chunk));
            customDefaultOptions.put("org.eclipse.jdt.core.compiler.groovy.groovyProjectName", chunk.getPresentableShortName());
            Object main = constructor.newInstance(new PrintWriter(out), new PrintWriter(err), customDefaultOptions, outputs);
            return (Boolean)compileMethod.invoke(main, new Object[]{ArrayUtil.toStringArray(args)});
        }
        catch (Exception e) {
            context.processMessage((BuildMessage)CompilerMessage.createInternalBuilderError((String)this.getPresentableName(), (Throwable)e));
            return false;
        }
    }

    private static List<String> createCommandLine(CompileContext context, ModuleChunk chunk, List<File> srcFiles, String mainOutputDir, @Nullable ProcessorConfigProfile profile, GreclipseSettings settings) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-cp");
        args.add(GreclipseBuilder.getClasspathString(chunk));
        JavaBuilder.addCompilationOptions(args, (CompileContext)context, (ModuleChunk)chunk, (ProcessorConfigProfile)profile);
        args.add("-d");
        args.add(mainOutputDir);
        List params = ParametersListUtil.parse((String)settings.cmdLineParams);
        Iterator iterator = params.iterator();
        while (iterator.hasNext()) {
            String option = (String)iterator.next();
            if ("-target".equals(option)) {
                iterator.next();
                continue;
            }
            if (option.isEmpty() || "-g".equals(option) || "-verbose".equals(option)) continue;
            args.add(option);
        }
        if (settings.debugInfo) {
            args.add("-g");
        }
        for (File file : srcFiles) {
            args.add(file.getPath());
        }
        return args;
    }

    private static String getClasspathString(ModuleChunk chunk) {
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        for (File file : ProjectPaths.getCompilationClasspathFiles((ModuleChunk)chunk, (boolean)chunk.containsTests(), (boolean)false, (boolean)false)) {
            if (!file.exists()) continue;
            cp.add(FileUtil.toCanonicalPath((String)file.getPath()));
        }
        return StringUtil.join(cp, (String)File.pathSeparator);
    }

    @NotNull
    public String getPresentableName() {
        if (ID == null) {
            GreclipseBuilder.$$$reportNull$$$0(0);
        }
        return ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GreclipseBuilder", "getPresentableName"));
    }
}

