/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.IntData;
import org.jetbrains.jetCheck.NodeId;
import org.jetbrains.jetCheck.RemoveListRange;
import org.jetbrains.jetCheck.ShrinkStep;
import org.jetbrains.jetCheck.StructureElement;

class StructureNode
extends StructureElement {
    final List<StructureElement> children;
    boolean shrinkProhibited;

    StructureNode(NodeId id) {
        this(id, new ArrayList<StructureElement>());
    }

    StructureNode(NodeId id, List<StructureElement> children) {
        super(id);
        this.children = children;
    }

    Iterator<StructureElement> childrenIterator() {
        return this.children.iterator();
    }

    void addChild(StructureElement child) {
        this.children.add(child);
    }

    StructureNode subStructure(@NotNull Generator<?> generator) {
        if (generator == null) {
            StructureNode.$$$reportNull$$$0(0);
        }
        StructureNode e = new StructureNode(this.id.childId(generator));
        this.addChild(e);
        return e;
    }

    void removeLastChild(StructureNode node) {
        if (this.children.isEmpty() || this.children.get(this.children.size() - 1) != node) {
            throw new IllegalStateException("Last sub-structure changed");
        }
        this.children.remove(this.children.size() - 1);
    }

    @Override
    @Nullable
    ShrinkStep shrink() {
        if (this.shrinkProhibited) {
            return null;
        }
        return this.isList() ? new RemoveListRange(this) : this.shrinkChild(this.children.size() - 1);
    }

    @Nullable
    ShrinkStep shrinkChild(int index) {
        int minIndex;
        int n = minIndex = this.isList() ? 1 : 0;
        while (index >= minIndex) {
            ShrinkStep childShrink = this.children.get(index).shrink();
            if (childShrink != null) {
                return this.wrapChildShrink(index, childShrink);
            }
            --index;
        }
        return this.shrinkRecursion();
    }

    @Nullable
    private ShrinkStep wrapChildShrink(final int index, final @Nullable ShrinkStep step) {
        if (step == null) {
            return this.shrinkChild(index - 1);
        }
        final NodeId oldChild = this.children.get((int)index).id;
        return new ShrinkStep(){

            @Override
            List<?> getEqualityObjects() {
                return Collections.singletonList(step);
            }

            @Override
            @Nullable
            StructureNode apply(StructureNode root) {
                return step.apply(root);
            }

            @Override
            ShrinkStep onSuccess(StructureNode smallerRoot) {
                StructureNode inheritor = (StructureNode)Objects.requireNonNull(smallerRoot.findChildById(StructureNode.this.id));
                assert (inheritor.children.size() == StructureNode.this.children.size());
                if (inheritor.children.get((int)index).id != oldChild) {
                    return inheritor.shrink();
                }
                return inheritor.wrapChildShrink(index, step.onSuccess(smallerRoot));
            }

            @Override
            ShrinkStep onFailure() {
                return StructureNode.this.wrapChildShrink(index, step.onFailure());
            }

            public String toString() {
                return "-" + step.toString();
            }
        };
    }

    private boolean isList() {
        if (this.children.size() > 1 && this.children.get(0) instanceof IntData && ((IntData)this.children.get((int)0)).value >= this.children.size() - 1) {
            for (int i = 1; i < this.children.size(); ++i) {
                if (this.children.get(i) instanceof StructureNode) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void findChildrenWithGenerator(int generatorHash, List<StructureNode> result) {
        for (StructureElement child : this.children) {
            if (!(child instanceof StructureNode)) continue;
            Integer childGen = child.id.generatorHash;
            if (childGen != null && generatorHash == childGen) {
                result.add((StructureNode)child);
                continue;
            }
            ((StructureNode)child).findChildrenWithGenerator(generatorHash, result);
        }
    }

    @Nullable
    private ShrinkStep shrinkRecursion() {
        if (this.id.generatorHash != null) {
            ArrayList<StructureNode> sameGeneratorChildren = new ArrayList<StructureNode>();
            this.findChildrenWithGenerator(this.id.generatorHash, sameGeneratorChildren);
            return this.tryReplacing(sameGeneratorChildren, 0);
        }
        return null;
    }

    @Nullable
    private ShrinkStep tryReplacing(List<StructureNode> candidates, int index) {
        if (index < candidates.size()) {
            StructureNode replacement = candidates.get(index);
            return ShrinkStep.create(this.id, replacement, __ -> replacement.shrink(), () -> this.tryReplacing(candidates, index + 1));
        }
        return null;
    }

    @Override
    @NotNull
    StructureNode replace(NodeId id, StructureElement replacement) {
        StructureElement newChild;
        if (id == this.id) {
            StructureNode structureNode = (StructureNode)replacement;
            if (structureNode == null) {
                StructureNode.$$$reportNull$$$0(1);
            }
            return structureNode;
        }
        if (this.children.isEmpty()) {
            StructureNode structureNode = this;
            if (structureNode == null) {
                StructureNode.$$$reportNull$$$0(2);
            }
            return structureNode;
        }
        int index = this.indexOfChildContaining(id);
        StructureElement oldChild = this.children.get(index);
        if (oldChild == (newChild = oldChild.replace(id, replacement))) {
            StructureNode structureNode = this;
            if (structureNode == null) {
                StructureNode.$$$reportNull$$$0(3);
            }
            return structureNode;
        }
        ArrayList<StructureElement> newChildren = new ArrayList<StructureElement>(this.children);
        newChildren.set(index, newChild);
        StructureNode copy = new StructureNode(this.id, newChildren);
        copy.shrinkProhibited = this.shrinkProhibited;
        StructureNode structureNode = copy;
        if (structureNode == null) {
            StructureNode.$$$reportNull$$$0(4);
        }
        return structureNode;
    }

    @Override
    @Nullable
    StructureElement findChildById(NodeId id) {
        if (id == this.id) {
            return this;
        }
        int index = this.indexOfChildContaining(id);
        return index < 0 ? null : this.children.get(index).findChildById(id);
    }

    @Override
    void serialize(DataOutputStream out) throws IOException {
        for (StructureElement child : this.children) {
            child.serialize(out);
        }
    }

    private int indexOfChildContaining(NodeId id) {
        int i;
        for (i = 0; i < this.children.size() && this.children.get((int)i).id.number <= id.number; ++i) {
        }
        return i - 1;
    }

    public boolean equals(Object obj) {
        return obj instanceof StructureNode && this.children.equals(((StructureNode)obj).children);
    }

    public int hashCode() {
        return this.children.hashCode();
    }

    public String toString() {
        String inner = this.children.stream().map(Object::toString).collect(Collectors.joining(", "));
        return this.isList() ? "[" + inner + "]" : "(" + inner + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jetCheck/StructureNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jetCheck/StructureNode";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "subStructure";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

