/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.Iteration;
import org.jetbrains.jetCheck.PropertyFailure;

class StatusNotifier {
    static final StatusNotifier SILENT = new StatusNotifier(0){

        @Override
        boolean shouldPrint() {
            return false;
        }

        @Override
        void counterExampleFound(Iteration<?> iteration) {
        }

        @Override
        void eofException() {
        }
    };
    private final int iterationCount;
    private int currentIteration;
    private long lastPrinted = System.currentTimeMillis();
    private int lastReportedStage = -1;
    private String lastReportedTrace = null;

    StatusNotifier(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    void iterationStarted(int iteration) {
        this.currentIteration = iteration;
        if (this.shouldPrint()) {
            System.out.println(StatusNotifier.formatCurrentTime() + ": iteration " + this.currentIteration + " of " + this.iterationCount + "...");
        }
    }

    void counterExampleFound(Iteration<?> iteration) {
        this.lastPrinted = System.currentTimeMillis();
        System.err.println(StatusNotifier.formatCurrentTime() + ": failed on iteration " + this.currentIteration + " (" + iteration.printSeeds() + "), shrinking...");
    }

    boolean shouldPrint() {
        if (System.currentTimeMillis() - this.lastPrinted > 5000L) {
            this.lastPrinted = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    <T> void shrinkAttempt(PropertyFailure<T> failure, Iteration<T> iteration) {
        if (this.shouldPrint()) {
            int stage = failure.getMinimizationStageCount();
            System.out.println(StatusNotifier.formatCurrentTime() + ": still shrinking (" + iteration.printSeeds() + "). Examples tried: " + failure.getTotalMinimizationExampleCount() + ", successful minimizations: " + stage);
            if (this.lastReportedStage != stage) {
                String trace;
                this.lastReportedStage = stage;
                System.err.println(" Current minimal example: " + failure.getMinimalCounterexample().getExampleValue());
                Throwable exceptionCause = failure.getMinimalCounterexample().getExceptionCause();
                if (exceptionCause != null && !(trace = StatusNotifier.shortenStackTrace(exceptionCause)).equals(this.lastReportedTrace)) {
                    this.lastReportedTrace = trace;
                    System.err.println(" Reason: " + trace);
                }
                System.err.println();
            }
        }
    }

    void eofException() {
        System.out.println("Generator tried to read past the end of serialized data, so it seems the failure isn't reproducible anymore");
    }

    private static String shortenStackTrace(Throwable e) {
        String trace = StatusNotifier.printStackTrace(e);
        return trace.length() > 1000 ? trace.substring(0, 1000) + "..." : trace;
    }

    @NotNull
    private static String formatCurrentTime() {
        String string = LocalTime.now().format(DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withLocale(Locale.getDefault()));
        if (string == null) {
            StatusNotifier.$$$reportNull$$$0(0);
        }
        return string;
    }

    static String printStackTrace(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        e.printStackTrace(writer);
        return stringWriter.getBuffer().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jetCheck/StatusNotifier", "formatCurrentTime"));
    }
}

