/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.CannotRestoreValue;
import org.jetbrains.jetCheck.DataSerializer;
import org.jetbrains.jetCheck.DataStructure;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;
import org.jetbrains.jetCheck.IntDistribution;

class Scenario {
    private final List<Object> log;
    private Throwable failure;

    Scenario(@NotNull ImperativeCommand cmd, @NotNull DataStructure data) {
        if (cmd == null) {
            Scenario.$$$reportNull$$$0(0);
        }
        if (data == null) {
            Scenario.$$$reportNull$$$0(1);
        }
        this.log = new ArrayList<Object>();
        try {
            this.performCommand(cmd, data, this.log);
        }
        catch (DataSerializer.EOFException e) {
            throw e;
        }
        catch (Throwable e) {
            this.addFailure(e);
        }
        if (this.failure instanceof CannotRestoreValue) {
            throw (CannotRestoreValue)this.failure;
        }
    }

    private void addFailure(Throwable e) {
        if (this.failure == null) {
            this.failure = e;
        }
    }

    private void performCommand(ImperativeCommand command, final DataStructure data, final List<Object> log) {
        command.performCommand(new ImperativeCommand.Environment(){

            @Override
            public void logMessage(@NotNull String message) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                log.add(message);
            }

            @Override
            public <T> T generateValue(@NotNull Generator<T> generator, @Nullable String logMessage) {
                if (generator == null) {
                    1.$$$reportNull$$$0(1);
                }
                Object value = Scenario.this.safeGenerate(data, generator);
                if (logMessage != null) {
                    this.logMessage(String.format(logMessage, value));
                }
                return (T)value;
            }

            @Override
            public void executeCommands(IntDistribution count, Generator<? extends ImperativeCommand> cmdGen) {
                this.innerCommandLists(Generator.listsOf(count, this.innerCommands(cmdGen)));
            }

            @Override
            public void executeCommands(Generator<? extends ImperativeCommand> cmdGen) {
                this.innerCommandLists(Generator.nonEmptyLists(this.innerCommands(cmdGen)));
            }

            private void innerCommandLists(final Generator<List<Object>> listGen) {
                data.generate(Generator.from(new EquivalentGenerator<List<Object>>(){

                    @Override
                    public List<Object> apply(DataStructure data) {
                        return (List)listGen.getGeneratorFunction().apply(data);
                    }
                }));
            }

            @NotNull
            private Generator<Object> innerCommands(final Generator<? extends ImperativeCommand> cmdGen) {
                Generator<Object> generator = Generator.from(new EquivalentGenerator<Object>(){

                    @Override
                    public Object apply(DataStructure cmdData) {
                        ArrayList localLog = new ArrayList();
                        log.add(localLog);
                        Scenario.this.performCommand((ImperativeCommand)Scenario.this.safeGenerate(cmdData, cmdGen), cmdData, localLog);
                        return null;
                    }
                });
                if (generator == null) {
                    1.$$$reportNull$$$0(2);
                }
                return generator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "generator";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/jetCheck/Scenario$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/jetCheck/Scenario$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "innerCommands";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "logMessage";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "generateValue";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private <T> T safeGenerate(DataStructure data, Generator<T> generator) {
        try {
            return data.generate(generator);
        }
        catch (CannotRestoreValue e) {
            this.addFailure(e);
            throw e;
        }
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Scenario && this.log.equals(((Scenario)o).log);
    }

    public int hashCode() {
        return this.log.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Scenario.printLog(sb, "", this.log);
        return "commands:" + (sb.length() == 0 ? "<none>" : sb.toString());
    }

    private static void printLog(StringBuilder sb, String indent, List<Object> log) {
        for (Object o : log) {
            if (o instanceof String) {
                sb.append("\n").append(indent).append(o);
                continue;
            }
            Scenario.printLog(sb, indent + "  ", (List)o);
        }
    }

    boolean ensureSuccessful() {
        if (this.failure instanceof Error) {
            throw (Error)this.failure;
        }
        if (this.failure instanceof RuntimeException) {
            throw (RuntimeException)this.failure;
        }
        if (this.failure != null) {
            throw new RuntimeException(this.failure);
        }
        return true;
    }

    static Generator<Scenario> scenarios(@NotNull Supplier<? extends ImperativeCommand> command) {
        if (command == null) {
            Scenario.$$$reportNull$$$0(2);
        }
        return Generator.from(data -> {
            if (command == null) {
                Scenario.$$$reportNull$$$0(3);
            }
            return new Scenario((ImperativeCommand)command.get(), (DataStructure)data);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jetCheck/Scenario";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "scenarios";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$scenarios$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class EquivalentGenerator<T>
    implements Function<DataStructure, T> {
        private EquivalentGenerator() {
        }

        public boolean equals(Object obj) {
            return this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

