/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.jetCheck.CounterExampleImpl;
import org.jetbrains.jetCheck.PropertyFailure;
import org.jetbrains.jetCheck.PropertyFailureImpl;
import org.jetbrains.jetCheck.StatusNotifier;

public class PropertyFalsified
extends RuntimeException {
    static final String FAILURE_REASON_HAS_CHANGED_DURING_MINIMIZATION = "Failure reason has changed during minimization, see initial failing example below";
    private static final String SEPARATOR = "\n==========================\n";
    private final PropertyFailureImpl<?> failure;
    private final String message;

    PropertyFalsified(PropertyFailureImpl<?> failure) {
        super(((CounterExampleImpl)failure.getMinimalCounterexample()).getExceptionCause());
        this.failure = failure;
        this.message = this.calcMessage();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    private String calcMessage() {
        Throwable first;
        StringBuilder traceBuilder = new StringBuilder();
        String exampleString = PropertyFalsified.valueToString(this.failure.getMinimalCounterexample(), traceBuilder);
        Throwable failureReason = ((CounterExampleImpl)this.failure.getMinimalCounterexample()).getExceptionCause();
        Throwable rootCause = failureReason == null ? null : PropertyFalsified.getRootCause(failureReason);
        String msg = rootCause != null && !rootCause.toString().contains("ComparisonFailure") ? "Failed with " + rootCause + "\nOn " + exampleString : "Falsified on " + exampleString;
        msg = msg + "\n" + this.getMinimizationStats() + "\n" + this.failure.iteration.printToReproduce(failureReason, (CounterExampleImpl<?>)this.failure.getMinimalCounterexample()) + "\n";
        if (failureReason != null) {
            PropertyFalsified.appendTrace(traceBuilder, rootCause == failureReason ? "Property failure reason: " : "Property failure reason, innermost exception (see full trace below): ", rootCause);
        }
        if (this.failure.getStoppingReason() != null) {
            msg = msg + "\n Minimization stopped prematurely, see the reason below.";
            PropertyFalsified.appendTrace(traceBuilder, "An unexpected exception happened during minimization: ", this.failure.getStoppingReason());
        }
        if (PropertyFalsified.exceptionsDiffer(first = ((CounterExampleImpl)this.failure.getFirstCounterExample()).getExceptionCause(), ((CounterExampleImpl)this.failure.getMinimalCounterexample()).getExceptionCause())) {
            msg = msg + "\n Failure reason has changed during minimization, see initial failing example below";
            StringBuilder secondaryTrace = new StringBuilder();
            traceBuilder.append("\n Initial value: ").append(PropertyFalsified.valueToString(this.failure.getFirstCounterExample(), secondaryTrace));
            if (first == null) {
                traceBuilder.append("\n Initially property was falsified without exceptions");
                traceBuilder.append((CharSequence)secondaryTrace);
            } else {
                traceBuilder.append((CharSequence)secondaryTrace);
                PropertyFalsified.appendTrace(traceBuilder, "Initially failed because of ", first);
            }
        }
        return msg + traceBuilder;
    }

    private static Throwable getRootCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    private static void appendTrace(StringBuilder traceBuilder, String prefix, Throwable e) {
        traceBuilder.append("\n ").append(prefix).append(StatusNotifier.printStackTrace(e)).append(SEPARATOR);
    }

    private static String valueToString(CounterExampleImpl<?> example, StringBuilder traceBuilder) {
        try {
            return String.valueOf(example.getExampleValue());
        }
        catch (Throwable e) {
            PropertyFalsified.appendTrace(traceBuilder, "Exception during toString evaluation: ", e);
            return "<can't evaluate toString(), see exception below>";
        }
    }

    private String getMinimizationStats() {
        int exampleCount = this.failure.getTotalMinimizationExampleCount();
        if (exampleCount == 0) {
            return "";
        }
        String examples = exampleCount == 1 ? "example" : "examples";
        int stageCount = this.failure.getMinimizationStageCount();
        if (stageCount == 0) {
            return "Couldn't minimize, tried " + exampleCount + " " + examples + "\n";
        }
        String stages = stageCount == 1 ? "stage" : "stages";
        return "Minimized in " + stageCount + " " + stages + ", by trying " + exampleCount + " " + examples + "\n";
    }

    private static boolean exceptionsDiffer(Throwable e1, Throwable e2) {
        if (e1 == null && e2 == null) {
            return false;
        }
        if (e1 == null != (e2 == null)) {
            return true;
        }
        if (!e1.getClass().equals(e2.getClass())) {
            return true;
        }
        if (e1 instanceof StackOverflowError) {
            return false;
        }
        return !PropertyFalsified.getUserTrace(e1).equals(PropertyFalsified.getUserTrace(e2));
    }

    private static List<String> getUserTrace(Throwable e) {
        StackTraceElement element;
        String s;
        ArrayList<String> result = new ArrayList<String>();
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        for (int i = 0; i < n && (!(s = (element = stackTraceElementArray[i]).toString()).startsWith("org.jetbrains.jetCheck.") || s.contains("Test.")); ++i) {
            result.add(s);
        }
        return result;
    }

    public PropertyFailure<?> getFailure() {
        return this.failure;
    }

    public Object getBreakingValue() {
        return ((CounterExampleImpl)this.failure.getMinimalCounterexample()).getExampleValue();
    }
}

