/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.CannotRestoreValue;
import org.jetbrains.jetCheck.CombinatorialIntCustomizer;
import org.jetbrains.jetCheck.CounterExampleImpl;
import org.jetbrains.jetCheck.Iteration;
import org.jetbrains.jetCheck.PropertyFailure;
import org.jetbrains.jetCheck.ReplayDataStructure;
import org.jetbrains.jetCheck.ShrinkStep;
import org.jetbrains.jetCheck.StructureNode;

class PropertyFailureImpl<T>
implements PropertyFailure<T> {
    private final CounterExampleImpl<T> initial;
    private CounterExampleImpl<T> minimized;
    private int totalSteps;
    private int successfulSteps;
    final Iteration<T> iteration;
    private Throwable stoppingReason;

    PropertyFailureImpl(@NotNull CounterExampleImpl<T> initial, Iteration<T> iteration) {
        if (initial == null) {
            PropertyFailureImpl.$$$reportNull$$$0(0);
        }
        this.initial = initial;
        this.minimized = initial;
        this.iteration = iteration;
        try {
            this.shrink();
        }
        catch (Throwable e) {
            this.stoppingReason = e;
        }
    }

    @Override
    @NotNull
    public CounterExampleImpl<T> getFirstCounterExample() {
        CounterExampleImpl<T> counterExampleImpl = this.initial;
        if (counterExampleImpl == null) {
            PropertyFailureImpl.$$$reportNull$$$0(1);
        }
        return counterExampleImpl;
    }

    @Override
    @NotNull
    public CounterExampleImpl<T> getMinimalCounterexample() {
        CounterExampleImpl<T> counterExampleImpl = this.minimized;
        if (counterExampleImpl == null) {
            PropertyFailureImpl.$$$reportNull$$$0(2);
        }
        return counterExampleImpl;
    }

    @Override
    @Nullable
    public Throwable getStoppingReason() {
        return this.stoppingReason;
    }

    @Override
    public int getTotalMinimizationExampleCount() {
        return this.totalSteps;
    }

    @Override
    public int getMinimizationStageCount() {
        return this.successfulSteps;
    }

    @Override
    public int getIterationNumber() {
        return this.iteration.iterationNumber;
    }

    @Override
    public long getIterationSeed() {
        return this.iteration.iterationSeed;
    }

    @Override
    public long getGlobalSeed() {
        return this.iteration.session.parameters.globalSeed;
    }

    @Override
    public int getSizeHint() {
        return this.iteration.sizeHint;
    }

    private void shrink() {
        ShrinkStep lastSuccessfulShrink = null;
        while ((lastSuccessfulShrink = this.shrinkIteration(lastSuccessfulShrink)) != null) {
        }
    }

    private ShrinkStep shrinkIteration(ShrinkStep limit) {
        ShrinkStep lastSuccessfulShrink = null;
        ShrinkStep step = this.minimized.data.shrink();
        while (step != null) {
            if ((step = this.findSuccessfulShrink(step, limit)) == null) continue;
            lastSuccessfulShrink = step;
            step = step.onSuccess(this.minimized.data);
        }
        return lastSuccessfulShrink;
    }

    @Nullable
    private ShrinkStep findSuccessfulShrink(ShrinkStep step, @Nullable ShrinkStep limit) {
        ArrayList<CustomizedNode> combinatorial = new ArrayList<CustomizedNode>();
        while (step != null && !step.equals(limit)) {
            StructureNode node = step.apply(this.minimized.data);
            if (node != null && this.iteration.session.addGeneratedNode(node)) {
                CombinatorialIntCustomizer customizer = new CombinatorialIntCustomizer();
                if (this.tryStep(node, customizer)) {
                    return step;
                }
                CombinatorialIntCustomizer next = customizer.nextAttempt();
                if (next != null) {
                    combinatorial.add(new CustomizedNode(next, step));
                }
            }
            step = step.onFailure();
        }
        return this.processDelayedCombinations(combinatorial);
    }

    @Nullable
    private ShrinkStep processDelayedCombinations(List<CustomizedNode> delayed) {
        Collections.sort(delayed);
        for (CustomizedNode customizedNode : delayed) {
            for (CombinatorialIntCustomizer customizer = customizedNode.customizer; customizer != null; customizer = customizer.nextAttempt()) {
                if (!this.tryStep(customizedNode.step.apply(this.minimized.data), customizer)) continue;
                return customizedNode.step;
            }
        }
        return null;
    }

    private boolean tryStep(StructureNode node, CombinatorialIntCustomizer customizer) {
        try {
            this.iteration.session.notifier.shrinkAttempt(this, this.iteration);
            ++this.totalSteps;
            T value = this.iteration.generateValue(new ReplayDataStructure(node, this.iteration.sizeHint, customizer));
            CounterExampleImpl<T> example = CounterExampleImpl.checkProperty(this.iteration, value, customizer.writeChanges(node));
            if (example != null) {
                this.minimized = example;
                ++this.successfulSteps;
                return true;
            }
        }
        catch (CannotRestoreValue cannotRestoreValue) {
            // empty catch block
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jetCheck/PropertyFailureImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jetCheck/PropertyFailureImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstCounterExample";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimalCounterexample";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CustomizedNode
    implements Comparable<CustomizedNode> {
        final CombinatorialIntCustomizer customizer;
        final ShrinkStep step;

        CustomizedNode(CombinatorialIntCustomizer customizer, ShrinkStep step) {
            this.customizer = customizer;
            this.step = step;
        }

        @Override
        public int compareTo(@NotNull CustomizedNode o) {
            if (o == null) {
                CustomizedNode.$$$reportNull$$$0(0);
            }
            return Integer.compare(this.customizer.countVariants(), o.customizer.countVariants());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/jetCheck/PropertyFailureImpl$CustomizedNode", "compareTo"));
        }
    }
}

