/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.Random;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.CheckSession;
import org.jetbrains.jetCheck.DataSerializer;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;
import org.jetbrains.jetCheck.IntSource;
import org.jetbrains.jetCheck.Iteration;
import org.jetbrains.jetCheck.Scenario;

public class PropertyChecker {
    static final int DEFAULT_MAX_SIZE_HINT = 100;

    public static <T> void forAll(Generator<T> generator, @NotNull Predicate<T> property) {
        if (property == null) {
            PropertyChecker.$$$reportNull$$$0(0);
        }
        PropertyChecker.customized().forAll(generator, property);
    }

    public static void checkScenarios(@NotNull Supplier<? extends ImperativeCommand> command) {
        if (command == null) {
            PropertyChecker.$$$reportNull$$$0(1);
        }
        PropertyChecker.customized().checkScenarios(command);
    }

    public static Parameters customized() {
        return new Parameters();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jetCheck/PropertyChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forAll";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkScenarios";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Parameters {
        long globalSeed = new Random().nextLong();
        @Nullable
        IntSource serializedData;
        IntUnaryOperator sizeHintFun = iteration -> (iteration - 1) % 100 + 1;
        int iterationCount = 100;
        boolean silent;

        private Parameters() {
        }

        public Parameters withSeed(long seed) {
            if (this.serializedData != null) {
                System.err.println("withSeed ignored, because 'rechecking' is used");
                return this;
            }
            this.globalSeed = seed;
            return this;
        }

        public Parameters withIterationCount(int iterationCount) {
            if (this.serializedData != null) {
                System.err.println("withIterationCount ignored, because 'rechecking' is used");
                return this;
            }
            this.iterationCount = iterationCount;
            return this;
        }

        public Parameters withSizeHint(@NotNull IntUnaryOperator sizeHintFun) {
            if (sizeHintFun == null) {
                Parameters.$$$reportNull$$$0(0);
            }
            if (this.serializedData != null) {
                System.err.println("withSizeHint ignored, because 'rechecking' is used");
                return this;
            }
            this.sizeHintFun = sizeHintFun;
            return this;
        }

        public Parameters silent() {
            this.silent = true;
            return this;
        }

        public Parameters recheckingIteration(long seed, int sizeHint) {
            return this.withSeed(seed).withSizeHint(whatever -> sizeHint).withIterationCount(1);
        }

        public Parameters rechecking(@NotNull String serializedData) {
            if (serializedData == null) {
                Parameters.$$$reportNull$$$0(1);
            }
            this.iterationCount = 1;
            DataSerializer.deserializeInto(serializedData, this);
            return this;
        }

        public <T> void forAll(Generator<T> generator, Predicate<T> property) {
            for (Iteration<T> iteration = new CheckSession<T>(this.serializedData == null ? generator : generator.noShrink(), property, this).firstIteration(); iteration != null; iteration = iteration.performIteration()) {
            }
        }

        public void checkScenarios(@NotNull Supplier<? extends ImperativeCommand> command) {
            if (command == null) {
                Parameters.$$$reportNull$$$0(2);
            }
            this.forAll(Scenario.scenarios(command), Scenario::ensureSuccessful);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sizeHintFun";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serializedData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jetCheck/PropertyChecker$Parameters";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withSizeHint";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rechecking";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkScenarios";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

