/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.Random;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.CannotRestoreValue;
import org.jetbrains.jetCheck.CannotSatisfyCondition;
import org.jetbrains.jetCheck.CheckSession;
import org.jetbrains.jetCheck.CounterExampleImpl;
import org.jetbrains.jetCheck.DataSerializer;
import org.jetbrains.jetCheck.GenerativeDataStructure;
import org.jetbrains.jetCheck.GeneratorException;
import org.jetbrains.jetCheck.IntSource;
import org.jetbrains.jetCheck.NodeId;
import org.jetbrains.jetCheck.PropertyFailureImpl;
import org.jetbrains.jetCheck.PropertyFalsified;
import org.jetbrains.jetCheck.ReplayDataStructure;
import org.jetbrains.jetCheck.StatusNotifier;
import org.jetbrains.jetCheck.StructureNode;
import org.jetbrains.jetCheck.WrongDataStructure;

class Iteration<T> {
    private static final Predicate<Object> DATA_IS_DIFFERENT = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return false;
        }

        public String toString() {
            return ": cannot generate enough sufficiently different values";
        }
    };
    final CheckSession<T> session;
    long iterationSeed;
    final int sizeHint;
    final int iterationNumber;
    private Random random;

    Iteration(CheckSession<T> session, long iterationSeed, int iterationNumber) {
        this.session = session;
        this.sizeHint = session.parameters.sizeHintFun.applyAsInt(iterationNumber);
        this.iterationNumber = iterationNumber;
        if (this.sizeHint < 0) {
            throw new IllegalArgumentException("Size hint should be non-negative, found " + this.sizeHint);
        }
        this.initSeed(iterationSeed);
    }

    private void initSeed(long seed) {
        this.iterationSeed = seed;
        this.random = new Random(seed);
    }

    @Nullable
    private CounterExampleImpl<T> findCounterExample() {
        for (int i = 0; i < 100; ++i) {
            Object value;
            if (i > 0) {
                this.initSeed(this.random.nextLong());
            }
            StructureNode node = new StructureNode(new NodeId(this.session.generator));
            try {
                IntSource source = this.session.parameters.serializedData != null ? this.session.parameters.serializedData : d -> d.generateInt(this.random);
                value = this.session.generator.getGeneratorFunction().apply(new GenerativeDataStructure(source, node, this.sizeHint));
            }
            catch (CannotSatisfyCondition e) {
                continue;
            }
            catch (DataSerializer.EOFException e) {
                this.session.notifier.eofException();
                return null;
            }
            catch (WrongDataStructure e) {
                throw e;
            }
            catch (Throwable e) {
                if (e instanceof CannotRestoreValue && this.session.parameters.serializedData != null) {
                    throw e;
                }
                throw new GeneratorException(this, e);
            }
            if (!this.session.addGeneratedNode(node)) continue;
            return CounterExampleImpl.checkProperty(this, value, node);
        }
        throw new GeneratorException(this, (Throwable)new CannotSatisfyCondition(DATA_IS_DIFFERENT));
    }

    String printToReproduce(@Nullable Throwable failureReason, CounterExampleImpl<?> minimalCounterExample) {
        String data = minimalCounterExample.getSerializedData();
        boolean scenarios = failureReason != null && StatusNotifier.printStackTrace(failureReason).contains("PropertyChecker$Parameters.checkScenarios");
        String rechecking = "PropertyChecker.customized().rechecking(\"" + data + "\")\n    ." + (scenarios ? "checkScenarios" : "forAll") + "(...)\n";
        return "To reproduce the minimal failing case, run\n  " + rechecking + "To re-run the test with all intermediate minimization steps, use `recheckingIteration(" + this.iterationSeed + "L, " + this.sizeHint + ")` instead for last iteration, or `withSeed(" + this.session.parameters.globalSeed + "L)` for all iterations";
    }

    String printSeeds() {
        return "iteration seed=" + this.iterationSeed + "L, size hint=" + this.sizeHint + ", global seed=" + this.session.parameters.globalSeed + "L";
    }

    @Nullable
    Iteration<T> performIteration() {
        this.session.notifier.iterationStarted(this.iterationNumber);
        CounterExampleImpl<T> example = this.findCounterExample();
        if (example != null) {
            this.session.notifier.counterExampleFound(this);
            throw new PropertyFalsified(new PropertyFailureImpl<T>(example, this));
        }
        if (this.iterationNumber >= this.session.parameters.iterationCount) {
            return null;
        }
        return new Iteration<T>(this.session, this.random.nextLong(), this.iterationNumber + 1);
    }

    T generateValue(ReplayDataStructure data) {
        return this.session.generator.getGeneratorFunction().apply(data);
    }
}

