/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.List;
import java.util.Random;
import org.jetbrains.jetCheck.BoundedIntDistribution;

public interface IntDistribution {
    public int generateInt(Random var1);

    public boolean isValidValue(int var1);

    public static IntDistribution uniform(int min, int max) {
        return new BoundedIntDistribution(min, max, r -> {
            if (min == max) {
                return min;
            }
            int i = r.nextInt();
            return i >= min && i <= max ? i : Math.abs(i) % (max - min + 1) + min;
        });
    }

    public static IntDistribution geometric(int mean) {
        final double p = 1.0 / (double)(mean + 1);
        return new IntDistribution(){

            @Override
            public int generateInt(Random random) {
                double u = random.nextDouble();
                return (int)(Math.log(u) / Math.log(1.0 - p));
            }

            @Override
            public boolean isValidValue(int i) {
                return i >= 0;
            }
        };
    }

    public static IntDistribution frequencyDistribution(List<Integer> weights) {
        if (weights.isEmpty()) {
            throw new IllegalArgumentException("No alternatives to choose from");
        }
        int sum = weights.stream().reduce(0, (a, b) -> a + b);
        return new BoundedIntDistribution(0, weights.size() - 1, r -> {
            int value = r.nextInt(sum);
            for (int i = 0; i < weights.size(); ++i) {
                if ((value -= ((Integer)weights.get(i)).intValue()) >= 0) continue;
                return i;
            }
            throw new IllegalArgumentException();
        });
    }
}

