/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.BoundedIntDistribution;
import org.jetbrains.jetCheck.DataSerializer;
import org.jetbrains.jetCheck.IntDistribution;
import org.jetbrains.jetCheck.NodeId;
import org.jetbrains.jetCheck.ShrinkStep;
import org.jetbrains.jetCheck.StructureElement;

class IntData
extends StructureElement {
    final int value;
    final IntDistribution distribution;

    IntData(NodeId id, int value, IntDistribution distribution) {
        super(id);
        this.value = value;
        this.distribution = distribution;
    }

    @Override
    @Nullable
    ShrinkStep shrink() {
        if (this.value == 0) {
            return null;
        }
        int minValue = 0;
        if (this.distribution instanceof BoundedIntDistribution) {
            minValue = Math.max(minValue, ((BoundedIntDistribution)this.distribution).getMin());
        }
        return this.tryInt(minValue, () -> null, this::tryNegation);
    }

    private ShrinkStep tryNegation() {
        if (this.value < 0) {
            return this.tryInt(-this.value, () -> this.divisionLoop(-this.value), () -> this.divisionLoop(this.value));
        }
        return this.divisionLoop(this.value);
    }

    private ShrinkStep divisionLoop(int value) {
        if (value == 0) {
            return null;
        }
        int divided = value / 2;
        return this.tryInt(divided, () -> this.divisionLoop(divided), null);
    }

    private ShrinkStep tryInt(int value, @NotNull Supplier<ShrinkStep> success, @Nullable Supplier<ShrinkStep> fail) {
        if (success == null) {
            IntData.$$$reportNull$$$0(0);
        }
        return this.distribution.isValidValue(value) ? ShrinkStep.create(this.id, new IntData(this.id, value, this.distribution), __ -> {
            if (success == null) {
                IntData.$$$reportNull$$$0(2);
            }
            return (ShrinkStep)success.get();
        }, fail) : null;
    }

    @Override
    @NotNull
    IntData replace(NodeId id, StructureElement replacement) {
        IntData intData = this.id == id ? (IntData)replacement : this;
        if (intData == null) {
            IntData.$$$reportNull$$$0(1);
        }
        return intData;
    }

    @Override
    @Nullable
    StructureElement findChildById(NodeId id) {
        return id == this.id ? this : null;
    }

    @Override
    void serialize(DataOutputStream out) throws IOException {
        DataSerializer.writeINT(out, this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object obj) {
        return obj instanceof IntData && this.value == ((IntData)obj).value;
    }

    public int hashCode() {
        return this.value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "success";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jetCheck/IntData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jetCheck/IntData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryInt";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lambda$tryInt$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

