/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.AbstractDataStructure;
import org.jetbrains.jetCheck.BoundedIntDistribution;
import org.jetbrains.jetCheck.DataStructure;
import org.jetbrains.jetCheck.FrequencyGenerator;
import org.jetbrains.jetCheck.IntDistribution;

public class Generator<T> {
    private final Function<DataStructure, T> myFunction;

    Generator(Function<DataStructure, T> function) {
        this.myFunction = function;
    }

    @NotNull
    public static <T> Generator<T> from(@NotNull Function<DataStructure, T> function) {
        if (function == null) {
            Generator.$$$reportNull$$$0(0);
        }
        Generator<T> generator = new Generator<T>(function);
        if (generator == null) {
            Generator.$$$reportNull$$$0(1);
        }
        return generator;
    }

    Function<DataStructure, T> getGeneratorFunction() {
        return this.myFunction;
    }

    public <V> Generator<V> map(@NotNull Function<? super T, ? extends V> fun) {
        if (fun == null) {
            Generator.$$$reportNull$$$0(2);
        }
        return Generator.from(data -> {
            if (fun == null) {
                Generator.$$$reportNull$$$0(16);
            }
            return fun.apply((T)this.myFunction.apply((DataStructure)data));
        });
    }

    public <V> Generator<V> flatMap(@NotNull Function<? super T, ? extends Generator<V>> fun) {
        if (fun == null) {
            Generator.$$$reportNull$$$0(3);
        }
        return Generator.from(data -> {
            Object value;
            Generator result;
            if (fun == null) {
                Generator.$$$reportNull$$$0(15);
            }
            if ((result = (Generator)fun.apply((T)(value = data.generate(this)))) == null) {
                throw new NullPointerException(fun + " returned null on " + value);
            }
            return data.generate(result);
        });
    }

    public Generator<T> noShrink() {
        return Generator.from(data -> ((AbstractDataStructure)data).generateNonShrinkable(this));
    }

    public Generator<T> suchThat(@NotNull Predicate<? super T> condition) {
        if (condition == null) {
            Generator.$$$reportNull$$$0(4);
        }
        return Generator.from(data -> {
            if (condition == null) {
                Generator.$$$reportNull$$$0(14);
            }
            return ((AbstractDataStructure)data).generateConditional(this, condition);
        });
    }

    public static <T> Generator<T> constant(T value) {
        return Generator.from(data -> value);
    }

    @SafeVarargs
    public static <T> Generator<T> sampledFrom(T ... values) {
        return Generator.sampledFrom(Arrays.asList(values));
    }

    public static <T> Generator<T> sampledFrom(List<T> values) {
        return Generator.anyOf(values.stream().map(Generator::constant).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T> Generator<T> anyOf(Generator<? extends T> ... alternatives) {
        return Generator.anyOf(Arrays.asList(alternatives));
    }

    public static <T> Generator<T> anyOf(List<? extends Generator<? extends T>> alternatives) {
        if (alternatives.isEmpty()) {
            throw new IllegalArgumentException("No alternatives to choose from");
        }
        return Generator.from(data -> {
            int index = ((AbstractDataStructure)data).generateNonShrinkable(Generator.integers(0, alternatives.size() - 1));
            return data.generate((Generator)alternatives.get(index));
        });
    }

    public static <T> FrequencyGenerator<T> frequency(int weight1, Generator<? extends T> alternative1, int weight2, Generator<? extends T> alternative2) {
        return new FrequencyGenerator<T>(weight1, alternative1, weight2, alternative2);
    }

    public static <T> Generator<T> frequency(int weight1, Generator<? extends T> alternative1, int weight2, Generator<? extends T> alternative2, int weight3, Generator<? extends T> alternative3) {
        return Generator.frequency(weight1, alternative1, weight2, alternative2).with(weight3, alternative3);
    }

    public static <A, B, C> Generator<C> zipWith(Generator<A> gen1, Generator<B> gen2, BiFunction<? super A, ? super B, ? extends C> zip) {
        return Generator.from(data -> zip.apply((Object)data.generate(gen1), (Object)data.generate(gen2)));
    }

    @NotNull
    public static <T> Generator<T> recursive(@NotNull Function<? super Generator<T>, ? extends Generator<T>> createGenerator) {
        if (createGenerator == null) {
            Generator.$$$reportNull$$$0(5);
        }
        AtomicReference ref = new AtomicReference();
        Generator<Object> result = Generator.from(data -> ((Generator)ref.get()).getGeneratorFunction().apply((DataStructure)data));
        ref.set(createGenerator.apply(result));
        Generator<Object> generator = result;
        if (generator == null) {
            Generator.$$$reportNull$$$0(6);
        }
        return generator;
    }

    public static Generator<Boolean> booleans() {
        return Generator.integers(0, 1).map(i -> i == 1);
    }

    public static Generator<Character> charsInRange(char min, char max) {
        return Generator.integers(min, max).map(i -> Character.valueOf((char)i.intValue()));
    }

    public static Generator<Character> charsFrom(String possibleChars) {
        return Generator.sampledFrom(IntStream.range(0, possibleChars.length()).mapToObj(possibleChars::charAt).collect(Collectors.toList()));
    }

    public static Generator<Character> asciiPrintableChars() {
        return Generator.charsInRange(' ', '~');
    }

    public static Generator<Character> asciiUppercaseChars() {
        return Generator.charsInRange('A', 'Z');
    }

    public static Generator<Character> asciiLowercaseChars() {
        return Generator.charsInRange('a', 'z');
    }

    public static Generator<Character> asciiLetters() {
        return Generator.frequency(9, Generator.asciiLowercaseChars(), 1, Generator.asciiUppercaseChars()).noShrink();
    }

    public static Generator<Character> digits() {
        return Generator.charsInRange('0', '9');
    }

    public static Generator<String> stringsOf(@NotNull String possibleChars) {
        if (possibleChars == null) {
            Generator.$$$reportNull$$$0(7);
        }
        return Generator.stringsOf(Generator.charsFrom(possibleChars));
    }

    public static Generator<String> stringsOf(@NotNull Generator<Character> charGen) {
        if (charGen == null) {
            Generator.$$$reportNull$$$0(8);
        }
        return Generator.listsOf(charGen).map(Generator::charsToString);
    }

    public static Generator<String> stringsOf(@NotNull IntDistribution length, @NotNull Generator<Character> charGen) {
        if (length == null) {
            Generator.$$$reportNull$$$0(9);
        }
        if (charGen == null) {
            Generator.$$$reportNull$$$0(10);
        }
        return Generator.listsOf(length, charGen).map(Generator::charsToString);
    }

    @NotNull
    private static String charsToString(List<Character> chars) {
        StringBuilder sb = new StringBuilder();
        chars.forEach(sb::append);
        String string = sb.toString();
        if (string == null) {
            Generator.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static Generator<String> asciiIdentifiers() {
        return Generator.stringsOf(Generator.frequency(50, Generator.asciiLetters(), 5, Generator.digits(), 1, Generator.constant(Character.valueOf('_')))).suchThat(s -> s.length() > 0 && !Character.isDigit(s.charAt(0)));
    }

    public static Generator<Integer> integers() {
        return Generator.integers(BoundedIntDistribution.ALL_INTS);
    }

    public static Generator<Integer> naturals() {
        return Generator.integers(0, Integer.MAX_VALUE);
    }

    public static Generator<Integer> integers(int min, int max) {
        return Generator.integers(IntDistribution.uniform(min, max));
    }

    public static Generator<Integer> integers(@NotNull IntDistribution distribution) {
        if (distribution == null) {
            Generator.$$$reportNull$$$0(12);
        }
        return Generator.from(data -> {
            if (distribution == null) {
                Generator.$$$reportNull$$$0(13);
            }
            return ((AbstractDataStructure)data).drawInt(distribution);
        });
    }

    public static Generator<Double> doubles() {
        return Generator.from(data -> {
            long i1 = data.generate(Generator.integers(BoundedIntDistribution.ALL_INTS)).intValue();
            long i2 = data.generate(Generator.integers(BoundedIntDistribution.ALL_INTS)).intValue();
            return Double.longBitsToDouble((i1 << 32) + (i2 & 0xFFFFFFFFL));
        });
    }

    public static <T> Generator<List<T>> listsOf(Generator<T> itemGenerator) {
        return Generator.from(data -> Generator.generateList(itemGenerator, data, ((AbstractDataStructure)data).suggestCollectionSize()));
    }

    public static <T> Generator<List<T>> nonEmptyLists(Generator<T> itemGenerator) {
        return Generator.listsOf(itemGenerator).suchThat(l -> !l.isEmpty());
    }

    public static <T> Generator<List<T>> listsOf(IntDistribution length, Generator<T> itemGenerator) {
        return Generator.from(data -> Generator.generateList(itemGenerator, data, ((AbstractDataStructure)data).drawInt(length)));
    }

    private static <T> List<T> generateList(Generator<T> itemGenerator, DataStructure data, int size) {
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(data.generate(itemGenerator));
        }
        return Collections.unmodifiableList(list);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jetCheck/Generator";
                break;
            }
            case 2: 
            case 3: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createGenerator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleChars";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charGen";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "length";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jetCheck/Generator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "recursive";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "charsToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "flatMap";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suchThat";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "recursive";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "stringsOf";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "integers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$integers$11";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$suchThat$3";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$flatMap$1";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$map$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

