/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.AbstractDataStructure;
import org.jetbrains.jetCheck.CannotSatisfyCondition;
import org.jetbrains.jetCheck.DataStructure;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.IntData;
import org.jetbrains.jetCheck.IntDistribution;
import org.jetbrains.jetCheck.IntSource;
import org.jetbrains.jetCheck.StructureNode;
import org.jetbrains.jetCheck.WrongDataStructure;

class GenerativeDataStructure
extends AbstractDataStructure {
    private final CurrentData dataTracker;
    private final IntSource random;

    GenerativeDataStructure(IntSource random, StructureNode node, int sizeHint) {
        this(null, random, node, sizeHint);
    }

    private GenerativeDataStructure(@Nullable CurrentData dataTracker, IntSource random, StructureNode node, int sizeHint) {
        super(node, sizeHint);
        this.random = random;
        this.dataTracker = dataTracker != null ? dataTracker : new CurrentData();
    }

    @Override
    int drawInt(@NotNull IntDistribution distribution) {
        if (distribution == null) {
            GenerativeDataStructure.$$$reportNull$$$0(0);
        }
        this.dataTracker.checkContext(this);
        int i = this.random.drawInt(distribution);
        this.node.addChild(new IntData(this.node.id.childId(null), i, distribution));
        return i;
    }

    @Override
    public <T> T generate(@NotNull Generator<T> generator) {
        if (generator == null) {
            GenerativeDataStructure.$$$reportNull$$$0(1);
        }
        return this.dataTracker.generateOn(generator, this.subStructure(generator, this.childSizeHint()), this);
    }

    @NotNull
    private GenerativeDataStructure subStructure(@NotNull Generator<?> generator, int childSizeHint) {
        if (generator == null) {
            GenerativeDataStructure.$$$reportNull$$$0(2);
        }
        GenerativeDataStructure generativeDataStructure = new GenerativeDataStructure(this.dataTracker, this.random, this.node.subStructure(generator), childSizeHint);
        if (generativeDataStructure == null) {
            GenerativeDataStructure.$$$reportNull$$$0(3);
        }
        return generativeDataStructure;
    }

    @Override
    <T> T generateNonShrinkable(@NotNull Generator<T> generator) {
        if (generator == null) {
            GenerativeDataStructure.$$$reportNull$$$0(4);
        }
        GenerativeDataStructure data = this.subStructure(generator, this.sizeHint);
        data.node.shrinkProhibited = true;
        return this.dataTracker.generateOn(generator, data, this);
    }

    @Override
    <T> T generateConditional(@NotNull Generator<T> generator, @NotNull Predicate<? super T> condition) {
        if (generator == null) {
            GenerativeDataStructure.$$$reportNull$$$0(5);
        }
        if (condition == null) {
            GenerativeDataStructure.$$$reportNull$$$0(6);
        }
        for (int i = 0; i < 100; ++i) {
            GenerativeDataStructure structure = this.subStructure(generator, this.childSizeHint());
            T value = this.dataTracker.generateOn(generator, structure, this);
            if (condition.test(value)) {
                return value;
            }
            this.node.removeLastChild(structure.node);
        }
        throw new CannotSatisfyCondition(condition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jetCheck/GenerativeDataStructure";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jetCheck/GenerativeDataStructure";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "subStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "drawInt";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "subStructure";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateNonShrinkable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateConditional";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CurrentData {
        DataStructure current;

        private CurrentData() {
            this.current = GenerativeDataStructure.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> T generateOn(Generator<T> gen, GenerativeDataStructure data, GenerativeDataStructure parent) {
            this.checkContext(parent);
            this.current = data;
            try {
                T t = gen.getGeneratorFunction().apply(data);
                return t;
            }
            finally {
                this.current = parent;
            }
        }

        void checkContext(GenerativeDataStructure data) {
            if (this.current != data) {
                throw new WrongDataStructure();
            }
        }
    }
}

