/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.AbstractDataStructure;
import org.jetbrains.jetCheck.DataStructure;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.IntDistribution;

public class FrequencyGenerator<T>
extends Generator<T> {
    private final List<WeightedGenerator<T>> alternatives;

    FrequencyGenerator(int weight1, Generator<? extends T> alternative1, int weight2, Generator<? extends T> alternative2) {
        this(FrequencyGenerator.weightedGenerators(weight1, alternative1, weight2, alternative2));
    }

    private FrequencyGenerator(List<WeightedGenerator<T>> alternatives) {
        super(FrequencyGenerator.frequencyFunction(alternatives));
        this.alternatives = alternatives;
    }

    FrequencyGenerator<T> with(int weight, Generator<? extends T> alternative) {
        ArrayList<WeightedGenerator<T>> alternatives = new ArrayList<WeightedGenerator<T>>(this.alternatives);
        alternatives.add(new WeightedGenerator<T>(weight, alternative));
        return new FrequencyGenerator<T>(alternatives);
    }

    @NotNull
    private static <T> Function<DataStructure, T> frequencyFunction(List<WeightedGenerator<T>> alternatives) {
        List<Integer> weights = alternatives.stream().map((? super T w) -> w.weight).collect(Collectors.toList());
        IntDistribution distribution = IntDistribution.frequencyDistribution(weights);
        Function<DataStructure, Object> function = data -> data.generate(((WeightedGenerator)alternatives.get((int)((AbstractDataStructure)data).drawInt((IntDistribution)distribution))).generator);
        if (function == null) {
            FrequencyGenerator.$$$reportNull$$$0(0);
        }
        return function;
    }

    @NotNull
    private static <T> List<WeightedGenerator<T>> weightedGenerators(int weight1, Generator<? extends T> alternative1, int weight2, Generator<? extends T> alternative2) {
        ArrayList<WeightedGenerator<T>> alternatives = new ArrayList<WeightedGenerator<T>>();
        alternatives.add(new WeightedGenerator<T>(weight1, alternative1));
        alternatives.add(new WeightedGenerator<T>(weight2, alternative2));
        ArrayList<WeightedGenerator<T>> arrayList = alternatives;
        if (arrayList == null) {
            FrequencyGenerator.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jetCheck/FrequencyGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "frequencyFunction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "weightedGenerators";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class WeightedGenerator<T> {
        final int weight;
        final Generator<? extends T> generator;

        WeightedGenerator(int weight, Generator<? extends T> generator) {
            this.weight = weight;
            this.generator = generator;
        }
    }
}

