/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Base64;
import org.jetbrains.jetCheck.CannotRestoreValue;
import org.jetbrains.jetCheck.Iteration;
import org.jetbrains.jetCheck.PropertyChecker;
import org.jetbrains.jetCheck.StructureElement;

class DataSerializer {
    DataSerializer() {
    }

    private static int readINT(ByteArrayInputStream record) {
        int val = DataSerializer.readWithEof(record);
        if (val < 192) {
            return val;
        }
        int res = val - 192;
        int sh = 6;
        while (true) {
            int next = DataSerializer.readWithEof(record);
            res |= (next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    private static int readWithEof(ByteArrayInputStream record) {
        if (record.available() <= 0) {
            throw new EOFException();
        }
        return record.read();
    }

    static void writeINT(DataOutput record, int val) throws IOException {
        if (0 > val || val >= 192) {
            record.writeByte(192 + (val & 0x3F));
            val >>>= 6;
            while (val >= 128) {
                record.writeByte(val & 0x7F | 0x80);
                val >>>= 7;
            }
        }
        record.writeByte(val);
    }

    static String serialize(Iteration iteration, StructureElement node) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (DataOutputStream data = new DataOutputStream(stream);){
            DataSerializer.writeINT(data, (int)(iteration.iterationSeed >> 32));
            DataSerializer.writeINT(data, (int)iteration.iterationSeed);
            DataSerializer.writeINT(data, iteration.sizeHint);
            node.serialize(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Base64.getEncoder().encodeToString(stream.toByteArray());
    }

    static void deserializeInto(String data, PropertyChecker.Parameters parameters) {
        ByteArrayInputStream stream = new ByteArrayInputStream(Base64.getDecoder().decode(data));
        int seedHigh = DataSerializer.readINT(stream);
        int seedLow = DataSerializer.readINT(stream);
        parameters.globalSeed = (long)seedHigh << 32 | (long)seedLow & 0xFFFFFFFFL;
        int hint = DataSerializer.readINT(stream);
        parameters.sizeHintFun = __ -> hint;
        parameters.serializedData = dist -> {
            int i = DataSerializer.readINT(stream);
            if (!dist.isValidValue(i)) {
                throw new CannotRestoreValue("Error restoring from serialized \"rechecking\" data. Possible cause: either the test or the environment it depends on has changed.");
            }
            return i;
        };
    }

    static class EOFException
    extends RuntimeException {
        EOFException() {
        }
    }
}

