/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.DataSerializer;
import org.jetbrains.jetCheck.IntCustomizer;
import org.jetbrains.jetCheck.Iteration;
import org.jetbrains.jetCheck.PropertyFailure;
import org.jetbrains.jetCheck.ReplayDataStructure;
import org.jetbrains.jetCheck.StructureNode;

class CounterExampleImpl<T>
implements PropertyFailure.CounterExample<T> {
    final StructureNode data;
    private final T value;
    @Nullable
    private final Throwable exception;
    private final Iteration<T> iteration;

    private CounterExampleImpl(StructureNode data, T value, @Nullable Throwable exception, Iteration<T> iteration) {
        this.data = data;
        this.value = value;
        this.exception = exception;
        this.iteration = iteration;
    }

    @Override
    public T getExampleValue() {
        return this.value;
    }

    @Override
    @Nullable
    public Throwable getExceptionCause() {
        return this.exception;
    }

    @Override
    @NotNull
    public CounterExampleImpl<T> replay() {
        T value = this.iteration.generateValue(this.createReplayData());
        CounterExampleImpl<T> example = CounterExampleImpl.checkProperty(this.iteration, value, this.data);
        CounterExampleImpl<T> counterExampleImpl = example != null ? example : new CounterExampleImpl<T>(this.data, value, new IllegalStateException("Replaying failure is unexpectedly successful!"), this.iteration);
        if (counterExampleImpl == null) {
            CounterExampleImpl.$$$reportNull$$$0(0);
        }
        return counterExampleImpl;
    }

    @Override
    @NotNull
    public String getSerializedData() {
        String string = DataSerializer.serialize(this.iteration, this.data);
        if (string == null) {
            CounterExampleImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    ReplayDataStructure createReplayData() {
        return new ReplayDataStructure(this.data, this.iteration.sizeHint, IntCustomizer::checkValidInt);
    }

    static <T> CounterExampleImpl<T> checkProperty(Iteration<T> iteration, T value, StructureNode node) {
        try {
            if (!iteration.session.property.test(value)) {
                return new CounterExampleImpl<T>(node, value, null, iteration);
            }
        }
        catch (Throwable e) {
            return new CounterExampleImpl<T>(node, value, e, iteration);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jetCheck/CounterExampleImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "replay";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializedData";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

