/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.BoundedIntDistribution;
import org.jetbrains.jetCheck.CannotRestoreValue;
import org.jetbrains.jetCheck.IntCustomizer;
import org.jetbrains.jetCheck.IntData;
import org.jetbrains.jetCheck.IntDistribution;
import org.jetbrains.jetCheck.NodeId;
import org.jetbrains.jetCheck.StructureNode;

class CombinatorialIntCustomizer
implements IntCustomizer {
    private final LinkedHashMap<NodeId, Set<Integer>> valuesToTry;
    private final Map<NodeId, Integer> currentCombination;
    private final Map<NodeId, IntDistribution> changedDistributions = new HashMap<NodeId, IntDistribution>();

    CombinatorialIntCustomizer() {
        this(new LinkedHashMap<NodeId, Set<Integer>>(), new HashMap<NodeId, Integer>());
    }

    private CombinatorialIntCustomizer(LinkedHashMap<NodeId, Set<Integer>> valuesToTry, Map<NodeId, Integer> currentCombination) {
        this.valuesToTry = valuesToTry;
        this.currentCombination = currentCombination;
    }

    @Override
    public int suggestInt(IntData data, IntDistribution currentDistribution) {
        if (data.distribution instanceof BoundedIntDistribution && currentDistribution instanceof BoundedIntDistribution && this.registerDifferentRange(data, (BoundedIntDistribution)currentDistribution, (BoundedIntDistribution)data.distribution)) {
            return this.suggestCombinatorialVariant(data, currentDistribution);
        }
        return IntCustomizer.checkValidInt(data, currentDistribution);
    }

    private int suggestCombinatorialVariant(IntData data, IntDistribution currentDistribution) {
        int value = this.currentCombination.computeIfAbsent(data.id, __ -> this.valuesToTry.get(data.id).iterator().next());
        if (currentDistribution.isValidValue(value)) {
            return value;
        }
        throw new CannotRestoreValue();
    }

    private boolean registerDifferentRange(IntData data, BoundedIntDistribution current, BoundedIntDistribution original) {
        LinkedHashSet<Integer> possibleValues;
        if (this.currentCombination.containsKey(data.id)) {
            this.changedDistributions.put(data.id, current);
            return true;
        }
        if (!(original.getMax() == current.getMax() && original.getMin() == current.getMin() || (possibleValues = this.getPossibleValues(data, current, original)).isEmpty())) {
            assert (!this.valuesToTry.containsKey(data.id));
            this.valuesToTry.put(data.id, possibleValues);
            this.changedDistributions.put(data.id, current);
            return true;
        }
        return false;
    }

    private LinkedHashSet<Integer> getPossibleValues(IntData data, BoundedIntDistribution current, BoundedIntDistribution original) {
        ArrayList<Integer> possibleValues = new ArrayList<Integer>();
        int fromStart = data.value - original.getMin();
        int fromEnd = original.getMax() - data.value;
        int sameDistanceFromStart = current.getMin() + fromStart;
        int sameDistanceFromEnd = current.getMax() - fromEnd;
        if (!this.tooManyCombinations()) {
            if (fromStart < fromEnd) {
                possibleValues.add(sameDistanceFromStart);
                possibleValues.add(sameDistanceFromEnd);
            } else {
                possibleValues.add(sameDistanceFromEnd);
                possibleValues.add(sameDistanceFromStart);
            }
        }
        possibleValues.add(data.value);
        return possibleValues.stream().map(value -> Math.min(Math.max(value, current.getMin()), current.getMax())).filter(current::isValidValue).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private boolean tooManyCombinations() {
        return this.valuesToTry.values().stream().filter(s -> s.size() > 1).count() > 3L;
    }

    @Nullable
    CombinatorialIntCustomizer nextAttempt() {
        HashMap<NodeId, Integer> nextCombination = new HashMap<NodeId, Integer>(this.currentCombination);
        for (Map.Entry<NodeId, Set<Integer>> entry : this.valuesToTry.entrySet()) {
            Integer usedValue;
            ArrayList possibleValues = new ArrayList(entry.getValue());
            int index = possibleValues.indexOf(usedValue = this.currentCombination.get(entry.getKey()));
            if (index < possibleValues.size() - 1) {
                nextCombination.put(entry.getKey(), (Integer)possibleValues.get(index + 1));
                return new CombinatorialIntCustomizer(this.valuesToTry, nextCombination);
            }
            nextCombination.put(entry.getKey(), (Integer)possibleValues.get(0));
        }
        return null;
    }

    StructureNode writeChanges(StructureNode node) {
        StructureNode result = node;
        for (Map.Entry<NodeId, IntDistribution> entry : this.changedDistributions.entrySet()) {
            NodeId id = entry.getKey();
            result = result.replace(id, new IntData(id, this.currentCombination.get(id), entry.getValue()));
        }
        return result;
    }

    int countVariants() {
        return this.valuesToTry.values().stream().mapToInt(Set::size).reduce(1, (a, b) -> a * b);
    }
}

