/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.Iteration;
import org.jetbrains.jetCheck.PropertyChecker;
import org.jetbrains.jetCheck.StatusNotifier;
import org.jetbrains.jetCheck.StructureNode;

class CheckSession<T> {
    final Generator<T> generator;
    final Predicate<T> property;
    final PropertyChecker.Parameters parameters;
    final StatusNotifier notifier;
    private final Set<StructureNode> generatedNodes = Collections.newSetFromMap(new LinkedHashMap<StructureNode, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<StructureNode, Boolean> eldest) {
            return this.size() > 1000;
        }
    });

    CheckSession(Generator<T> generator, Predicate<T> property, PropertyChecker.Parameters parameters) {
        this.generator = generator;
        this.property = property;
        this.parameters = parameters;
        this.notifier = parameters.silent ? StatusNotifier.SILENT : new StatusNotifier(parameters.iterationCount);
    }

    boolean addGeneratedNode(StructureNode node) {
        return this.generatedNodes.add(node);
    }

    Iteration<T> firstIteration() {
        return new Iteration(this, this.parameters.globalSeed, 1);
    }
}

