/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.Random;
import java.util.function.ToIntFunction;
import org.jetbrains.jetCheck.IntDistribution;

public class BoundedIntDistribution
implements IntDistribution {
    public static final IntDistribution ALL_INTS = IntDistribution.uniform(Integer.MIN_VALUE, Integer.MAX_VALUE);
    private final int min;
    private final int max;
    private final ToIntFunction<Random> producer;

    BoundedIntDistribution(int min, int max, ToIntFunction<Random> producer) {
        if (min > max) {
            throw new IllegalArgumentException(min + ">" + max);
        }
        this.min = min;
        this.max = max;
        this.producer = producer;
    }

    int getMin() {
        return this.min;
    }

    int getMax() {
        return this.max;
    }

    @Override
    public int generateInt(Random random) {
        int i = this.producer.applyAsInt(random);
        if (i < this.min || i > this.max) {
            throw new IllegalStateException("Int out of bounds produced by " + this.producer + ": " + i + " not in [" + this.min + ", " + this.max + "]");
        }
        return i;
    }

    @Override
    public boolean isValidValue(int i) {
        return i >= this.min && i <= this.max;
    }

    public static BoundedIntDistribution bound(int min, int max, final IntDistribution distribution) {
        return new BoundedIntDistribution(min, max, random -> Math.min(Math.max(distribution.generateInt((Random)random), min), max)){

            @Override
            public boolean isValidValue(int i) {
                return super.isValidValue(i) && distribution.isValidValue(i);
            }
        };
    }
}

