/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.DataStructure;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.IntDistribution;
import org.jetbrains.jetCheck.StructureNode;

abstract class AbstractDataStructure
implements DataStructure {
    protected final StructureNode node;
    protected final int sizeHint;

    AbstractDataStructure(StructureNode node, int sizeHint) {
        this.node = node;
        this.sizeHint = sizeHint;
    }

    int childSizeHint() {
        return Math.max(1, this.sizeHint - 1);
    }

    @Override
    public int getSizeHint() {
        return this.sizeHint;
    }

    abstract int drawInt(@NotNull IntDistribution var1);

    int suggestCollectionSize() {
        return this.drawInt(IntDistribution.uniform(0, this.getSizeHint()));
    }

    abstract <T> T generateNonShrinkable(@NotNull Generator<T> var1);

    abstract <T> T generateConditional(@NotNull Generator<T> var1, @NotNull Predicate<? super T> var2);
}

