/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;

@SupportedAnnotationTypes(value={"*"})
public class JavacASTAnalyser
extends AbstractProcessor {
    private Trees myTrees;
    private final DiagnosticOutputConsumer myOutputConsumer;
    private final boolean mySuppressOtherProcessors;

    public JavacASTAnalyser(DiagnosticOutputConsumer outputConsumer, boolean suppressOtherProcessors) {
        this.myOutputConsumer = outputConsumer;
        this.mySuppressOtherProcessors = suppressOtherProcessors;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.myTrees = Trees.instance(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getRootElements();
        for (Element element : elements) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            ImportsCollector importsCollector = new ImportsCollector();
            importsCollector.scan(this.myTrees.getPath(typeElement).getParentPath().getLeaf(), this.myTrees);
            Set<String> imports = importsCollector.getImports();
            Set<String> staticImports = importsCollector.getStaticImports();
            if (imports.isEmpty() && staticImports.isEmpty()) break;
            String className = typeElement.getQualifiedName().toString();
            this.myOutputConsumer.registerImports(className, imports, staticImports);
            break;
        }
        return this.mySuppressOtherProcessors;
    }

    private static class ImportsCollector
    extends TreeScanner<Object, Trees> {
        private final Set<String> myImports = new HashSet<String>();
        private final Set<String> myStaticImports = new HashSet<String>();

        private ImportsCollector() {
        }

        public Set<String> getImports() {
            return this.myImports;
        }

        public Set<String> getStaticImports() {
            return this.myStaticImports;
        }

        @Override
        public Object visitImport(ImportTree node, Trees trees) {
            Tree identifier = node.getQualifiedIdentifier();
            Set<String> container = node.isStatic() ? this.myStaticImports : this.myImports;
            container.add(identifier.toString());
            return null;
        }

        @Override
        public Object visitClass(ClassTree node, Trees trees) {
            return null;
        }
    }
}

