/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.google.protobuf.MessageLite;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacMessageHandler;
import org.jetbrains.jps.javac.ExternalJavacProcess;
import org.jetbrains.jps.javac.JavacProtoUtil;
import org.jetbrains.jps.javac.JavacRemoteProto;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.PlainMessageDiagnostic;

public class ExternalJavacManager {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.javac.ExternalJavacServer");
    public static final GlobalContextKey<ExternalJavacManager> KEY = GlobalContextKey.create("_external_javac_server_");
    public static final int DEFAULT_SERVER_PORT = 7878;
    public static final String STDOUT_LINE_PREFIX = "JAVAC_PROCESS[STDOUT]";
    public static final String STDERR_LINE_PREFIX = "JAVAC_PROCESS[STDERR]";
    private static final AttributeKey<JavacProcessDescriptor> SESSION_DESCRIPTOR = AttributeKey.valueOf((String)"ExternalJavacServer.JavacProcessDescriptor");
    private final File myWorkingDir;
    private final ChannelRegistrar myChannelRegistrar;
    private final Map<UUID, JavacProcessDescriptor> myMessageHandlers;
    private int myListenPort;
    private final Set<ProcessHandler> myRunningHandlers;
    private final ThreadPoolExecutor myExecutor;

    public ExternalJavacManager(@NotNull File workingDir) {
        if (workingDir == null) {
            ExternalJavacManager.$$$reportNull$$$0(0);
        }
        this.myMessageHandlers = new HashMap<UUID, JavacProcessDescriptor>();
        this.myListenPort = 7878;
        this.myRunningHandlers = ContainerUtil.newConcurrentSet();
        this.myExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"Javac server event loop pool");
        this.myWorkingDir = workingDir;
        this.myChannelRegistrar = new ChannelRegistrar();
    }

    public void start(int listenPort) {
        CompilationRequestsHandler compilationRequestsHandler = new CompilationRequestsHandler();
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)new NioEventLoopGroup(1, (Executor)this.myExecutor)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer((ChannelHandler)compilationRequestsHandler){
            final /* synthetic */ ChannelHandler val$compilationRequestsHandler;
            {
                this.val$compilationRequestsHandler = channelHandler;
            }

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{ExternalJavacManager.this.myChannelRegistrar, new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)JavacRemoteProto.Message.getDefaultInstance()), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), this.val$compilationRequestsHandler});
            }
        });
        try {
            InetAddress loopback = InetAddress.getByName(null);
            this.myChannelRegistrar.add(bootstrap.bind(loopback, listenPort).syncUninterruptibly().channel());
            this.myListenPort = listenPort;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forkJavac(String javaHome, int heapSize, List<String> vmOptions, List<String> options, Collection<File> platformCp, Collection<File> classpath, Collection<File> upgradeModulePath, Collection<File> modulePath, Collection<File> sourcePath, Collection<File> files, Map<File, Set<File>> outs, final DiagnosticOutputConsumer diagnosticSink, OutputFileConsumer outputSink, JavaCompilingTool compilingTool, CanceledStatus cancelStatus) {
        ExternalJavacMessageHandler rh = new ExternalJavacMessageHandler(diagnosticSink, outputSink, ExternalJavacManager.getEncodingName(options));
        JavacRemoteProto.Message.Request request = JavacProtoUtil.createCompilationRequest(options, files, classpath, platformCp, modulePath, upgradeModulePath, sourcePath, outs);
        UUID uuid = UUID.randomUUID();
        JavacProcessDescriptor processDescriptor = new JavacProcessDescriptor(uuid, rh, request);
        Map<UUID, JavacProcessDescriptor> map = this.myMessageHandlers;
        synchronized (map) {
            this.myMessageHandlers.put(uuid, processDescriptor);
        }
        try {
            final ExternalJavacProcessHandler processHandler = this.launchExternalJavacProcess(uuid, javaHome, heapSize, this.myListenPort, this.myWorkingDir, vmOptions, compilingTool);
            this.myRunningHandlers.add((ProcessHandler)processHandler);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ExternalJavacManager.this.myRunningHandlers.remove((Object)processHandler);
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    String text;
                    if (event == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (outputType == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)(text = event.getText()))) {
                        String prefix = null;
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            prefix = ExternalJavacManager.STDOUT_LINE_PREFIX;
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            prefix = ExternalJavacManager.STDERR_LINE_PREFIX;
                        }
                        if (prefix != null) {
                            diagnosticSink.outputLineAvailable(prefix + ": " + text);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/jps/javac/ExternalJavacManager$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            processHandler.startNotify();
            while (!processDescriptor.waitFor(300L)) {
                if (processHandler.isProcessTerminated() && processDescriptor.channel == null && processHandler.getExitCode() != 0) {
                    processDescriptor.setDone();
                    break;
                }
                if (!cancelStatus.isCanceled()) continue;
                processDescriptor.cancelBuild();
            }
            boolean bl = rh.isTerminatedSuccessfully();
            return bl;
        }
        catch (Throwable e) {
            LOG.info(e);
            diagnosticSink.report((Diagnostic)new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, e.getMessage()));
        }
        finally {
            this.unregisterMessageHandler(uuid);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean waitForAllProcessHandlers(long time, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            ExternalJavacManager.$$$reportNull$$$0(1);
        }
        for (ProcessHandler handler : this.myRunningHandlers) {
            void unit;
            if (handler.waitFor(unit.toMillis(time))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean awaitNettyThreadPoolTermination(long time, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            ExternalJavacManager.$$$reportNull$$$0(2);
        }
        try {
            void unit;
            return this.myExecutor.awaitTermination(time, (TimeUnit)unit);
        }
        catch (InterruptedException ignored) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterMessageHandler(UUID uuid) {
        JavacProcessDescriptor descriptor;
        Map<UUID, JavacProcessDescriptor> map = this.myMessageHandlers;
        synchronized (map) {
            descriptor = this.myMessageHandlers.remove(uuid);
        }
        if (descriptor != null) {
            descriptor.setDone();
        }
    }

    @Nullable
    private static String getEncodingName(List<String> options) {
        int p = options.indexOf("-encoding");
        return p >= 0 && p < options.size() - 1 ? options.get(p + 1) : null;
    }

    public void stop() {
        this.myChannelRegistrar.close().awaitUninterruptibly();
        this.myExecutor.shutdown();
    }

    private ExternalJavacProcessHandler launchExternalJavacProcess(UUID uuid, String sdkHomePath, int heapSize, int port, File workingDir, List<String> vmOptions, JavaCompilingTool compilingTool) throws Exception {
        ArrayList<String> cmdLine = new ArrayList<String>();
        ExternalJavacManager.appendParam(cmdLine, ExternalJavacManager.getVMExecutablePath(sdkHomePath));
        ExternalJavacManager.appendParam(cmdLine, "-Djava.awt.headless=true");
        if (heapSize > 0) {
            int xms = heapSize / 2;
            if (xms > 32) {
                ExternalJavacManager.appendParam(cmdLine, "-Xms" + xms + "m");
            }
            ExternalJavacManager.appendParam(cmdLine, "-Xmx" + heapSize + "m");
        }
        ExternalJavacManager.copyProperty(cmdLine, "file.encoding");
        ExternalJavacManager.copyProperty(cmdLine, "user.language");
        ExternalJavacManager.copyProperty(cmdLine, "user.country");
        ExternalJavacManager.copyProperty(cmdLine, "user.region");
        ExternalJavacManager.copyProperty(cmdLine, "io.netty.noUnsafe");
        ExternalJavacManager.appendParam(cmdLine, "-Djps.java.compiling.tool=" + compilingTool.getId());
        ExternalJavacManager.appendParam(cmdLine, "-Djava.ext.dirs=");
        ExternalJavacManager.appendParam(cmdLine, "-Dlog4j.defaultInitOverride=true");
        for (String option : vmOptions) {
            ExternalJavacManager.appendParam(cmdLine, option);
        }
        ExternalJavacManager.appendParam(cmdLine, "-classpath");
        List<File> cp = ClasspathBootstrap.getExternalJavacProcessClasspath(sdkHomePath, compilingTool);
        ExternalJavacManager.appendParam(cmdLine, cp.stream().map(File::getPath).collect(Collectors.joining(File.pathSeparator)));
        ExternalJavacManager.appendParam(cmdLine, ExternalJavacProcess.class.getName());
        ExternalJavacManager.appendParam(cmdLine, uuid.toString());
        ExternalJavacManager.appendParam(cmdLine, "127.0.0.1");
        ExternalJavacManager.appendParam(cmdLine, Integer.toString(port));
        ExternalJavacManager.appendParam(cmdLine, FileUtil.toSystemIndependentName((String)workingDir.getPath()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting external compiler: " + cmdLine);
        }
        FileUtil.createDirectory((File)workingDir);
        Process process = new ProcessBuilder(cmdLine).directory(workingDir).start();
        return this.createProcessHandler(process, StringUtil.join(cmdLine, (String)" "));
    }

    protected ExternalJavacProcessHandler createProcessHandler(@NotNull Process process, @NotNull String commandLine) {
        if (process == null) {
            ExternalJavacManager.$$$reportNull$$$0(3);
        }
        if (commandLine == null) {
            ExternalJavacManager.$$$reportNull$$$0(4);
        }
        return new ExternalJavacProcessHandler(process, commandLine);
    }

    private static void appendParam(List<String> cmdLine, String parameter) {
        if (SystemInfo.isWindows) {
            if (parameter.contains("\"")) {
                parameter = StringUtil.replace((String)parameter, (String)"\"", (String)"\\\"");
            } else if (parameter.length() == 0) {
                parameter = "\"\"";
            }
        }
        cmdLine.add(parameter);
    }

    private static void copyProperty(List<String> cmdLine, String name) {
        String value = System.getProperty(name);
        if (value != null) {
            ExternalJavacManager.appendParam(cmdLine, "-D" + name + '=' + value);
        }
    }

    private static String getVMExecutablePath(String sdkHome) {
        return sdkHome + "/bin/java";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/javac/ExternalJavacManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForAllProcessHandlers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "awaitNettyThreadPoolTermination";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createProcessHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JavacProcessDescriptor {
        private final UUID sessionId;
        private final ExternalJavacMessageHandler handler;
        private volatile JavacRemoteProto.Message.Request request;
        private volatile Channel channel;
        private final Semaphore myDone;

        public JavacProcessDescriptor(@NotNull UUID sessionId, @NotNull ExternalJavacMessageHandler handler, @NotNull JavacRemoteProto.Message.Request request) {
            if (sessionId == null) {
                JavacProcessDescriptor.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                JavacProcessDescriptor.$$$reportNull$$$0(1);
            }
            if (request == null) {
                JavacProcessDescriptor.$$$reportNull$$$0(2);
            }
            this.myDone = new Semaphore();
            this.sessionId = sessionId;
            this.handler = handler;
            this.request = request;
            this.myDone.down();
        }

        public void cancelBuild() {
            if (this.channel != null) {
                this.channel.writeAndFlush((Object)JavacProtoUtil.toMessage((UUID)this.sessionId, (JavacRemoteProto.Message.Request)JavacProtoUtil.createCancelRequest()));
            }
        }

        public void setDone() {
            this.myDone.up();
        }

        public boolean waitFor(long timeout) {
            return this.myDone.waitFor(timeout);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sessionId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/javac/ExternalJavacManager$JavacProcessDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ChannelHandler.Sharable
    private static final class ChannelRegistrar
    extends ChannelInboundHandlerAdapter {
        private final ChannelGroup openChannels = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);

        private ChannelRegistrar() {
        }

        public boolean isEmpty() {
            return this.openChannels.isEmpty();
        }

        public void add(@NotNull Channel serverChannel) {
            if (serverChannel == null) {
                ChannelRegistrar.$$$reportNull$$$0(0);
            }
            assert (serverChannel instanceof ServerChannel);
            this.openChannels.add((Object)serverChannel);
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            this.openChannels.add((Object)context.channel());
            super.channelActive(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChannelGroupFuture close() {
            EventLoopGroup eventLoopGroup = null;
            for (Channel channel : this.openChannels) {
                if (!(channel instanceof ServerChannel)) continue;
                eventLoopGroup = channel.eventLoop().parent();
                break;
            }
            try {
                Iterator iterator = this.openChannels.close();
                return iterator;
            }
            finally {
                if (eventLoopGroup != null) {
                    eventLoopGroup.shutdownGracefully(0L, 15L, TimeUnit.SECONDS);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverChannel", "org/jetbrains/jps/javac/ExternalJavacManager$ChannelRegistrar", "add"));
        }
    }

    @ChannelHandler.Sharable
    private class CompilationRequestsHandler
    extends SimpleChannelInboundHandler<JavacRemoteProto.Message> {
        private CompilationRequestsHandler() {
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            JavacProcessDescriptor descriptor = (JavacProcessDescriptor)ctx.channel().attr(SESSION_DESCRIPTOR).getAndSet(null);
            if (descriptor != null) {
                descriptor.setDone();
            }
            super.channelUnregistered(ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void channelRead0(ChannelHandlerContext context, JavacRemoteProto.Message message) throws Exception {
            UUID sessionId;
            JavacProcessDescriptor descriptor = (JavacProcessDescriptor)context.channel().attr(SESSION_DESCRIPTOR).get();
            if (descriptor == null) {
                sessionId = JavacProtoUtil.fromProtoUUID((JavacRemoteProto.Message.UUID)message.getSessionId());
                descriptor = (JavacProcessDescriptor)ExternalJavacManager.this.myMessageHandlers.get(sessionId);
                if (descriptor != null) {
                    descriptor.channel = context.channel();
                    context.channel().attr(SESSION_DESCRIPTOR).set((Object)descriptor);
                }
            } else {
                sessionId = descriptor.sessionId;
            }
            ExternalJavacMessageHandler handler = descriptor != null ? descriptor.handler : null;
            JavacRemoteProto.Message.Type messageType = message.getMessageType();
            JavacRemoteProto.Message reply = null;
            try {
                if (messageType == JavacRemoteProto.Message.Type.RESPONSE) {
                    JavacRemoteProto.Message.Response response = message.getResponse();
                    JavacRemoteProto.Message.Response.Type responseType = response.getResponseType();
                    if (handler != null) {
                        if (responseType == JavacRemoteProto.Message.Response.Type.REQUEST_ACK) {
                            JavacRemoteProto.Message.Request request = descriptor.request;
                            if (request != null) {
                                reply = JavacProtoUtil.toMessage((UUID)sessionId, (JavacRemoteProto.Message.Request)request);
                                descriptor.request = null;
                            }
                        } else {
                            boolean terminateOk = handler.handleMessage((MessageLite)message);
                            if (terminateOk) {
                                descriptor.setDone();
                            }
                        }
                    } else {
                        reply = JavacProtoUtil.toMessage((UUID)sessionId, (JavacRemoteProto.Message.Request)JavacProtoUtil.createCancelRequest());
                    }
                } else {
                    reply = JavacProtoUtil.toMessage((UUID)sessionId, (JavacRemoteProto.Message.Failure)JavacProtoUtil.createFailure((String)("Unsupported message: " + messageType.name()), null));
                }
                if (reply == null) return;
            }
            catch (Throwable throwable) {
                if (reply == null) throw throwable;
                context.channel().writeAndFlush(reply);
                throw throwable;
            }
            context.channel().writeAndFlush((Object)reply);
        }
    }

    protected static class ExternalJavacProcessHandler
    extends BaseOSProcessHandler {
        private volatile int myExitCode;

        protected ExternalJavacProcessHandler(@NotNull Process process, @NotNull String commandLine) {
            if (process == null) {
                ExternalJavacProcessHandler.$$$reportNull$$$0(0);
            }
            if (commandLine == null) {
                ExternalJavacProcessHandler.$$$reportNull$$$0(1);
            }
            super(process, commandLine, null);
            this.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    myExitCode = event.getExitCode();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/jps/javac/ExternalJavacManager$ExternalJavacProcessHandler$1", "processTerminated"));
                }
            });
        }

        @NotNull
        public Integer getExitCode() {
            Integer n = this.myExitCode;
            if (n == null) {
                ExternalJavacProcessHandler.$$$reportNull$$$0(2);
            }
            return n;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/javac/ExternalJavacManager$ExternalJavacProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/javac/ExternalJavacManager$ExternalJavacProcessHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExitCode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

