/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.messages;

import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.messages.BuildMessage;

public class CompilerMessage
extends BuildMessage {
    private final String myCompilerName;
    private final long myProblemBeginOffset;
    private final long myProblemEndOffset;
    private final long myProblemLocationOffset;
    private final String mySourcePath;
    private final long myLine;
    private final long myColumn;

    public CompilerMessage(@NotNull String compilerName, @NotNull Throwable internalError) {
        if (compilerName == null) {
            CompilerMessage.$$$reportNull$$$0(0);
        }
        if (internalError == null) {
            CompilerMessage.$$$reportNull$$$0(1);
        }
        this(compilerName, BuildMessage.Kind.ERROR, CompilerMessage.getTextFromThrowable(internalError), null, -1L, -1L, -1L, -1L, -1L);
    }

    public CompilerMessage(@NotNull String compilerName, BuildMessage.Kind kind, String messageText) {
        if (compilerName == null) {
            CompilerMessage.$$$reportNull$$$0(2);
        }
        this(compilerName, kind, messageText, null, -1L, -1L, -1L, -1L, -1L);
    }

    public CompilerMessage(@NotNull String compilerName, BuildMessage.Kind kind, String messageText, String sourcePath) {
        if (compilerName == null) {
            CompilerMessage.$$$reportNull$$$0(3);
        }
        this(compilerName, kind, messageText, sourcePath, -1L, -1L, -1L, -1L, -1L);
    }

    /*
     * WARNING - void declaration
     */
    public CompilerMessage(@NotNull String compilerName, BuildMessage.Kind kind, String messageText, @Nullable String sourcePath, long problemBeginOffset, long problemEndOffset, long problemLocationOffset, long l, long l2) {
        void locationColumn;
        void locationLine;
        if (compilerName == null) {
            CompilerMessage.$$$reportNull$$$0(4);
        }
        super(messageText, kind);
        this.myCompilerName = compilerName;
        this.myProblemBeginOffset = problemBeginOffset;
        this.myProblemEndOffset = problemEndOffset;
        this.myProblemLocationOffset = problemLocationOffset;
        this.mySourcePath = sourcePath != null && !sourcePath.isEmpty() ? sourcePath.replace(File.separatorChar, '/') : null;
        this.myLine = locationLine;
        this.myColumn = locationColumn;
    }

    @NotNull
    public String getCompilerName() {
        String string = this.myCompilerName;
        if (string == null) {
            CompilerMessage.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public String getSourcePath() {
        return this.mySourcePath;
    }

    public long getLine() {
        return this.myLine;
    }

    public long getColumn() {
        return this.myColumn;
    }

    public long getProblemBeginOffset() {
        return this.myProblemBeginOffset;
    }

    public long getProblemEndOffset() {
        return this.myProblemEndOffset;
    }

    public long getProblemLocationOffset() {
        return this.myProblemLocationOffset;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getCompilerName()).append(":").append(this.getKind().name()).append(":").append(super.toString());
        String path = this.getSourcePath();
        if (path != null) {
            builder.append("; file: ").append(path);
            long line = this.getLine();
            long column = this.getColumn();
            if (line >= 0L && column >= 0L) {
                builder.append(" at (").append(line).append(":").append(column).append(")");
            }
        }
        return builder.toString();
    }

    public static CompilerMessage createInternalCompilationError(@NotNull String compilerName, @NotNull Throwable t) {
        if (compilerName == null) {
            CompilerMessage.$$$reportNull$$$0(6);
        }
        if (t == null) {
            CompilerMessage.$$$reportNull$$$0(7);
        }
        return new CompilerMessage(compilerName, t);
    }

    public static CompilerMessage createInternalBuilderError(@NotNull String compilerName, @NotNull Throwable t) {
        if (compilerName == null) {
            CompilerMessage.$$$reportNull$$$0(8);
        }
        if (t == null) {
            CompilerMessage.$$$reportNull$$$0(9);
        }
        return new CompilerMessage(compilerName, BuildMessage.Kind.INTERNAL_BUILDER_ERROR, CompilerMessage.getTextFromThrowable(t));
    }

    public static String getTextFromThrowable(Throwable internalError) {
        StringBuilder text = new StringBuilder();
        text.append("Error: ");
        String msg = internalError.getMessage();
        if (!StringUtil.isEmptyOrSpaces((String)msg)) {
            text.append(msg);
        } else {
            text.append(internalError.getClass().getName());
        }
        text.append("\n");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        internalError.printStackTrace(new PrintStream(out));
        text.append(out.toString());
        return text.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalError";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/messages/CompilerMessage";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/messages/CompilerMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createInternalCompilationError";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createInternalBuilderError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

