/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.builders;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ClassMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.artifacts.builders.ArtifactLayoutCustomizationService;
import org.jetbrains.jps.incremental.artifacts.builders.LayoutElementBuilderService;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderContext;
import org.jetbrains.jps.incremental.artifacts.instructions.CopyToDirectoryInstructionCreator;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArchivePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;
import org.jetbrains.jps.model.artifact.elements.JpsComplexPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsExtractedDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsFileCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JpsProductionModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.JpsProductionModuleSourcePackagingElement;
import org.jetbrains.jps.model.java.JpsTestModuleOutputPackagingElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.util.JpsPathUtil;

public class LayoutElementBuildersRegistry {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.artifacts.builders.LayoutElementBuildersRegistry");
    private final ClassMap<LayoutElementBuilderService> myBuilders = new ClassMap();

    public static LayoutElementBuildersRegistry getInstance() {
        return InstanceHolder.ourInstance;
    }

    private LayoutElementBuildersRegistry() {
        LayoutElementBuilderService[] standardBuilders = new LayoutElementBuilderService[]{new RootElementBuilder(), new DirectoryElementBuilder(), new ArchiveElementBuilder(), new DirectoryCopyElementBuilder(), new FileCopyElementBuilder(), new ExtractedDirectoryElementBuilder(), new ModuleOutputElementBuilder(), new ModuleSourceElementBuilder(), new ModuleTestOutputElementBuilder(), new ComplexElementBuilder(), new ArtifactOutputElementBuilder()};
        for (LayoutElementBuilderService builder : standardBuilders) {
            this.myBuilders.put(builder.getElementClass(), (Object)builder);
        }
        for (LayoutElementBuilderService builder : JpsServiceManager.getInstance().getExtensions(LayoutElementBuilderService.class)) {
            this.myBuilders.put(builder.getElementClass(), (Object)builder);
        }
    }

    public void generateInstructions(JpsArtifact artifact, CopyToDirectoryInstructionCreator creator, ArtifactInstructionsBuilderContext context) {
        context.enterArtifact(artifact);
        this.generateInstructions((JpsPackagingElement)artifact.getRootElement(), (ArtifactCompilerInstructionCreator)creator, context);
    }

    public Collection<BuildTarget<?>> getDependencies(JpsPackagingElement element, TargetOutputIndex outputIndex) {
        LayoutElementBuilderService<?> builder = this.getElementBuilder(element);
        if (builder != null) {
            return builder.getDependencies(element, outputIndex);
        }
        return Collections.emptyList();
    }

    private void generateInstructions(JpsPackagingElement layoutElement, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
        LayoutElementBuilderService<?> builder = this.getElementBuilder(layoutElement);
        if (builder != null) {
            builder.generateInstructions(layoutElement, instructionCreator, builderContext);
        }
    }

    private LayoutElementBuilderService<?> getElementBuilder(JpsPackagingElement layoutElement) {
        LayoutElementBuilderService builder = (LayoutElementBuilderService)this.myBuilders.get(layoutElement.getClass());
        if (builder == null) {
            LOG.error("Builder not found for artifact output layout element of class " + layoutElement.getClass());
        }
        return builder;
    }

    private void generateChildrenInstructions(JpsCompositePackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
        this.generateInstructions(element.getChildren(), instructionCreator, builderContext);
    }

    private void generateSubstitutionInstructions(JpsComplexPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
        List substitution = element.getSubstitution();
        if (substitution != null) {
            this.generateInstructions(substitution, instructionCreator, builderContext);
        }
    }

    private void generateInstructions(List<JpsPackagingElement> elements, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
        for (JpsPackagingElement child : elements) {
            this.generateInstructions(child, instructionCreator, builderContext);
        }
    }

    private static void generateModuleSourceInstructions(@NotNull List<JpsModuleSourceRoot> roots, @NotNull ArtifactCompilerInstructionCreator creator, @NotNull JpsPackagingElement contextElement) {
        if (roots == null) {
            LayoutElementBuildersRegistry.$$$reportNull$$$0(0);
        }
        if (creator == null) {
            LayoutElementBuildersRegistry.$$$reportNull$$$0(1);
        }
        if (contextElement == null) {
            LayoutElementBuildersRegistry.$$$reportNull$$$0(2);
        }
        for (JpsModuleSourceRoot root : roots) {
            ArtifactCompilerInstructionCreator target;
            File source = root.getFile();
            JavaSourceRootProperties javaProperties = (JavaSourceRootProperties)root.getProperties(JavaModuleSourceRootTypes.SOURCES);
            if (javaProperties != null) {
                String prefix = javaProperties.getPackagePrefix().replace('.', '/');
                target = creator.subFolderByRelativePath(prefix);
            } else {
                target = creator;
            }
            target.addDirectoryCopyInstructions(source, null, target.getInstructionsBuilder().createCopyingHandler(source, contextElement, target));
        }
    }

    private static void generateModuleOutputInstructions(@Nullable String outputUrl, @NotNull ArtifactCompilerInstructionCreator creator, @NotNull JpsPackagingElement contextElement) {
        if (creator == null) {
            LayoutElementBuildersRegistry.$$$reportNull$$$0(3);
        }
        if (contextElement == null) {
            LayoutElementBuildersRegistry.$$$reportNull$$$0(4);
        }
        if (outputUrl != null) {
            File directory = JpsPathUtil.urlToFile((String)outputUrl);
            creator.addDirectoryCopyInstructions(directory, null, creator.getInstructionsBuilder().createCopyingHandler(directory, contextElement, creator));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/builders/LayoutElementBuildersRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateModuleSourceInstructions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "generateModuleOutputInstructions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ArtifactOutputElementBuilder
    extends LayoutElementBuilderService<JpsArtifactOutputPackagingElement> {
        public ArtifactOutputElementBuilder() {
            super(JpsArtifactOutputPackagingElement.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void generateInstructions(JpsArtifactOutputPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            JpsArtifact artifact = (JpsArtifact)element.getArtifactReference().resolve();
            if (artifact == null) {
                return;
            }
            Set<JpsArtifact> parentArtifacts = builderContext.getParentArtifacts();
            List<JpsPackagingElement> customLayout = this.getCustomArtifactLayout(artifact, parentArtifacts);
            String outputPath = artifact.getOutputPath();
            if (StringUtil.isEmpty((String)outputPath) || customLayout != null) {
                try {
                    if (builderContext.enterArtifact(artifact)) {
                        if (customLayout != null) {
                            LayoutElementBuildersRegistry.this.generateInstructions(customLayout, instructionCreator, builderContext);
                        } else {
                            LayoutElementBuildersRegistry.this.generateSubstitutionInstructions((JpsComplexPackagingElement)element, instructionCreator, builderContext);
                        }
                    }
                }
                finally {
                    builderContext.leaveArtifact(artifact);
                }
                return;
            }
            JpsCompositePackagingElement rootElement = artifact.getRootElement();
            File outputDir = new File(outputPath);
            if (rootElement instanceof JpsArchivePackagingElement) {
                String fileName = ((JpsArchivePackagingElement)rootElement).getArchiveName();
                instructionCreator.addFileCopyInstruction(new File(outputDir, fileName), fileName);
            } else {
                instructionCreator.addDirectoryCopyInstructions(outputDir);
            }
        }

        @Nullable
        private List<JpsPackagingElement> getCustomArtifactLayout(@NotNull JpsArtifact artifact, @NotNull Set<JpsArtifact> parentArtifacts) {
            if (artifact == null) {
                ArtifactOutputElementBuilder.$$$reportNull$$$0(0);
            }
            if (parentArtifacts == null) {
                ArtifactOutputElementBuilder.$$$reportNull$$$0(1);
            }
            for (ArtifactLayoutCustomizationService service : JpsServiceManager.getInstance().getExtensions(ArtifactLayoutCustomizationService.class)) {
                List<JpsPackagingElement> elements = service.getCustomizedLayout(artifact, parentArtifacts);
                if (elements == null) continue;
                return elements;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "artifact";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentArtifacts";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/incremental/artifacts/builders/LayoutElementBuildersRegistry$ArtifactOutputElementBuilder";
            objectArray[2] = "getCustomArtifactLayout";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ComplexElementBuilder
    extends LayoutElementBuilderService<JpsComplexPackagingElement> {
        public ComplexElementBuilder() {
            super(JpsComplexPackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsComplexPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            LayoutElementBuildersRegistry.this.generateSubstitutionInstructions(element, instructionCreator, builderContext);
        }
    }

    private static class ModuleTestOutputElementBuilder
    extends LayoutElementBuilderService<JpsTestModuleOutputPackagingElement> {
        public ModuleTestOutputElementBuilder() {
            super(JpsTestModuleOutputPackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsTestModuleOutputPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            LayoutElementBuildersRegistry.generateModuleOutputInstructions(element.getOutputUrl(), instructionCreator, (JpsPackagingElement)element);
        }

        @Override
        public Collection<? extends BuildTarget<?>> getDependencies(@NotNull JpsTestModuleOutputPackagingElement element, TargetOutputIndex outputIndex) {
            JpsModule module;
            if (element == null) {
                ModuleTestOutputElementBuilder.$$$reportNull$$$0(0);
            }
            if ((module = (JpsModule)element.getModuleReference().resolve()) != null) {
                return Collections.singletonList(new ModuleBuildTarget(module, JavaModuleBuildTargetType.TEST));
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/incremental/artifacts/builders/LayoutElementBuildersRegistry$ModuleTestOutputElementBuilder", "getDependencies"));
        }
    }

    private static class ModuleSourceElementBuilder
    extends LayoutElementBuilderService<JpsProductionModuleSourcePackagingElement> {
        public ModuleSourceElementBuilder() {
            super(JpsProductionModuleSourcePackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsProductionModuleSourcePackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            JpsModule module = (JpsModule)element.getModuleReference().resolve();
            if (module != null) {
                LayoutElementBuildersRegistry.generateModuleSourceInstructions(module.getSourceRoots(), instructionCreator, (JpsPackagingElement)element);
            }
        }

        @Override
        public Collection<? extends BuildTarget<?>> getDependencies(@NotNull JpsProductionModuleSourcePackagingElement element, TargetOutputIndex outputIndex) {
            if (element == null) {
                ModuleSourceElementBuilder.$$$reportNull$$$0(0);
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/incremental/artifacts/builders/LayoutElementBuildersRegistry$ModuleSourceElementBuilder", "getDependencies"));
        }
    }

    private static class ModuleOutputElementBuilder
    extends LayoutElementBuilderService<JpsProductionModuleOutputPackagingElement> {
        public ModuleOutputElementBuilder() {
            super(JpsProductionModuleOutputPackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsProductionModuleOutputPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            LayoutElementBuildersRegistry.generateModuleOutputInstructions(element.getOutputUrl(), instructionCreator, (JpsPackagingElement)element);
        }

        @Override
        public Collection<? extends BuildTarget<?>> getDependencies(@NotNull JpsProductionModuleOutputPackagingElement element, TargetOutputIndex outputIndex) {
            JpsModule module;
            if (element == null) {
                ModuleOutputElementBuilder.$$$reportNull$$$0(0);
            }
            if ((module = (JpsModule)element.getModuleReference().resolve()) != null) {
                return Collections.singletonList(new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/incremental/artifacts/builders/LayoutElementBuildersRegistry$ModuleOutputElementBuilder", "getDependencies"));
        }
    }

    private static class ExtractedDirectoryElementBuilder
    extends LayoutElementBuilderService<JpsExtractedDirectoryPackagingElement> {
        public ExtractedDirectoryElementBuilder() {
            super(JpsExtractedDirectoryPackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsExtractedDirectoryPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            String jarPath = element.getFilePath();
            String pathInJar = element.getPathInJar();
            instructionCreator.addExtractDirectoryInstruction(new File(jarPath), pathInJar);
        }
    }

    private static class FileCopyElementBuilder
    extends LayoutElementBuilderService<JpsFileCopyPackagingElement> {
        public FileCopyElementBuilder() {
            super(JpsFileCopyPackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsFileCopyPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            String filePath = element.getFilePath();
            if (filePath != null) {
                File file = new File(filePath);
                String fileName = element.getRenamedOutputFileName();
                String outputFileName = fileName != null ? fileName : file.getName();
                instructionCreator.addFileCopyInstruction(file, outputFileName, instructionCreator.getInstructionsBuilder().createCopyingHandler(file, (JpsPackagingElement)element, instructionCreator));
            }
        }

        @Override
        public Collection<? extends BuildTarget<?>> getDependencies(@NotNull JpsFileCopyPackagingElement element, TargetOutputIndex outputIndex) {
            String filePath;
            if (element == null) {
                FileCopyElementBuilder.$$$reportNull$$$0(0);
            }
            if ((filePath = element.getFilePath()) != null) {
                return outputIndex.getTargetsByOutputFile(new File(filePath));
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/incremental/artifacts/builders/LayoutElementBuildersRegistry$FileCopyElementBuilder", "getDependencies"));
        }
    }

    private static class DirectoryCopyElementBuilder
    extends LayoutElementBuilderService<JpsDirectoryCopyPackagingElement> {
        public DirectoryCopyElementBuilder() {
            super(JpsDirectoryCopyPackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsDirectoryCopyPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            String dirPath = element.getDirectoryPath();
            if (dirPath != null) {
                File directory = new File(dirPath);
                instructionCreator.addDirectoryCopyInstructions(directory, null, instructionCreator.getInstructionsBuilder().createCopyingHandler(directory, (JpsPackagingElement)element, instructionCreator));
            }
        }

        @Override
        public Collection<? extends BuildTarget<?>> getDependencies(@NotNull JpsDirectoryCopyPackagingElement element, TargetOutputIndex outputIndex) {
            String dirPath;
            if (element == null) {
                DirectoryCopyElementBuilder.$$$reportNull$$$0(0);
            }
            if ((dirPath = element.getDirectoryPath()) != null) {
                return outputIndex.getTargetsByOutputFile(new File(dirPath));
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/incremental/artifacts/builders/LayoutElementBuildersRegistry$DirectoryCopyElementBuilder", "getDependencies"));
        }
    }

    private class ArchiveElementBuilder
    extends LayoutElementBuilderService<JpsArchivePackagingElement> {
        public ArchiveElementBuilder() {
            super(JpsArchivePackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsArchivePackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            LayoutElementBuildersRegistry.this.generateChildrenInstructions((JpsCompositePackagingElement)element, instructionCreator.archive(element.getArchiveName()), builderContext);
        }
    }

    private class DirectoryElementBuilder
    extends LayoutElementBuilderService<JpsDirectoryPackagingElement> {
        public DirectoryElementBuilder() {
            super(JpsDirectoryPackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsDirectoryPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            LayoutElementBuildersRegistry.this.generateChildrenInstructions((JpsCompositePackagingElement)element, instructionCreator.subFolder(element.getDirectoryName()), builderContext);
        }
    }

    private class RootElementBuilder
    extends LayoutElementBuilderService<JpsArtifactRootElement> {
        public RootElementBuilder() {
            super(JpsArtifactRootElement.class);
        }

        @Override
        public void generateInstructions(JpsArtifactRootElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            LayoutElementBuildersRegistry.this.generateChildrenInstructions((JpsCompositePackagingElement)element, instructionCreator, builderContext);
        }
    }

    private static class InstanceHolder {
        static final LayoutElementBuildersRegistry ourInstance = new LayoutElementBuildersRegistry();

        private InstanceHolder() {
        }
    }
}

