/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.PathStringDescriptor;

public class ArtifactOutputToSourceMapping
extends AbstractStateStorage<String, List<SourcePathAndRootIndex>> {
    public ArtifactOutputToSourceMapping(File storePath) throws IOException {
        super(storePath, PathStringDescriptor.INSTANCE, new SourcePathListExternalizer());
    }

    @Override
    public void update(String path, @Nullable List<SourcePathAndRootIndex> state) throws IOException {
        super.update(FileUtil.toSystemIndependentName((String)path), state);
    }

    @Override
    public void appendData(String path, List<SourcePathAndRootIndex> data) throws IOException {
        super.appendData(FileUtil.toSystemIndependentName((String)path), data);
    }

    public void appendData(String outputPath, int rootIndex, String sourcePath) throws IOException {
        super.appendData(outputPath, Collections.singletonList(new SourcePathAndRootIndex(sourcePath, rootIndex)));
    }

    @Override
    public void remove(String path) throws IOException {
        super.remove(FileUtil.toSystemIndependentName((String)path));
    }

    @Override
    @Nullable
    public List<SourcePathAndRootIndex> getState(String path) throws IOException {
        return (List)super.getState(FileUtil.toSystemIndependentName((String)path));
    }

    private static class SourcePathListExternalizer
    implements DataExternalizer<List<SourcePathAndRootIndex>> {
        private SourcePathListExternalizer() {
        }

        public void save(@NotNull DataOutput out, List<SourcePathAndRootIndex> value) throws IOException {
            if (out == null) {
                SourcePathListExternalizer.$$$reportNull$$$0(0);
            }
            for (SourcePathAndRootIndex pair : value) {
                IOUtil.writeUTF((DataOutput)out, (String)pair.myPath);
                out.writeInt(pair.getRootIndex());
            }
        }

        public List<SourcePathAndRootIndex> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                SourcePathListExternalizer.$$$reportNull$$$0(1);
            }
            SmartList result = new SmartList();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                String path = IOUtil.readUTF((DataInput)stream);
                int index = stream.readInt();
                result.add(new SourcePathAndRootIndex(path, index));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/ArtifactOutputToSourceMapping$SourcePathListExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SourcePathAndRootIndex {
        private final String myPath;
        private final int myRootIndex;

        private SourcePathAndRootIndex(String path, int rootIndex) {
            this.myPath = FileUtil.toSystemIndependentName((String)path);
            this.myRootIndex = rootIndex;
        }

        public String getPath() {
            return this.myPath;
        }

        public int getRootIndex() {
            return this.myRootIndex;
        }
    }
}

