/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Predicate;
import com.intellij.util.io.MappingFailedException;
import com.intellij.util.io.PersistentEnumeratorBase;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.TimingLog;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.impl.BuildOutputConsumerImpl;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.java.JavaBuilderExtension;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuildListener;
import org.jetbrains.jps.incremental.BuildOperations;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.Builder;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.ChainedTargetsBuildListener;
import org.jetbrains.jps.incremental.ChunkBuildOutputConsumerImpl;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompileContextImpl;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.CompositeConstantResolver;
import org.jetbrains.jps.incremental.FSCache;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.MessageHandler;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.RebuildRequestedException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.fs.FilesDelta;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.BuilderStatisticsMessage;
import org.jetbrains.jps.incremental.messages.BuildingTargetProgressMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.DoneSomethingNotification;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.messages.UnprocessedFSChangesNotification;
import org.jetbrains.jps.incremental.storage.BuildTargetConfiguration;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;
import org.jetbrains.jps.incremental.storage.OutputToTargetRegistry;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingImpl;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.javac.ExternalJavacManager;
import org.jetbrains.jps.javac.JavacMain;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.service.SharedThreadPool;
import org.jetbrains.jps.util.JpsPathUtil;

public class IncProjectBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.IncProjectBuilder");
    private static final String CLASSPATH_INDEX_FILE_NAME = "classpath.index";
    private static final boolean SYNC_DELETE = Boolean.parseBoolean(System.getProperty("jps.sync.delete", "false"));
    private static final GlobalContextKey<Set<BuildTarget<?>>> TARGET_WITH_CLEARED_OUTPUT = GlobalContextKey.create("_targets_with_cleared_output_");
    public static final int MAX_BUILDER_THREADS;
    private final ProjectDescriptor myProjectDescriptor;
    private final BuilderRegistry myBuilderRegistry;
    private final Map<String, String> myBuilderParams;
    private final CanceledStatus myCancelStatus;
    @Nullable
    private final Callbacks.ConstantAffectionResolver myJavaConstantResolver;
    private final List<MessageHandler> myMessageHandlers = new ArrayList<MessageHandler>();
    private final MessageHandler myMessageDispatcher = new MessageHandler(){

        @Override
        public void processMessage(BuildMessage msg) {
            for (MessageHandler h : IncProjectBuilder.this.myMessageHandlers) {
                h.processMessage(msg);
            }
        }
    };
    private final boolean myIsTestMode;
    private volatile float myTargetsProcessed = 0.0f;
    private volatile float myTotalTargetsWork;
    private final int myTotalModuleLevelBuilderCount;
    private final List<Future> myAsyncTasks = Collections.synchronizedList(new ArrayList());
    private final ConcurrentMap<Builder, AtomicLong> myElapsedTimeNanosByBuilder = ContainerUtil.newConcurrentMap();
    private final ConcurrentMap<Builder, AtomicInteger> myNumberOfSourcesProcessedByBuilder = ContainerUtil.newConcurrentMap();

    public IncProjectBuilder(ProjectDescriptor pd, BuilderRegistry builderRegistry, Map<String, String> builderParams, CanceledStatus cs, @Nullable Callbacks.ConstantAffectionResolver javaConstantResolver, boolean isTestMode) {
        this.myProjectDescriptor = pd;
        this.myBuilderRegistry = builderRegistry;
        this.myBuilderParams = builderParams;
        this.myCancelStatus = cs;
        this.myJavaConstantResolver = javaConstantResolver;
        this.myTotalTargetsWork = pd.getBuildTargetIndex().getAllTargets().size();
        this.myTotalModuleLevelBuilderCount = builderRegistry.getModuleLevelBuilderCount();
        this.myIsTestMode = isTestMode;
    }

    public void addMessageHandler(MessageHandler handler) {
        this.myMessageHandlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkUpToDate(CompileScope scope) {
        CompileContextImpl context = null;
        try {
            context = this.createContext(scope);
            BuildFSState fsState = this.myProjectDescriptor.fsState;
            for (BuildTarget<?> target : this.myProjectDescriptor.getBuildTargetIndex().getAllTargets()) {
                if (!scope.isAffected(target)) continue;
                BuildOperations.ensureFSStateInitialized(context, target);
                FilesDelta delta = fsState.getEffectiveFilesDelta(context, target);
                delta.lockData();
                try {
                    for (Set<File> files : delta.getSourcesToRecompile().values()) {
                        for (File file : files) {
                            if (!scope.isAffected(target, file)) continue;
                            this.myMessageDispatcher.processMessage(DoneSomethingNotification.INSTANCE);
                            return;
                        }
                    }
                }
                finally {
                    delta.unlockData();
                }
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            this.myMessageDispatcher.processMessage(DoneSomethingNotification.INSTANCE);
        }
        finally {
            if (context != null) {
                IncProjectBuilder.flushContext(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(CompileScope scope, boolean forceCleanCaches) throws RebuildRequestedException {
        memWatcher = LowMemoryWatcher.register((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$build$0(), ()V)((IncProjectBuilder)this));
        this.startTempDirectoryCleanupTask();
        context = null;
        try {
            context = this.createContext(scope);
            this.runBuild(context, forceCleanCaches);
            this.myProjectDescriptor.dataManager.saveVersion();
            IncProjectBuilder.reportRebuiltModules(context);
            IncProjectBuilder.reportUnprocessedChanges(context);
        }
        catch (StopBuildException e) {
            block31: {
                IncProjectBuilder.reportRebuiltModules(context);
                IncProjectBuilder.reportUnprocessedChanges(context);
                msg = e.getMessage();
                if (StringUtil.isEmptyOrSpaces((String)msg)) break block31;
                this.myMessageDispatcher.processMessage(new ProgressMessage((String)msg));
            }
            memWatcher.stop();
            IncProjectBuilder.flushContext(context);
            status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
            msg = this.myAsyncTasks;
            synchronized (msg) {
                var7_17 = this.myAsyncTasks.iterator();
                while (var7_17.hasNext() != false) {
                    task = var7_17.next();
                    if (status.isCanceled()) {
                        return;
                    }
                    IncProjectBuilder.waitForTask(status, task);
                }
                return;
            }
            catch (BuildDataCorruptedException e) {
                IncProjectBuilder.LOG.info((Throwable)e);
                this.requestRebuild(e, e);
                memWatcher.stop();
                IncProjectBuilder.flushContext(context);
                status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
                msg = this.myAsyncTasks;
                synchronized (msg) {
                    var7_18 = this.myAsyncTasks.iterator();
                    while (var7_18.hasNext() != false) {
                        task = var7_18.next();
                        if (status.isCanceled()) {
                            return;
                        }
                        IncProjectBuilder.waitForTask(status, task);
                    }
                    return;
                }
                catch (ProjectBuildException e) {
                    block32: {
                        try {
                            IncProjectBuilder.LOG.info((Throwable)e);
                            cause = e.getCause();
                            if (cause instanceof PersistentEnumeratorBase.CorruptedException || cause instanceof MappingFailedException || cause instanceof IOException || cause instanceof BuildDataCorruptedException || cause instanceof RuntimeException && cause.getCause() instanceof IOException) {
                                this.requestRebuild(e, cause);
                                break block32;
                            }
                            errMessage = e.getMessage();
                            if (StringUtil.isEmptyOrSpaces((String)errMessage)) {
                                msg = new CompilerMessage("", cause != null ? cause : e);
                            } else {
                                causeMessage = cause != null ? cause.getMessage() : "";
                                msg = new CompilerMessage("", BuildMessage.Kind.ERROR, StringUtil.isEmptyOrSpaces((String)causeMessage) != false || errMessage.trim().endsWith(causeMessage) != false ? errMessage : errMessage + ": " + causeMessage);
                            }
                            this.myMessageDispatcher.processMessage(msg);
                        }
                        catch (Throwable var13_25) {
                            memWatcher.stop();
                            IncProjectBuilder.flushContext(context);
                            status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
                            var15_27 = this.myAsyncTasks;
                            synchronized (var15_27) {
                                ** break block33
                            }
lbl-1000:
                            // 2 sources

                            {
                                while (var7_16.hasNext() != false) {
                                    task = var7_16.next();
                                    if (status.isCanceled()) {
                                        return;
                                    }
                                    IncProjectBuilder.waitForTask(status, task);
                                }
                                return;
                            }
lbl-1000:
                            // 2 sources

                            {
                                while (var7_19.hasNext() != false) {
                                    task = var7_19.next();
                                    if (status.isCanceled()) {
                                        return;
                                    }
                                    IncProjectBuilder.waitForTask(status, task);
                                }
                                return;
                            }
lbl-1000:
                            // 1 sources

                            {
                                var16_28 = this.myAsyncTasks.iterator();
                                while (var16_28.hasNext() != false) {
                                    task = var16_28.next();
                                    if (status.isCanceled()) {
                                        throw var13_25;
                                    }
                                    IncProjectBuilder.waitForTask(status, task);
                                }
                                throw var13_25;
                            }
                        }
                    }
                    memWatcher.stop();
                    IncProjectBuilder.flushContext(context);
                    status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
                    var6_15 = this.myAsyncTasks;
                    synchronized (var6_15) {
                        var7_19 = this.myAsyncTasks.iterator();
                        ** GOTO lbl-1000
                    }
                }
            }
        }
        memWatcher.stop();
        IncProjectBuilder.flushContext(context);
        status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
        var6_12 = this.myAsyncTasks;
        synchronized (var6_12) {
            var7_16 = this.myAsyncTasks.iterator();
            ** GOTO lbl-1000
        }
    }

    private void requestRebuild(Exception e, Throwable cause) throws RebuildRequestedException {
        this.myMessageDispatcher.processMessage(new CompilerMessage("", BuildMessage.Kind.INFO, "Internal caches are corrupted or have outdated format, forcing project rebuild: " + e.getMessage()));
        throw new RebuildRequestedException(cause);
    }

    private static void waitForTask(@NotNull CanceledStatus status, Future task) {
        if (status == null) {
            IncProjectBuilder.$$$reportNull$$$0(0);
        }
        try {
            while (true) {
                try {
                    task.get(500L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ignored) {
                    if (!status.isCanceled()) continue;
                }
                break;
            }
        }
        catch (Throwable th) {
            LOG.info(th);
        }
    }

    private static void reportRebuiltModules(CompileContextImpl context) {
        Set modules = (Set)BuildTargetConfiguration.MODULES_WITH_TARGET_CONFIG_CHANGED_KEY.get((UserDataHolder)context);
        if (modules == null || modules.isEmpty()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        if (modules.size() > 1) {
            message.append("Modules ");
            int namesLimit = 5;
            int idx = 0;
            Iterator iterator = modules.iterator();
            while (iterator.hasNext()) {
                JpsModule module = (JpsModule)iterator.next();
                if (idx == 5 && iterator.hasNext()) {
                    message.append(" and ").append(modules.size() - 5).append(" others");
                    break;
                }
                if (idx > 0) {
                    message.append(", ");
                }
                message.append("\"").append(module.getName()).append("\"");
                ++idx;
            }
            message.append(" were");
        } else {
            message.append("Module \"").append(((JpsModule)modules.iterator().next()).getName()).append("\" was");
        }
        message.append(" fully rebuilt due to project configuration");
        if (ModuleBuildTarget.REBUILD_ON_DEPENDENCY_CHANGE.booleanValue()) {
            message.append("/dependencies");
        }
        message.append(" changes");
        context.processMessage(new CompilerMessage("", BuildMessage.Kind.INFO, message.toString()));
    }

    private static void reportUnprocessedChanges(CompileContextImpl context) {
        ProjectDescriptor pd = context.getProjectDescriptor();
        BuildFSState fsState = pd.fsState;
        for (BuildTarget<?> target : pd.getBuildTargetIndex().getAllTargets()) {
            if (!fsState.hasUnprocessedChanges(context, target)) continue;
            context.processMessage(new UnprocessedFSChangesNotification());
            break;
        }
    }

    private static void flushContext(CompileContext context) {
        ExternalJavacManager server;
        if (context != null) {
            ProjectDescriptor pd = context.getProjectDescriptor();
            pd.timestamps.getStorage().force();
            pd.dataManager.flush(false);
        }
        if ((server = (ExternalJavacManager)ExternalJavacManager.KEY.get(context)) != null) {
            server.stop();
            ExternalJavacManager.KEY.set(context, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(CompileContextImpl context, boolean forceCleanCaches) throws ProjectBuildException {
        context.setDone(0.0f);
        LOG.info("Building project; isRebuild:" + context.isProjectRebuild() + "; isMake:" + context.isMake() + " parallel compilation:" + BuildRunner.PARALLEL_BUILD_ENABLED);
        context.addBuildListener(new ChainedTargetsBuildListener(context));
        context.addBuildListener(new BuildListener(){

            @Override
            public void filesGenerated(FileGeneratedEvent event) {
                THashSet outputs = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                for (Pair<String, String> pair : event.getPaths()) {
                    outputs.add(new File((String)pair.getFirst()));
                }
                for (File root : outputs) {
                    new File(root, IncProjectBuilder.CLASSPATH_INDEX_FILE_NAME).delete();
                }
            }

            @Override
            public void filesDeleted(FileDeletedEvent event) {
            }
        });
        for (TargetBuilder<?, ?> targetBuilder : this.myBuilderRegistry.getTargetBuilders()) {
            targetBuilder.buildStarted(context);
        }
        for (ModuleLevelBuilder moduleLevelBuilder : this.myBuilderRegistry.getModuleLevelBuilders()) {
            moduleLevelBuilder.buildStarted(context);
        }
        try {
            this.cleanOutputRoots(context, context.isProjectRebuild() || forceCleanCaches);
            context.processMessage(new ProgressMessage("Running 'before' tasks"));
            IncProjectBuilder.runTasks(context, this.myBuilderRegistry.getBeforeTasks());
            TimingLog.LOG.debug("'before' tasks finished");
            context.processMessage(new ProgressMessage("Checking sources"));
            this.buildChunks(context);
            TimingLog.LOG.debug("Building targets finished");
            context.processMessage(new ProgressMessage("Running 'after' tasks"));
            IncProjectBuilder.runTasks(context, this.myBuilderRegistry.getAfterTasks());
            TimingLog.LOG.debug("'after' tasks finished");
            this.sendElapsedTimeMessages(context);
        }
        catch (Throwable throwable) {
            for (TargetBuilder<?, ?> targetBuilder : this.myBuilderRegistry.getTargetBuilders()) {
                targetBuilder.buildFinished(context);
            }
            for (ModuleLevelBuilder moduleLevelBuilder : this.myBuilderRegistry.getModuleLevelBuilders()) {
                moduleLevelBuilder.buildFinished(context);
            }
            context.processMessage(new ProgressMessage("Finished, saving caches..."));
            throw throwable;
        }
        for (TargetBuilder targetBuilder : this.myBuilderRegistry.getTargetBuilders()) {
            targetBuilder.buildFinished(context);
        }
        for (ModuleLevelBuilder moduleLevelBuilder : this.myBuilderRegistry.getModuleLevelBuilders()) {
            moduleLevelBuilder.buildFinished(context);
        }
        context.processMessage(new ProgressMessage("Finished, saving caches..."));
    }

    private void sendElapsedTimeMessages(CompileContext context) {
        for (Map.Entry entry : this.myElapsedTimeNanosByBuilder.entrySet()) {
            AtomicInteger processedSourcesRef = (AtomicInteger)this.myNumberOfSourcesProcessedByBuilder.get(entry.getKey());
            int processedSources = processedSourcesRef != null ? processedSourcesRef.get() : 0;
            context.processMessage(new BuilderStatisticsMessage(((Builder)entry.getKey()).getPresentableName(), processedSources, ((AtomicLong)entry.getValue()).get() / 1000000L));
        }
    }

    private void startTempDirectoryCleanupTask() {
        String tempPath = System.getProperty("java.io.tmpdir", null);
        if (StringUtil.isEmptyOrSpaces((String)tempPath)) {
            return;
        }
        File tempDir = new File(tempPath);
        File dataRoot = this.myProjectDescriptor.dataManager.getDataPaths().getDataStorageRoot();
        if (!FileUtil.isAncestor((File)dataRoot, (File)tempDir, (boolean)true)) {
            return;
        }
        File[] files = tempDir.listFiles();
        if (files != null && files.length != 0) {
            FutureTask<Object> task = new FutureTask<Object>(() -> {
                for (File tempFile : files) {
                    FileUtil.delete((File)tempFile);
                }
            }, null);
            Thread thread = new Thread(task, "Temp directory cleanup");
            thread.setPriority(1);
            thread.setDaemon(true);
            thread.start();
            this.myAsyncTasks.add(task);
        }
    }

    private CompileContextImpl createContext(CompileScope scope) throws ProjectBuildException {
        CompileContextImpl context = new CompileContextImpl(scope, this.myProjectDescriptor, this.myMessageDispatcher, this.myBuilderParams, this.myCancelStatus);
        this.myProjectDescriptor.setFSCache(context.isProjectRebuild() ? FSCache.NO_CACHE : new FSCache());
        Callbacks.ConstantAffectionResolver javaResolver = this.myJavaConstantResolver;
        if (javaResolver == null) {
            JavaBuilderUtil.CONSTANT_SEARCH_SERVICE.set((UserDataHolder)context, null);
        } else {
            SmartList<Callbacks.ConstantAffectionResolver> resolvers = this.getResolvers();
            resolvers.add(javaResolver);
            for (JavaBuilderExtension provider : JpsServiceManager.getInstance().getExtensions(JavaBuilderExtension.class)) {
                Callbacks.ConstantAffectionResolver extResolver = provider.getConstantSearch(context);
                if (extResolver == null) continue;
                resolvers.add(extResolver);
            }
            JavaBuilderUtil.CONSTANT_SEARCH_SERVICE.set((UserDataHolder)context, (Object)(resolvers.size() == 1 ? (Callbacks.ConstantAffectionResolver)resolvers.get(0) : new CompositeConstantResolver((Collection<Callbacks.ConstantAffectionResolver>)resolvers)));
        }
        return context;
    }

    @NotNull
    private SmartList<Callbacks.ConstantAffectionResolver> getResolvers() {
        SmartList smartList = new SmartList();
        if (smartList == null) {
            IncProjectBuilder.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanOutputRoots(CompileContext context, boolean cleanCaches) throws ProjectBuildException {
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        ProjectBuildException ex = null;
        try {
            JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(projectDescriptor.getProject());
            boolean shouldClear = configuration.isClearOutputDirectoryOnRebuild();
            if (shouldClear) {
                this.clearOutputs(context);
            } else {
                for (BuildTarget buildTarget : projectDescriptor.getBuildTargetIndex().getAllTargets()) {
                    context.checkCanceled();
                    if (!context.getScope().isBuildForced(buildTarget)) continue;
                    IncProjectBuilder.clearOutputFilesUninterruptibly(context, buildTarget);
                }
            }
            for (BuildTargetType buildTargetType : TargetTypeRegistry.getInstance().getTargetTypes()) {
                if (!context.getScope().isAllTargetsOfTypeAffected(buildTargetType)) continue;
                this.cleanOutputOfStaleTargets(buildTargetType, context);
            }
            return;
        }
        catch (ProjectBuildException e) {
            ex = e;
        }
        finally {
            if (!cleanCaches) return;
            try {
                projectDescriptor.timestamps.getStorage().clean();
            }
            catch (IOException e) {
                if (ex == null) {
                    ex = new ProjectBuildException("Error cleaning timestamps storage", e);
                }
                LOG.info("Error cleaning timestamps storage", (Throwable)e);
            }
            finally {
                try {
                    projectDescriptor.dataManager.clean();
                }
                catch (IOException e) {
                    if (ex == null) {
                        ex = new ProjectBuildException("Error cleaning compiler storages", e);
                    }
                    LOG.info("Error cleaning compiler storages", (Throwable)e);
                }
                finally {
                    projectDescriptor.fsState.clearAll();
                    if (ex == null) return;
                    throw ex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOutputOfStaleTargets(BuildTargetType<?> type, CompileContext context) {
        List<Pair<String, Integer>> targetIds = this.myProjectDescriptor.dataManager.getTargetsState().getStaleTargetIds(type);
        if (targetIds.isEmpty()) {
            return;
        }
        context.processMessage(new ProgressMessage("Cleaning old output directories..."));
        for (Pair<String, Integer> ids : targetIds) {
            String stringId = (String)ids.first;
            try {
                try (SourceToOutputMappingImpl mapping = null;){
                    mapping = this.myProjectDescriptor.dataManager.createSourceToOutputMapForStaleTarget(type, stringId);
                    IncProjectBuilder.clearOutputFiles(context, mapping, type, (Integer)ids.second);
                }
                FileUtil.delete((File)this.myProjectDescriptor.dataManager.getDataPaths().getTargetDataRoot(type, stringId));
                this.myProjectDescriptor.dataManager.getTargetsState().cleanStaleTarget(type, stringId);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                this.myMessageDispatcher.processMessage(new CompilerMessage("", BuildMessage.Kind.WARNING, "Failed to delete output files from obsolete '" + stringId + "' target: " + e.toString()));
            }
        }
    }

    public static void clearOutputFiles(CompileContext context, BuildTarget<?> target) throws IOException {
        SourceToOutputMapping map = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target);
        BuildTargetType<?> targetType = target.getTargetType();
        IncProjectBuilder.clearOutputFiles(context, map, targetType, context.getProjectDescriptor().dataManager.getTargetsState().getBuildTargetId(target));
        IncProjectBuilder.registerTargetsWithClearedOutput(context, Collections.singletonList(target));
    }

    private static void clearOutputFiles(CompileContext context, SourceToOutputMapping mapping, BuildTargetType<?> targetType, int targetId) throws IOException {
        THashSet dirsToDelete = targetType instanceof ModuleBasedBuildTargetType ? new THashSet(FileUtil.FILE_HASHING_STRATEGY) : null;
        OutputToTargetRegistry outputToTargetRegistry = context.getProjectDescriptor().dataManager.getOutputToTargetRegistry();
        for (String srcPath : mapping.getSources()) {
            Collection<String> outs = mapping.getOutputs(srcPath);
            if (outs == null || outs.isEmpty()) continue;
            ArrayList<String> deletedPaths = new ArrayList<String>();
            for (String out : outs) {
                BuildOperations.deleteRecursively(out, deletedPaths, (Set<File>)dirsToDelete);
            }
            outputToTargetRegistry.removeMapping(outs, targetId);
            if (deletedPaths.isEmpty()) continue;
            context.processMessage(new FileDeletedEvent(deletedPaths));
        }
        if (dirsToDelete != null) {
            FSOperations.pruneEmptyDirs(context, (Set<File>)dirsToDelete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerTargetsWithClearedOutput(CompileContext context, Collection<? extends BuildTarget<?>> targets) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGET_WITH_CLEARED_OUTPUT;
        synchronized (globalContextKey) {
            Set data = (Set)context.getUserData(TARGET_WITH_CLEARED_OUTPUT);
            if (data == null) {
                data = new THashSet();
                context.putUserData(TARGET_WITH_CLEARED_OUTPUT, data);
            }
            data.addAll(targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTargetOutputCleared(CompileContext context, BuildTarget<?> target) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGET_WITH_CLEARED_OUTPUT;
        synchronized (globalContextKey) {
            Set data = (Set)context.getUserData(TARGET_WITH_CLEARED_OUTPUT);
            return data != null && data.contains(target);
        }
    }

    private void clearOutputs(CompileContext context) throws ProjectBuildException {
        long cleanStart = System.currentTimeMillis();
        MultiMap rootsToDelete = MultiMap.createSet();
        THashSet allSourceRoots = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.FILE_HASHING_STRATEGY);
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        List<BuildTarget<?>> allTargets = projectDescriptor.getBuildTargetIndex().getAllTargets();
        for (BuildTarget<?> target : allTargets) {
            if (target instanceof ModuleBasedTarget) {
                for (File file : target.getOutputRoots(context)) {
                    rootsToDelete.putValue((Object)file, (Object)target);
                }
                continue;
            }
            if (!context.getScope().isBuildForced(target)) continue;
            IncProjectBuilder.clearOutputFilesUninterruptibly(context, target);
        }
        ModuleExcludeIndex moduleIndex = projectDescriptor.getModuleExcludeIndex();
        for (BuildTarget buildTarget : allTargets) {
            for (BuildRootDescriptor descriptor : projectDescriptor.getBuildRootIndex().getTargetRoots(buildTarget, context)) {
                File rootFile;
                if (descriptor.isGenerated() || !moduleIndex.isInContent(rootFile = descriptor.getRootFile())) continue;
                allSourceRoots.add(rootFile);
            }
        }
        CompileScope compileScope = context.getScope();
        ArrayList<File> arrayList = new ArrayList<File>();
        Predicate predicate = input -> compileScope.isBuildForced((BuildTarget<?>)input);
        for (Map.Entry entry : rootsToDelete.entrySet()) {
            boolean okToDelete;
            context.checkCanceled();
            File outputRoot = (File)entry.getKey();
            Collection rootTargets = (Collection)entry.getValue();
            Applicability applicability = Applicability.calculate(predicate, rootTargets);
            if (applicability == Applicability.NONE) continue;
            boolean bl = okToDelete = applicability == Applicability.ALL;
            if (okToDelete && !moduleIndex.isExcluded(outputRoot)) {
                if (JpsPathUtil.isUnder((Set)allSourceRoots, (File)outputRoot)) {
                    okToDelete = false;
                } else {
                    THashSet _outRoot = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.FILE_HASHING_STRATEGY, (Object[])new File[]{outputRoot});
                    for (File srcRoot : allSourceRoots) {
                        if (!JpsPathUtil.isUnder((Set)_outRoot, (File)srcRoot)) continue;
                        okToDelete = false;
                        break;
                    }
                }
            }
            if (okToDelete) {
                File[] children = outputRoot.listFiles();
                if (children != null) {
                    for (File child : children) {
                        if (child.delete()) continue;
                        arrayList.add(child);
                    }
                } else if (!outputRoot.delete()) {
                    arrayList.add(outputRoot);
                }
                IncProjectBuilder.registerTargetsWithClearedOutput(context, rootTargets);
                continue;
            }
            if (applicability == Applicability.ALL) {
                context.processMessage(new CompilerMessage("", BuildMessage.Kind.WARNING, "Output path " + outputRoot.getPath() + " intersects with a source root. Only files that were created by build will be cleaned."));
            }
            context.processMessage(new ProgressMessage("Cleaning output directories..."));
            for (BuildTarget target : rootTargets) {
                if (!compileScope.isBuildForced(target)) continue;
                IncProjectBuilder.clearOutputFilesUninterruptibly(context, target);
            }
        }
        if (!arrayList.isEmpty()) {
            context.processMessage(new ProgressMessage("Cleaning output directories..."));
            if (SYNC_DELETE) {
                for (File file : arrayList) {
                    context.checkCanceled();
                    FileUtil.delete((File)file);
                }
            } else {
                this.myAsyncTasks.add(FileUtil.asyncDelete(arrayList));
            }
        }
        LOG.info("Cleaned output directories in " + (System.currentTimeMillis() - cleanStart) + " ms");
    }

    private static void clearOutputFilesUninterruptibly(CompileContext context, BuildTarget<?> target) {
        try {
            IncProjectBuilder.clearOutputFiles(context, target);
        }
        catch (Throwable e) {
            LOG.info(e);
            String reason = e.getMessage();
            if (reason == null) {
                reason = e.getClass().getName();
            }
            context.processMessage(new CompilerMessage("", BuildMessage.Kind.WARNING, "Problems clearing output files for target \"" + target.getPresentableName() + "\": " + reason));
        }
    }

    private static void runTasks(CompileContext context, List<BuildTask> tasks) throws ProjectBuildException {
        for (BuildTask task : tasks) {
            task.build(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildChunks(CompileContextImpl context) throws ProjectBuildException {
        try {
            CompileScope scope = context.getScope();
            ProjectDescriptor pd = context.getProjectDescriptor();
            BuildTargetIndex targetIndex = pd.getBuildTargetIndex();
            int totalAffected = 0;
            for (BuildTargetChunk chunk : targetIndex.getSortedTargetChunks(context)) {
                if (!IncProjectBuilder.isAffected(context.getScope(), chunk)) continue;
                totalAffected += chunk.getTargets().size();
            }
            this.myTotalTargetsWork = totalAffected;
            boolean compileInParallel = BuildRunner.PARALLEL_BUILD_ENABLED;
            if (compileInParallel && MAX_BUILDER_THREADS <= 1) {
                LOG.info("Switched off parallel compilation because maximum number of builder threads is less than 2. Set 'compile.parallel.max.threads' system property to a value greater than 1 to really enable parallel compilation.");
                compileInParallel = false;
            }
            if (compileInParallel) {
                new BuildParallelizer(context).buildInParallel();
            } else {
                for (BuildTargetChunk chunk : targetIndex.getSortedTargetChunks(context)) {
                    try {
                        this.buildChunkIfAffected(context, scope, chunk);
                    }
                    finally {
                        pd.dataManager.closeSourceToOutputStorages(Collections.singleton(chunk));
                        pd.dataManager.flush(true);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
    }

    private void buildChunkIfAffected(CompileContext context, CompileScope scope, BuildTargetChunk chunk) throws ProjectBuildException {
        if (IncProjectBuilder.isAffected(scope, chunk)) {
            this.buildTargetsChunk(context, chunk);
        }
    }

    private static boolean isAffected(CompileScope scope, BuildTargetChunk chunk) {
        for (BuildTarget<?> target : chunk.getTargets()) {
            if (!scope.isAffected(target)) continue;
            return true;
        }
        return false;
    }

    private boolean runBuildersForChunk(CompileContext context, BuildTargetChunk chunk) throws ProjectBuildException, IOException {
        Set<BuildTarget<?>> targets = chunk.getTargets();
        if (targets.size() > 1) {
            LinkedHashSet<ModuleBuildTarget> moduleTargets = new LinkedHashSet<ModuleBuildTarget>();
            for (BuildTarget<?> target : targets) {
                if (target instanceof ModuleBuildTarget) {
                    moduleTargets.add((ModuleBuildTarget)target);
                    continue;
                }
                String targetsString = StringUtil.join(targets, target1 -> StringUtil.decapitalize((String)target1.getPresentableName()), (String)", ");
                context.processMessage(new CompilerMessage("", BuildMessage.Kind.ERROR, "Cannot build " + StringUtil.decapitalize((String)target.getPresentableName()) + " because it is included into a circular dependency (" + targetsString + ")"));
                return false;
            }
            return this.runModuleLevelBuilders(context, new ModuleChunk(moduleTargets));
        }
        BuildTarget<?> target = targets.iterator().next();
        if (target instanceof ModuleBuildTarget) {
            return this.runModuleLevelBuilders(context, new ModuleChunk(Collections.singleton((ModuleBuildTarget)target)));
        }
        IncProjectBuilder.cleanOldOutputs(context, target);
        List<TargetBuilder<?, ?>> builders = BuilderRegistry.getInstance().getTargetBuilders();
        float builderProgressDelta = 1.0f / (float)builders.size();
        for (TargetBuilder<?, ?> builder : builders) {
            this.buildTarget(target, context, builder);
            this.updateDoneFraction(context, builderProgressDelta);
        }
        return true;
    }

    private <R extends BuildRootDescriptor, T extends BuildTarget<R>> void buildTarget(final T target, final CompileContext context, TargetBuilder<?, ?> builder) throws ProjectBuildException, IOException {
        if (builder.getTargetTypes().contains(target.getTargetType())) {
            DirtyFilesHolderBase holder = new DirtyFilesHolderBase<R, T>(context){

                @Override
                public void processDirtyFiles(@NotNull FileProcessor<R, T> processor) throws IOException {
                    if (processor == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    context.getProjectDescriptor().fsState.processFilesToRecompile(context, target, processor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/jps/incremental/IncProjectBuilder$3", "processDirtyFiles"));
                }
            };
            BuildOutputConsumerImpl outputConsumer = new BuildOutputConsumerImpl(target, context);
            long start = System.nanoTime();
            builder.build(target, holder, outputConsumer, context);
            this.storeBuilderStatistics(builder, System.nanoTime() - start, outputConsumer.getNumberOfProcessedSources());
            outputConsumer.fireFileGeneratedEvent();
            context.checkCanceled();
        }
    }

    private static <T extends BuildRootDescriptor> void cleanOldOutputs(final CompileContext context, final BuildTarget<T> target) throws ProjectBuildException, IOException {
        if (!context.getScope().isBuildForced(target)) {
            BuildOperations.cleanOutputsCorrespondingToChangedFiles(context, new DirtyFilesHolderBase<T, BuildTarget<T>>(context){

                @Override
                public void processDirtyFiles(@NotNull FileProcessor<T, BuildTarget<T>> processor) throws IOException {
                    if (processor == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    context.getProjectDescriptor().fsState.processFilesToRecompile(context, target, processor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/jps/incremental/IncProjectBuilder$4", "processDirtyFiles"));
                }
            });
        }
    }

    private void updateDoneFraction(CompileContext context, float delta) {
        this.myTargetsProcessed += delta;
        float processed = this.myTargetsProcessed;
        context.setDone(processed / this.myTotalTargetsWork);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildTargetsChunk(CompileContext context, BuildTargetChunk chunk) throws ProjectBuildException {
        BuildFSState fsState = this.myProjectDescriptor.fsState;
        try {
            context.setCompilationStartStamp(chunk.getTargets(), System.currentTimeMillis());
            this.sendBuildingTargetMessages(chunk.getTargets(), BuildingTargetProgressMessage.Event.STARTED);
            Utils.ERRORS_DETECTED_KEY.set((UserDataHolder)context, (Object)Boolean.FALSE);
            for (BuildTarget<?> buildTarget : chunk.getTargets()) {
                BuildOperations.ensureFSStateInitialized(context, buildTarget);
            }
            boolean doneSomething = this.processDeletedPaths(context, chunk.getTargets());
            fsState.beforeChunkBuildStart(context, chunk);
            doneSomething |= this.runBuildersForChunk(context, chunk);
            fsState.clearContextRoundData(context);
            fsState.clearContextChunk(context);
            BuildOperations.markTargetsUpToDate(context, chunk);
        }
        catch (BuildDataCorruptedException | ProjectBuildException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(chunk.getPresentableName()).append(": ").append(e2.getClass().getName());
                    String string = e2.getMessage();
                    if (string == null) throw new ProjectBuildException(stringBuilder.toString(), e2);
                    stringBuilder.append(": ").append(string);
                    throw new ProjectBuildException(stringBuilder.toString(), e2);
                }
            }
            catch (Throwable throwable) {
                for (BuildRootDescriptor buildRootDescriptor : context.getProjectDescriptor().getBuildRootIndex().clearTempRoots(context)) {
                    context.getProjectDescriptor().fsState.clearRecompile(buildRootDescriptor);
                }
                try {
                    Map map = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context);
                    if (map == null) throw throwable;
                    for (Map.Entry entry : map.entrySet()) {
                        BuildTarget target = (BuildTarget)entry.getKey();
                        Collection paths = (Collection)entry.getValue();
                        if (paths == null) continue;
                        for (String path : paths) {
                            fsState.registerDeleted(context, target, new File(path), null);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new ProjectBuildException(e3);
                }
                finally {
                    Utils.REMOVED_SOURCES_KEY.set((UserDataHolder)context, null);
                    this.sendBuildingTargetMessages(chunk.getTargets(), BuildingTargetProgressMessage.Event.FINISHED);
                }
            }
        }
        for (BuildRootDescriptor buildRootDescriptor : context.getProjectDescriptor().getBuildRootIndex().clearTempRoots(context)) {
            context.getProjectDescriptor().fsState.clearRecompile(buildRootDescriptor);
        }
        try {
            Map map = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context);
            if (map == null) return;
            for (Map.Entry entry : map.entrySet()) {
                BuildTarget target = (BuildTarget)entry.getKey();
                Collection paths = (Collection)entry.getValue();
                if (paths == null) continue;
                for (String path : paths) {
                    fsState.registerDeleted(context, target, new File(path), null);
                }
            }
            return;
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
        finally {
            Utils.REMOVED_SOURCES_KEY.set((UserDataHolder)context, null);
            this.sendBuildingTargetMessages(chunk.getTargets(), BuildingTargetProgressMessage.Event.FINISHED);
        }
    }

    private void sendBuildingTargetMessages(@NotNull Set<? extends BuildTarget<?>> targets, @NotNull BuildingTargetProgressMessage.Event event) {
        if (targets == null) {
            IncProjectBuilder.$$$reportNull$$$0(2);
        }
        if (event == null) {
            IncProjectBuilder.$$$reportNull$$$0(3);
        }
        this.myMessageDispatcher.processMessage(new BuildingTargetProgressMessage(targets, event));
    }

    private boolean processDeletedPaths(CompileContext context, Set<? extends BuildTarget<?>> targets) throws ProjectBuildException {
        boolean doneSomething = false;
        try {
            HashMap<BuildTarget<Object>, Collection<String>> targetToRemovedSources = new HashMap<BuildTarget<Object>, Collection<String>>();
            THashSet dirsToDelete = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            for (BuildTarget<?> target : targets) {
                Collection<String> pathsForIteration;
                Collection<String> deletedPaths = this.myProjectDescriptor.fsState.getAndClearDeletedPaths(target);
                if (deletedPaths.isEmpty()) continue;
                targetToRemovedSources.put(target, deletedPaths);
                if (IncProjectBuilder.isTargetOutputCleared(context, target)) continue;
                int buildTargetId = context.getProjectDescriptor().getTargetsState().getBuildTargetId(target);
                boolean shouldPruneEmptyDirs = target instanceof ModuleBasedTarget;
                SourceToOutputMapping sourceToOutputStorage = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target);
                ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
                if (this.myIsTestMode) {
                    pathsForIteration = new ArrayList<String>(deletedPaths);
                    Collections.sort((List)pathsForIteration);
                } else {
                    pathsForIteration = deletedPaths;
                }
                for (String deletedSource : pathsForIteration) {
                    OneToManyPathsMapping sourceToFormMap;
                    Collection<String> boundForms;
                    Collection<String> outputs = sourceToOutputStorage.getOutputs(deletedSource);
                    if (outputs != null && !outputs.isEmpty()) {
                        ArrayList<String> deletedOutputPaths = new ArrayList<String>();
                        OutputToTargetRegistry outputToSourceRegistry = context.getProjectDescriptor().dataManager.getOutputToTargetRegistry();
                        for (String output : outputToSourceRegistry.getSafeToDeleteOutputs(outputs, buildTargetId)) {
                            boolean deleted = BuildOperations.deleteRecursively(output, deletedOutputPaths, (Set<File>)(shouldPruneEmptyDirs ? dirsToDelete : null));
                            if (!deleted) continue;
                            doneSomething = true;
                        }
                        for (String outputPath : outputs) {
                            outputToSourceRegistry.removeMapping(outputPath, buildTargetId);
                        }
                        if (!deletedOutputPaths.isEmpty()) {
                            if (logger.isEnabled()) {
                                logger.logDeletedFiles(deletedOutputPaths);
                            }
                            context.processMessage(new FileDeletedEvent(deletedOutputPaths));
                        }
                    }
                    if (!(target instanceof ModuleBuildTarget) || (boundForms = (sourceToFormMap = context.getProjectDescriptor().dataManager.getSourceToFormMap()).getState(deletedSource)) == null) continue;
                    for (String formPath : boundForms) {
                        File formFile = new File(formPath);
                        if (!formFile.exists()) continue;
                        FSOperations.markDirty(context, CompilationRound.CURRENT, formFile);
                    }
                    sourceToFormMap.remove(deletedSource);
                }
            }
            if (!targetToRemovedSources.isEmpty()) {
                Map existing = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context);
                if (existing != null) {
                    for (Map.Entry entry : existing.entrySet()) {
                        Collection paths = (Collection)targetToRemovedSources.get(entry.getKey());
                        if (paths != null) {
                            paths.addAll((Collection)entry.getValue());
                            continue;
                        }
                        targetToRemovedSources.put((BuildTarget<Object>)entry.getKey(), (Collection<String>)entry.getValue());
                    }
                }
                Utils.REMOVED_SOURCES_KEY.set((UserDataHolder)context, targetToRemovedSources);
            }
            FSOperations.pruneEmptyDirs(context, (Set<File>)dirsToDelete);
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
        return doneSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runModuleLevelBuilders(final CompileContext context, final ModuleChunk chunk) throws ProjectBuildException, IOException {
        for (BuilderCategory category : BuilderCategory.values()) {
            for (ModuleLevelBuilder builder : this.myBuilderRegistry.getBuilders(category)) {
                builder.chunkBuildStarted(context, chunk);
            }
        }
        boolean doneSomething = false;
        boolean rebuildFromScratchRequested = false;
        float stageCount = this.myTotalModuleLevelBuilderCount;
        int modulesInChunk = chunk.getModules().size();
        int buildersPassed = 0;
        ChunkBuildOutputConsumerImpl outputConsumer = new ChunkBuildOutputConsumerImpl(context);
        try {
            boolean nextPassRequired;
            block14: do {
                nextPassRequired = false;
                this.myProjectDescriptor.fsState.beforeNextRoundStart(context, chunk);
                DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder = new DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget>(context){

                    @Override
                    public void processDirtyFiles(@NotNull FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) throws IOException {
                        if (processor == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        FSOperations.processFilesToRecompile(context, chunk, processor);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/jps/incremental/IncProjectBuilder$5", "processDirtyFiles"));
                    }
                };
                if (!JavaBuilderUtil.isForcedRecompilationAllJavaModules(context)) {
                    Map<ModuleBuildTarget, Set<File>> cleanedSources = BuildOperations.cleanOutputsCorrespondingToChangedFiles(context, dirtyFilesHolder);
                    for (Map.Entry<ModuleBuildTarget, Set<File>> entry : cleanedSources.entrySet()) {
                        ModuleBuildTarget target = entry.getKey();
                        Set<File> files = entry.getValue();
                        if (files.isEmpty()) continue;
                        SourceToOutputMapping mapping = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target);
                        for (File srcFile : files) {
                            mapping.setOutputs(srcFile.getPath(), Collections.emptyList());
                        }
                    }
                }
                try {
                    for (BuilderCategory category : BuilderCategory.values()) {
                        List<ModuleLevelBuilder> builders = this.myBuilderRegistry.getBuilders(category);
                        if (category == BuilderCategory.CLASS_POST_PROCESSOR) {
                            IncProjectBuilder.saveInstrumentedClasses(outputConsumer);
                        }
                        if (builders.isEmpty()) continue;
                        try {
                            for (ModuleLevelBuilder builder : builders) {
                                this.processDeletedPaths(context, chunk.getTargets());
                                long start = System.nanoTime();
                                int processedSourcesBefore = outputConsumer.getNumberOfProcessedSources();
                                ModuleLevelBuilder.ExitCode buildResult = builder.build(context, chunk, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)dirtyFilesHolder, outputConsumer);
                                this.storeBuilderStatistics(builder, System.nanoTime() - start, outputConsumer.getNumberOfProcessedSources() - processedSourcesBefore);
                                doneSomething |= buildResult != ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                                if (buildResult == ModuleLevelBuilder.ExitCode.ABORT) {
                                    throw new StopBuildException("Builder " + builder.getPresentableName() + " requested build stop");
                                }
                                context.checkCanceled();
                                if (buildResult == ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED) {
                                    nextPassRequired = true;
                                } else if (buildResult == ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED) {
                                    if (!rebuildFromScratchRequested && !JavaBuilderUtil.isForcedRecompilationAllJavaModules(context)) {
                                        IncProjectBuilder.notifyChunkRebuildRequested(context, chunk, builder);
                                        rebuildFromScratchRequested = true;
                                        try {
                                            context.getProjectDescriptor().fsState.clearContextRoundData(context);
                                            FSOperations.markDirty(context, CompilationRound.NEXT, chunk, null);
                                            this.myTargetsProcessed -= (float)(buildersPassed * modulesInChunk) / stageCount;
                                            stageCount = this.myTotalModuleLevelBuilderCount;
                                            buildersPassed = 0;
                                            nextPassRequired = true;
                                            outputConsumer.clear();
                                            continue block14;
                                        }
                                        catch (Exception e) {
                                            throw new ProjectBuildException(e);
                                        }
                                    }
                                    LOG.debug("Builder " + builder.getPresentableName() + " requested second chunk rebuild");
                                }
                                ++buildersPassed;
                                this.updateDoneFraction(context, (float)modulesInChunk / stageCount);
                            }
                        }
                        finally {
                            boolean moreToCompile = JavaBuilderUtil.updateMappingsOnRoundCompletion(context, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)dirtyFilesHolder, chunk);
                            if (moreToCompile) {
                                nextPassRequired = true;
                            }
                            if (nextPassRequired && !rebuildFromScratchRequested) {
                                this.myTargetsProcessed -= (float)(buildersPassed * modulesInChunk) / stageCount;
                                this.myTargetsProcessed += (float)(buildersPassed * modulesInChunk) / (stageCount += (float)this.myTotalModuleLevelBuilderCount);
                            }
                        }
                    }
                }
                finally {
                    JavaBuilderUtil.clearDataOnRoundCompletion(context);
                }
            } while (nextPassRequired);
        }
        finally {
            IncProjectBuilder.saveInstrumentedClasses(outputConsumer);
            outputConsumer.fireFileGeneratedEvents();
            outputConsumer.clear();
            for (BuilderCategory category : BuilderCategory.values()) {
                for (ModuleLevelBuilder builder : this.myBuilderRegistry.getBuilders(category)) {
                    builder.chunkBuildFinished(context, chunk);
                }
            }
        }
        return doneSomething;
    }

    private static void notifyChunkRebuildRequested(CompileContext context, ModuleChunk chunk, ModuleLevelBuilder builder) {
        String infoMessage = "Builder \"" + builder.getPresentableName() + "\" requested rebuild of module chunk \"" + chunk.getName() + "\"";
        LOG.info(infoMessage);
        BuildMessage.Kind kind = BuildMessage.Kind.JPS_INFO;
        CompileScope scope = context.getScope();
        for (ModuleBuildTarget target : chunk.getTargets()) {
            if (scope.isWholeTargetAffected(target)) continue;
            infoMessage = infoMessage + ".\nConsider building whole project or rebuilding the module.";
            kind = BuildMessage.Kind.INFO;
            break;
        }
        context.processMessage(new CompilerMessage("", kind, infoMessage));
    }

    private void storeBuilderStatistics(Builder builder, long elapsedTime, int processedFiles) {
        if (!this.myElapsedTimeNanosByBuilder.containsKey(builder)) {
            this.myElapsedTimeNanosByBuilder.putIfAbsent(builder, new AtomicLong());
        }
        ((AtomicLong)this.myElapsedTimeNanosByBuilder.get(builder)).addAndGet(elapsedTime);
        if (!this.myNumberOfSourcesProcessedByBuilder.containsKey(builder)) {
            this.myNumberOfSourcesProcessedByBuilder.putIfAbsent(builder, new AtomicInteger());
        }
        ((AtomicInteger)this.myNumberOfSourcesProcessedByBuilder.get(builder)).addAndGet(processedFiles);
    }

    private static void saveInstrumentedClasses(ChunkBuildOutputConsumerImpl outputConsumer) throws IOException {
        for (CompiledClass compiledClass : outputConsumer.getCompiledClasses().values()) {
            if (!compiledClass.isDirty()) continue;
            compiledClass.save();
        }
    }

    private static CompileContext createContextWrapper(final CompileContext delegate) {
        ClassLoader loader = delegate.getClass().getClassLoader();
        final UserDataHolderBase localDataHolder = new UserDataHolderBase();
        final Set deletedKeysSet = ContainerUtil.newConcurrentSet();
        final Class<UserDataHolder> dataHolderInterface = UserDataHolder.class;
        final Class<MessageHandler> messageHandlerInterface = MessageHandler.class;
        return (CompileContext)Proxy.newProxyInstance(loader, new Class[]{CompileContext.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                BuildMessage msg;
                Class<?> declaringClass = method.getDeclaringClass();
                if (dataHolderInterface.equals(declaringClass)) {
                    Object firstArgument = args[0];
                    if (!(firstArgument instanceof GlobalContextKey)) {
                        boolean isWriteOperation;
                        boolean bl = isWriteOperation = args.length == 2;
                        if (isWriteOperation) {
                            if (args[1] == null) {
                                deletedKeysSet.add(firstArgument);
                            } else {
                                deletedKeysSet.remove(firstArgument);
                            }
                        } else if (deletedKeysSet.contains(firstArgument)) {
                            return null;
                        }
                        Object result = method.invoke((Object)localDataHolder, args);
                        if (isWriteOperation || result != null) {
                            return result;
                        }
                    }
                } else if (messageHandlerInterface.equals(declaringClass) && (msg = (BuildMessage)args[0]).getKind() == BuildMessage.Kind.ERROR) {
                    Utils.ERRORS_DETECTED_KEY.set((UserDataHolder)localDataHolder, (Object)Boolean.TRUE);
                }
                try {
                    return method.invoke((Object)delegate, args);
                }
                catch (InvocationTargetException e) {
                    Throwable targetEx = e.getTargetException();
                    if (targetEx instanceof ProjectBuildException) {
                        throw targetEx;
                    }
                    throw e;
                }
            }
        });
    }

    private /* synthetic */ void lambda$build$0() {
        this.myProjectDescriptor.getFSCache().clear();
        JavacMain.clearCompilerZipFileCache();
        this.myProjectDescriptor.dataManager.flush(false);
        this.myProjectDescriptor.timestamps.getStorage().force();
    }

    static {
        int maxThreads = Math.min(6, Runtime.getRuntime().availableProcessors() - 1);
        try {
            maxThreads = Math.max(1, Integer.parseInt(System.getProperty("compile.parallel.max.threads", Integer.toString(maxThreads))));
        }
        catch (NumberFormatException ignored) {
            maxThreads = Math.max(1, maxThreads);
        }
        MAX_BUILDER_THREADS = maxThreads;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/IncProjectBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/IncProjectBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "waitForTask";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sendBuildingTargetMessages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BuildParallelizer {
        private final ExecutorService myParallelBuildExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"IncProjectBuilder Executor Pool", (Executor)SharedThreadPool.getInstance(), (int)MAX_BUILDER_THREADS);
        private final CompileContext myContext;
        private final AtomicReference<Throwable> myException = new AtomicReference();
        private final Object myQueueLock = new Object();
        private final CountDownLatch myTasksCountDown;
        private final List<BuildChunkTask> myTasks;

        private BuildParallelizer(CompileContext context) {
            this.myContext = context;
            ProjectDescriptor pd = this.myContext.getProjectDescriptor();
            BuildTargetIndex targetIndex = pd.getBuildTargetIndex();
            List<BuildTargetChunk> chunks = targetIndex.getSortedTargetChunks(this.myContext);
            this.myTasks = new ArrayList<BuildChunkTask>(chunks.size());
            THashMap targetToTask = new THashMap();
            for (BuildTargetChunk chunk : chunks) {
                BuildChunkTask task = new BuildChunkTask(chunk);
                this.myTasks.add(task);
                for (BuildTarget<?> target : chunk.getTargets()) {
                    targetToTask.put(target, task);
                }
            }
            for (BuildChunkTask task : this.myTasks) {
                for (BuildTarget<?> target : task.getChunk().getTargets()) {
                    for (BuildTarget<?> dependency : targetIndex.getDependencies(target, this.myContext)) {
                        BuildChunkTask depTask = (BuildChunkTask)targetToTask.get(dependency);
                        if (depTask == null || depTask == task) continue;
                        task.addDependency(depTask);
                    }
                }
            }
            this.myTasksCountDown = new CountDownLatch(this.myTasks.size());
        }

        public void buildInParallel() throws IOException, ProjectBuildException {
            ArrayList<BuildChunkTask> initialTasks = new ArrayList<BuildChunkTask>();
            for (BuildChunkTask task : this.myTasks) {
                if (!task.isReady()) continue;
                initialTasks.add(task);
            }
            this.queueTasks(initialTasks);
            try {
                this.myTasksCountDown.await();
            }
            catch (InterruptedException e) {
                LOG.info((Throwable)e);
            }
            Throwable throwable = this.myException.get();
            if (throwable instanceof ProjectBuildException) {
                throw (ProjectBuildException)throwable;
            }
            if (throwable != null) {
                throw new ProjectBuildException(throwable);
            }
        }

        private void queueTasks(List<BuildChunkTask> tasks) {
            if (LOG.isDebugEnabled() && !tasks.isEmpty()) {
                ArrayList<BuildTargetChunk> chunksToLog = new ArrayList<BuildTargetChunk>();
                for (BuildChunkTask task : tasks) {
                    chunksToLog.add(task.getChunk());
                }
                StringBuilder logBuilder = new StringBuilder("Queuing " + chunksToLog.size() + " chunks in parallel: ");
                chunksToLog.sort(Comparator.comparing(BuildTargetChunk::toString));
                for (BuildTargetChunk chunk : chunksToLog) {
                    logBuilder.append(chunk.toString()).append("; ");
                }
                LOG.debug(logBuilder.toString());
            }
            for (BuildChunkTask task : tasks) {
                this.queueTask(task);
            }
        }

        private void queueTask(BuildChunkTask task) {
            CompileContext chunkLocalContext = IncProjectBuilder.createContextWrapper(this.myContext);
            this.myParallelBuildExecutor.execute(() -> {
                try {
                    try {
                        if (this.myException.get() == null) {
                            IncProjectBuilder.this.buildChunkIfAffected(chunkLocalContext, this.myContext.getScope(), task.getChunk());
                        }
                    }
                    finally {
                        ((IncProjectBuilder)IncProjectBuilder.this).myProjectDescriptor.dataManager.closeSourceToOutputStorages(Collections.singletonList(task.getChunk()));
                        ((IncProjectBuilder)IncProjectBuilder.this).myProjectDescriptor.dataManager.flush(true);
                    }
                }
                catch (Throwable e) {
                    this.myException.compareAndSet(null, e);
                    LOG.info(e);
                }
                finally {
                    List<BuildChunkTask> nextTasks;
                    LOG.debug("Finished compilation of " + task.getChunk().toString());
                    this.myTasksCountDown.countDown();
                    Object object = this.myQueueLock;
                    synchronized (object) {
                        nextTasks = task.markAsFinishedAndGetNextReadyTasks();
                    }
                    if (!nextTasks.isEmpty()) {
                        this.queueTasks(nextTasks);
                    }
                }
            });
        }
    }

    private static class BuildChunkTask {
        private final BuildTargetChunk myChunk;
        private final Set<BuildChunkTask> myNotBuiltDependencies = new THashSet();
        private final List<BuildChunkTask> myTasksDependsOnThis = new ArrayList<BuildChunkTask>();

        private BuildChunkTask(BuildTargetChunk chunk) {
            this.myChunk = chunk;
        }

        public BuildTargetChunk getChunk() {
            return this.myChunk;
        }

        public boolean isReady() {
            return this.myNotBuiltDependencies.isEmpty();
        }

        public void addDependency(BuildChunkTask dependency) {
            if (this.myNotBuiltDependencies.add(dependency)) {
                dependency.myTasksDependsOnThis.add(this);
            }
        }

        public List<BuildChunkTask> markAsFinishedAndGetNextReadyTasks() {
            SmartList nextTasks = new SmartList();
            for (BuildChunkTask task : this.myTasksDependsOnThis) {
                boolean removed = task.myNotBuiltDependencies.remove(this);
                LOG.assertTrue(removed, (Object)(task.getChunk().toString() + " didn't have " + this.getChunk().toString()));
                if (!task.isReady()) continue;
                nextTasks.add(task);
            }
            return nextTasks;
        }
    }

    private static enum Applicability {
        NONE,
        PARTIAL,
        ALL;


        static <T> Applicability calculate(Predicate<T> p, Collection<T> collection) {
            int count = 0;
            int item = 0;
            for (T elem : collection) {
                ++item;
                if (!(p.apply(elem) ? item > ++count : count > 0)) continue;
                return PARTIAL;
            }
            return count == 0 ? NONE : ALL;
        }
    }
}

