/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.java.JavaBuilderExtension;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsEncodingProjectConfiguration;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.util.JpsPathUtil;

public class CompilerEncodingConfiguration {
    private final JpsModel myJpsModel;
    private final Map<String, String> myUrlToCharset;
    private final String myProjectCharset;
    private final BuildRootIndex myRootsIndex;
    private Map<JpsModule, Set<String>> myModuleCharsetMap;

    public CompilerEncodingConfiguration(JpsModel jpsModel, BuildRootIndex index) {
        this.myJpsModel = jpsModel;
        JpsEncodingProjectConfiguration configuration = JpsEncodingConfigurationService.getInstance().getEncodingConfiguration(jpsModel.getProject());
        this.myUrlToCharset = configuration != null ? configuration.getUrlToEncoding() : Collections.emptyMap();
        this.myProjectCharset = JpsEncodingConfigurationService.getInstance().getProjectEncoding(jpsModel);
        this.myRootsIndex = index;
    }

    public Map<JpsModule, Set<String>> getModuleCharsetMap() {
        if (this.myModuleCharsetMap == null) {
            this.myModuleCharsetMap = this.computeModuleCharsetMap();
        }
        return this.myModuleCharsetMap;
    }

    private Map<JpsModule, Set<String>> computeModuleCharsetMap() {
        THashMap map = new THashMap();
        Iterable builderExtensions = JpsServiceManager.getInstance().getExtensions(JavaBuilderExtension.class);
        for (Map.Entry<String, String> entry : this.myUrlToCharset.entrySet()) {
            JavaSourceRootDescriptor rootDescriptor;
            String fileUrl = entry.getKey();
            String charset = entry.getValue();
            File file = JpsPathUtil.urlToFile((String)fileUrl);
            if (charset == null || !file.isDirectory() && !CompilerEncodingConfiguration.shouldHonorEncodingForCompilation(builderExtensions, file) || (rootDescriptor = this.myRootsIndex.findJavaRootDescriptor(null, file)) == null) continue;
            JpsModule module = rootDescriptor.target.getModule();
            LinkedHashSet<String> set = (LinkedHashSet<String>)map.get(module);
            if (set == null) {
                set = new LinkedHashSet<String>();
                map.put(module, set);
                File sourceRoot = rootDescriptor.root;
                File current = FileUtilRt.getParentFile((File)file);
                String parentCharset = null;
                while (current != null) {
                    String currentCharset = this.lookupCharsetMap(current);
                    if (currentCharset != null) {
                        parentCharset = currentCharset;
                    }
                    if (FileUtil.filesEqual((File)current, (File)sourceRoot)) break;
                    current = FileUtilRt.getParentFile((File)current);
                }
                if (parentCharset != null) {
                    set.add(parentCharset);
                }
            }
            set.add(charset);
        }
        for (JpsModule module : this.myJpsModel.getProject().getModules()) {
            for (JpsModuleSourceRoot srcRoot : module.getSourceRoots()) {
                String encoding = this.getEncoding(srcRoot.getFile());
                if (encoding == null) continue;
                LinkedHashSet<String> charsets = (LinkedHashSet<String>)map.get(module);
                if (charsets == null) {
                    charsets = new LinkedHashSet<String>();
                    map.put(module, charsets);
                }
                charsets.add(encoding);
            }
        }
        return map;
    }

    @Nullable
    public String getEncoding(@Nullable File file) {
        while (file != null) {
            String charset = this.lookupCharsetMap(file);
            if (charset != null) {
                return charset;
            }
            file = FileUtilRt.getParentFile((File)file);
        }
        return this.myProjectCharset;
    }

    @Nullable
    private String lookupCharsetMap(File file) {
        return this.myUrlToCharset.get(JpsPathUtil.pathToUrl((String)FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath())));
    }

    private static boolean shouldHonorEncodingForCompilation(Iterable<JavaBuilderExtension> builders, File file) {
        for (JavaBuilderExtension extension : builders) {
            if (!extension.shouldHonorFileEncodingForCompilation(file)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getPreferredModuleChunkEncoding(@NotNull ModuleChunk moduleChunk) {
        if (moduleChunk == null) {
            CompilerEncodingConfiguration.$$$reportNull$$$0(0);
        }
        for (JpsModule module : moduleChunk.getModules()) {
            String encoding = this.getPreferredModuleEncoding(module);
            if (encoding == null) continue;
            return encoding;
        }
        return this.myProjectCharset;
    }

    public String getPreferredModuleEncoding(JpsModule module) {
        Set<String> encodings = this.getModuleCharsetMap().get(module);
        return (String)ContainerUtil.getFirstItem(encodings, null);
    }

    @NotNull
    public Set<String> getAllModuleChunkEncodings(@NotNull ModuleChunk moduleChunk) {
        if (moduleChunk == null) {
            CompilerEncodingConfiguration.$$$reportNull$$$0(1);
        }
        Map<JpsModule, Set<String>> map = this.getModuleCharsetMap();
        HashSet<String> encodings = new HashSet<String>();
        for (JpsModule module : moduleChunk.getModules()) {
            Set<String> moduleEncodings = map.get(module);
            if (moduleEncodings == null) continue;
            encodings.addAll(moduleEncodings);
        }
        HashSet<String> hashSet = encodings;
        if (hashSet == null) {
            CompilerEncodingConfiguration.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleChunk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/CompilerEncodingConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/CompilerEncodingConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModuleChunkEncodings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredModuleChunkEncoding";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllModuleChunkEncodings";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

