/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.jetbrains.annotations.NotNull;

public class LogSetup {
    private static final String LOG_CONFIG_FILE_NAME = "build-log.properties";
    private static final String LOG_FILE_NAME = "build.log";
    private static final String DEFAULT_LOGGER_CONFIG = "defaultLogConfig.properties";
    private static final String LOG_FILE_MACRO = "$LOG_FILE_PATH$";

    public static void initLoggers() {
        if (!SystemProperties.getBooleanProperty((String)"jps.use.default.file.logging", (boolean)true)) {
            return;
        }
        try {
            String logDir = System.getProperty("jps.log.dir", null);
            File configFile = logDir != null ? new File(logDir, LOG_CONFIG_FILE_NAME) : new File(LOG_CONFIG_FILE_NAME);
            LogSetup.ensureLogConfigExists(configFile);
            String text = FileUtil.loadFile((File)configFile);
            String logFile = logDir != null ? new File(logDir, LOG_FILE_NAME).getAbsolutePath() : LOG_FILE_NAME;
            text = StringUtil.replace((String)text, (String)LOG_FILE_MACRO, (String)StringUtil.replace((String)logFile, (String)"\\", (String)"\\\\"));
            PropertyConfigurator.configure((InputStream)new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            System.err.println("Failed to configure logging: ");
            e.printStackTrace(System.err);
        }
        com.intellij.openapi.diagnostic.Logger.setFactory(MyLoggerFactory.class);
    }

    private static void ensureLogConfigExists(File logConfig) throws IOException {
        block25: {
            if (!logConfig.exists()) {
                FileUtil.createIfDoesntExist((File)logConfig);
                try (InputStream in = LogSetup.class.getResourceAsStream("/defaultLogConfig.properties");){
                    if (in == null) break block25;
                    try (FileOutputStream out = new FileOutputStream(logConfig);){
                        FileUtil.copy((InputStream)in, (OutputStream)out);
                    }
                }
            }
        }
    }

    private static class MyLoggerFactory
    implements Logger.Factory {
        private MyLoggerFactory() {
        }

        @NotNull
        public com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String category) {
            if (category == null) {
                MyLoggerFactory.$$$reportNull$$$0(0);
            }
            Log4jBasedLogger log4jBasedLogger = new Log4jBasedLogger(Logger.getLogger((String)category));
            if (log4jBasedLogger == null) {
                MyLoggerFactory.$$$reportNull$$$0(1);
            }
            return log4jBasedLogger;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/cmdline/LogSetup$MyLoggerFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/cmdline/LogSetup$MyLoggerFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLoggerInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLoggerInstance";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

