/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

public class SignatureData {
    public static final byte ZERO_DIM = 0;
    public static final byte ARRAY_ONE_DIM = 1;
    public static final byte ITERATOR_ONE_DIM = -1;
    private final int myRawReturnType;
    private final byte myArrayKind;
    private final boolean myStatic;

    public SignatureData(int rawReturnType, byte arrayKind, boolean isStatic) {
        this.myRawReturnType = rawReturnType;
        this.myArrayKind = arrayKind;
        this.myStatic = isStatic;
    }

    public int getRawReturnType() {
        return this.myRawReturnType;
    }

    public byte getIteratorKind() {
        return this.myArrayKind;
    }

    public boolean isStatic() {
        return this.myStatic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureData data = (SignatureData)o;
        if (this.myRawReturnType != data.myRawReturnType) {
            return false;
        }
        if (this.myArrayKind != data.myArrayKind) {
            return false;
        }
        return this.myStatic == data.myStatic;
    }

    public int hashCode() {
        int result = this.myRawReturnType;
        result = 31 * result + this.myArrayKind;
        result = 31 * result + (this.myStatic ? 1 : 0);
        return result;
    }

    public static @interface IteratorKind {
    }
}

