/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.inconsistentResourceBundle;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.InconsistentResourceBundleInspectionProvider;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PropertiesKeysConsistencyInspectionProvider
implements InconsistentResourceBundleInspectionProvider {
    @Override
    @NotNull
    public String getName() {
        if ("REPORT_INCONSISTENT_PROPERTIES" == null) {
            PropertiesKeysConsistencyInspectionProvider.$$$reportNull$$$0(0);
        }
        return "REPORT_INCONSISTENT_PROPERTIES";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = InspectionsBundle.message((String)"inconsistent.bundle.report.inconsistent.properties", (Object[])new Object[0]);
        if (string == null) {
            PropertiesKeysConsistencyInspectionProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void check(BidirectionalMap<PropertiesFile, PropertiesFile> parents, List<PropertiesFile> files, Map<PropertiesFile, Set<String>> keysUpToParent, Map<PropertiesFile, Map<String, String>> propertiesFilesNamesMaps, InspectionManager manager, RefManager refManager, ProblemDescriptionsProcessor processor) {
        for (PropertiesFile file : files) {
            PropertiesFile parent = (PropertiesFile)parents.get((Object)file);
            THashSet parentKeys = keysUpToParent.get(parent);
            if (parent == null) {
                parentKeys = new THashSet();
                for (PropertiesFile otherTopLevelFile : files) {
                    if (otherTopLevelFile == file || parents.get((Object)otherTopLevelFile) != null) continue;
                    parent = otherTopLevelFile;
                    parentKeys.addAll(propertiesFilesNamesMaps.get(otherTopLevelFile).keySet());
                }
                if (parent == null) continue;
            }
            THashSet keys = new THashSet(propertiesFilesNamesMaps.get(file).keySet());
            keys.removeAll((Collection<?>)parentKeys);
            for (String inconsistentKey : keys) {
                IProperty property = file.findPropertyByKey(inconsistentKey);
                assert (property != null);
                String message = InspectionsBundle.message((String)"inconsistent.bundle.property.error", (Object[])new Object[]{inconsistentKey, parent.getName()});
                ProblemDescriptor descriptor = manager.createProblemDescriptor(property.getPsiElement(), message, false, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                processor.addProblemElement((RefEntity)refManager.getReference((PsiElement)file.getContainingFile()), new CommonProblemDescriptor[]{descriptor});
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/i18n/inconsistentResourceBundle/PropertiesKeysConsistencyInspectionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

