/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j;

import com.pty4j.PtyProcess;
import com.pty4j.unix.Pty;
import com.pty4j.unix.UnixPtyProcess;
import com.pty4j.util.PtyUtil;
import com.pty4j.windows.CygwinPtyProcess;
import com.pty4j.windows.WinPtyProcess;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Advapi32Util;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PtyProcessBuilder {
    private String[] myCommand;
    private Map<String, String> myEnvironment;
    private String myDirectory;
    private boolean myConsole;
    private boolean myCygwin;
    private File myLogFile;
    private boolean myRedirectErrorStream = false;

    public PtyProcessBuilder(@NotNull String[] command) {
        this.myCommand = command;
    }

    public void setCommand(@NotNull String[] command) {
        this.myCommand = command;
    }

    @NotNull
    public PtyProcessBuilder setEnvironment(@Nullable Map<String, String> environment) {
        this.myEnvironment = environment;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setDirectory(String directory) {
        this.myDirectory = directory;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setConsole(boolean console) {
        this.myConsole = console;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setCygwin(boolean cygwin) {
        this.myCygwin = cygwin;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setLogFile(@Nullable File logFile) {
        this.myLogFile = logFile;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setRedirectErrorStream(boolean redirectErrorStream) {
        this.myRedirectErrorStream = redirectErrorStream;
        return this;
    }

    @NotNull
    public PtyProcess start() throws IOException {
        if (Platform.isWindows()) {
            Map<String, String> environment = this.myEnvironment;
            if (environment == null) {
                environment = new TreeMap<String, String>();
            }
            if (this.myCygwin) {
                return new CygwinPtyProcess(this.myCommand, environment, this.myDirectory, this.myLogFile, this.myConsole);
            }
            return new WinPtyProcess(this.myCommand, Advapi32Util.getEnvironmentBlock(environment), this.myDirectory, this.myConsole);
        }
        Pty pty = new Pty(this.myConsole);
        Pty errPty = this.myRedirectErrorStream ? pty : (this.myConsole ? new Pty() : null);
        return new UnixPtyProcess(this.myCommand, PtyUtil.toStringArray(this.myEnvironment), this.myDirectory, pty, errPty);
    }
}

