/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.wpad;

import com.github.markusbernhardt.proxy.ProxySearchStrategy;
import com.github.markusbernhardt.proxy.util.Logger;
import com.github.markusbernhardt.proxy.util.ProxyException;
import com.github.markusbernhardt.proxy.util.ProxyUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;

public class WpadProxySearchStrategy
implements ProxySearchStrategy {
    @Override
    public ProxySelector getProxySelector() throws ProxyException {
        try {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Using WPAD to find a proxy", new Object[0]);
            String pacScriptUrl = this.detectScriptUrlPerDHCP();
            if (pacScriptUrl == null) {
                pacScriptUrl = this.detectScriptUrlPerDNS();
            }
            if (pacScriptUrl == null) {
                return null;
            }
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "PAC script url found: {0}", pacScriptUrl);
            return ProxyUtil.buildPacSelectorForUrl(pacScriptUrl);
        }
        catch (IOException e) {
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, "Error during WPAD search.", e);
            throw new ProxyException(e);
        }
    }

    @Override
    public String getName() {
        return "wpad";
    }

    public Properties readSettings() {
        try {
            String pacScriptUrl = this.detectScriptUrlPerDHCP();
            if (pacScriptUrl == null) {
                pacScriptUrl = this.detectScriptUrlPerDNS();
            }
            if (pacScriptUrl == null) {
                return null;
            }
            Properties result = new Properties();
            result.setProperty("url", pacScriptUrl);
            return result;
        }
        catch (IOException e) {
            return new Properties();
        }
    }

    private String detectScriptUrlPerDNS() throws IOException {
        String fqdn = InetAddress.getLocalHost().getCanonicalHostName();
        if (fqdn.equalsIgnoreCase("localhost") || fqdn.length() == 0 || Character.isDigit(fqdn.charAt(0))) {
            return null;
        }
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Searching per DNS guessing.", new Object[0]);
        String[] fqdnParts = fqdn.split("\\.");
        for (int i = 0; i < fqdnParts.length; ++i) {
            if (i == fqdnParts.length - 2) continue;
            StringBuilder stringBuilder = new StringBuilder("http://wpad");
            for (int j = i + 1; j < fqdnParts.length; ++j) {
                stringBuilder.append('.');
                stringBuilder.append(fqdnParts[j]);
            }
            stringBuilder.append("/wpad.dat");
            try {
                URL lookupURL = new URL(stringBuilder.toString());
                Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Trying url: {0}", lookupURL);
                HttpURLConnection con = (HttpURLConnection)lookupURL.openConnection(Proxy.NO_PROXY);
                con.setInstanceFollowRedirects(true);
                con.setRequestProperty("accept", "application/x-ns-proxy-autoconfig");
                if (con.getResponseCode() == 200) {
                    return lookupURL.toString();
                }
                con.disconnect();
                continue;
            }
            catch (UnknownHostException e) {
                Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Not available!", new Object[0]);
            }
        }
        return null;
    }

    private String detectScriptUrlPerDHCP() {
        Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Searching per DHCP not supported yet.", new Object[0]);
        return null;
    }
}

