/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.TargetTypeProvider;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.ModelsHolder;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;

public class ProjectImportAction
implements BuildAction<AllModels>,
Serializable {
    private final Set<Class> myExtraProjectModelClasses = new LinkedHashSet<Class>();
    private final boolean myIsPreviewMode;
    private final boolean myIsGradleProjectDirSupported;
    private final boolean myIsCompositeBuildsSupported;

    public ProjectImportAction(boolean isPreviewMode) {
        this(isPreviewMode, false, false);
    }

    public ProjectImportAction(boolean isPreviewMode, boolean isGradleProjectDirSupported, boolean isCompositeBuildsSupported) {
        this.myIsPreviewMode = isPreviewMode;
        this.myIsGradleProjectDirSupported = isGradleProjectDirSupported;
        this.myIsCompositeBuildsSupported = isCompositeBuildsSupported;
    }

    public void addExtraProjectModelClasses(@NotNull Set<Class> projectModelClasses) {
        if (projectModelClasses == null) {
            ProjectImportAction.$$$reportNull$$$0(0);
        }
        this.myExtraProjectModelClasses.addAll(projectModelClasses);
    }

    @Nullable
    public AllModels execute(BuildController controller) {
        IdeaProject ideaProject;
        ProjectImportAction.configureAdditionalTypes(controller);
        long startTime = System.currentTimeMillis();
        IdeaProject ideaProject2 = ideaProject = this.myIsPreviewMode ? (IdeaProject)controller.getModel(BasicIdeaProject.class) : (IdeaProject)controller.getModel(IdeaProject.class);
        if (ideaProject == null || ideaProject.getModules().isEmpty()) {
            return null;
        }
        AllModels allModels = new AllModels(ideaProject);
        allModels.setGradleProjectDirSupported(this.myIsGradleProjectDirSupported);
        allModels.logPerformance("Get model IdeaProject" + (this.myIsPreviewMode ? " (preview mode)" : ""), System.currentTimeMillis() - startTime);
        long startTimeBuildEnv = System.currentTimeMillis();
        BuildEnvironment buildEnvironment = (BuildEnvironment)controller.findModel(BuildEnvironment.class);
        allModels.setBuildEnvironment(buildEnvironment);
        allModels.logPerformance("Get model BuildEnvironment", System.currentTimeMillis() - startTimeBuildEnv);
        this.addExtraProject(controller, allModels, null);
        for (IdeaModule module : ideaProject.getModules()) {
            this.addExtraProject(controller, allModels, module);
        }
        if (this.myIsCompositeBuildsSupported) {
            long startTimeGradleBuild = System.currentTimeMillis();
            GradleBuild gradleBuild = (GradleBuild)controller.getModel(GradleBuild.class);
            allModels.logPerformance("Get model GradleBuild", System.currentTimeMillis() - startTimeGradleBuild);
            for (GradleBuild build : gradleBuild.getIncludedBuilds()) {
                IdeaProject ideaIncludedProject = (IdeaProject)controller.findModel((Model)build, IdeaProject.class);
                allModels.getIncludedBuilds().add(ideaIncludedProject);
                for (IdeaModule module : ideaIncludedProject.getModules()) {
                    this.addExtraProject(controller, allModels, module);
                }
            }
        }
        return allModels;
    }

    private static void configureAdditionalTypes(BuildController controller) {
        try {
            Field adapterField;
            try {
                adapterField = controller.getClass().getDeclaredField("adapter");
            }
            catch (NoSuchFieldException e) {
                Field delegate = controller.getClass().getDeclaredField("delegate");
                delegate.setAccessible(true);
                Object wrappedController = delegate.get(controller);
                adapterField = wrappedController.getClass().getDeclaredField("adapter");
                controller = (BuildController)wrappedController;
            }
            adapterField.setAccessible(true);
            ProtocolToModelAdapter adapter = (ProtocolToModelAdapter)adapterField.get(controller);
            Field typeProviderField = adapter.getClass().getDeclaredField("targetTypeProvider");
            typeProviderField.setAccessible(true);
            TargetTypeProvider typeProvider = (TargetTypeProvider)typeProviderField.get(adapter);
            Field targetTypesField = typeProvider.getClass().getDeclaredField("configuredTargetTypes");
            targetTypesField.setAccessible(true);
            Map targetTypes = (Map)targetTypesField.get(typeProvider);
            targetTypes.put(ExternalProjectDependency.class.getCanonicalName(), ExternalProjectDependency.class);
            targetTypes.put(ExternalLibraryDependency.class.getCanonicalName(), ExternalLibraryDependency.class);
            targetTypes.put(FileCollectionDependency.class.getCanonicalName(), FileCollectionDependency.class);
            targetTypes.put(UnresolvedExternalDependency.class.getCanonicalName(), UnresolvedExternalDependency.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addExtraProject(@NotNull BuildController controller, @NotNull AllModels allModels, @Nullable IdeaModule model) {
        if (controller == null) {
            ProjectImportAction.$$$reportNull$$$0(1);
        }
        if (allModels == null) {
            ProjectImportAction.$$$reportNull$$$0(2);
        }
        for (Class aClass : this.myExtraProjectModelClasses) {
            try {
                long startTime = System.currentTimeMillis();
                Object extraProject = controller.findModel((Model)model, aClass);
                if (extraProject == null) continue;
                allModels.addExtraProject(extraProject, aClass, model != null ? model.getGradleProject() : null);
                allModels.logPerformance("Get model " + aClass.getName() + (model == null ? " without target" : " for module " + model.getName()), System.currentTimeMillis() - startTime);
            }
            catch (Exception e) {
                if (this.myIsPreviewMode) continue;
                throw new ExternalSystemException((Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModelClasses";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModels";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addExtraProjectModelClasses";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addExtraProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class AllModels
    extends ModelsHolder<IdeaProject, GradleProject> {
        private final List<IdeaProject> includedBuilds;
        private boolean isGradleProjectDirSupported;
        private final Map<String, Long> performanceTrace;

        public AllModels(@NotNull IdeaProject ideaProject) {
            if (ideaProject == null) {
                AllModels.$$$reportNull$$$0(0);
            }
            super(ideaProject);
            this.includedBuilds = new ArrayList<IdeaProject>();
            this.performanceTrace = new LinkedHashMap<String, Long>();
        }

        @NotNull
        public IdeaProject getIdeaProject() {
            IdeaProject ideaProject = (IdeaProject)this.getRootModel();
            if (ideaProject == null) {
                AllModels.$$$reportNull$$$0(1);
            }
            return ideaProject;
        }

        public List<IdeaProject> getIncludedBuilds() {
            return this.includedBuilds;
        }

        @Nullable
        public BuildEnvironment getBuildEnvironment() {
            return this.getExtraProject(BuildEnvironment.class);
        }

        public void setBuildEnvironment(@Nullable BuildEnvironment buildEnvironment) {
            if (buildEnvironment != null) {
                this.addExtraProject(buildEnvironment, BuildEnvironment.class);
            }
        }

        public void setGradleProjectDirSupported(boolean gradleProjectDirSupported) {
            this.isGradleProjectDirSupported = gradleProjectDirSupported;
        }

        @Override
        @Nullable
        public <T> T getExtraProject(@Nullable IdeaModule model, Class<T> modelClazz) {
            return super.getExtraProject(model != null ? model.getGradleProject() : null, modelClazz);
        }

        @Override
        public void addExtraProject(@NotNull Object project, @NotNull Class modelClazz, @Nullable IdeaModule subPropject) {
            if (project == null) {
                AllModels.$$$reportNull$$$0(2);
            }
            if (modelClazz == null) {
                AllModels.$$$reportNull$$$0(3);
            }
            super.addExtraProject(project, modelClazz, subPropject != null ? subPropject.getGradleProject() : null);
        }

        @Override
        @NotNull
        protected String extractMapKey(Class modelClazz, @Nullable GradleProject gradleProject) {
            if (gradleProject != null) {
                String id = this.isGradleProjectDirSupported ? gradleProject.getProjectDirectory().getPath() : gradleProject.getPath();
                String string = modelClazz.getName() + '@' + id;
                if (string == null) {
                    AllModels.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = modelClazz.getName() + '@' + "root" + ((IdeaProject)this.getRootModel()).getName().hashCode();
            if (string == null) {
                AllModels.$$$reportNull$$$0(5);
            }
            return string;
        }

        public void logPerformance(@NotNull String description, long millis) {
            if (description == null) {
                AllModels.$$$reportNull$$$0(6);
            }
            this.performanceTrace.put(description, millis);
        }

        public Map<String, Long> getPerformanceTrace() {
            return this.performanceTrace;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ideaProject";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelClazz";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIdeaProject";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extractMapKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addExtraProject";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "logPerformance";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

