/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.packer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockObtainFailedException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.context.IndexCreator;
import org.sonatype.nexus.index.context.IndexUtils;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.context.NexusLegacyAnalyzer;
import org.sonatype.nexus.index.creator.LegacyDocumentUpdater;
import org.sonatype.nexus.index.packer.DigesterUtils;
import org.sonatype.nexus.index.packer.IndexPacker;
import org.sonatype.nexus.index.packer.IndexPackingRequest;
import org.sonatype.nexus.index.updater.IndexDataWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=IndexPacker.class)
public class DefaultIndexPacker
extends AbstractLogEnabled
implements IndexPacker {
    @Override
    public void packIndex(IndexPackingRequest request) throws IOException, IllegalArgumentException {
        File file;
        if (request.getTargetDir() == null) {
            throw new IllegalArgumentException("The target dir is null");
        }
        if (request.getTargetDir().exists()) {
            if (!request.getTargetDir().isDirectory()) {
                throw new IllegalArgumentException(String.format("Specified target path %s is not a directory", request.getTargetDir().getAbsolutePath()));
            }
            if (!request.getTargetDir().canWrite()) {
                throw new IllegalArgumentException(String.format("Specified target path %s is not writtable", request.getTargetDir().getAbsolutePath()));
            }
        } else if (!request.getTargetDir().mkdirs()) {
            throw new IllegalArgumentException("Can't create " + request.getTargetDir().getAbsolutePath());
        }
        Properties info = new Properties();
        if (request.isCreateIncrementalChunks()) {
            Map<String, List<Integer>> chunks = this.getIndexChunks(request);
            this.writeIndexChunks(info, chunks, request);
        }
        if (request.getFormats().contains((Object)IndexPackingRequest.IndexFormat.FORMAT_LEGACY)) {
            file = new File(request.getTargetDir(), "nexus-maven-repository-index.zip");
            this.writeIndexArchive(request.getContext(), file);
            if (request.isCreateChecksumFiles()) {
                FileUtils.fileWrite((String)new File(file.getParentFile(), file.getName() + ".sha1").getAbsolutePath(), (String)DigesterUtils.getSha1Digest(file));
                FileUtils.fileWrite((String)new File(file.getParentFile(), file.getName() + ".md5").getAbsolutePath(), (String)DigesterUtils.getMd5Digest(file));
            }
        }
        if (request.getFormats().contains((Object)IndexPackingRequest.IndexFormat.FORMAT_V1)) {
            file = new File(request.getTargetDir(), "nexus-maven-repository-index.gz");
            this.writeIndexData(request.getContext(), null, file);
            if (request.isCreateChecksumFiles()) {
                FileUtils.fileWrite((String)new File(file.getParentFile(), file.getName() + ".sha1").getAbsolutePath(), (String)DigesterUtils.getSha1Digest(file));
                FileUtils.fileWrite((String)new File(file.getParentFile(), file.getName() + ".md5").getAbsolutePath(), (String)DigesterUtils.getMd5Digest(file));
            }
        }
        file = new File(request.getTargetDir(), "nexus-maven-repository-index.properties");
        this.writeIndexProperties(request, info, file);
        if (request.isCreateChecksumFiles()) {
            FileUtils.fileWrite((String)new File(file.getParentFile(), file.getName() + ".sha1").getAbsolutePath(), (String)DigesterUtils.getSha1Digest(file));
            FileUtils.fileWrite((String)new File(file.getParentFile(), file.getName() + ".md5").getAbsolutePath(), (String)DigesterUtils.getMd5Digest(file));
        }
    }

    private Map<String, List<Integer>> getIndexChunks(IndexPackingRequest request) throws IOException {
        TreeMap<String, List<Integer>> chunks = new TreeMap<String, List<Integer>>(Collections.reverseOrder());
        IndexReader r = request.getContext().getIndexReader();
        for (int i = 0; i < r.numDocs(); ++i) {
            Document d;
            String lastModified;
            if (r.isDeleted(i) || (lastModified = (d = r.document(i)).get("m")) == null) continue;
            Date t = new Date(Long.parseLong(lastModified));
            String chunkId = request.getIndexChunker().getChunkId(t);
            if (chunkId == null) continue;
            this.getChunk(chunks, chunkId).add(i);
        }
        return chunks;
    }

    void writeIndexChunks(Properties info, Map<String, List<Integer>> chunks, IndexPackingRequest request) throws IOException {
        if (chunks.size() < 2) {
            return;
        }
        IndexingContext context = request.getContext();
        int n = 0;
        List<Integer> currentIndexes = null;
        for (Map.Entry<String, List<Integer>> e : chunks.entrySet()) {
            String key = e.getKey();
            info.put("nexus.index.update-" + n, this.format(request.getIndexChunker().getChunkDate(key)));
            List<Integer> indexes = e.getValue();
            if (currentIndexes != null) {
                indexes.addAll(currentIndexes);
            }
            currentIndexes = indexes;
            File file = new File(request.getTargetDir(), "nexus-maven-repository-index." + key + ".gz");
            this.writeIndexData(context, indexes, file);
            if (request.isCreateChecksumFiles()) {
                FileUtils.fileWrite((String)new File(file.getParentFile(), file.getName() + ".sha1").getAbsolutePath(), (String)DigesterUtils.getSha1Digest(file));
                FileUtils.fileWrite((String)new File(file.getParentFile(), file.getName() + ".md5").getAbsolutePath(), (String)DigesterUtils.getMd5Digest(file));
            }
            if (request.getMaxIndexChunks() > ++n && n != chunks.size() - 1) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeIndexArchive(IndexingContext context, File targetArchive) throws IOException {
        if (targetArchive.exists()) {
            targetArchive.delete();
        }
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(targetArchive), 4096);
            DefaultIndexPacker.packIndexArchive(context, os);
        }
        catch (Throwable throwable) {
            IOUtil.close(os);
            throw throwable;
        }
        IOUtil.close((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packIndexArchive(IndexingContext context, OutputStream os) throws IOException {
        File indexArchive = File.createTempFile("nexus-index", "");
        File indexDir = new File(indexArchive.getAbsoluteFile().getParentFile(), indexArchive.getName() + ".dir");
        indexDir.mkdirs();
        FSDirectory fdir = FSDirectory.getDirectory((File)indexDir);
        try {
            IndexUtils.updateTimestamp(context.getIndexDirectory(), context.getTimestamp());
            IndexUtils.updateTimestamp((Directory)fdir, context.getTimestamp());
            DefaultIndexPacker.copyLegacyDocuments(context.getIndexReader(), (Directory)fdir, context);
            DefaultIndexPacker.packDirectory((Directory)fdir, os);
        }
        finally {
            IndexUtils.close((Directory)fdir);
            indexArchive.delete();
            IndexUtils.delete(indexDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyLegacyDocuments(IndexReader r, Directory targetdir, IndexingContext context) throws CorruptIndexException, LockObtainFailedException, IOException {
        IndexWriter w = null;
        try {
            w = new IndexWriter(targetdir, false, (Analyzer)new NexusLegacyAnalyzer(), true);
            for (int i = 0; i < r.maxDoc(); ++i) {
                if (r.isDeleted(i)) continue;
                w.addDocument(DefaultIndexPacker.updateLegacyDocument(r.document(i), context));
            }
            w.optimize();
            w.flush();
        }
        catch (Throwable throwable) {
            IndexUtils.close(w);
            throw throwable;
        }
        IndexUtils.close(w);
    }

    static Document updateLegacyDocument(Document doc, IndexingContext context) {
        ArtifactInfo ai = IndexUtils.constructArtifactInfo(doc, context);
        if (ai == null) {
            return doc;
        }
        Document document = new Document();
        document.add((Fieldable)new Field("u", ai.getUinfo(), Field.Store.YES, Field.Index.UN_TOKENIZED));
        for (IndexCreator ic : context.getIndexCreators()) {
            if (!(ic instanceof LegacyDocumentUpdater)) continue;
            ((LegacyDocumentUpdater)((Object)ic)).updateLegacyDocument(ai, document);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void packDirectory(Directory directory, OutputStream os) throws IOException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(os);
            zos.setLevel(9);
            String[] names = directory.list();
            boolean savedTimestamp = false;
            byte[] buf = new byte[8192];
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                DefaultIndexPacker.writeFile(name, zos, directory, buf);
                if (!name.equals("timestamp")) continue;
                savedTimestamp = true;
            }
            if (!savedTimestamp && directory.fileExists("timestamp")) {
                DefaultIndexPacker.writeFile("timestamp", zos, directory, buf);
            }
        }
        catch (Throwable throwable) {
            IndexUtils.close(zos);
            throw throwable;
        }
        IndexUtils.close(zos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeFile(String name, ZipOutputStream zos, Directory directory, byte[] buf) throws IOException {
        ZipEntry e = new ZipEntry(name);
        zos.putNextEntry(e);
        IndexInput in = directory.openInput(name);
        try {
            int toRead = 0;
            for (int bytesLeft = (int)in.length(); bytesLeft > 0; bytesLeft -= toRead) {
                toRead = bytesLeft >= buf.length ? buf.length : bytesLeft;
                in.readBytes(buf, 0, toRead, false);
                zos.write(buf, 0, toRead);
            }
        }
        finally {
            IndexUtils.close(in);
        }
        zos.flush();
        zos.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeIndexData(IndexingContext context, List<Integer> docIndexes, File targetArchive) throws IOException {
        if (targetArchive.exists()) {
            targetArchive.delete();
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(targetArchive);
            IndexDataWriter dw = new IndexDataWriter(os);
            dw.write(context, docIndexes);
            os.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(os);
            throw throwable;
        }
        IOUtil.close((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeIndexProperties(IndexPackingRequest request, Properties info, File propertiesFile) throws IOException {
        info.setProperty("nexus.index.id", request.getContext().getId());
        Date timestamp = request.getContext().getTimestamp();
        if (timestamp == null) {
            timestamp = new Date(0L);
        }
        info.setProperty("nexus.index.time", this.format(timestamp));
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(propertiesFile);
            info.store(os, null);
        }
        catch (Throwable throwable) {
            IOUtil.close(os);
            throw throwable;
        }
        IOUtil.close((OutputStream)os);
    }

    private String format(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss.SSS Z");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(d);
    }

    private List<Integer> getChunk(Map<String, List<Integer>> chunks, String key) {
        List<Integer> chunk = chunks.get(key);
        if (chunk == null) {
            chunk = new ArrayList<Integer>();
            chunks.put(key, chunk);
        }
        return chunk;
    }
}

