/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util.resolve;

import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.component.Artifact;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.DefaultUnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.tooling.util.SourceSetCachedFinder;
import org.jetbrains.plugins.gradle.tooling.util.resolve.DependencyResolverImpl;

public class DependencyResultsTransformer {
    private static final boolean is46rBetter = GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"4.6")) >= 0;
    private final Project myProject;
    private final SourceSetCachedFinder mySourceSetFinder;
    private final Multimap<ModuleVersionIdentifier, ResolvedArtifact> artifactMap;
    private final Map<ComponentIdentifier, ComponentArtifactsResult> componentResultsMap;
    private final Multimap<ModuleComponentIdentifier, ProjectDependency> configurationProjectDependencies;
    private final String scope;
    private final Set<File> resolvedDepsFiles;
    private final List<DependencyResult> handledDependencyResults;
    private final Set<ComponentResultKey> myVisitedComponentResults;

    public DependencyResultsTransformer(@NotNull Project project, @NotNull SourceSetCachedFinder sourceSetFinder, @NotNull Multimap<ModuleVersionIdentifier, ResolvedArtifact> artifactMap, @NotNull Map<ComponentIdentifier, ComponentArtifactsResult> auxiliaryArtifactsMap, @NotNull Multimap<ModuleComponentIdentifier, ProjectDependency> configurationProjectDependencies, @Nullable String scope) {
        if (project == null) {
            DependencyResultsTransformer.$$$reportNull$$$0(0);
        }
        if (sourceSetFinder == null) {
            DependencyResultsTransformer.$$$reportNull$$$0(1);
        }
        if (artifactMap == null) {
            DependencyResultsTransformer.$$$reportNull$$$0(2);
        }
        if (auxiliaryArtifactsMap == null) {
            DependencyResultsTransformer.$$$reportNull$$$0(3);
        }
        if (configurationProjectDependencies == null) {
            DependencyResultsTransformer.$$$reportNull$$$0(4);
        }
        this.resolvedDepsFiles = new HashSet<File>();
        this.handledDependencyResults = new ArrayList<DependencyResult>();
        this.myVisitedComponentResults = new HashSet<ComponentResultKey>();
        this.myProject = project;
        this.mySourceSetFinder = sourceSetFinder;
        this.artifactMap = artifactMap;
        this.componentResultsMap = auxiliaryArtifactsMap;
        this.configurationProjectDependencies = configurationProjectDependencies;
        this.scope = scope;
    }

    public Set<File> getResolvedDepsFiles() {
        return this.resolvedDepsFiles;
    }

    Set<ExternalDependency> buildExternalDependencies(Collection<? extends DependencyResult> gradleDependencies) {
        LinkedHashSet<ExternalDependency> dependencies = new LinkedHashSet<ExternalDependency>();
        for (DependencyResult dependencyResult : gradleDependencies) {
            ComponentSelector attempted;
            if (this.handledDependencyResults.contains(dependencyResult)) continue;
            this.handledDependencyResults.add(dependencyResult);
            if (dependencyResult instanceof ResolvedDependencyResult) {
                dependencies.addAll(this.processResolvedResult((ResolvedDependencyResult)dependencyResult));
            }
            if (!(dependencyResult instanceof UnresolvedDependencyResult) || !((attempted = ((UnresolvedDependencyResult)dependencyResult).getAttempted()) instanceof ModuleComponentSelector)) continue;
            ModuleComponentSelector attemptedMCSelector = (ModuleComponentSelector)attempted;
            DefaultUnresolvedExternalDependency dependency = new DefaultUnresolvedExternalDependency();
            dependency.setName(attemptedMCSelector.getModule());
            dependency.setGroup(attemptedMCSelector.getGroup());
            dependency.setVersion(attemptedMCSelector.getVersion());
            dependency.setScope(this.scope);
            dependency.setFailureMessage(((UnresolvedDependencyResult)dependencyResult).getFailure().getMessage());
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private Set<ExternalDependency> processResolvedResult(ResolvedDependencyResult dependencyResult) {
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        ResolvedComponentResult componentResult = dependencyResult.getSelected();
        if (!this.myVisitedComponentResults.add(this.getKey(componentResult))) {
            return Collections.emptySet();
        }
        ComponentSelector componentSelector = dependencyResult.getRequested();
        ModuleComponentIdentifier componentIdentifier = componentResult.getId() instanceof ModuleComponentIdentifier ? (ModuleComponentIdentifier)componentResult.getId() : DependencyResolverImpl.toComponentIdentifier(componentResult.getModuleVersion());
        String name = componentResult.getModuleVersion().getName();
        String group = componentResult.getModuleVersion().getGroup();
        String version = componentResult.getModuleVersion().getVersion();
        String selectionReason = componentResult.getSelectionReason().getDescription();
        boolean resolveFromArtifacts = componentSelector instanceof ModuleComponentSelector;
        if (componentSelector instanceof ProjectComponentSelector) {
            Collection<Object> dependencyConfigurations;
            Collection projectDependencies = this.configurationProjectDependencies.get((Object)componentIdentifier);
            if (projectDependencies.isEmpty()) {
                Project dependencyProject = this.myProject.findProject(((ProjectComponentSelector)componentSelector).getProjectPath());
                if (dependencyProject != null) {
                    Configuration configuration = dependencyProject.getConfigurations().getByName("default");
                    dependencyConfigurations = Collections.singleton(configuration);
                } else {
                    dependencyConfigurations = Collections.emptySet();
                    resolveFromArtifacts = true;
                    selectionReason = "composite build substitution";
                }
            } else {
                dependencyConfigurations = new ArrayList();
                for (ProjectDependency projectDependency : projectDependencies) {
                    dependencyConfigurations.add(DependencyResolverImpl.getTargetConfiguration(projectDependency));
                }
            }
            for (Configuration configuration : dependencyConfigurations) {
                PublishArtifact artifact;
                MetaProperty taskProperty;
                DefaultExternalProjectDependency dependency = this.createProjectDependency((DependencyResult)dependencyResult, componentResult, (ProjectComponentSelector)componentSelector, configuration);
                if (!componentResult.equals(dependencyResult.getFrom())) {
                    dependency.getDependencies().addAll(this.buildExternalDependencies(componentResult.getDependencies()));
                }
                result.add(dependency);
                this.resolvedDepsFiles.addAll(dependency.getProjectDependencyArtifacts());
                if (configuration.getName().equals("default")) continue;
                ArrayList<File> files = new ArrayList<File>();
                PublishArtifactSet artifacts = configuration.getArtifacts();
                if (artifacts != null && !artifacts.isEmpty() && (taskProperty = DefaultGroovyMethods.hasProperty((Object)(artifact = (PublishArtifact)artifacts.iterator().next()), (String)"archiveTask")) != null && taskProperty.getProperty((Object)artifact) instanceof AbstractArchiveTask) {
                    AbstractArchiveTask archiveTask = (AbstractArchiveTask)taskProperty.getProperty((Object)artifact);
                    this.resolvedDepsFiles.add(new File(archiveTask.getDestinationDir(), archiveTask.getArchiveName()));
                    try {
                        Set sourcePaths;
                        Method mainSpecGetter = AbstractCopyTask.class.getDeclaredMethod("getMainSpec", new Class[0]);
                        mainSpecGetter.setAccessible(true);
                        Object mainSpec = mainSpecGetter.invoke((Object)archiveTask, new Object[0]);
                        List sourcePathGetters = DefaultGroovyMethods.respondsTo((Object)mainSpec, (String)"getSourcePaths", (Object[])new Object[0]);
                        if (!sourcePathGetters.isEmpty() && (sourcePaths = (Set)((MetaMethod)sourcePathGetters.get(0)).doMethodInvoke(mainSpec, new Object[0])) != null) {
                            for (Object path : sourcePaths) {
                                if (path instanceof String) {
                                    File file = new File((String)path);
                                    if (!file.isAbsolute()) continue;
                                    files.add(file);
                                    continue;
                                }
                                if (!(path instanceof SourceSetOutput)) continue;
                                files.addAll(((SourceSetOutput)path).getFiles());
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (files.isEmpty()) continue;
                DefaultFileCollectionDependency fileCollectionDependency = new DefaultFileCollectionDependency(files);
                fileCollectionDependency.setScope(this.scope);
                result.add(fileCollectionDependency);
                this.resolvedDepsFiles.addAll(files);
            }
        }
        if (resolveFromArtifacts) {
            Collection artifacts = this.artifactMap.get((Object)componentResult.getModuleVersion());
            if (artifacts != null && artifacts.isEmpty()) {
                result.addAll(this.buildExternalDependencies(componentResult.getDependencies()));
            }
            boolean first = true;
            if (artifacts != null) {
                for (ResolvedArtifact resolvedArtifact : artifacts) {
                    AbstractExternalDependency dependency;
                    String packaging = resolvedArtifact.getExtension() != null ? resolvedArtifact.getExtension() : "jar";
                    String classifier = resolvedArtifact.getClassifier();
                    if (DependencyResolverImpl.isProjectDependencyArtifact(resolvedArtifact)) {
                        ProjectComponentIdentifier artifactComponentIdentifier = (ProjectComponentIdentifier)resolvedArtifact.getId().getComponentIdentifier();
                        dependency = new DefaultExternalProjectDependency();
                        DefaultExternalProjectDependency dDep = (DefaultExternalProjectDependency)dependency;
                        dDep.setName(name);
                        dDep.setGroup(group);
                        dDep.setVersion(version);
                        dDep.setScope(this.scope);
                        dDep.setSelectionReason(selectionReason);
                        dDep.setProjectPath(artifactComponentIdentifier.getProjectPath());
                        dDep.setConfigurationName("default");
                        ArrayList<File> files = new ArrayList<File>();
                        for (ResolvedArtifact resolvedArtifact2 : this.artifactMap.get((Object)componentResult.getModuleVersion())) {
                            files.add(resolvedArtifact2.getFile());
                        }
                        dDep.setProjectDependencyArtifacts(files);
                        DependencyResultsTransformer.setProjectDependencyArtifactsSources(dDep, files, this.mySourceSetFinder);
                        this.resolvedDepsFiles.addAll(dDep.getProjectDependencyArtifacts());
                    } else {
                        dependency = new DefaultExternalLibraryDependency();
                        DefaultExternalLibraryDependency dDep = dependency;
                        dDep.setName(name);
                        dDep.setGroup(group);
                        dDep.setPackaging(packaging);
                        dDep.setClassifier(classifier);
                        dDep.setVersion(version);
                        dDep.setScope(this.scope);
                        dDep.setSelectionReason(selectionReason);
                        dDep.setFile(resolvedArtifact.getFile());
                        ComponentArtifactsResult artifactsResult = this.componentResultsMap.get(componentIdentifier);
                        if (artifactsResult != null) {
                            ResolvedArtifactResult javadocResult;
                            ResolvedArtifactResult sourcesResult = DependencyResultsTransformer.findMatchingArtifact(resolvedArtifact, artifactsResult, SourcesArtifact.class);
                            if (sourcesResult != null) {
                                ((DefaultExternalLibraryDependency)dependency).setSource(sourcesResult.getFile());
                            }
                            if ((javadocResult = DependencyResultsTransformer.findMatchingArtifact(resolvedArtifact, artifactsResult, JavadocArtifact.class)) != null) {
                                ((DefaultExternalLibraryDependency)dependency).setJavadoc(javadocResult.getFile());
                            }
                        }
                    }
                    if (first) {
                        dependency.getDependencies().addAll(this.buildExternalDependencies(componentResult.getDependencies()));
                        first = false;
                    }
                    result.add(dependency);
                    this.resolvedDepsFiles.add(resolvedArtifact.getFile());
                }
            }
        }
        return result;
    }

    private ComponentResultKey getKey(ResolvedComponentResult result) {
        if (is46rBetter) {
            return new AttributesBasedKey(result.getId(), result.getVariant().getAttributes());
        }
        return new ComponentIdKey(result.getId());
    }

    @NotNull
    private DefaultExternalProjectDependency createProjectDependency(DependencyResult dependencyResult, ResolvedComponentResult componentResult, ProjectComponentSelector componentSelector, Configuration it) {
        String name = componentResult.getModuleVersion().getName();
        String group = componentResult.getModuleVersion().getGroup();
        String version = componentResult.getModuleVersion().getVersion();
        String selectionReason = componentResult.getSelectionReason().getDescription();
        DefaultExternalProjectDependency dependency = new DefaultExternalProjectDependency();
        dependency.setName(name);
        dependency.setGroup(group);
        dependency.setVersion(version);
        dependency.setScope(this.scope);
        dependency.setSelectionReason(selectionReason);
        dependency.setProjectPath(componentSelector.getProjectPath());
        dependency.setConfigurationName(it.getName());
        LinkedHashSet<File> artifactsFiles = new LinkedHashSet<File>(it.getAllArtifacts().getFiles().getFiles());
        dependency.setProjectDependencyArtifacts(artifactsFiles);
        DependencyResultsTransformer.setProjectDependencyArtifactsSources(dependency, artifactsFiles, this.mySourceSetFinder);
        if (it.getArtifacts().size() == 1) {
            PublishArtifact publishArtifact = (PublishArtifact)it.getAllArtifacts().iterator().next();
            dependency.setClassifier(publishArtifact.getClassifier());
            dependency.setPackaging(publishArtifact.getExtension() != null ? publishArtifact.getExtension() : "jar");
        }
        DefaultExternalProjectDependency defaultExternalProjectDependency = dependency;
        if (defaultExternalProjectDependency == null) {
            DependencyResultsTransformer.$$$reportNull$$$0(5);
        }
        return defaultExternalProjectDependency;
    }

    @Nullable
    private static ResolvedArtifactResult findMatchingArtifact(ResolvedArtifact artifact, ComponentArtifactsResult componentArtifacts, Class<? extends Artifact> artifactType) {
        String baseName = Files.getNameWithoutExtension((String)artifact.getFile().getName());
        Set artifactResults = componentArtifacts.getArtifacts(artifactType);
        if (artifactResults.size() == 1) {
            ArtifactResult artifactResult = (ArtifactResult)artifactResults.iterator().next();
            return artifactResult instanceof ResolvedArtifactResult ? (ResolvedArtifactResult)artifactResult : null;
        }
        for (ArtifactResult result : artifactResults) {
            if (!(result instanceof ResolvedArtifactResult) || !((ResolvedArtifactResult)result).getFile().getName().startsWith(baseName)) continue;
            return (ResolvedArtifactResult)result;
        }
        return null;
    }

    private static void setProjectDependencyArtifactsSources(DefaultExternalProjectDependency projectDependency, Collection<File> artifactFiles, SourceSetCachedFinder sourceSetFinder) {
        ArrayList<File> artifactSources = new ArrayList<File>();
        for (File artifactFile : artifactFiles) {
            Set<File> sources = sourceSetFinder.findSourcesByArtifact(artifactFile.getPath());
            if (sources == null) continue;
            artifactSources.addAll(sources);
        }
        projectDependency.setProjectDependencyArtifactsSources(artifactSources);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetFinder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "auxiliaryArtifactsMap";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationProjectDependencies";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/tooling/util/resolve/DependencyResultsTransformer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/util/resolve/DependencyResultsTransformer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AttributesBasedKey
    implements ComponentResultKey {
        private final ComponentIdentifier myId;
        private final AttributeContainer myAttributes;

        public AttributesBasedKey(ComponentIdentifier id, AttributeContainer attributes) {
            this.myId = id;
            this.myAttributes = attributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributesBasedKey key = (AttributesBasedKey)o;
            if (!this.myId.equals(key.myId)) {
                return false;
            }
            return this.myAttributes.equals(key.myAttributes);
        }

        public int hashCode() {
            int result = this.myId.hashCode();
            result = 31 * result + this.myAttributes.hashCode();
            return result;
        }

        public String toString() {
            return "AttributesBasedKey{myId=" + this.myId + ", myAttributes=" + this.myAttributes + '}';
        }
    }

    private static class ComponentIdKey
    implements ComponentResultKey {
        private final ComponentIdentifier myId;

        public ComponentIdKey(ComponentIdentifier id) {
            this.myId = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentIdKey key = (ComponentIdKey)o;
            return this.myId.equals(key.myId);
        }

        public int hashCode() {
            return this.myId.hashCode();
        }
    }

    private static interface ComponentResultKey {
    }
}

