/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util.resolve;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.component.Component;
import org.gradle.api.specs.Specs;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.tooling.util.SourceSetCachedFinder;
import org.jetbrains.plugins.gradle.tooling.util.resolve.DependencyResolverImpl;
import org.jetbrains.plugins.gradle.tooling.util.resolve.DependencyResultsTransformer;
import org.jetbrains.plugins.gradle.tooling.util.resolve.ExternalDepsResolutionResult;

class ArtifactQueryResolver {
    private final Configuration myConfiguration;
    private final String myScope;
    private final Project myProject;
    private final boolean myDownloadSources;
    private final boolean myDownloadJavadoc;
    private final SourceSetCachedFinder mySourceSetFinder;

    public ArtifactQueryResolver(@NotNull Configuration configuration, @Nullable String scope, @NotNull Project project, boolean downloadJavadoc, boolean downloadSources, @NotNull SourceSetCachedFinder sourceSetFinder) {
        if (configuration == null) {
            ArtifactQueryResolver.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ArtifactQueryResolver.$$$reportNull$$$0(1);
        }
        if (sourceSetFinder == null) {
            ArtifactQueryResolver.$$$reportNull$$$0(2);
        }
        this.myConfiguration = configuration;
        this.myScope = scope;
        this.myProject = project;
        this.myDownloadJavadoc = downloadJavadoc;
        this.myDownloadSources = downloadSources;
        this.mySourceSetFinder = sourceSetFinder;
    }

    public ExternalDepsResolutionResult resolve() {
        LinkedHashSet<ExternalDependency> extDependencies = new LinkedHashSet<ExternalDependency>();
        Class<? extends Component> jvmLibrary = this.tryLoadingJvmLibraryClass();
        if (jvmLibrary == null) {
            return ExternalDepsResolutionResult.EMPTY;
        }
        Set resolvedArtifacts = this.myConfiguration.getResolvedConfiguration().getLenientConfiguration().getArtifacts(Specs.SATISFIES_ALL);
        Multimap<ModuleVersionIdentifier, ResolvedArtifact> artifactMap = this.groupByModuleVersionId(resolvedArtifacts);
        Map<ComponentIdentifier, ComponentArtifactsResult> auxiliaryArtifactsMap = this.buildAuxiliaryArtifactsMap(jvmLibrary, resolvedArtifacts);
        Multimap<ModuleComponentIdentifier, ProjectDependency> configurationProjectDependencies = DependencyResolverImpl.collectProjectDeps(this.myConfiguration);
        if (!this.myConfiguration.getResolvedConfiguration().hasError()) {
            extDependencies.addAll(this.buildFileCollectionDeps(resolvedArtifacts, configurationProjectDependencies.values()));
        }
        DependencyResultsTransformer dependencyResultsTransformer = new DependencyResultsTransformer(this.myProject, this.mySourceSetFinder, artifactMap, auxiliaryArtifactsMap, configurationProjectDependencies, this.myScope);
        ResolutionResult resolutionResult = this.myConfiguration.getIncoming().getResolutionResult();
        extDependencies.addAll(dependencyResultsTransformer.buildExternalDependencies(resolutionResult.getRoot().getDependencies()));
        return new ExternalDepsResolutionResult(extDependencies, new ArrayList<File>(dependencyResultsTransformer.getResolvedDepsFiles()));
    }

    @NotNull
    public Multimap<ModuleVersionIdentifier, ResolvedArtifact> groupByModuleVersionId(Set<ResolvedArtifact> resolvedArtifacts) {
        ArrayListMultimap artifactMap = ArrayListMultimap.create();
        for (ResolvedArtifact artifact : resolvedArtifacts) {
            ModuleVersionIdentifier moduleVersionId = artifact.getModuleVersion().getId();
            artifactMap.put((Object)moduleVersionId, (Object)artifact);
        }
        ArrayListMultimap arrayListMultimap = artifactMap;
        if (arrayListMultimap == null) {
            ArtifactQueryResolver.$$$reportNull$$$0(3);
        }
        return arrayListMultimap;
    }

    @NotNull
    public Map<ComponentIdentifier, ComponentArtifactsResult> buildAuxiliaryArtifactsMap(@NotNull Class<? extends Component> jvmLibrary, @NotNull Set<ResolvedArtifact> resolvedArtifacts) {
        if (jvmLibrary == null) {
            ArtifactQueryResolver.$$$reportNull$$$0(4);
        }
        if (resolvedArtifacts == null) {
            ArtifactQueryResolver.$$$reportNull$$$0(5);
        }
        ArrayList<ModuleComponentIdentifier> components = new ArrayList<ModuleComponentIdentifier>();
        for (ResolvedArtifact artifact : resolvedArtifacts) {
            ModuleVersionIdentifier moduleVersionId = artifact.getModuleVersion().getId();
            if (DependencyResolverImpl.isProjectDependencyArtifact(artifact)) continue;
            components.add(DependencyResolverImpl.toComponentIdentifier(moduleVersionId));
        }
        boolean isBuildScriptConfiguration = this.myProject.getBuildscript().getConfigurations().contains((Object)this.myConfiguration);
        DependencyHandler dependencyHandler = isBuildScriptConfiguration ? this.myProject.getBuildscript().getDependencies() : this.myProject.getDependencies();
        Set componentResults = dependencyHandler.createArtifactResolutionQuery().forComponents(components).withArtifacts(jvmLibrary, this.additionalArtifactsTypes().toArray(new Class[0])).execute().getResolvedComponents();
        HashMap<ComponentIdentifier, ComponentArtifactsResult> componentResultsMap = new HashMap<ComponentIdentifier, ComponentArtifactsResult>();
        for (ComponentArtifactsResult artifactsResult : componentResults) {
            componentResultsMap.put(artifactsResult.getId(), artifactsResult);
        }
        HashMap<ComponentIdentifier, ComponentArtifactsResult> hashMap = componentResultsMap;
        if (hashMap == null) {
            ArtifactQueryResolver.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    protected Collection<ExternalDependency> buildFileCollectionDeps(Collection<ResolvedArtifact> resolvedArtifactToFilter, Collection<ProjectDependency> projectDepsToFilter) {
        ArrayList<ExternalDependency> result = new ArrayList<ExternalDependency>();
        LinkedHashSet fileDeps = new LinkedHashSet(this.myConfiguration.getIncoming().getFiles().getFiles());
        for (ResolvedArtifact artifact : resolvedArtifactToFilter) {
            fileDeps.remove(artifact.getFile());
        }
        if (!fileDeps.isEmpty()) {
            for (ProjectDependency dep : projectDepsToFilter) {
                Set depFiles = DependencyResolverImpl.getTargetConfiguration(dep).getAllArtifacts().getFiles().getFiles();
                LinkedHashSet<File> intersection = new LinkedHashSet<File>((Collection<File>)Sets.intersection(fileDeps, (Set)depFiles));
                if (intersection.isEmpty()) continue;
                DefaultFileCollectionDependency fileCollectionDependency = new DefaultFileCollectionDependency(intersection);
                fileCollectionDependency.setScope(this.myScope);
                result.add(fileCollectionDependency);
                fileDeps.removeAll(intersection);
            }
        }
        for (File file : fileDeps) {
            DefaultFileCollectionDependency fileCollectionDependency = new DefaultFileCollectionDependency(Collections.singleton(file));
            fileCollectionDependency.setScope(this.myScope);
            result.add(fileCollectionDependency);
        }
        return result;
    }

    @NotNull
    protected List<Class<? extends Artifact>> additionalArtifactsTypes() {
        ArrayList<Class<? extends Artifact>> artifactTypes = new ArrayList<Class<? extends Artifact>>();
        if (this.myDownloadSources) {
            artifactTypes.add(SourcesArtifact.class);
        }
        if (this.myDownloadJavadoc) {
            artifactTypes.add(JavadocArtifact.class);
        }
        ArrayList<Class<? extends Artifact>> arrayList = artifactTypes;
        if (arrayList == null) {
            ArtifactQueryResolver.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    protected Class<? extends Component> tryLoadingJvmLibraryClass() {
        Class<?> jvmLibrary = null;
        try {
            jvmLibrary = Class.forName("org.gradle.jvm.JvmLibrary");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (jvmLibrary == null) {
            try {
                jvmLibrary = Class.forName("org.gradle.runtime.jvm.JvmLibrary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return jvmLibrary;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetFinder";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/tooling/util/resolve/ArtifactQueryResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmLibrary";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/util/resolve/ArtifactQueryResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByModuleVersionId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAuxiliaryArtifactsMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "additionalArtifactsTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildAuxiliaryArtifactsMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

