/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XBreakpointType<B extends XBreakpoint<P>, P extends XBreakpointProperties> {
    public static final ExtensionPointName<XBreakpointType> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.xdebugger.breakpointType");
    @NonNls
    @NotNull
    private final String myId;
    @Nls
    @NotNull
    private final String myTitle;
    private final boolean mySuspendThreadSupported;

    protected XBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            XBreakpointType.$$$reportNull$$$0(0);
        }
        if (title == null) {
            XBreakpointType.$$$reportNull$$$0(1);
        }
        this(id, title, false);
    }

    protected XBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title, boolean suspendThreadSupported) {
        if (id == null) {
            XBreakpointType.$$$reportNull$$$0(2);
        }
        if (title == null) {
            XBreakpointType.$$$reportNull$$$0(3);
        }
        this.myId = id;
        this.myTitle = title;
        this.mySuspendThreadSupported = suspendThreadSupported;
    }

    @Nullable
    public P createProperties() {
        return null;
    }

    public boolean isSuspendThreadSupported() {
        return this.mySuspendThreadSupported;
    }

    public SuspendPolicy getDefaultSuspendPolicy() {
        return SuspendPolicy.ALL;
    }

    public EnumSet<StandardPanels> getVisibleStandardPanels() {
        return EnumSet.allOf(StandardPanels.class);
    }

    @NotNull
    public final String getId() {
        String string = this.myId;
        if (string == null) {
            XBreakpointType.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            XBreakpointType.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_set_breakpoint;
        if (icon == null) {
            XBreakpointType.$$$reportNull$$$0(6);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_breakpoint;
        if (icon == null) {
            XBreakpointType.$$$reportNull$$$0(7);
        }
        return icon;
    }

    @NotNull
    public Icon getSuspendNoneIcon() {
        Icon icon = AllIcons.Debugger.Db_no_suspend_breakpoint;
        if (icon == null) {
            XBreakpointType.$$$reportNull$$$0(8);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_breakpoint;
        if (icon == null) {
            XBreakpointType.$$$reportNull$$$0(9);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_disabled_breakpoint;
        if (icon == null) {
            XBreakpointType.$$$reportNull$$$0(10);
        }
        return icon;
    }

    @Nullable
    public Icon getPendingIcon() {
        return null;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = this.getDisabledDependentIcon();
        if (icon == null) {
            XBreakpointType.$$$reportNull$$$0(11);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_dep_line_breakpoint;
        if (icon == null) {
            XBreakpointType.$$$reportNull$$$0(12);
        }
        return icon;
    }

    public abstract String getDisplayText(B var1);

    @Nullable
    public XBreakpointCustomPropertiesPanel<B> createCustomConditionsPanel() {
        return null;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<B> createCustomPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            XBreakpointType.$$$reportNull$$$0(13);
        }
        return this.createCustomPropertiesPanel();
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<B> createCustomPropertiesPanel() {
        return null;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<B> createCustomRightPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            XBreakpointType.$$$reportNull$$$0(14);
        }
        return null;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<B> createCustomTopPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            XBreakpointType.$$$reportNull$$$0(15);
        }
        return null;
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider() {
        return null;
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull B breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            XBreakpointType.$$$reportNull$$$0(16);
        }
        if (project == null) {
            XBreakpointType.$$$reportNull$$$0(17);
        }
        return this.getEditorsProvider();
    }

    public List<XBreakpointGroupingRule<B, ?>> getGroupingRules() {
        return Collections.emptyList();
    }

    @NotNull
    public Comparator<B> getBreakpointComparator() {
        Comparator comparator = (b, b1) -> (int)(b1.getTimeStamp() - b.getTimeStamp());
        if (comparator == null) {
            XBreakpointType.$$$reportNull$$$0(18);
        }
        return comparator;
    }

    public boolean isAddBreakpointButtonVisible() {
        return false;
    }

    @Nullable
    public B addBreakpoint(Project project, JComponent parentComponent) {
        return null;
    }

    @Nullable
    public XBreakpoint<P> createDefaultBreakpoint(@NotNull XBreakpointCreator<P> creator) {
        if (creator == null) {
            XBreakpointType.$$$reportNull$$$0(19);
        }
        return null;
    }

    public boolean shouldShowInBreakpointsDialog(@NotNull Project project) {
        if (project == null) {
            XBreakpointType.$$$reportNull$$$0(20);
        }
        return true;
    }

    @Nullable
    @NonNls
    public String getBreakpointsDialogHelpTopic() {
        return null;
    }

    @Nullable
    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<P> breakpoint) {
        if (breakpoint == null) {
            XBreakpointType.$$$reportNull$$$0(21);
        }
        return null;
    }

    public String getShortText(B breakpoint) {
        return this.getDisplayText(breakpoint);
    }

    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull B breakpoint, @Nullable XDebugSession currentSession) {
        if (breakpoint == null) {
            XBreakpointType.$$$reportNull$$$0(22);
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/breakpoints/XBreakpointType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/breakpoints/XBreakpointType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendNoneIcon";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedEnabledIcon";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedDisabledIcon";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveDependentIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledDependentIcon";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createCustomPropertiesPanel";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createCustomRightPropertiesPanel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createCustomTopPropertiesPanel";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsProvider";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBreakpoint";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowInBreakpointsDialog";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePosition";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalPopupMenuActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface XBreakpointCreator<P extends XBreakpointProperties> {
        @NotNull
        public XBreakpoint<P> createBreakpoint(@Nullable P var1);
    }

    public static enum StandardPanels {
        SUSPEND_POLICY,
        ACTIONS,
        DEPENDENCY;

    }
}

