/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.pom.Navigatable;
import com.intellij.pom.StatePreservingNavigatable;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class OpenSourceUtil {
    private OpenSourceUtil() {
    }

    public static void openSourcesFrom(DataContext context, boolean requestFocus) {
        OpenSourceUtil.navigate(requestFocus, CommonDataKeys.NAVIGATABLE_ARRAY.getData(context));
    }

    public static void openSourcesFrom(DataProvider context, boolean requestFocus) {
        OpenSourceUtil.navigate(requestFocus, CommonDataKeys.NAVIGATABLE_ARRAY.getData(context));
    }

    public static boolean canNavigate(@Nullable Object object) {
        return object instanceof Navigatable && ((Navigatable)object).canNavigate();
    }

    public static boolean canNavigateToSource(@Nullable Object object) {
        return object instanceof Navigatable && ((Navigatable)object).canNavigateToSource();
    }

    public static void navigate(Navigatable ... navigatables) {
        OpenSourceUtil.navigate(true, navigatables);
    }

    public static void navigate(boolean requestFocus, Navigatable ... navigatables) {
        OpenSourceUtil.navigate(requestFocus, false, navigatables);
    }

    public static void navigate(boolean requestFocus, boolean tryNotToScroll, Navigatable ... navigatables) {
        if (navigatables != null && navigatables.length > 0) {
            OpenSourceUtil.navigate(requestFocus, tryNotToScroll, Arrays.asList(navigatables));
        }
    }

    public static boolean navigate(boolean requestFocus, boolean tryNotToScroll, @Nullable Iterable<Navigatable> navigatables) {
        if (navigatables == null) {
            return false;
        }
        Navigatable nonSourceNavigatable = null;
        boolean alreadyNavigatedToSource = false;
        for (Navigatable navigatable : navigatables) {
            if (OpenSourceUtil.navigateToSource(requestFocus, tryNotToScroll, navigatable)) {
                alreadyNavigatedToSource = true;
                continue;
            }
            if (alreadyNavigatedToSource || nonSourceNavigatable != null || !OpenSourceUtil.canNavigate(navigatable)) continue;
            nonSourceNavigatable = navigatable;
        }
        if (alreadyNavigatedToSource) {
            return true;
        }
        if (nonSourceNavigatable == null) {
            return false;
        }
        nonSourceNavigatable.navigate(requestFocus);
        return true;
    }

    public static boolean navigateToSource(boolean requestFocus, boolean tryNotToScroll, @Nullable Iterable<Navigatable> navigatables) {
        if (navigatables == null) {
            return false;
        }
        boolean alreadyNavigatedToSource = false;
        for (Navigatable navigatable : navigatables) {
            if (!OpenSourceUtil.navigateToSource(requestFocus, tryNotToScroll, navigatable)) continue;
            alreadyNavigatedToSource = true;
        }
        return alreadyNavigatedToSource;
    }

    public static boolean navigateToSource(boolean requestFocus, boolean tryNotToScroll, @Nullable Navigatable navigatable) {
        if (!OpenSourceUtil.canNavigateToSource(navigatable)) {
            return false;
        }
        if (tryNotToScroll && navigatable instanceof StatePreservingNavigatable) {
            ((StatePreservingNavigatable)navigatable).navigate(requestFocus, true);
        } else {
            navigatable.navigate(requestFocus);
        }
        return true;
    }
}

